/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.install;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.install.ConfigCommandException;
import oracle.sysman.ccr.collector.install.ConfigResponseCommand;
import oracle.sysman.ccr.collector.install.ConfigResponseExitConsts;
import oracle.sysman.ccr.collector.install.ConfigResponseMsgID;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.LicenseAgreement;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.ResponseFile;
import oracle.sysman.ccr.collector.install.ResponseNotFoundException;
import oracle.sysman.ccr.collector.install.VerifyResponseCommandException;
import oracle.sysman.ccr.common.MessageBundle;

class VerifyResponseCommand
extends ConfigResponseCommand
implements ConfigResponseExitConsts {
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.install.ConfigResponse");
    private String m_strResponseFile;

    VerifyResponseCommand(String string) {
        this.m_strResponseFile = string;
    }

    void execute() throws ConfigCommandException {
        ResponseFile responseFile;
        try {
            responseFile = ResponseFile.reconstituteResponseFile(this.m_strResponseFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResponseNotFoundException(new String[]{this.m_strResponseFile, fileNotFoundException.getMessage()});
        }
        LicenseAgreement licenseAgreement = responseFile.getLicenseInstance();
        if (!licenseAgreement.licenseAccepted()) {
            throw new VerifyResponseCommandException(ConfigResponseMsgID.VERIFY_LICENSE_DECLINED, 12);
        }
        NetworkConfiguration networkConfiguration = new NetworkConfiguration(responseFile.getNetworkConfig());
        if (networkConfiguration == null) {
            throw new VerifyResponseCommandException(ConfigResponseMsgID.VERIFY_UNEXPECTED_FAILURE, 11);
        }
        if (networkConfiguration.isDisconnectedNetConfig()) {
            throw new VerifyResponseCommandException(ConfigResponseMsgID.VERIFY_DISCONNECTED_MODE, 10);
        }
        try {
            if (networkConfiguration.testExtendedConnection() == null) {
                throw new VerifyResponseCommandException(ConfigResponseMsgID.VERIFY_CONNECT_FAILURE, new String[]{""}, 9);
            }
        }
        catch (ConnectionException connectionException) {
            throw new VerifyResponseCommandException(ConfigResponseMsgID.VERIFY_CONNECT_FAILURE, new String[]{connectionException.getMessage()}, 9);
        }
        catch (UnknownHostException unknownHostException) {
            throw new VerifyResponseCommandException(ConfigResponseMsgID.VERIFY_CONNECT_FAILURE, new String[]{unknownHostException.getMessage()}, 9);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            throw new VerifyResponseCommandException(ConfigResponseMsgID.VERIFY_CONNECT_FAILURE, new String[]{sSLPeerUnverifiedException.getMessage()}, 9);
        }
        catch (IOException iOException) {
            throw new VerifyResponseCommandException(ConfigResponseMsgID.VERIFY_CONNECT_FAILURE, new String[]{iOException.getMessage()}, 9);
        }
        System.out.println(s_msgBundle.getMessage(ConfigResponseMsgID.VERIFY_CONNECTIVITY_SUCCESS, false));
    }
}

