/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.util;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.sysman.ccr.collector.util.AgentConfig;
import oracle.sysman.ccr.collector.util.OutOfPlaceUpgradeConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OutOfPlaceUpgradeClient {
    private Config config = null;
    private static String XML_CONFIG_FILE_NAME = "out_of_place_upgrade_properties.xml";
    private static String XML_CONFIG_FILE = null;
    public static String OLD_ORACLE_HOME_ATTR = "OLD_ORACLE_HOME";
    public static String OLD_ORACLE_CONFIG_HOME_ATTR = "OLD_ORACLE_CONFIG_HOME";
    public static String OLD_HOST_ATTR = "OLD_HOST";
    public static String UPGRADE_INFO = "UPGRADE_INFO";
    public static String UPGRADE_INSTANCE = "UPGRADE_INSTANCE";
    public static String OLD_ORACLE_HOME_PROP = "ccr.old_oracle_home";
    public static String OLD_ORACLE_CONFIG_HOME_PROP = "ccr.old_oracle_config_home";
    public static String OLD_HOST_PROP = "ccr.old_host";
    private static String OLD_ORACLE_HOME = null;
    private static String OLD_ORACLE_CONFIG_HOME = null;
    private static String OLD_HOST = null;
    public static final String TARGETS_OLD_NAME = "OLD_NAME";
    public static final String TARGETS_OLD_UNIQUE_ID = "OLD_UNIQUE_ID";
    public static final String TARGETS_OLD_ORACLE_CONFIG_HOME = "OLD_ORACLE_CONFIG_HOME";
    public static final String TARGETS_OLD_ORACLE_HOME = "OLD_ORACLE_HOME";
    public static final String TARGETS_OLD_HOST = "OLD_HOST";
    public static final String OUT_OF_PLACE_UPGRADE_INFO = "OUT_OF_PLACE_UPGRADE_INFO";
    private static final int ERR_UNEXPECTED_FAILURE = 11;

    public OutOfPlaceUpgradeClient(String string) throws ParserConfigurationException, TransformerConfigurationException, IOException, TransformerException {
        this.config = OutOfPlaceUpgradeConfig.getInstance(string);
        this.writeXml();
    }

    public static void main(String[] stringArray) {
        try {
            String string = System.getProperty(OUT_OF_PLACE_UPGRADE_INFO);
            if (string == null) {
                System.out.println("Out of place upgrade property was not passed to java code.");
                System.exit(11);
            }
            new OutOfPlaceUpgradeClient(string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println(parserConfigurationException.getMessage());
            System.exit(11);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println(transformerConfigurationException.getMessage());
            System.exit(11);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.exit(11);
        }
        catch (TransformerException transformerException) {
            System.out.println(transformerException.getMessage());
            System.exit(11);
        }
    }

    private void writeXml() throws ParserConfigurationException, TransformerConfigurationException, IOException, TransformerException {
        String string = this.config.getProperty(OLD_HOST_PROP);
        String string2 = this.config.getProperty(OLD_ORACLE_HOME_PROP);
        String string3 = this.config.getProperty(OLD_ORACLE_CONFIG_HOME_PROP);
        string = string == null ? "" : string;
        string2 = string2 == null ? "" : string2;
        String string4 = string3 = string3 == null ? "" : string3;
        if (string.equals("") && string2.equals("") && string3.equals("")) {
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement(UPGRADE_INFO);
        Element element2 = document.createElement(UPGRADE_INSTANCE);
        element2.setAttribute(OLD_HOST_ATTR, string);
        element2.setAttribute(OLD_ORACLE_HOME_ATTR, string2);
        element2.setAttribute(OLD_ORACLE_CONFIG_HOME_ATTR, string3);
        element.appendChild(element2);
        document.appendChild(element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        File file = new File(XML_CONFIG_FILE);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        StreamResult streamResult = new StreamResult(file);
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, streamResult);
    }

    public static boolean parseXml() throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        if (XML_CONFIG_FILE == null || XML_CONFIG_FILE.equals("")) {
            return false;
        }
        File file = new File(XML_CONFIG_FILE);
        if (!file.exists()) {
            return false;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(file);
        Element element = (Element)document.getElementsByTagName(UPGRADE_INSTANCE).item(0);
        OLD_ORACLE_HOME = element.getAttribute(OLD_ORACLE_HOME_ATTR);
        OLD_ORACLE_CONFIG_HOME = element.getAttribute(OLD_ORACLE_CONFIG_HOME_ATTR);
        OLD_HOST = element.getAttribute(OLD_HOST_ATTR);
        return true;
    }

    public static String getOldOracleHome() {
        return OLD_ORACLE_HOME;
    }

    public static String getOldOracleConfigHome() {
        return OLD_ORACLE_CONFIG_HOME;
    }

    public static String getOldHost() {
        return OLD_HOST;
    }

    static {
        String string = AgentConfig.getRootStateDir();
        if (string != null && (string = string.trim()).length() != 0) {
            XML_CONFIG_FILE = FileSpec.catfile((String[])new String[]{string, UplinkPath.CONFIG_PATH, XML_CONFIG_FILE_NAME});
        }
    }
}

