/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.util;

import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.collector.util.OCMConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.util.crypt.OCMCrypt;
import oracle.sysman.ccr.util.crypt.OCMEncryptedObject;

public class UplinkSystemConfigWriter
extends ConfigWriter {
    private Properties m_systemUserProps = this.loadProperties(OCMConfig.USER_OVERRIDE_PATH, "ccr.properties");
    private Properties m_instanceUserProps = this.loadProperties(OCMConfig.HOST_OVERRIDE_PATH, "ccr.properties");
    private static UplinkSystemConfigWriter m_instance = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$util$UplinkSystemConfig;

    private UplinkSystemConfigWriter() throws FileReadException, FileWriteException {
        super(UplinkSystemConfig.getInstance());
        this.processSensitiveProperties(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigWriter getInstance() throws FileReadException, FileWriteException {
        if (m_instance == null) {
            Class clazz = class$oracle$sysman$ccr$collector$util$UplinkSystemConfig == null ? (class$oracle$sysman$ccr$collector$util$UplinkSystemConfig = UplinkSystemConfigWriter.class$("oracle.sysman.ccr.collector.util.UplinkSystemConfig")) : class$oracle$sysman$ccr$collector$util$UplinkSystemConfig;
            synchronized (clazz) {
                if (m_instance == null) {
                    m_instance = new UplinkSystemConfigWriter();
                }
            }
        }
        return m_instance;
    }

    protected void reloadConfigInstance() {
        UplinkSystemConfig.reload();
        super.reload(UplinkSystemConfig.getInstance());
    }

    public void setProperty(String string, String string2) {
        if (this.setProperty(string, string2, true)) {
            this.m_instanceUserProps.setProperty(string, string2);
        }
    }

    public void removeProperty(String string) {
        super.remove(string, true);
        ((Hashtable)this.m_systemUserProps).remove(string);
        ((Hashtable)this.m_instanceUserProps).remove(string);
    }

    private void processSensitiveProperties(boolean bl) throws FileWriteException {
        boolean bl2 = false;
        Properties properties = null;
        String string = this.m_instanceUserProps.getProperty("http.proxyPassword");
        if (string == null) {
            string = this.m_systemUserProps.getProperty("http.proxyPassword");
            if (string == null) {
                this.removeProperty("ccr.proxypswd.seed.v2");
                this.removeProperty("ccr.proxypswd.seed");
                return;
            }
            bl2 = true;
            properties = this.m_systemUserProps;
        } else {
            properties = this.m_instanceUserProps;
        }
        String string2 = properties.getProperty("ccr.proxypswd.seed.v2");
        if (string2 == null) {
            string2 = properties.getProperty("ccr.proxypswd.seed");
        }
        if (string2 == null) {
            this.encryptSave(string, bl, bl2);
        }
    }

    private void encryptSave(String string, boolean bl, boolean bl2) throws FileWriteException {
        OCMCrypt oCMCrypt = new OCMCrypt();
        OCMEncryptedObject oCMEncryptedObject = null;
        Properties properties = null;
        properties = bl2 ? this.m_systemUserProps : this.m_instanceUserProps;
        String string2 = null;
        String string3 = null;
        if (bl || this.getSettingsChanged()) {
            string3 = oCMCrypt.genOCMProxyKey();
            oCMEncryptedObject = oCMCrypt.encrypt(string, string3);
            string2 = oCMEncryptedObject.getencryptData();
            if (oCMEncryptedObject.getencryptMechanism() == oCMEncryptedObject.getAesAlg()) {
                this.setProperty("ccr.proxypswd.seed.v2", string3);
            } else {
                this.setProperty("ccr.proxypswd.seed", string3);
            }
            properties.setProperty("http.proxyPassword", string2);
            this.setSettingsChanged(true);
            if (bl2) {
                this.persistProperties(OCMConfig.USER_OVERRIDE_PATH, "ccr.properties", this.m_systemUserProps);
            } else {
                this.persistProperties(OCMConfig.HOST_OVERRIDE_PATH, "ccr.properties", this.m_instanceUserProps);
            }
            properties.setProperty("http.proxyPassword", string);
            this.setSettingsChanged(false);
        }
    }

    public void persistProperties() throws FileWriteException {
        this.processSensitiveProperties(false);
        boolean bl = this.getSettingsChanged();
        this.setSettingsChanged(bl);
        this.persistProperties(OCMConfig.HOST_OVERRIDE_PATH, "ccr.properties", this.m_instanceUserProps);
    }

    public String toString() {
        return "Instance Properties:\n" + ((Hashtable)this.m_instanceUserProps).toString() + "\nSystem Properties:\n" + this.m_systemUserProps;
    }

    public String propertyValue(String string) {
        String string2 = this.m_instanceUserProps.getProperty(string);
        if (string2 == null) {
            string2 = this.m_systemUserProps.getProperty(string);
        }
        if (string2 == null) {
            string2 = super.propertyValue(string);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

