/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.netmgr.OCMNetworkMsgID;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DiagnosticResponse
extends DefaultHandler {
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$netmgr$DiagnosticResponse == null ? (class$oracle$sysman$ccr$netmgr$DiagnosticResponse = DiagnosticResponse.class$("oracle.sysman.ccr.netmgr.DiagnosticResponse")) : class$oracle$sysman$ccr$netmgr$DiagnosticResponse));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.netmgr.OCMNetwork");
    private boolean m_successful = false;
    private String m_sessionID = null;
    private int m_failureCode = -1;
    private String m_failureMsg = null;
    private static final String SUCCESS = "SUCCESS";
    private static final String SESSION = "SESSION";
    private static final String SESSION_ID = "ID";
    private static final String FAILURE = "FAILURE";
    private static final String MESSAGE = "MESSAGE";
    private static final String CODE = "CODE";
    private StringBuffer buffer = null;
    private String responseXML = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$DiagnosticResponse;

    public DiagnosticResponse(byte[] byArray) throws InvalidResponseException {
        try {
            if (byArray == null || byArray.length == 0) {
                String string = s_msgBundle.getMessage(OCMNetworkMsgID.INVALID_RESPONSE, false, new Object[]{"Empty response received."});
                throw new InvalidResponseException(string);
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Server Response: " + new String(byArray)));
            }
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InputSource inputSource = new InputSource(byteArrayInputStream);
            xMLReader.parse(inputSource);
            byteArrayInputStream.close();
        }
        catch (SAXException sAXException) {
            String string = s_msgBundle.getMessage(OCMNetworkMsgID.INVALID_RESPONSE, false, new Object[]{sAXException.getMessage()});
            throw new InvalidResponseException(string);
        }
        catch (IOException iOException) {
            String string = s_msgBundle.getMessage(OCMNetworkMsgID.INVALID_RESPONSE, false, new Object[]{iOException.getMessage()});
            throw new InvalidResponseException(string);
        }
    }

    public void startDocument() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Started parsing server response");
        }
    }

    public void endDocument() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"End of server response.");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase(SUCCESS)) {
            this.m_successful = true;
        } else if (string3.equalsIgnoreCase(SESSION)) {
            this.m_sessionID = attributes.getValue(SESSION_ID);
        } else if (string3.equalsIgnoreCase(FAILURE)) {
            this.m_successful = false;
            try {
                this.m_failureCode = Integer.parseInt(attributes.getValue(CODE));
            }
            catch (NumberFormatException numberFormatException) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Failed to convert error code: " + attributes.getValue(CODE) + " to integer"));
                }
                throw new SAXException(numberFormatException.getMessage());
            }
        } else if (string3.equalsIgnoreCase(MESSAGE)) {
            this.buffer = new StringBuffer();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase(MESSAGE)) {
            this.m_failureMsg = this.buffer.toString();
            this.buffer = null;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Upload response failure code: " + this.m_failureCode + ", message: " + this.m_failureMsg));
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append(cArray, n, n2);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)sAXParseException.getMessage());
        }
        throw new SAXException(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)sAXParseException.getMessage());
        }
        throw new SAXException(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)sAXParseException.getMessage());
        }
        throw new SAXException(sAXParseException);
    }

    public boolean isSuccessful() {
        return this.m_successful;
    }

    public String getSessionID() {
        return this.m_sessionID;
    }

    public String getFailureMsg() {
        return this.m_failureMsg;
    }

    public int getFailureCode() {
        return this.m_failureCode;
    }

    public String toString() {
        return this.responseXML;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

