/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import HTTPClient.AuthorizationPrompter;
import HTTPClient.HTTPConnection;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.NetMgrMsgID;
import oracle.sysman.ccr.netmgr.AuthenticationXMLParse;
import oracle.sysman.ccr.netmgr.CCRProxyAuthorization;
import oracle.sysman.ccr.netmgr.CollectionInputStream;
import oracle.sysman.ccr.netmgr.CollectionXMLFileParser;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.FileDownloadException;
import oracle.sysman.ccr.netmgr.HTTPServerException;
import oracle.sysman.ccr.netmgr.HarvesterClientActionsXMLParser;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMHTTPConnection;
import oracle.sysman.ccr.netmgr.OCMHTTPResponse;
import oracle.sysman.ccr.netmgr.OCMRepeaterHTTPResponse;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;
import oracle.sysman.ccr.netmgr.RegistrationXMLParse;
import oracle.sysman.ccr.netmgr.SystemConsole;
import oracle.sysman.ccr.netmgr.WebsvcResponse;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.SAXException;

public class OCMEndPoint {
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$netmgr$EndPoint == null ? (class$oracle$sysman$ccr$netmgr$EndPoint = OCMEndPoint.class$("oracle.sysman.ccr.netmgr.EndPoint")) : class$oracle$sysman$ccr$netmgr$EndPoint));
    private static final String UPLOAD_RESPONSE_HEADER_NAME = "EM_UPLOAD_NOTIF_RESPONSE";
    private static final String REGISTRATION_URI = "/emccr/registerUser";
    public static final String UPLOAD_URI = "/em/upload";
    public static final String GETUPDATES_URI = "/emccr/contentServer/getUpgrades";
    public static final String ENDPING_URI = "/emccr/contentServer/endPing";
    public static final String GET_HARVESTER_CLIENT_ACTIONS_URI = "/emccr/contentServer/getHarvesterClientActions";
    public static final String DIAG_START_UPLOAD_URI = "/emdiag/upload";
    public static final String DIAG_RESTART_UPLOAD_URI = "/emdiag/restartUpload";
    public static final String DIAG_CONTINUE_UPLOAD_URI = "/emdiag/continuation";
    private static final String PWD_MASK = "************";
    private long m_collFileSize = 0L;
    private static final String COLLECTOR_PROTOCOL_VER = "10.3.8.0.0";
    private static int DEFAULT_REGISTER_TIMEOUT = 60000;
    public static final String DEFAULT_OCM_SERVICE_ENDPOINT = "https://ccr.oracle.com";
    public static final String GCHARVESTER_KEY_TYPE = "GC";
    public static final String OCM_KEY_TYPE = "OCM";
    private static RE s_unknownHostRE = null;
    private static RE s_portOutOfRangeRE = null;
    private EndPoint m_endPoint = null;
    private OCMHTTPConnection m_ocmConnection = null;
    private static String s_strOracleHome = null;
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.common.network.NetMgr");
    private static final MessageFormat s_loggerMsg = new MessageFormat("Oracle Configuration Manager failed to establish a connection to Oracle. Reconfigure using {0}");
    private static final String CONFIG_CCR = "configCCR";
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$EndPoint;

    public static void init() {
    }

    static int getReadTimeout() {
        int n;
        try {
            Config config = UplinkHomeConfig.getInstance();
            n = config.getProperty("ccr.netmgr.timeout.read", oracle.sysman.ccr.common.network.EndPoint.DEFAULT_READ_TIMEOUT);
        }
        catch (IllegalStateException illegalStateException) {
            n = oracle.sysman.ccr.common.network.EndPoint.DEFAULT_READ_TIMEOUT;
        }
        return n;
    }

    static int getConnectionTimeout() {
        int n;
        try {
            Config config = UplinkHomeConfig.getInstance();
            n = config.getProperty("ccr.netmgr.timeout.connect", oracle.sysman.ccr.common.network.EndPoint.DEFAULT_CONNECT_TIMEOUT);
        }
        catch (IllegalStateException illegalStateException) {
            n = oracle.sysman.ccr.common.network.EndPoint.DEFAULT_CONNECT_TIMEOUT;
        }
        return n;
    }

    public OCMEndPoint(EndPoint endPoint) throws NetworkException {
        this.m_endPoint = endPoint;
        this.m_ocmConnection = OCMHTTPConnection.createConnection(this.m_endPoint.getConnection(), this.m_endPoint.getIsRepeater());
    }

    public OCMEndPoint(oracle.sysman.ccr.common.network.EndPoint endPoint) throws NetworkException {
        this.m_endPoint = new EndPoint(endPoint);
        this.m_ocmConnection = OCMHTTPConnection.createConnection(this.m_endPoint.getConnection(), this.m_endPoint.getIsRepeater());
    }

    public OCMEndPoint(URI uRI) throws NetworkException {
        try {
            this.initialize(uRI, new Properties(), false);
        }
        catch (NetworkException networkException) {
            OCMEndPoint.logConnectFailure();
            throw networkException;
        }
    }

    public OCMEndPoint(URI uRI, boolean bl) throws NetworkException {
        try {
            this.initialize(uRI, new Properties(), bl);
        }
        catch (NetworkException networkException) {
            OCMEndPoint.logConnectFailure();
            throw networkException;
        }
    }

    public OCMEndPoint(URI uRI, Properties properties, boolean bl) throws NetworkException {
        try {
            this.initialize(uRI, properties, bl);
        }
        catch (NetworkException networkException) {
            OCMEndPoint.logConnectFailure();
            throw networkException;
        }
    }

    public OCMEndPoint(EndPointAddr endPointAddr) throws NetworkException {
        try {
            this.initialize(endPointAddr.getURI(), new Properties(), endPointAddr.getIsRepeater());
        }
        catch (NetworkException networkException) {
            OCMEndPoint.logConnectFailure();
            throw networkException;
        }
    }

    public OCMEndPoint(URI uRI, Properties properties) throws NetworkException {
        try {
            this.initialize(uRI, properties, false);
        }
        catch (NetworkException networkException) {
            OCMEndPoint.logConnectFailure();
            throw networkException;
        }
    }

    public static void logConnectFailure() {
        String string = FileSpec.catfile((String[])new String[]{s_strOracleHome, UplinkPath.BIN_PATH, CONFIG_CCR});
        String string2 = s_loggerMsg.format(new String[]{string});
        SystemConsole.logMessage(SystemConsole.LEVEL_WARNING, string2);
    }

    private void initialize(URI uRI, Properties properties, boolean bl) throws NetworkException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("OCMEndPoint() : with URI of " + uRI + ", isRepeater of " + bl));
        }
        try {
            EndPointAddr endPointAddr = new EndPointAddr(null, bl, uRI);
            this.m_endPoint = new EndPoint(endPointAddr, properties);
            this.m_ocmConnection = OCMHTTPConnection.createConnection(this.m_endPoint.getConnection(), this.m_endPoint.getIsRepeater());
        }
        catch (MalformedURLException malformedURLException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.URL_FORMAT_ERR, false, (Object[])new String[]{uRI.toExternalForm()}), malformedURLException);
        }
        catch (ProtocolNotSuppException protocolNotSuppException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.PROTOCOL_TYPE_UNK, false, (Object[])new String[]{uRI.toExternalForm()}), protocolNotSuppException);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.CONNECT_ERROR, false), sSLPeerUnverifiedException);
        }
        catch (UnknownHostException unknownHostException) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)unknownHostException);
            }
            String string = unknownHostException.getMessage();
            String string2 = null;
            if (s_unknownHostRE.match(string)) {
                String string3 = s_msgBundle.getMessage(NetMgrMsgID.CCR_ENDPOINT_CONFIG, false);
                String string4 = s_unknownHostRE.getParen(1);
                String string5 = System.getProperty("http.proxyHost");
                if (string5 != null && string4.equalsIgnoreCase(string5)) {
                    string3 = s_msgBundle.getMessage(NetMgrMsgID.CCR_PROXY_CONFIG, false);
                }
                string2 = s_msgBundle.getMessage(NetMgrMsgID.UNKNOWN_HOST, false, (Object[])new String[]{string3, string4});
            } else {
                string2 = s_msgBundle.getMessage(NetMgrMsgID.UNKNOWN_HOST_UNCATEGORIZED, false, (Object[])new String[]{string});
            }
            throw new NetworkException(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.getMessage();
            String string6 = null;
            if (s_portOutOfRangeRE.match(string)) {
                String string7 = System.getProperty("http.proxyPort");
                long l = 80L;
                if (string7 != null) {
                    l = Long.parseLong(string7);
                }
                String string8 = s_msgBundle.getMessage(NetMgrMsgID.CCR_ENDPOINT_CONFIG, false);
                String string9 = s_portOutOfRangeRE.getParen(1);
                long l2 = Long.parseLong(string9);
                if (l2 == l) {
                    string8 = s_msgBundle.getMessage(NetMgrMsgID.CCR_PROXY_CONFIG, false);
                }
                string6 = s_msgBundle.getMessage(NetMgrMsgID.INVALID_PORT, false, new Object[]{string8, new Long(l2)});
            } else {
                string6 = s_msgBundle.getMessage(NetMgrMsgID.ILLEGAL_CONNECT_INFO, false, (Object[])new String[]{string});
            }
            throw new NetworkException(string6);
        }
        catch (IOException iOException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.CONNECT_ERROR, false), iOException);
        }
        catch (ParseException parseException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.URL_FORMAT_ERR, false, (Object[])new String[]{uRI.toExternalForm()}), parseException);
        }
    }

    protected void preConnect() {
        if (s_logger.isEnabledFor(Logger.INFO) && this.getConnection().getProxyHost() != null) {
            s_logger.info(NetMgrMsgID.PROXY_CONFIG, new Object[]{this.getConnection().getProxyHost(), new Long(this.getConnection().getProxyPort())});
        }
    }

    public List getHarvesterClientActions(String string) throws NetworkException {
        Object object;
        Object object2;
        String string2 = null;
        try {
            int n;
            object2 = new NVPair[]{new NVPair("X-ORCL-GCREGGUID", string)};
            if (s_logger.isDebugEnabled()) {
                object = new StringBuffer();
                for (n = 0; n < ((NVPair[])object2).length; ++n) {
                    if (n > 0) {
                        ((StringBuffer)object).append("&");
                    }
                    ((StringBuffer)object).append(object2[n].getName());
                    ((StringBuffer)object).append("=");
                    ((StringBuffer)object).append(object2[n].getValue());
                }
                s_logger.debug((Object)("Sending getHarvesterClientActions request to " + this.m_endPoint.getConnectionURL().toExternalForm()));
                s_logger.debug((Object)("\tParams = " + ((StringBuffer)object).toString()));
            }
            if ((n = ((OCMHTTPResponse)(object = this.getOCMConnection().Post(GET_HARVESTER_CLIENT_ACTIONS_URI, (NVPair[])object2))).getStatusCode()) >= 300) {
                switch (n) {
                    case 500: 
                    case 502: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.INVENTORY_SEND_FAILURE, false, (Object[])new Integer[]{new Integer(n)}));
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n), ((OCMHTTPResponse)object).getReasonLine(), ((OCMHTTPResponse)object).getText()}));
            }
            string2 = ((OCMHTTPResponse)object).getText();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Result from the getHarvesterClientActions() request is: " + string2));
            }
        }
        catch (IOException iOException) {
            throw new NetworkException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(this.processSendingError((Exception)((Object)moduleException)), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
        catch (ParseException parseException) {
            throw new NetworkException(parseException.toString());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("OCMEndPoint.getHarvesterClientActions(): XML returned from ContentServer = " + string2));
        }
        object2 = null;
        try {
            object = new HarvesterClientActionsXMLParser(string2);
            object2 = ((HarvesterClientActionsXMLParser)object).getActionList();
        }
        catch (SAXException sAXException) {
            throw new NetworkException(sAXException.toString());
        }
        return object2;
    }

    public String getUpdates(Vector vector, String string, String string2, String string3, String string4, String string5) throws NetworkException {
        String string6 = null;
        try {
            int n;
            Object object;
            Vector<NVPair> vector2 = new Vector<NVPair>();
            vector2.addAll(vector);
            String string7 = UplinkSystemConfig.getInstance().getProperty("ccr.metalink_email.address");
            vector2.add(new NVPair("X-ORCL-METAEML", string7 != null ? string7 : ""));
            vector2.add(new NVPair("X-ORCL-ORGI", string3));
            vector2.add(new NVPair("X-ORCL-HOST", string));
            vector2.add(new NVPair("X-ORCL-HOME", string2));
            String string8 = System.getProperty("os.name");
            if (string8.startsWith("Windows")) {
                string8 = "Windows";
            }
            vector2.add(new NVPair("X-ORCL-PLAT", string8));
            vector2.add(new NVPair("X-ORCL-CFGHOME", string5));
            vector2.add(new NVPair("X-ORCL-REGKEY", string4));
            vector2.add(new NVPair("X-ORCL-PLVR", System.getProperty("os.version")));
            vector2.add(new NVPair("X-ORCL-ARCH", System.getProperty("os.arch")));
            vector2.add(new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER));
            vector2.add(new NVPair("X-ORCL-CJVM", System.getProperty("java.version")));
            Object[] objectArray = new NVPair[vector2.size()];
            vector2.copyInto(objectArray);
            if (s_logger.isDebugEnabled()) {
                object = new StringBuffer();
                for (n = 0; n < objectArray.length; ++n) {
                    if (n > 0) {
                        ((StringBuffer)object).append("&");
                    }
                    ((StringBuffer)object).append(objectArray[n].getName());
                    ((StringBuffer)object).append("=");
                    ((StringBuffer)object).append(objectArray[n].getValue());
                }
                s_logger.debug((Object)("Sending getUpdates request to " + this.m_endPoint.getConnectionURL().toExternalForm()));
                s_logger.debug((Object)("\tParams = " + ((StringBuffer)object).toString()));
            }
            if ((n = ((OCMHTTPResponse)(object = this.getOCMConnection().Post(GETUPDATES_URI, (NVPair[])objectArray))).getStatusCode()) >= 300) {
                switch (n) {
                    case 500: 
                    case 502: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.INVENTORY_SEND_FAILURE, false, (Object[])new Integer[]{new Integer(n)}));
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n), ((OCMHTTPResponse)object).getReasonLine(), ((OCMHTTPResponse)object).getText()}));
            }
            string6 = ((OCMHTTPResponse)object).getText();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Result from the getUpdates() request is: " + string6));
            }
        }
        catch (IOException iOException) {
            throw new NetworkException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(this.processSendingError((Exception)((Object)moduleException)), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
        catch (ParseException parseException) {
            throw new NetworkException(parseException.toString());
        }
        return string6;
    }

    public void endPing(String string, String string2, String string3, String string4, String string5, String string6) throws NetworkException {
        Vector<NVPair> vector = new Vector<NVPair>();
        vector.add(new NVPair("ENDPING", string2));
        vector.add(new NVPair("X-ORCL-ORGI", string6));
        vector.add(new NVPair("X-ORCL-HOST", string3));
        vector.add(new NVPair("X-ORCL-HOME", string4));
        vector.add(new NVPair("X-ORCL-CFGHOME", string5));
        vector.add(new NVPair("ENDPING_COMMANDS", string));
        Object[] objectArray = new NVPair[vector.size()];
        vector.copyInto(objectArray);
        try {
            OCMHTTPResponse oCMHTTPResponse = this.getOCMConnection().Post(ENDPING_URI, (NVPair[])objectArray);
            int n = oCMHTTPResponse.getStatusCode();
            if (n >= 300) {
                switch (n) {
                    case 500: 
                    case 502: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.INVENTORY_SEND_FAILURE, false, (Object[])new Integer[]{new Integer(n)}));
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n), oCMHTTPResponse.getReasonLine(), oCMHTTPResponse.getText()}));
            }
            String string7 = oCMHTTPResponse.getText();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Result from the getUpdates() request is: " + string7));
            }
        }
        catch (IOException iOException) {
            throw new NetworkException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(this.processSendingError((Exception)((Object)moduleException)), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void sendContent(File file, String string, String string2, String string3, String string4, String string5) throws NetworkException {
        this.sendContent(file, string, string2, string3, string4, string5, OCM_KEY_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendContent(File file, String string, String string2, String string3, String string4, String string5, String string6) throws NetworkException {
        this.m_collFileSize = file.length();
        if (null == string5 || 0 == string5.length()) {
            string5 = "";
        }
        CollectionInputStream collectionInputStream = new CollectionInputStream(file);
        try {
            this.sendContent(collectionInputStream, string, string2, string3, string4, string5, string6);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (collectionInputStream != null) {
                    collectionInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (collectionInputStream != null) {
                collectionInputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void sendContent(CollectionInputStream collectionInputStream, String string, String string2, String string3, String string4, String string5, String string6) throws NetworkException {
        if (null == string5) {
            string5 = "";
        }
        NVPair[] nVPairArray = null;
        String string7 = null;
        String string8 = null;
        OCMHTTPResponse oCMHTTPResponse = null;
        try {
            String string9;
            String string10;
            CollectionXMLFileParser collectionXMLFileParser = new CollectionXMLFileParser(collectionInputStream.getCollectionFile());
            nVPairArray = this.setupConfigUploadHeaders(collectionXMLFileParser, string, string2, string3, string4, string5, string6);
            string8 = UPLOAD_URI;
            if (s_logger.isDebugEnabled()) {
                string10 = string8;
                string9 = oracle.sysman.ccr.common.network.EndPoint.getURLParamString((NVPair[])nVPairArray);
                if (string9 != null && string9.length() > 0) {
                    string10 = string8 + "?" + string9;
                }
                s_logger.debug((Object)("Sending load request to " + this.m_endPoint.getConnectionURL().toExternalForm()));
                s_logger.debug((Object)("\tParams = " + string10));
            }
            if ((string7 = (oCMHTTPResponse = this.getOCMConnection().Post(string8, collectionInputStream, this.m_collFileSize, nVPairArray)).getHeader("X-ORCL-EMRS")) != null && !string7.equalsIgnoreCase("SUCCESS")) {
                string10 = s_msgBundle.getMessage(NetMgrMsgID.HANDSHAKE_FAILED, false, new Object[]{this.m_endPoint.getConnectionURL().toString(), string7});
                s_logger.error(NetMgrMsgID.HANDSHAKE_FAILED, new Object[]{this.m_endPoint.getConnectionURL().toString(), string7});
                throw new NetworkException(string10);
            }
            string10 = oCMHTTPResponse.getHeader(UPLOAD_RESPONSE_HEADER_NAME);
            if (string10 == null || !string10.startsWith("SUCCESS")) {
                string9 = null;
                string9 = string10 == null ? oCMHTTPResponse.getReasonLine() : string10;
                String string11 = s_msgBundle.getMessage(NetMgrMsgID.INVALID_RESPONSE, false, new Object[]{this.m_endPoint.getConnectionURL().toString(), string9});
                s_logger.error(NetMgrMsgID.INVALID_RESPONSE, new Object[]{this.m_endPoint.getConnectionURL().toString(), string9});
                throw new NetworkException(string11);
            }
        }
        catch (SAXException sAXException) {
            throw new NetworkException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new NetworkException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(this.processSendingError((Exception)((Object)moduleException)), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
    }

    public InputStream getFile(String string) throws FileNotFoundException, NetworkException {
        try {
            OCMHTTPResponse oCMHTTPResponse = this.getOCMConnection().Get(string);
            int n = oCMHTTPResponse.getStatusCode();
            if (n >= 300) {
                switch (n) {
                    case 404: {
                        throw new FileNotFoundException(s_msgBundle.getMessage(NetMgrMsgID.KIT_NOTFOUND, false, (Object[])new String[]{oCMHTTPResponse.getEffectiveURI().toExternalForm()}));
                    }
                    case 500: {
                        throw new FileDownloadException(s_msgBundle.getMessage(NetMgrMsgID.KIT_DOWNLOAD_ERR, false, (Object[])new Integer[]{new Integer(n)}));
                    }
                }
                throw new FileDownloadException(s_msgBundle.getMessage(NetMgrMsgID.KIT_DOWNLOAD_IERR, false, new Object[]{oCMHTTPResponse.getEffectiveURI().toExternalForm(), new Integer(n)}));
            }
            return oCMHTTPResponse.getInputStream();
        }
        catch (IOException iOException) {
            throw new FileDownloadException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new FileDownloadException(this.processSendingError((Exception)((Object)moduleException)), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new FileDownloadException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
    }

    public RegistrationKeyDoc registerUser(String string, String string2, String string3, String string4) throws NetworkException {
        String string5 = string4;
        if (null == string5) {
            string5 = "";
        }
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "register"), new NVPair("form", "VALIDATED"), new NVPair("X-ORCL-HOST", string2), new NVPair("X-ORCL-HOME", string3), new NVPair("X-ORCL-CFGHOME", string5), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER), new NVPair("X-ORCL-REGCIPHER", string)};
        this.dumpRegistrationNVPairs("Validated RegisterUser", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    public RegistrationKeyDoc registerAnonymous(String string, String string2, String string3, String string4, String string5) throws NetworkException {
        String string6 = string5;
        if (null == string6) {
            string6 = "";
        }
        NVPair[] nVPairArray = new NVPair[]{new NVPair("X-ORCL-REGKEY", string), new NVPair("X-ORCL-ORGI", string2), new NVPair("cmd", "register"), new NVPair("form", "ANONYMOUS"), new NVPair("X-ORCL-HOST", string3), new NVPair("X-ORCL-HOME", string4), new NVPair("X-ORCL-CFGHOME", string6), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("Anonymous re-registration", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    public RegistrationKeyDoc registerAnonymous(String string, String string2, String string3, String string4) throws NetworkException {
        String string5 = string4;
        if (null == string5) {
            string5 = "";
        }
        if (null == string) {
            string = "";
        }
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "register"), new NVPair("form", "ANONYMOUS"), new NVPair("X-ORCL-METAEML", string), new NVPair("X-ORCL-HOST", string2), new NVPair("X-ORCL-HOME", string3), new NVPair("X-ORCL-CFGHOME", string5), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("Anonymous registration", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    public RegistrationKeyDoc registerGcHarvesterDefault(String string, String string2, String string3, String string4) throws NetworkException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "register"), new NVPair("form", "GCHARVESTER_DEFAULT"), new NVPair("X-ORCL-HOST", string2), new NVPair("X-ORCL-HOME", string3), new NVPair("X-ORCL-GCREPURL", string4), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER), new NVPair("X-ORCL-REGCIPHER", string)};
        this.dumpRegistrationNVPairs("Validated registerGcHarvesterDefault", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    public RegistrationKeyDoc registerGcHarvesterDefaultAnonymous(String string, String string2, String string3, String string4) throws NetworkException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "register"), new NVPair("form", "ANONYMOUS_GCHARVESTER_DEFAULT"), new NVPair("X-ORCL-METAEML", string), new NVPair("X-ORCL-HOST", string2), new NVPair("X-ORCL-HOME", string3), new NVPair("X-ORCL-GCREPURL", string4), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("Anonymous registerGcHarvesterDefaultAnonymous", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    public RegistrationKeyDoc registerGcHarvesterDefaultAnonymous(String string, String string2, String string3, String string4, String string5) throws NetworkException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "register"), new NVPair("form", "ANONYMOUS_GCHARVESTER_DEFAULT"), new NVPair("X-ORCL-REGKEY", string), new NVPair("X-ORCL-ORGI", string2), new NVPair("X-ORCL-HOST", string3), new NVPair("X-ORCL-HOME", string4), new NVPair("X-ORCL-GCREPURL", string5), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("Anonymous registerGcHarvesterDefaultAnonymous", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    public RegistrationKeyDoc registerGcHarvestedTargetHome(String string, String string2, String string3, String string4) throws NetworkException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "register"), new NVPair("form", "GCHARVESTED_TARGET"), new NVPair("X-ORCL-HOST", string2), new NVPair("X-ORCL-HOME", string3), new NVPair("X-ORCL-GCREGGUID", string4), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER), new NVPair("X-ORCL-REGCIPHER", string)};
        this.dumpRegistrationNVPairs("Validated registerGcHarvestedTargetHome", nVPairArray);
        return this.postRegistrationRequest(nVPairArray);
    }

    private void dumpRegistrationNVPairs(String string, NVPair[] nVPairArray) {
        if (s_logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nVPairArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("&");
                }
                stringBuffer.append(nVPairArray[i].getName());
                stringBuffer.append("=");
                if (nVPairArray[i].getName().equals("X-ORCL-METAPWD")) {
                    stringBuffer.append(PWD_MASK);
                    continue;
                }
                stringBuffer.append(nVPairArray[i].getValue());
            }
            s_logger.debug((Object)("Sending " + string + " request to " + this.m_endPoint.getConnectionURL().toExternalForm()));
            s_logger.debug((Object)("\tParams = " + stringBuffer.toString()));
        }
    }

    private RegistrationKeyDoc postRegistrationRequest(NVPair[] nVPairArray) throws NetworkException {
        int n;
        Object object;
        String string = "";
        try {
            object = UplinkHomeConfig.getInstance();
            n = object.getProperty("ccr.netmgr.timeout.register", DEFAULT_REGISTER_TIMEOUT);
        }
        catch (IllegalStateException illegalStateException) {
            n = DEFAULT_REGISTER_TIMEOUT;
        }
        this.getConnection().setTimeout(n);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Registering with a read timeout of " + n + "ms."));
        }
        this.getConnection().setConnectionTimeout(OCMEndPoint.getConnectionTimeout());
        object = null;
        try {
            object = this.getOCMConnection().Post(REGISTRATION_URI, nVPairArray);
            int n2 = ((OCMHTTPResponse)object).getStatusCode();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("return code is: " + n2));
            }
            if (n2 >= 300) {
                switch (n2) {
                    case 407: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_PROXYAUTH_FAILURE, false));
                    }
                    case 500: 
                    case 502: {
                        throw new HTTPServerException(NetMgrMsgID.REGISTRATION_COMMS_ERR, n2);
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n2), ((OCMHTTPResponse)object).getReasonLine(), ((OCMHTTPResponse)object).getText()}));
            }
            string = ((OCMHTTPResponse)object).getText();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Result from the registerUser() request is: " + string));
            }
            RegistrationXMLParse registrationXMLParse = new RegistrationXMLParse();
            try {
                WebsvcResponse websvcResponse = new WebsvcResponse((OCMHTTPResponse)object, registrationXMLParse);
                switch (websvcResponse.getRequestStatusCode()) {
                    case 1001: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.INV_REGISTRATION_CREDS, false));
                    }
                    case 1004: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.BAD_REGISTRATION_PARAMS, false));
                    }
                    case 1003: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.DUP_REG_ID, false));
                    }
                    case 1006: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_INVALID_CIPHER, false));
                    }
                    case 1002: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_SQLERR, false, (Object[])new String[]{((OCMHTTPResponse)object).getReasonLine()}));
                    }
                    case 1007: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.INV_REGISTRATION_DOC, false));
                    }
                    case 202: {
                        break;
                    }
                    default: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.UNKNOWN_ERR, false, (Object[])new String[]{new Integer(websvcResponse.getRequestStatusCode()).toString(), websvcResponse.getRequestResponseMessage()}));
                    }
                }
                return registrationXMLParse.getRegistrationDoc();
            }
            catch (SAXException sAXException) {
                throw new NetworkException(sAXException.toString());
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            InputStream inputStream = null;
            try {
                if (object != null && (inputStream = ((OCMHTTPResponse)object).getInputStream()) != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_COMMS, false), interruptedIOException);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("Bug in authorization handling: server refused the given info")) {
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_PROXYAUTH_FAILURE, false));
            }
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_COMMS, false), iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(generalSecurityException.getMessage(), generalSecurityException);
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.LINK_ERR, false));
        }
        catch (ParseException parseException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_RESPONSE_ERR, false), parseException);
        }
    }

    private NVPair[] setupConfigUploadHeaders(CollectionXMLFileParser collectionXMLFileParser, String string, String string2, String string3, String string4, String string5, String string6) throws NetworkException {
        String string7 = null;
        ArrayList<NVPair> arrayList = new ArrayList<NVPair>();
        string7 = Hostname.getHostname();
        arrayList.add(new NVPair("type", "data"));
        arrayList.add(new NVPair("X-ORCL-EMCV", "4.0.0.0.0"));
        arrayList.add(new NVPair("X-ORCL-EMSV", "4.0.0.0.0"));
        arrayList.add(new NVPair("X-ORCL-EMOV", "4.0.0.0.0"));
        arrayList.add(new NVPair("EMD_URL", "http://" + string7 + "/CCR/"));
        arrayList.add(new NVPair("X-ORCL-EMUR", "http://" + string7 + "/CCR/"));
        arrayList.add(new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER));
        arrayList.add(new NVPair("X-ORCL-HOST", string3));
        arrayList.add(new NVPair("X-ORCL-ORGI", string2));
        arrayList.add(new NVPair("X-ORCL-HOME", string4));
        arrayList.add(new NVPair("X-ORCL-CFGHOME", string5));
        if (collectionXMLFileParser.isProxyTarget()) {
            arrayList.add(new NVPair("X-ORCL-PROXY", new Boolean(collectionXMLFileParser.isProxyTarget()).toString()));
            arrayList.add(new NVPair("X-ORCL-PHOST", collectionXMLFileParser.getProxyHost()));
            arrayList.add(new NVPair("X-ORCL-PHOME", collectionXMLFileParser.getProxyHome()));
            arrayList.add(new NVPair("X-ORCL-PCFGHOME", collectionXMLFileParser.getProxyCfgHome()));
        }
        if (string != null) {
            arrayList.add(new NVPair("X-ORCL-EMAK", string));
            arrayList.add(new NVPair("X-ORCL-EMKT", string6));
        }
        NVPair[] nVPairArray = new NVPair[arrayList.size()];
        arrayList.toArray(nVPairArray);
        return nVPairArray;
    }

    public byte[] sendDiagnosticRequest(String string, byte[] byArray, NVPair[] nVPairArray) throws NetworkException {
        String string2 = null;
        string2 = string;
        OCMHTTPResponse oCMHTTPResponse = null;
        try {
            String string3;
            if (s_logger.isDebugEnabled()) {
                String string4 = string2;
                string3 = oracle.sysman.ccr.common.network.EndPoint.getURLParamString((NVPair[])nVPairArray);
                if (string3 != null && string3.length() > 0) {
                    string4 = string2 + "?" + string3;
                }
                s_logger.debug((Object)"Sending upload request to diagnostic server. ");
                s_logger.debug((Object)("URI: " + string4));
            }
            oCMHTTPResponse = this.getOCMConnection().Post(string2, byArray, nVPairArray);
            int n = oCMHTTPResponse.getStatusCode();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Server response code for diagnostic request:  " + n));
            }
            if (n >= 300) {
                string3 = s_msgBundle.getMessage(NetMgrMsgID.ERROR_SENDING, false, new Object[]{this.m_endPoint.getConnectionURL().toString(), new Integer(n)});
                NetworkException networkException = new NetworkException(string3);
                s_logger.error(NetMgrMsgID.ERROR_SENDING, new Object[]{this.m_endPoint.getConnectionURL().toString(), new Integer(n)});
                throw networkException;
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Response received from server: ");
                s_logger.debug((Object)new String(oCMHTTPResponse.getData()));
            }
            return oCMHTTPResponse.getData();
        }
        catch (IOException iOException) {
            throw new NetworkException(this.processSendingError(iOException));
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(this.processSendingError((Exception)((Object)moduleException)), moduleException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(this.processSendingError(generalSecurityException), generalSecurityException);
        }
    }

    HTTPConnection getConnection() {
        if (this.m_endPoint != null) {
            return this.m_endPoint.getConnection();
        }
        return null;
    }

    OCMHTTPConnection getOCMConnection() {
        if (this.m_ocmConnection != null) {
            return this.m_ocmConnection;
        }
        return null;
    }

    public String authenticateUser(String string, byte[] byArray) throws NetworkException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "authenticate"), new NVPair("form", "MLIDPW"), new NVPair("X-ORCL-METAEML", string), new NVPair("X-ORCL-METAPWD", new String(byArray)), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("email authentication", nVPairArray);
        return this.postAuthenticationRequest(nVPairArray);
    }

    public String authenticateUser(String string, String string2, int n) throws NetworkException {
        return this.authenticateUser(string, string2);
    }

    public String authenticateUser(String string, String string2) throws NetworkException {
        NVPair[] nVPairArray = new NVPair[]{new NVPair("cmd", "authenticate"), new NVPair("form", "CSI"), new NVPair("X-ORCL-META", string), new NVPair("X-ORCL-CUST", string2), new NVPair("X-ORCL-CTRY", Integer.toString(-99)), new NVPair("X-ORCL-CCRCOLLPROT", COLLECTOR_PROTOCOL_VER)};
        this.dumpRegistrationNVPairs("CSI authentication", nVPairArray);
        return this.postAuthenticationRequest(nVPairArray);
    }

    private String postAuthenticationRequest(NVPair[] nVPairArray) throws NetworkException {
        int n;
        Object object;
        try {
            object = UplinkHomeConfig.getInstance();
            n = object.getProperty("ccr.netmgr.timeout.register", DEFAULT_REGISTER_TIMEOUT);
        }
        catch (IllegalStateException illegalStateException) {
            n = DEFAULT_REGISTER_TIMEOUT;
        }
        this.getConnection().setTimeout(n);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Authenticating with a read timeout of " + n + "ms."));
        }
        this.getConnection().setConnectionTimeout(OCMEndPoint.getConnectionTimeout());
        object = null;
        try {
            object = this.getOCMConnection().Post(REGISTRATION_URI, nVPairArray);
            int n2 = ((OCMHTTPResponse)object).getStatusCode();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("return code is: " + n2));
            }
            if (n2 >= 300) {
                switch (n2) {
                    case 407: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_PROXYAUTH_FAILURE, false));
                    }
                    case 500: 
                    case 502: {
                        throw new HTTPServerException(NetMgrMsgID.REGISTRATION_COMMS_ERR, n2);
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n2), ((OCMHTTPResponse)object).getReasonLine(), ((OCMHTTPResponse)object).getText()}));
            }
            String string = ((OCMHTTPResponse)object).getText();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Result from the authenticateUser() request is: " + string));
            }
            AuthenticationXMLParse authenticationXMLParse = new AuthenticationXMLParse();
            try {
                WebsvcResponse websvcResponse = new WebsvcResponse((OCMHTTPResponse)object, authenticationXMLParse);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Received cipherText of: " + authenticationXMLParse.cipherText()));
                }
                switch (websvcResponse.getRequestStatusCode()) {
                    case 1001: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.INV_REGISTRATION_CREDS, false));
                    }
                    case 1004: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.BAD_REGISTRATION_PARAMS, false));
                    }
                    case 1002: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_SQLERR, false, (Object[])new String[]{websvcResponse.getRequestResponseMessage()}));
                    }
                    case 1005: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_AUTH_ATTACK, false));
                    }
                    case 202: {
                        break;
                    }
                    default: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.UNKNOWN_ERR, false, (Object[])new String[]{new Integer(websvcResponse.getRequestStatusCode()).toString(), websvcResponse.getRequestResponseMessage()}));
                    }
                }
            }
            catch (SAXException sAXException) {
                throw new NetworkException(sAXException.toString());
            }
            return authenticationXMLParse.cipherText();
        }
        catch (InterruptedIOException interruptedIOException) {
            InputStream inputStream = null;
            try {
                if (object != null && (inputStream = ((OCMHTTPResponse)object).getInputStream()) != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_COMMS, false), interruptedIOException);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("Bug in authorization handling: server refused the given info")) {
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_PROXYAUTH_FAILURE, false));
            }
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_COMMS, false), iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException(generalSecurityException.getMessage(), generalSecurityException);
        }
        catch (ModuleException moduleException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.LINK_ERR, false));
        }
        catch (ParseException parseException) {
            throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REGISTRATION_RESPONSE_ERR, false), parseException);
        }
    }

    private String processSendingError(Exception exception) {
        String string = s_msgBundle.getMessage(NetMgrMsgID.ERROR_SENDING, false, (Object[])new String[]{this.m_endPoint.getConnectionURL().toString(), exception.getMessage()});
        s_logger.error(NetMgrMsgID.INVALID_RESPONSE, (Object[])new String[]{this.m_endPoint.getConnectionURL().toString(), exception.getMessage()});
        return string;
    }

    public String processRepeaterTestRequest() throws NetworkException {
        String string = "";
        try {
            OCMHTTPResponse oCMHTTPResponse = this.getOCMConnection().Post("EMCCR_TEST_CMD", null);
            int n = oCMHTTPResponse.getStatusCode();
            if (n >= 300) {
                switch (n) {
                    case 500: {
                        throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.REPEATER_UNAVAILABLE_ERR, false, (Object[])new Integer[]{new Integer(n)}));
                    }
                }
                throw new NetworkException(s_msgBundle.getMessage(NetMgrMsgID.HTTP_FAILURE, false, new Object[]{new Integer(n), oCMHTTPResponse.getReasonLine(), oCMHTTPResponse.getText()}));
            }
            if (oCMHTTPResponse instanceof OCMRepeaterHTTPResponse) {
                string = ((OCMRepeaterHTTPResponse)oCMHTTPResponse).getRepeaterMessage();
            }
        }
        catch (Exception exception) {
            throw new NetworkException(exception.getMessage());
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        s_strOracleHome = System.getProperty("ORACLE_HOME");
        HTTPConnection.setDefaultAllowUserInteraction((boolean)true);
        AuthorizationPrompter authorizationPrompter = oracle.sysman.ccr.common.network.EndPoint.getAuthorizationHandler();
        if (authorizationPrompter == null) {
            oracle.sysman.ccr.common.network.EndPoint.setAuthorizationHandler((AuthorizationPrompter)new CCRProxyAuthorization());
        }
        HTTPConnection.setDefaultTimeout((int)OCMEndPoint.getReadTimeout());
        HTTPConnection.setDefaultConnectionTimeout((int)OCMEndPoint.getConnectionTimeout());
        try {
            s_unknownHostRE = new RE("^(.*?)(:.*)?$");
            s_portOutOfRangeRE = new RE("^port out of range:(\\d+)$");
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
    }
}

