/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.EncryptionKeysManager;
import oracle.sysman.ccr.common.network.JCEInitializationException;
import oracle.sysman.ccr.common.network.MessageEnvelopeHandler;
import oracle.sysman.ccr.common.network.OCMTunnelCommon;
import oracle.sysman.ccr.netmgr.CollectionInputStream;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMHTTPConnection;
import oracle.sysman.ccr.netmgr.OCMHTTPResponse;
import oracle.sysman.ccr.util.Utils;

public class OCMRepeaterHTTPConnection
extends OCMHTTPConnection {
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$netmgr$OCMHTTPConnection == null ? (class$oracle$sysman$ccr$netmgr$OCMHTTPConnection = OCMRepeaterHTTPConnection.class$("oracle.sysman.ccr.netmgr.OCMHTTPConnection")) : class$oracle$sysman$ccr$netmgr$OCMHTTPConnection));
    private static String REPEATER_URI = "/ocmrepeater/";
    private byte[] m_symKey = null;
    private PublicKey m_asymmKey = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$OCMHTTPConnection;

    public OCMRepeaterHTTPConnection(HTTPConnection hTTPConnection) {
        super(hTTPConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCMHTTPResponse Post(String string, CollectionInputStream collectionInputStream, long l, NVPair[] nVPairArray) throws ModuleException, IOException, GeneralSecurityException, NetworkException {
        byte[] byArray;
        HTTPResponse hTTPResponse;
        NVPair[] nVPairArray2 = this.createRepeaterParams(string);
        HttpOutputStream httpOutputStream = new HttpOutputStream();
        try {
            hTTPResponse = this.m_connection.Post(REPEATER_URI, httpOutputStream, nVPairArray2);
            byArray = this.getSymmetricKey();
            MessageEnvelopeHandler.writeEnvelope((InputStream)collectionInputStream, (OutputStream)httpOutputStream, (NVPair[])nVPairArray, (byte[])byArray);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            try {
                httpOutputStream.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    httpOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        try {
            httpOutputStream.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                httpOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return OCMHTTPResponse.createResponse(hTTPResponse, 1, byArray);
    }

    public OCMHTTPResponse Post(String string, byte[] byArray, NVPair[] nVPairArray) throws ModuleException, IOException, GeneralSecurityException, NetworkException {
        NVPair[] nVPairArray2 = this.createRepeaterParams(string);
        byte[] byArray2 = this.getSymmetricKey();
        return OCMHTTPResponse.createResponse(this.m_connection.Post(REPEATER_URI, MessageEnvelopeHandler.createEnvelope((byte[])byArray, (NVPair[])nVPairArray, (byte[])byArray2), nVPairArray2), 1, byArray2);
    }

    public OCMHTTPResponse Post(String string, NVPair[] nVPairArray) throws ModuleException, IOException, GeneralSecurityException, NetworkException {
        NVPair[] nVPairArray2 = this.createRepeaterParams(string);
        byte[] byArray = this.getSymmetricKey();
        return OCMHTTPResponse.createResponse(this.m_connection.Post(REPEATER_URI, MessageEnvelopeHandler.createEnvelope((NVPair[])nVPairArray, (byte[])byArray), nVPairArray2), 1, byArray);
    }

    public OCMHTTPResponse Get(String string) throws ModuleException, IOException, GeneralSecurityException, NetworkException {
        NVPair[] nVPairArray = this.createRepeaterParams(string);
        return OCMHTTPResponse.createResponse(this.m_connection.Get(REPEATER_URI, (NVPair[])null, nVPairArray), 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey getAsymmetricKey() throws GeneralSecurityException {
        if (this.m_asymmKey == null) {
            OCMRepeaterHTTPConnection oCMRepeaterHTTPConnection = this;
            synchronized (oCMRepeaterHTTPConnection) {
                if (this.m_asymmKey == null) {
                    this.m_asymmKey = EncryptionKeysManager.getInstanse(null).getPublicKey(EncryptionKeysManager.OCM_REPEATER_PUBLIC_KEY_CERT_NAME);
                }
            }
        }
        return this.m_asymmKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSymmetricKey() throws GeneralSecurityException {
        if (this.m_symKey == null) {
            OCMRepeaterHTTPConnection oCMRepeaterHTTPConnection = this;
            synchronized (oCMRepeaterHTTPConnection) {
                if (this.m_symKey == null) {
                    this.m_symKey = OCMTunnelCommon.generateSymmetricKey();
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Symmetric key is: " + Utils.toHex((byte[])this.m_symKey)));
                    }
                }
            }
        }
        return this.m_symKey;
    }

    private NVPair[] createRepeaterParams(String string) throws NetworkException {
        String string2;
        byte[] byArray = null;
        PublicKey publicKey = null;
        byte[] byArray2 = null;
        try {
            string2 = EncryptionKeysManager.getInstanse(null).getPublicKeyAliasName();
        }
        catch (KeyStoreException keyStoreException) {
            throw new NetworkException("Failed to get PublicKey Alias" + keyStoreException.getMessage());
        }
        try {
            byArray = this.getSymmetricKey();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JCEInitializationException("\nSupporting JDK does not contain required JCE support\nUse JDK>=1.4.2 and run emSnapshotEnv.");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException("Failed to get Symmetric Key " + generalSecurityException.getMessage());
        }
        try {
            publicKey = this.getAsymmetricKey();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException("Failed to get ASymmetric Key" + generalSecurityException.getMessage());
        }
        try {
            byArray2 = OCMTunnelCommon.encryptAsymmetric((byte[])byArray, (PublicKey)publicKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new NetworkException("Failed to get Encrypt symmetric Key" + generalSecurityException.getMessage());
        }
        if (s_logger.isDebugEnabled() && byArray2 != null) {
            s_logger.debug((Object)("encrypted sessionid length= " + byArray2.length));
        }
        if (byArray2 == null) {
            throw new NetworkException("encryptAssymetric failed to return valid result");
        }
        String string3 = Utils.toHex((byte[])byArray2);
        return new NVPair[]{new NVPair("X-ORCL-APPURL", string), new NVPair("X-ORCL-KEYNAME", string2 + ":" + 2), new NVPair("X-ORCL-OCMSID", string3)};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

