/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.netmgr;

import HTTPClient.NVPair;
import HTTPClient.URI;
import java.io.IOException;
import java.util.ArrayList;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.exception.KeyMismatchException;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagnosticUtil;
import oracle.sysman.ccr.netmgr.DiagnosticRequest;
import oracle.sysman.ccr.netmgr.DiagnosticResponse;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.netmgr.OCMNetworkMsgID;
import oracle.sysman.ccr.netmgr.ServerAccessException;

public class UploadConnection {
    private String m_hostName = null;
    private String m_oracleHome = null;
    private String m_configHome = null;
    private String m_orgID = null;
    private String m_regKey = null;
    private OCMEndPoint m_endPoint = null;
    private URI m_uri = null;
    private boolean m_isRepeater = false;
    private String m_SRNumber = null;
    private String m_packageName = null;
    private long m_packageSize = -1L;
    private String m_packageDigest = null;
    private String m_uploadClient = "OCM";
    private static Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$netmgr$UploadConnection == null ? (class$oracle$sysman$ccr$netmgr$UploadConnection = UploadConnection.class$("oracle.sysman.ccr.netmgr.UploadConnection")) : class$oracle$sysman$ccr$netmgr$UploadConnection));
    private static MessageBundle s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.netmgr.OCMNetwork");
    static /* synthetic */ Class class$oracle$sysman$ccr$netmgr$UploadConnection;

    public UploadConnection(URI uRI, String string, String string2, String string3, String string4, String string5, String string6, String string7, long l, String string8, boolean bl) throws NetworkException, ServerAccessException, KeyMismatchException {
        if (string5 != null && string5.length() > 0) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Establishing connection to diagnostic server: " + uRI.toExternalForm()), (String)string6, (String)string7));
            }
            this.m_hostName = string;
            this.m_oracleHome = string2;
            this.m_configHome = string3;
            this.m_orgID = string4;
            this.m_regKey = string5;
            this.m_SRNumber = string6;
            this.m_packageName = string7;
            this.m_packageSize = l;
            this.m_packageDigest = string8;
            this.m_uri = uRI;
            this.m_isRepeater = bl;
            this.m_uploadClient = "OCM";
            try {
                this.m_endPoint = new OCMEndPoint(this.m_uri, this.m_isRepeater);
            }
            catch (NetworkException networkException) {
                throw this.convertToDiagnosticException(networkException);
            }
        } else {
            String string9 = s_msgBundle.getMessage(OCMNetworkMsgID.MISSING_REG_KEY, false);
            throw new KeyMismatchException(DiagnosticUtil.prefixMsg((String)string9, (String)string6, (String)string7));
        }
    }

    public UploadConnection(URI uRI, String string, String string2, String string3, long l, String string4, NetworkConfiguration networkConfiguration) throws NetworkException, ServerAccessException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Establishing connection to diagnostic server: " + uRI.toExternalForm()), (String)string2, (String)string3));
        }
        this.m_hostName = string;
        this.m_SRNumber = string2;
        this.m_packageName = string3;
        this.m_packageSize = l;
        this.m_packageDigest = string4;
        this.m_uri = uRI;
        this.m_isRepeater = networkConfiguration.getIsRepeater();
        this.m_uploadClient = "SDK";
        try {
            this.m_endPoint = new OCMEndPoint(this.m_uri, networkConfiguration.populateProxyProperties(), this.m_isRepeater);
        }
        catch (NetworkException networkException) {
            throw this.convertToDiagnosticException(networkException);
        }
    }

    private NetworkException convertToDiagnosticException(NetworkException networkException) {
        NetworkException networkException2 = null;
        String string = ((Throwable)((Object)networkException)).getMessage();
        s_logger.error(OCMNetworkMsgID.EXIT_ERROR_WRAPPER, (Object[])new String[]{string});
        System.err.println(string);
        Throwable throwable = null;
        throwable = networkException.getCause();
        while (throwable != null) {
            string = throwable.getMessage();
            s_logger.error(OCMNetworkMsgID.EXIT_ERROR_WRAPPER, (Object[])new String[]{string});
            System.err.println(string);
            if (throwable instanceof CCRException) {
                throwable = ((CCRException)throwable).getCause();
                continue;
            }
            if (throwable instanceof IOException) {
                string = s_msgBundle.getMessage(OCMNetworkMsgID.NETWORK_ACCESS_ERR, false);
                networkException2 = new NetworkException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_packageName));
                break;
            }
            string = s_msgBundle.getMessage(OCMNetworkMsgID.SERVER_ACCESS_ERR, false, new Object[]{this.m_uri.toExternalForm()});
            networkException2 = new ServerAccessException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_packageName));
            break;
        }
        if (networkException2 != null) {
            return networkException2;
        }
        string = s_msgBundle.getMessage(OCMNetworkMsgID.SERVER_ACCESS_ERR, false, new Object[]{this.m_uri.toExternalForm()});
        return new ServerAccessException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_packageName));
    }

    private NVPair[] setupHeaders() {
        ArrayList<NVPair> arrayList = new ArrayList<NVPair>();
        arrayList.add(new NVPair("X-ORCL-HOST", this.m_hostName));
        arrayList.add(new NVPair("X-ORCL-ORGI", this.m_orgID));
        arrayList.add(new NVPair("X-ORCL-HOME", this.m_oracleHome));
        arrayList.add(new NVPair("X-ORCL-CFGHOME", this.m_configHome));
        arrayList.add(new NVPair("X-ORCL-REGKEY", this.m_regKey));
        arrayList.add(new NVPair("X-ORCL-CCRDIAGPROT", "2.0.0.0.0"));
        arrayList.add(new NVPair("X-ORCL-SR", this.m_SRNumber));
        arrayList.add(new NVPair("X-ORCL-PKGNAME", this.m_packageName.replace(System.getProperty("file.separator").charAt(0), '/')));
        arrayList.add(new NVPair("X-ORCL-PKGSIZE", Long.toString(this.m_packageSize)));
        arrayList.add(new NVPair("X-ORCL-PKGDIGEST", this.m_packageDigest));
        arrayList.add(new NVPair("X-ORCL-DRCLIENT", this.m_uploadClient));
        NVPair[] nVPairArray = new NVPair[arrayList.size()];
        arrayList.toArray(nVPairArray);
        return nVPairArray;
    }

    private NVPair[] setupNonOHHeaders() {
        ArrayList<NVPair> arrayList = new ArrayList<NVPair>();
        arrayList.add(new NVPair("X-ORCL-HOST", this.m_hostName));
        arrayList.add(new NVPair("X-ORCL-CCRDIAGPROT", "2.0.0.0.0"));
        arrayList.add(new NVPair("X-ORCL-SR", this.m_SRNumber));
        arrayList.add(new NVPair("X-ORCL-PKGNAME", this.m_packageName.replace(System.getProperty("file.separator").charAt(0), '/')));
        arrayList.add(new NVPair("X-ORCL-PKGSIZE", Long.toString(this.m_packageSize)));
        arrayList.add(new NVPair("X-ORCL-PKGDIGEST", this.m_packageDigest));
        arrayList.add(new NVPair("X-ORCL-DRCLIENT", this.m_uploadClient));
        NVPair[] nVPairArray = new NVPair[arrayList.size()];
        arrayList.toArray(nVPairArray);
        return nVPairArray;
    }

    public DiagnosticResponse send(String string, DiagnosticRequest diagnosticRequest, String string2) throws NetworkException, ServerAccessException, InvalidResponseException {
        NVPair[] nVPairArray = null;
        if (string2 == null) {
            if (this.m_uploadClient == "OCM") {
                nVPairArray = this.setupHeaders();
            } else if (this.m_uploadClient == "SDK") {
                nVPairArray = this.setupNonOHHeaders();
            }
        } else {
            nVPairArray = new NVPair[]{new NVPair("X-ORCL-DIAGSID", string2), new NVPair("X-ORCL-CCRDIAGPROT", "2.0.0.0.0")};
        }
        try {
            byte[] byArray = this.m_endPoint.sendDiagnosticRequest(string, diagnosticRequest.toString().getBytes(), nVPairArray);
            DiagnosticResponse diagnosticResponse = new DiagnosticResponse(byArray);
            return diagnosticResponse;
        }
        catch (NetworkException networkException) {
            throw this.convertToDiagnosticException(networkException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

