/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocmSDK.component;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import oracle.sysman.ccr.ocmSDK.component.ComponentStateException;
import oracle.sysman.ccr.ocmSDK.component.ComponentVersion;
import oracle.sysman.ccr.ocmSDK.component.InvalidComponentException;
import oracle.sysman.ccr.ocmSDK.component.InvalidComponentVersionException;
import oracle.sysman.ccr.ocmSDK.component.ManifestVersion;

public class Component {
    private String m_strPackageName = null;
    private ComponentVersion m_packageVersion = null;
    private String m_strPackageDescription = null;
    private String m_strPackageBuildDate = null;
    private String m_strPackageHeader = null;
    private String m_strPlatform = null;
    private String m_strArchitecture = null;
    private String m_strFilename = null;
    private boolean m_bMandatory = false;
    private String m_strChksum = null;
    protected JarFile m_jarFile = null;
    private boolean m_bVerifiedContent = false;
    private static String PACKAGE_NAME = "package-name";
    private static String PACKAGE_DESCR = "package-description";
    private static String PACKAGE_VERSION = "package-version";
    private static String PACKAGE_DATE = "package-date";
    private static String PACKAGE_HEADER = "package-header";
    private static String PACKAGE_MANIFEST_VER = "package-metadata-version";
    private static String PACKAGE_PLATFORM = "package-platform";
    private static final String GENERIC = "generic";
    private static String PACKAGE_ARCHITECTURE = "package-architecture";

    public Component(File file) throws InvalidComponentException {
        this(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component(File file, boolean bl) throws InvalidComponentException {
        try {
            this.m_jarFile = this.openJar(file, bl);
            Manifest manifest = this.getManifest(this.m_jarFile);
            this.init(manifest);
            this.m_strFilename = file.getAbsolutePath();
            this.m_bVerifiedContent = true;
        }
        finally {
            if (!bl) {
                this.close();
            }
        }
    }

    public Component(String string, String string2, String string3, String string4, String string5) throws InvalidComponentException {
        this.setComponentName(string);
        this.setComponentVersion(string2);
        this.setComponentHeader(string3);
        if (string4 != null) {
            this.setComponentPlatform(string4);
        }
        if (string5 != null) {
            this.setComponentArchitecture(string5);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Component(String string, String string2, String string3, String string4) throws InvalidComponentException {
        this.setComponentName(string);
        this.setComponentVersion(string2);
        this.setMandatoryComponent(string3);
        this.setComponentFilename(string4);
    }

    public void close() {
        if (this.m_jarFile != null) {
            try {
                this.m_jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_jarFile = null;
        }
    }

    public String getComponentBuildDate() {
        return this.m_strPackageBuildDate;
    }

    public String getComponentDescription() {
        return this.m_strPackageDescription;
    }

    public String getComponentFilename() {
        return this.m_strFilename;
    }

    public String getChksum() {
        return this.m_strChksum;
    }

    public String getComponentHeader() {
        return this.m_strPackageHeader;
    }

    public String getComponentName() {
        return this.m_strPackageName;
    }

    public ComponentVersion getComponentVersion() {
        return this.m_packageVersion;
    }

    public String getComponentArchitecture() {
        return this.m_strArchitecture;
    }

    public boolean isValid() {
        return this.m_strPackageName != null && this.m_strPackageName.trim().length() > 0 && this.m_packageVersion != null && this.m_strFilename != null;
    }

    public boolean isMandatory() throws ComponentStateException {
        if (this.m_bVerifiedContent) {
            throw new ComponentStateException("INTERNAL - Detected incorrectly request for a mandatory state for " + this.getComponentFilename());
        }
        return this.m_bMandatory;
    }

    private Manifest getManifest(JarFile jarFile) throws InvalidComponentException {
        Manifest manifest = null;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException iOException) {
            throw new InvalidComponentException("Error extracting Manifest from the package", iOException);
        }
        if (manifest == null) {
            throw new InvalidComponentException("Invalid/incomplete package for {0}");
        }
        return manifest;
    }

    private void init(Manifest manifest) throws InvalidComponentException {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            throw new InvalidComponentException("Package is missing Manifest");
        }
        String string = attributes.getValue(PACKAGE_MANIFEST_VER);
        if (string == null) {
            throw new InvalidComponentException("Invalid component package. Missing Manifest version.");
        }
        this.setComponentName(attributes.getValue(PACKAGE_NAME));
        this.setComponentDescr(attributes.getValue(PACKAGE_DESCR));
        this.setComponentVersion(attributes.getValue(PACKAGE_VERSION));
        this.setComponentHeader(attributes.getValue(PACKAGE_HEADER));
        this.setComponentBuildDate(attributes.getValue(PACKAGE_DATE));
        ManifestVersion manifestVersion = new ManifestVersion(string);
        if (manifestVersion.compare(ManifestVersion.CCR_MANIFEST_VER_1_0) == 1) {
            this.setComponentPlatform(attributes.getValue(PACKAGE_PLATFORM));
        }
        if (manifestVersion.compare(ManifestVersion.CCR_MANIFEST_VER_1_1) == 1) {
            this.setComponentArchitecture(attributes.getValue(PACKAGE_ARCHITECTURE));
        }
    }

    private JarFile openJar(File file, boolean bl) throws InvalidComponentException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InvalidComponentException("Oracle Configuration Manager Software package not found", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new InvalidComponentException("Error reading the JAR file", iOException);
        }
        return jarFile;
    }

    private void setComponentBuildDate(String string) {
        this.m_strPackageBuildDate = string;
    }

    private void setComponentDescr(String string) {
        this.m_strPackageDescription = string;
    }

    private void setComponentPlatform(String string) throws InvalidComponentException {
        int n;
        String string2 = System.getProperty("os.name");
        if (string == null) {
            throw new InvalidComponentException("Component definition is lacking a platform specification!");
        }
        int n2 = string2.indexOf(" ");
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        if ((n = string.indexOf(" ")) > 0) {
            string = string.substring(0, n);
        }
        if (!string.equals(string2) && !string.equalsIgnoreCase(GENERIC)) {
            throw new InvalidComponentException("Component detected for " + string + " on " + string2);
        }
        this.m_strPlatform = string;
    }

    private void setComponentArchitecture(String string) {
        this.m_strArchitecture = string;
    }

    private void setComponentHeader(String string) throws InvalidComponentException {
        this.m_strPackageHeader = string;
        if (this.m_strPackageHeader == null) {
            throw new InvalidComponentException("Missing Component Header");
        }
        this.m_strPackageHeader = this.m_strPackageHeader.trim();
        if (this.m_strPackageHeader.length() == 0) {
            throw new InvalidComponentException("Missing Component Header");
        }
    }

    private void setComponentName(String string) throws InvalidComponentException {
        this.m_strPackageName = string;
        if (this.m_strPackageName == null) {
            throw new InvalidComponentException("Missing Component Name");
        }
        this.m_strPackageName = this.m_strPackageName.trim();
        if (this.m_strPackageName.length() == 0) {
            throw new InvalidComponentException("Missing Component Name");
        }
        if (this.m_strPackageName.equals("pending")) {
            throw new InvalidComponentException("Invalid package - package name pendingis reserved");
        }
    }

    private void setComponentVersion(String string) throws InvalidComponentException {
        try {
            this.m_packageVersion = ComponentVersion.valueOf(string);
        }
        catch (InvalidComponentVersionException invalidComponentVersionException) {
            throw new InvalidComponentException("Bad Manifest property", (Throwable)((Object)invalidComponentVersionException));
        }
    }

    private void setMandatoryComponent(String string) {
        this.m_bMandatory = Boolean.valueOf(string);
    }

    private void setComponentFilename(String string) {
        this.m_strFilename = string;
    }

    protected void setChksum(String string) {
        this.m_strChksum = string;
    }
}

