/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocmSDK.component;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.ocmSDK.component.Component;
import oracle.sysman.ccr.ocmSDK.component.ComponentVerificationException;
import oracle.sysman.ccr.ocmSDK.component.InvalidComponentException;
import oracle.sysman.ccr.util.TrustedKeystore;
import oracle.sysman.ccr.util.TrustedKeystoreException;

public class SignedComponent
extends Component {
    public SignedComponent(File file) throws InvalidComponentException {
        super(file, true);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("No Jar files identified to verify");
        } else {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    SignedComponent.verify(stringArray[i]);
                }
            }
            catch (CCRException cCRException) {
                Throwable throwable = cCRException;
                while (throwable != null) {
                    System.err.println(throwable.getMessage());
                    if (throwable instanceof CCRException) {
                        CCRException cCRException2 = throwable;
                        throwable = cCRException2.getCause();
                        continue;
                    }
                    throwable = null;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getMessage());
            }
        }
    }

    public static void verify(String string) throws ComponentVerificationException, InvalidComponentException, FileNotFoundException {
        SignedComponent.verify(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verify(String string, File file) throws ComponentVerificationException, InvalidComponentException, FileNotFoundException {
        Component component = null;
        try {
            component = new SignedComponent(new File(string));
            Vector vector = super.verifySignatures();
            super.verifyCertificates(vector, file);
        }
        finally {
            if (component != null) {
                component.close();
            }
        }
    }

    private Vector verifySignatures() throws FileNotFoundException, ComponentVerificationException {
        ZipEntry zipEntry = null;
        Vector<ZipEntry> vector = new Vector<ZipEntry>();
        byte[] byArray = new byte[8192];
        try {
            Enumeration<JarEntry> enumeration = this.m_jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                zipEntry = enumeration.nextElement();
                vector.add(zipEntry);
                InputStream inputStream = this.m_jarFile.getInputStream(zipEntry);
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ComponentVerificationException("An error was encountered reading the component package " + this.m_jarFile.getName(), iOException);
        }
        catch (SecurityException securityException) {
            throw new ComponentVerificationException(zipEntry.getName() + " in signed JAR file has been tampered with", securityException);
        }
        finally {
            this.close();
        }
        return vector;
    }

    private void verifyCertificates(Vector vector, File file) throws FileNotFoundException, ComponentVerificationException {
        KeyStore keyStore = null;
        try {
            keyStore = null == file ? TrustedKeystore.getInstance() : TrustedKeystore.createKeyStore((String)file.getPath());
        }
        catch (TrustedKeystoreException trustedKeystoreException) {
            throw new ComponentVerificationException("Unable to verify certificates for signed jar", trustedKeystoreException);
        }
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = (JarEntry)enumeration.nextElement();
            String string = jarEntry.getName();
            if (string.toUpperCase().startsWith("META-INF/")) continue;
            ++n;
            Certificate[] certificateArray = jarEntry.getCertificates();
            if (certificateArray == null) {
                throw new ComponentVerificationException("Component Element " + string + " was not signed");
            }
            if (certificateArray.length <= 0) continue;
            try {
                String string2 = keyStore.getCertificateAlias(certificateArray[0]);
                if (string2 != null) continue;
                throw new ComponentVerificationException("Certificate validation problem encountered for " + string, (Throwable)((Object)new ComponentVerificationException("Component signed by an unknown certificate")));
            }
            catch (KeyStoreException keyStoreException) {
                keyStoreException.printStackTrace();
            }
        }
        if (n <= 0) {
            throw new ComponentVerificationException("Component contains no elements");
        }
    }
}

