/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocmSDK.diagUpload;

import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.ResourceID;
import oracle.sysman.ccr.common.exception.CSIMismatchException;
import oracle.sysman.ccr.common.exception.InternalException;
import oracle.sysman.ccr.common.exception.InvalidCredentialsException;
import oracle.sysman.ccr.common.exception.InvalidEndPointException;
import oracle.sysman.ccr.common.exception.InvalidRequestException;
import oracle.sysman.ccr.common.exception.InvalidSRException;
import oracle.sysman.ccr.common.exception.KeyMismatchException;
import oracle.sysman.ccr.common.exception.MessageFormatException;
import oracle.sysman.ccr.common.exception.NoSuchReqException;
import oracle.sysman.ccr.common.exception.SRClosedException;
import oracle.sysman.ccr.common.exception.SRFormatException;
import oracle.sysman.ccr.common.exception.network.InvalidResponseException;
import oracle.sysman.ccr.common.exception.network.InvalidSessionException;
import oracle.sysman.ccr.common.exception.network.NotSupportedException;
import oracle.sysman.ccr.common.exception.network.ServerException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagPackage;
import oracle.sysman.ccr.diagnostic.common.DiagUploadState;
import oracle.sysman.ccr.diagnostic.common.DiagnosticUtil;
import oracle.sysman.ccr.diagnostic.common.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.AlreadyUploadedException;
import oracle.sysman.ccr.diagnostic.common.exception.DuplicateUploadException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.InvalidPackageException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageModifiedException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageNotFoundException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.InvalidStateException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;
import oracle.sysman.ccr.netmgr.DiagnosticResponse;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.ServerAccessException;
import oracle.sysman.ccr.netmgr.SessionTimeoutLimitException;
import oracle.sysman.ccr.netmgr.UploadConnection;
import oracle.sysman.ccr.netmgr.UploadRequest;
import oracle.sysman.ccr.netmgr.ValidationRequest;
import oracle.sysman.ccr.ocmSDK.diagUpload.UploadStatusEvent;
import oracle.sysman.ccr.ocmSDK.diagUpload.UploadStatusListener;
import org.apache.log4j.PropertyConfigurator;

public class DiagUploader {
    protected UploadStatusListener m_USL = null;
    protected String m_SRNumber = null;
    protected DiagPackage m_diagPkg = null;
    protected DiagUploadState m_uploadState = null;
    protected UploadConnection m_diagCon = null;
    protected long m_progress = -1L;
    protected String m_state = null;
    protected boolean restart = false;
    protected int m_sessionTimeout = -1;
    protected String m_sessionID = null;
    protected UploadRequest m_request = null;
    protected DiagnosticResponse m_response = null;
    protected NetworkConfiguration m_netConfig = null;
    protected boolean m_bAbort = false;
    protected boolean m_busy = false;
    private Object syncObject = new Object();
    protected String m_hostName = null;
    protected ValidationRequest m_valRequest = null;
    protected static final String START_UPLOAD_URI = "/emdiag/upload";
    protected static final String RESTART_UPLOAD_URI = "/emdiag/restartUpload";
    protected static final String CONTINUE_UPLOAD_URI = "/emdiag/continuation";
    protected int m_chunkSize = -1;
    static final String OCM_LOG_LEVEL = "OCM_LOG_LEVEL";
    static final String DEFAULT_LOG_LEVEL = "WARN";
    private static Logger s_logger;
    private static MessageBundle s_msgBundle;
    static /* synthetic */ Class class$oracle$sysman$ccr$ocmSDK$diagUpload$DiagUploader;

    public static void init() {
        if (!Logger.isLoggingConfigured()) {
            Properties properties = new Properties();
            ((Hashtable)properties).put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
            ((Hashtable)properties).put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
            ((Hashtable)properties).put("log4j.appender.Console.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
            String string = System.getProperty(OCM_LOG_LEVEL);
            if (string == null) {
                string = DEFAULT_LOG_LEVEL;
            }
            ((Hashtable)properties).put("log4j.rootCategory", string + ", Console");
            PropertyConfigurator.configure((Properties)properties);
        }
        System.setProperty("ocm.keystore_resource", "true");
        s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$ocmSDK$diagUpload$DiagUploader == null ? (class$oracle$sysman$ccr$ocmSDK$diagUpload$DiagUploader = DiagUploader.class$("oracle.sysman.ccr.ocmSDK.diagUpload.DiagUploader")) : class$oracle$sysman$ccr$ocmSDK$diagUpload$DiagUploader));
    }

    protected DiagUploader(String string, String string2) throws InvalidPackageException, PackageNotFoundException, PackageAccessException, InternalException {
        this();
        this.printMesgID(UploaderMsgID.INIT_UPLOAD);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Initializing upload.", (String)string, (String)string2));
        }
        this.m_SRNumber = string;
        this.m_diagPkg = new DiagPackage(string2);
        this.m_sessionTimeout = 150;
        this.m_chunkSize = 524288;
    }

    public DiagUploader() {
    }

    protected void updateState() throws StateCreationException, StateAccessException {
        this.m_uploadState.update(this.m_state, this.m_progress);
        if (this.m_USL != null) {
            UploadStatusEvent uploadStatusEvent = new UploadStatusEvent(this, this.m_uploadState);
            this.m_USL.UploadStatusAlert(uploadStatusEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(NetworkConfiguration networkConfiguration, String string, String string2, byte[] byArray, File file, UploadStatusListener uploadStatusListener) throws ServerAccessException, PackageAccessException, PackageModifiedException, SessionTimeoutLimitException, InvalidStateException, InvalidEndPointException, NetworkException, InvalidResponseException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, DuplicateUploadException, AlreadyUploadedException, SRClosedException, InvalidRequestException, ServerException, InvalidCredentialsException, CSIMismatchException, SSLPeerUnverifiedException, UnknownHostException, IOException, InvalidPackageException, PackageNotFoundException, InternalException, SRFormatException, ConnectionException {
        if (networkConfiguration == null) {
            throw new IllegalArgumentException("pass valid NetworkConfiguration");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("pass valid SR number");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("pass valid Metalink Username");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("pass valid Metalink password");
        }
        if (file == null) {
            throw new IllegalArgumentException("pass valid package File");
        }
        Object object = this.syncObject;
        synchronized (object) {
            if (this.m_busy) {
                throw new InvalidRequestException("An Upload is in progress");
            }
            this.m_busy = true;
        }
        try {
            DiagnosticUtil.validateSRFormat((String)string, (String)file.getAbsolutePath());
            this.m_SRNumber = string;
            this.m_diagPkg = new DiagPackage(file.getAbsolutePath());
            this.m_sessionTimeout = 150;
            this.m_chunkSize = 524288;
            this.m_USL = uploadStatusListener;
            this.m_netConfig = networkConfiguration;
            this.restart = false;
            this.printMesgID(UploaderMsgID.STARTING_UPLOAD);
            this.m_uploadState = new DiagUploadState(this.m_SRNumber, this.m_diagPkg.getName(), this.m_diagPkg.getSize(), this.m_diagPkg.getDigest());
            this.m_progress = 0L;
            this.m_valRequest = new ValidationRequest();
            this.m_valRequest.createValidationXML("1.0", string2, new String(byArray).toCharArray());
            this.connect();
            this.upload();
        }
        catch (StateCreationException stateCreationException) {
        }
        catch (StateAccessException stateAccessException) {
        }
        catch (KeyMismatchException keyMismatchException) {
        }
        finally {
            this.cleanup();
        }
    }

    private void connect() throws InvalidEndPointException, NetworkException, ServerAccessException, KeyMismatchException, SSLPeerUnverifiedException, UnknownHostException, IOException, ConnectionException {
        this.printMesgID(UploaderMsgID.CONNECTING);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Retrieving connection parameters for diagnostic upload.", (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        URI uRI = null;
        boolean bl = false;
        EndPointAddr endPointAddr = this.getEndpoint();
        if (endPointAddr != null) {
            uRI = endPointAddr.getURI();
            bl = endPointAddr.getIsRepeater();
        }
        this.m_hostName = Hostname.getHostname();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Establishing connection to diagnostic receiver: " + uRI.toExternalForm()), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("host name: " + this.m_hostName), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        this.m_diagCon = new UploadConnection(uRI, this.m_hostName, this.m_SRNumber, this.m_diagPkg.getName(), this.m_diagPkg.getSize(), this.m_diagPkg.getDigest(), this.m_netConfig);
    }

    private EndPointAddr getEndpoint() throws SSLPeerUnverifiedException, UnknownHostException, IOException, InvalidEndPointException, ConnectionException {
        EndPoint endPoint = null;
        URL uRL = null;
        URI uRI = null;
        EndPointAddr endPointAddr = null;
        endPoint = this.m_netConfig.testExtendedConnection();
        if (endPoint == null) {
            endPoint = this.m_netConfig.testProxyConnection();
        }
        if (endPoint == null) {
            String string = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_ENDPOINT_ERROR, false);
            throw new InvalidEndPointException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        uRL = endPoint.getConnectionURL();
        String string = START_UPLOAD_URI;
        if (this.restart) {
            string = RESTART_UPLOAD_URI;
        }
        try {
            uRI = new URI(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
            endPointAddr = new EndPointAddr(null, this.m_netConfig.getIsRepeater(), uRI);
        }
        catch (ParseException parseException) {
            String string2 = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_ENDPOINT_ERROR, false);
            throw new InvalidEndPointException(DiagnosticUtil.prefixMsg((String)string2, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        return endPointAddr;
    }

    protected void upload() throws InvalidEndPointException, NetworkException, ServerAccessException, KeyMismatchException, StateCreationException, StateAccessException, PackageAccessException, PackageModifiedException, InvalidResponseException, SessionTimeoutLimitException, InvalidStateException, InvalidRequestException, ServerException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, DuplicateUploadException, AlreadyUploadedException, InvalidCredentialsException, SRClosedException, CSIMismatchException {
        String string = null;
        int n = 0;
        byte[] byArray = null;
        this.printMesgID(UploaderMsgID.UPLOADING);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Allocating " + this.m_chunkSize + " bytes memory for chunk buffer"), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        byArray = new byte[this.m_chunkSize];
        this.m_request = new UploadRequest();
        if (this.restart) {
            string = RESTART_UPLOAD_URI;
            n = this.m_diagPkg.readChunk(this.m_progress, byArray);
        } else {
            string = START_UPLOAD_URI;
            if (!this.sendValidationRequest(string)) {
                this.handleFailureResponse(true);
            } else {
                string = CONTINUE_UPLOAD_URI;
                n = this.m_diagPkg.readChunk(byArray);
            }
        }
        this.m_state = "STARTED";
        while (!this.m_state.equalsIgnoreCase("COMPLETED") && !this.m_bAbort) {
            if (!this.uploadChunk(string, byArray, n)) {
                if (this.m_response.getFailureCode() == 6) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Session timed out at server.", (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
                    }
                    s_logger.error(UploaderMsgID.SESSION_TIMEOUT_ERR);
                    this.adjustSessionTimeout();
                    string = RESTART_UPLOAD_URI;
                    this.m_sessionID = null;
                    continue;
                }
                if (string.equals(START_UPLOAD_URI)) {
                    this.handleFailureResponse(true);
                    continue;
                }
                this.handleFailureResponse(false);
                continue;
            }
            string = CONTINUE_UPLOAD_URI;
            n = this.m_diagPkg.readChunk(byArray);
        }
        if (!this.m_bAbort) {
            this.printMesgID(UploaderMsgID.UPLOAD_COMPLETED);
        } else if (!this.m_state.equalsIgnoreCase("COMPLETED")) {
            this.m_state = "ABORTED";
            this.updateState();
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Cleaning up...", (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        if (this.m_diagPkg != null) {
            this.m_diagPkg.close();
        }
        Object object = this.syncObject;
        synchronized (object) {
            this.m_busy = false;
        }
    }

    public void abortUpload() {
        this.m_bAbort = true;
    }

    protected void adjustSessionTimeout() throws SessionTimeoutLimitException {
        if (this.m_sessionTimeout >= 600) {
            String string = s_msgBundle.getMessage(UploaderMsgID.SESSION_TIMEOUT_LIMIT_ERR, false, new Object[]{Integer.toString(600)});
            throw new SessionTimeoutLimitException(DiagnosticUtil.prefixMsg((String)string, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        this.m_sessionTimeout = (int)((double)this.m_sessionTimeout * 1.1);
        if (this.m_sessionTimeout > 600) {
            this.m_sessionTimeout = 600;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendValidationRequest(String string) throws NetworkException, ServerAccessException, InvalidResponseException {
        block8: {
            try {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Sending validation request to uri path " + string), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
                }
                this.m_response = null;
                this.m_response = this.m_diagCon.send(string, this.m_valRequest, this.m_sessionID);
                if (null == this.m_response || !this.m_response.isSuccessful()) break block8;
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Validation performed sucessfully.", (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
                }
                this.m_sessionID = this.m_response.getSessionID();
                boolean bl = true;
                Object var4_4 = null;
                if (this.m_valRequest != null) {
                    this.m_valRequest.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var4_6 = null;
                    if (this.m_valRequest == null) break block9;
                    this.m_valRequest.close();
                }
                throw throwable;
            }
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Validation unsuccessful. Server failure code: " + this.m_response.getFailureCode() + ", message: " + this.m_response.getFailureMsg()), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        boolean bl = false;
        Object var4_5 = null;
        if (this.m_valRequest != null) {
            this.m_valRequest.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean uploadChunk(String string, byte[] byArray, int n) throws NetworkException, ServerAccessException, InvalidResponseException, StateCreationException, StateAccessException {
        block12: {
            if (n <= 0) {
                n = 0;
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Preparing upload request for chunk of " + n + " bytes, offset is " + this.m_progress + " bytes, session timeout is " + this.m_sessionTimeout + " seconds."), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            this.m_request.prepareUploadRequest(byArray, n, this.m_progress, this.m_sessionTimeout);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Uploading chunk to uri path " + string + " with session ID: " + this.m_sessionID), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            try {
                this.m_response = null;
                this.m_response = this.m_diagCon.send(string, this.m_request, this.m_sessionID);
                Object var5_4 = null;
                if (this.m_response != null || START_UPLOAD_URI.equals(string)) break block12;
                this.m_state = "FAILED";
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.m_response == null && !START_UPLOAD_URI.equals(string)) {
                    this.m_state = "FAILED";
                    this.updateState();
                }
                throw throwable;
            }
            this.updateState();
            {
            }
        }
        if (null != this.m_response && this.m_response.isSuccessful()) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Chunk uploaded sucessfully.", (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            this.m_sessionID = this.m_response.getSessionID();
            if (this.m_sessionID.equals("0") && n == 0) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)"Diagnostic package uploaded sucessfully.", (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
                }
                this.m_state = "COMPLETED";
            } else {
                this.m_state = "STARTED";
            }
            this.m_progress += (long)n;
            this.updateState();
            return true;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)DiagnosticUtil.prefixMsg((String)("Upload unsuccessful. Server failure code: " + this.m_response.getFailureCode() + ", message: " + this.m_response.getFailureMsg()), (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
        }
        return false;
    }

    protected void handleFailureResponse(boolean bl) throws StateCreationException, StateAccessException, InvalidStateException, InvalidRequestException, PackageModifiedException, ServerException, KeyMismatchException, InvalidSessionException, InvalidSRException, MessageFormatException, NoSuchReqException, NotSupportedException, DuplicateUploadException, AlreadyUploadedException, InvalidCredentialsException, SRClosedException, CSIMismatchException {
        int n = this.m_response.getFailureCode();
        String string = this.m_response.getFailureMsg();
        if (!bl) {
            this.m_state = "FAILED";
            this.updateState();
        }
        switch (n) {
            case 7: {
                String string2 = s_msgBundle.getMessage(UploaderMsgID.INVALID_UPLOAD_STATE, false);
                throw new InvalidStateException(DiagnosticUtil.prefixMsg((String)string2, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 8: {
                String string3 = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_MODIFIED_ERR, false, new Object[]{this.m_diagPkg.getName()});
                throw new PackageModifiedException(DiagnosticUtil.prefixMsg((String)string3, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 14: {
                String string4 = s_msgBundle.getMessage(UploaderMsgID.SERVER_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new ServerException(DiagnosticUtil.prefixMsg((String)string4, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 4: {
                String string5 = s_msgBundle.getMessage(UploaderMsgID.INVALID_REG_KEY, false);
                throw new KeyMismatchException(DiagnosticUtil.prefixMsg((String)string5, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 17: {
                String string6 = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_UPLOAD_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new InvalidRequestException(DiagnosticUtil.prefixMsg((String)string6, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 9: {
                String string7 = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_UPLOAD_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new InvalidSessionException(DiagnosticUtil.prefixMsg((String)string7, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 2: {
                String string8 = s_msgBundle.getMessage(UploaderMsgID.CSI_MISMATCH, false, new Object[]{this.m_SRNumber});
                throw new CSIMismatchException(DiagnosticUtil.prefixMsg((String)string8, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 18: {
                String string9 = s_msgBundle.getMessage(UploaderMsgID.DIAGNOSTIC_UPLOAD_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new MessageFormatException(DiagnosticUtil.prefixMsg((String)string9, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 3: {
                String string10 = s_msgBundle.getMessage(UploaderMsgID.NO_SUCH_REQ_RESTART, false);
                throw new NoSuchReqException(DiagnosticUtil.prefixMsg((String)string10, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 1: {
                String string11 = s_msgBundle.getMessage(UploaderMsgID.NOT_SUPPORTED, false, new Object[]{string});
                throw new NotSupportedException(string11);
            }
            case 10: {
                String string12 = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_MODIFIED_ERR, false);
                throw new PackageModifiedException(DiagnosticUtil.prefixMsg((String)string12, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 15: {
                String string13 = s_msgBundle.getMessage(UploaderMsgID.SERVER_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new ServerException(DiagnosticUtil.prefixMsg((String)string13, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 5: {
                String string14 = s_msgBundle.getMessage(UploaderMsgID.DUPLICATE_UPLOAD_REQ_SERVER, false, new Object[]{string});
                throw new DuplicateUploadException(DiagnosticUtil.prefixMsg((String)string14, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 16: {
                String string15 = s_msgBundle.getMessage(UploaderMsgID.SERVER_ERROR, false, new Object[]{Integer.toString(n), string});
                throw new ServerException(DiagnosticUtil.prefixMsg((String)string15, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 21: {
                this.m_state = "COMPLETED";
                this.updateState();
                String string16 = s_msgBundle.getMessage(UploaderMsgID.ALREADY_UPLOADED, false);
                throw new AlreadyUploadedException(DiagnosticUtil.prefixMsg((String)string16, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 22: {
                String string17 = s_msgBundle.getMessage(UploaderMsgID.INVALID_ML_CREDS, false);
                throw new InvalidCredentialsException(DiagnosticUtil.prefixMsg((String)string17, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 24: {
                String string18 = s_msgBundle.getMessage(UploaderMsgID.SR_CLOSED, false, new Object[]{this.m_SRNumber});
                throw new SRClosedException(DiagnosticUtil.prefixMsg((String)string18, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
            case 23: {
                String string19 = s_msgBundle.getMessage(UploaderMsgID.SR_NOT_FOUND, false, new Object[]{this.m_SRNumber});
                throw new InvalidSRException(DiagnosticUtil.prefixMsg((String)string19, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
            }
        }
        String string20 = s_msgBundle.getMessage(UploaderMsgID.SERVER_ERROR, false, new Object[]{Integer.toString(n), string});
        throw new ServerException(DiagnosticUtil.prefixMsg((String)string20, (String)this.m_SRNumber, (String)this.m_diagPkg.getName()));
    }

    protected void printMesgID(ResourceID resourceID) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)s_msgBundle.getMessage(resourceID, false));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        s_msgBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.diagnostic.common.Uploader");
        DiagUploader.init();
    }
}

