/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocmSDK.websvc;

import oracle.sysman.ccr.ocmSDK.common.ResourceID;
import oracle.sysman.ccr.ocmSDK.websvc.HttpException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcExceptionMsgID;

public class HttpClientException
extends HttpException {
    public HttpClientException(int n) {
        super(n, WebsvcException.s_msgBundle.getMessage(HttpClientException.mapErrToResID(n), false));
    }

    public HttpClientException(int n, Throwable throwable) {
        super(n, WebsvcException.s_msgBundle.getMessage(HttpClientException.mapErrToResID(n), false), throwable);
    }

    private static ResourceID mapErrToResID(int n) {
        ResourceID resourceID = null;
        if (n < 400 || n >= 500) {
            throw new RuntimeException("Exit code out of range (" + n + ")");
        }
        switch (n) {
            case 401: {
                resourceID = WebsvcExceptionMsgID.HTTP_401_UNAUTHORIZED;
                break;
            }
            case 403: {
                resourceID = WebsvcExceptionMsgID.HTTP_403_FORBIDDEN;
                break;
            }
            case 404: {
                resourceID = WebsvcExceptionMsgID.HTTP_404_NOT_FOUND;
                break;
            }
            case 405: {
                resourceID = WebsvcExceptionMsgID.HTTP_405_BAD_METHOD;
                break;
            }
            case 406: {
                resourceID = WebsvcExceptionMsgID.HTTP_406_NOT_ACCEPTABLE;
                break;
            }
            case 407: {
                resourceID = WebsvcExceptionMsgID.HTTP_407_PROXY_AUTH;
                break;
            }
            case 408: {
                resourceID = WebsvcExceptionMsgID.HTTP_408_CLIENT_TIMEOUT;
                break;
            }
            default: {
                resourceID = WebsvcExceptionMsgID.HTTP_400_BAD_REQUEST;
            }
        }
        return resourceID;
    }
}

