/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocmSDK.websvc;

import oracle.sysman.ccr.ocmSDK.common.ResourceID;
import oracle.sysman.ccr.ocmSDK.websvc.HttpException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcExceptionMsgID;

public class HttpServerException
extends HttpException {
    public HttpServerException(int n) {
        super(n, WebsvcException.s_msgBundle.getMessage(HttpServerException.mapErrToResID(n), false));
    }

    public HttpServerException(int n, Throwable throwable) {
        super(n, WebsvcException.s_msgBundle.getMessage(HttpServerException.mapErrToResID(n), false), throwable);
    }

    private static ResourceID mapErrToResID(int n) {
        ResourceID resourceID = null;
        if (n < 500 || n >= 600) {
            throw new RuntimeException("Exit code out of range (" + n + ")");
        }
        switch (n) {
            case 500: {
                resourceID = WebsvcExceptionMsgID.HTTP_500_ISE;
                break;
            }
            case 502: {
                resourceID = WebsvcExceptionMsgID.HTTP_502_BAD_GATEWAY;
                break;
            }
            case 503: {
                resourceID = WebsvcExceptionMsgID.HTTP_503_SERVICE_UNAVAILABLE;
            }
            case 504: {
                resourceID = WebsvcExceptionMsgID.HTTP_504_GATEWAY_TIMEOUT;
                break;
            }
            case 505: {
                resourceID = WebsvcExceptionMsgID.HTTP_505_VERSION;
                break;
            }
            default: {
                resourceID = WebsvcExceptionMsgID.HTTP_5xx_UNKNOWN;
            }
        }
        return resourceID;
    }
}

