/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocmSDK.websvc;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.NVPair;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.ocmSDK.common.Config;
import oracle.sysman.ccr.ocmSDK.common.FileSpec;
import oracle.sysman.ccr.ocmSDK.websvc.InvalidOCMStateException;
import oracle.sysman.ccr.ocmSDK.websvc.OCMNotConfiguredException;
import oracle.sysman.ccr.ocmSDK.websvc.PathNotADirectoryException;
import oracle.sysman.ccr.ocmSDK.websvc.UnexpectedOCMConfigException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcExceptionMsgID;
import oracle.sysman.ccr.util.Process;
import oracle.sysman.ccr.util.crypt.OCMCrypt;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class OCMConfig
extends Config
implements AuthorizationPrompter {
    private static final Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$ocmSDK$websvc$OCMConfig == null ? (class$oracle$sysman$ccr$ocmSDK$websvc$OCMConfig = OCMConfig.class$("oracle.sysman.ccr.ocmSDK.websvc.OCMConfig")) : class$oracle$sysman$ccr$ocmSDK$websvc$OCMConfig));
    private static final String CCR_CONFIG_ROOT_SUBDIR = "ccr";
    private static final String CCR_HOSTS_SUBDIR = "hosts";
    private static final String BAT_FILETYPE = ".bat";
    private static final String SH_FILETYPE = "";
    private static final String CCR_PROPERTIES_FNM = "ccr.properties";
    private static final String COLLECTOR_PROPERTIES_FNM = "collector.properties";
    private static final String CCR_DEFAULT_ENDPOINT = "https://ccr.oracle.com";
    private static final String CCR_HOME = "ccr";
    private static final String LIB_DIR = "lib";
    private static final String EMCCR_JAR = "emCCR.jar";
    private static final String EMOCMUTL = "emocmutl";
    private static final String CONFIG_DIR = "config";
    private static final String CONFIG_DEFAULT_DIR = "default";
    private static final String STATE_DIR = "state";
    private static final String STATE_DIAGNOSTIC_DIR = "diagnostic";
    private static final String LOG_DIR = "log";
    private static final String CCR_DISCONNECTED_PROP = "ccr.disconnected";
    static final String CCR_ENDPOINT_PROP = "ccr.endpoint";
    private static final String PROXY_USER = "http.proxyUser";
    private static final String PROXY_PASSWORD = "http.proxyPassword";
    static final String PROXY_HOST = "http.proxyHost";
    static final String PROXY_PORT = "http.proxyPort";
    private String m_strInstallRoot = null;
    private String m_strConfigRoot = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$ocmSDK$websvc$OCMConfig;

    public static OCMConfig getInstance(String string, String string2) throws PathNotADirectoryException, OCMNotConfiguredException, InvalidOCMStateException, UnexpectedOCMConfigException, FileNotFoundException {
        return OCMConfig.getInstance(string, string2, false);
    }

    public static OCMConfig getInstance(String string, String string2, boolean bl) throws PathNotADirectoryException, OCMNotConfiguredException, InvalidOCMStateException, UnexpectedOCMConfigException, FileNotFoundException {
        Object object;
        OCMConfig oCMConfig = null;
        OCMConfig.validatePaths(string, string2);
        String string3 = null;
        string3 = string2 != null ? FileSpec.catfile(new String[]{string2, "ccr"}) : OCMConfig.getHostInstanceConfigRoot(string);
        if (!(string3 == null || ((File)(object = new File(string3))).exists() && ((File)object).isDirectory())) {
            string3 = null;
        }
        try {
            object = FileSpec.catfile(new String[]{string, "ccr", CONFIG_DIR});
            String string4 = FileSpec.catfile(new String[]{string, "ccr", CONFIG_DIR, CONFIG_DEFAULT_DIR});
            if (string3 == null) {
                oCMConfig = new OCMConfig(string, string3, string4, (String)object);
            } else {
                String string5 = FileSpec.catfile(new String[]{string3, CONFIG_DIR});
                String string6 = FileSpec.catfile(new String[]{string3, CONFIG_DIR, CONFIG_DEFAULT_DIR});
                oCMConfig = new OCMConfig(string, string3, string4, (String)object, string6, string5);
            }
            if (!oCMConfig.isOCMConfigured()) {
                throw new OCMNotConfiguredException();
            }
            if (!bl && oCMConfig.isDisconnectedMode()) {
                throw new InvalidOCMStateException();
            }
        }
        catch (IOException iOException) {
            throw new UnexpectedOCMConfigException(iOException);
        }
        return oCMConfig;
    }

    private static String getHostInstanceConfigRoot(String string) throws UnexpectedOCMConfigException {
        String string2 = FileSpec.catfile(new String[]{string, "ccr", CCR_HOSTS_SUBDIR});
        File file = new File(string2);
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        String string3 = OCMConfig.getHostname(string);
        return FileSpec.catfile(new String[]{string2, string3});
    }

    private static String stripTrimHostname(String string) {
        String string2 = null;
        try {
            RE rE = new RE("([0-9a-zA-Z\\-\\.]+)");
            if (rE.match(string)) {
                string2 = rE.getParen(0);
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
        }
        catch (RESyntaxException rESyntaxException) {
            string2 = null;
        }
        return string2;
    }

    private static String getHostname(String string) throws UnexpectedOCMConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        try {
            String string2 = OCMConfig.getUtilityCmd(string);
            Process process = Process.exec((String[])new String[]{string2, "get_hostname"}, null, null, null);
            n = process.waitFor(stringBuffer);
            if (n == 0) {
                return OCMConfig.stripTrimHostname(stringBuffer.toString());
            }
            throw new UnexpectedOCMConfigException(WebsvcException.formatMsg(WebsvcExceptionMsgID.HOSTCMD_LAUNCH_ERR, new Integer[]{new Integer(n)}));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UnexpectedOCMConfigException(WebsvcException.formatMsg(WebsvcExceptionMsgID.OLD_OCM));
        }
        catch (IOException iOException) {
            throw new UnexpectedOCMConfigException(WebsvcException.formatMsg(WebsvcExceptionMsgID.HOST_OS_LAUNCH_FAILURE));
        }
        catch (InterruptedException interruptedException) {
            throw new UnexpectedOCMConfigException(interruptedException);
        }
    }

    private static String getUtilityCmd(String string) throws FileNotFoundException {
        String string2 = System.getProperty("os.name").startsWith("Windows") ? BAT_FILETYPE : SH_FILETYPE;
        String string3 = FileSpec.catfile(new String[]{string, "ccr", LIB_DIR, EMOCMUTL}) + string2;
        File file = new File(string3);
        if (!file.exists()) {
            throw new FileNotFoundException(string3);
        }
        return string3;
    }

    private static void validatePaths(String string, String string2) throws FileNotFoundException, PathNotADirectoryException {
        OCMConfig.validateDirEntry(string);
        if (string2 != null) {
            OCMConfig.validateDirEntry(string2);
        }
    }

    private static void validateDirEntry(String string) throws FileNotFoundException, PathNotADirectoryException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (!file.isDirectory()) {
            throw new PathNotADirectoryException();
        }
    }

    private OCMConfig(String string, String string2, String string3, String string4) throws OCMNotConfiguredException, IOException {
        super(CCR_PROPERTIES_FNM, string3, string4, null);
        this.init(string, string2);
    }

    private OCMConfig(String string, String string2, String string3, String string4, String string5, String string6) throws OCMNotConfiguredException, IOException {
        super(CCR_PROPERTIES_FNM, string3, string4, null, string5, string6);
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        this.m_strInstallRoot = string;
        this.m_strConfigRoot = string2;
        String string3 = this.getProperty(CCR_ENDPOINT_PROP);
        if (string3 == null || string3.trim().length() == 0) {
            this.setProperty(CCR_ENDPOINT_PROP, CCR_DEFAULT_ENDPOINT, false);
        }
    }

    private boolean isDisconnectedMode() throws IOException {
        boolean bl = false;
        String string = this.m_strConfigRoot == null ? FileSpec.catfile(new String[]{this.m_strInstallRoot, "ccr", CONFIG_DIR, COLLECTOR_PROPERTIES_FNM}) : FileSpec.catfile(new String[]{this.m_strConfigRoot, CONFIG_DIR, COLLECTOR_PROPERTIES_FNM});
        try {
            File file = new File(string);
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            properties.load(bufferedInputStream);
            String string2 = (String)((Hashtable)properties).get(CCR_DISCONNECTED_PROP);
            if (string2 != null) {
                Boolean bl2 = Boolean.valueOf(string2);
                bl = bl2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return bl;
    }

    private boolean isOCMConfigured() {
        String string = FileSpec.catfile(new String[]{this.m_strInstallRoot, "ccr", LIB_DIR, EMCCR_JAR});
        File file = new File(string);
        File file2 = new File(FileSpec.catfile(new String[]{this.m_strConfigRoot, CONFIG_DIR}));
        File file3 = new File(FileSpec.catfile(new String[]{this.m_strConfigRoot, CONFIG_DIR, CONFIG_DEFAULT_DIR}));
        File file4 = new File(FileSpec.catfile(new String[]{this.m_strConfigRoot, STATE_DIR}));
        File file5 = new File(FileSpec.catfile(new String[]{this.m_strConfigRoot, STATE_DIR, STATE_DIAGNOSTIC_DIR}));
        File file6 = new File(FileSpec.catfile(new String[]{this.m_strConfigRoot, LOG_DIR}));
        return file.exists() && file2.isDirectory() && file3.isDirectory() && file4.isDirectory() && file5.isDirectory() && file6.isDirectory();
    }

    public NVPair getUsernamePassword(AuthorizationInfo authorizationInfo, boolean bl) {
        NVPair nVPair = null;
        String string = this.getProperty(PROXY_USER);
        String string2 = this.getSecProperty(PROXY_PASSWORD);
        if (string != null && string2 != null) {
            nVPair = new NVPair(string, string2);
        }
        return nVPair;
    }

    private String getSecProperty(String string) {
        OCMCrypt oCMCrypt = new OCMCrypt();
        String string2 = this.getProperty(string);
        try {
            String string3 = this.getProperty("ccr.proxypswd.seed");
            String string4 = this.getProperty("ccr.proxypswd.seed.v2");
            if (string3 != null || string4 != null) {
                string2 = oCMCrypt.decrypt(string2, string3, string4);
            }
            return string2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Could not decrypt the password so sending the cipher");
            }
            return string2;
        }
    }

    public String getOCMStateParentDir() {
        return this.m_strConfigRoot;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

