/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocmSDK.websvc;

import HTTPClient.AuthorizationPrompter;
import HTTPClient.CookieModule;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import HTTPClient.https.Handler;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import oracle.sysman.ccr.common.network.OCMSSLContext;
import oracle.sysman.ccr.common.network.OCMSSLContextFactory;
import oracle.sysman.ccr.common.network.OCMSSLContextJDK;
import oracle.sysman.ccr.ocmSDK.websvc.CommunicationsException;
import oracle.sysman.ccr.ocmSDK.websvc.HttpClientException;
import oracle.sysman.ccr.ocmSDK.websvc.HttpServerException;
import oracle.sysman.ccr.ocmSDK.websvc.InvalidOCMStateException;
import oracle.sysman.ccr.ocmSDK.websvc.OCMConfig;
import oracle.sysman.ccr.ocmSDK.websvc.OCMNotConfiguredException;
import oracle.sysman.ccr.ocmSDK.websvc.PathNotADirectoryException;
import oracle.sysman.ccr.ocmSDK.websvc.SSLInitializationException;
import oracle.sysman.ccr.ocmSDK.websvc.UnexpectedOCMConfigException;
import oracle.sysman.ccr.ocmSDK.websvc.UnexpectedWebsvcException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcExceptionMsgID;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcInitException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcResponse;
import oracle.sysman.ccr.util.SecureRandomUtil;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.ContentHandler;

public abstract class Webservice {
    private static OCMConfig m_ocmConfig = null;
    private final String HTTPS_PROTOCOL = "https";
    private final int CONNECTION_TIMEOUT = 60000;
    private final int READ_CONNECTION_TIMEOUT = 300000;
    private static final String OCM_KEYSTORE_PROP = "oracle.sysman.ccr.ocmSDK.websvc.keystore";
    protected static final String POST = "Post";
    protected static final String GET = "Get";
    private static SecureRandom s_secureRandom = null;
    private static KeyStore s_caKeystore = null;
    private static TrustManager[] s_trustManagers = null;
    private static boolean s_bUseSunJsseCtx = true;
    private static OCMSSLContext s_ocmSslContext = null;
    private static boolean s_bSSLInitialized = false;
    private static RE s_patternCN = null;
    private static RE s_patternDot = null;
    private static RE s_patternWildcard = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$ocmSDK$websvc$Webservice;

    protected Webservice() throws WebsvcInitException {
        if (m_ocmConfig == null) {
            throw new WebsvcInitException();
        }
    }

    protected Webservice(boolean bl) throws WebsvcInitException {
        if (bl && m_ocmConfig == null) {
            throw new WebsvcInitException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstallRoot(String string) throws FileNotFoundException, PathNotADirectoryException, OCMNotConfiguredException, InvalidOCMStateException, UnexpectedOCMConfigException {
        if (m_ocmConfig == null) {
            Class clazz = class$oracle$sysman$ccr$ocmSDK$websvc$Webservice == null ? (class$oracle$sysman$ccr$ocmSDK$websvc$Webservice = Webservice.class$("oracle.sysman.ccr.ocmSDK.websvc.Webservice")) : class$oracle$sysman$ccr$ocmSDK$websvc$Webservice;
            synchronized (clazz) {
                if (m_ocmConfig == null) {
                    m_ocmConfig = OCMConfig.getInstance(string, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOCMConfig(OCMConfig oCMConfig) {
        Class clazz = class$oracle$sysman$ccr$ocmSDK$websvc$Webservice == null ? (class$oracle$sysman$ccr$ocmSDK$websvc$Webservice = Webservice.class$("oracle.sysman.ccr.ocmSDK.websvc.Webservice")) : class$oracle$sysman$ccr$ocmSDK$websvc$Webservice;
        synchronized (clazz) {
            m_ocmConfig = oCMConfig;
        }
    }

    protected WebsvcResponse doRequest(String string, String string2, ContentHandler contentHandler) throws CommunicationsException, UnexpectedWebsvcException, HttpClientException, HttpServerException {
        String string3 = null;
        String string4 = null;
        String string5 = m_ocmConfig.getProperty("ccr.endpoint");
        StringBuffer stringBuffer = new StringBuffer(string5).append(string);
        string3 = m_ocmConfig.getProperty("http.proxyHost");
        if (string3 != null && string3.trim().length() > 0) {
            string4 = m_ocmConfig.getProperty("http.proxyPort");
        }
        return this.doRequest(stringBuffer.toString(), string3, string4, string2, null, contentHandler, false, POST);
    }

    protected WebsvcResponse doRequest(String string, String string2, String string3, NVPair[] nVPairArray, ContentHandler contentHandler) throws CommunicationsException, UnexpectedWebsvcException, HttpClientException, HttpServerException {
        return this.doRequest(string, string2, string3, null, nVPairArray, contentHandler, true, POST);
    }

    protected WebsvcResponse doRequest(String string, String string2, String string3, String string4, NVPair[] nVPairArray, ContentHandler contentHandler, boolean bl, String string5) throws CommunicationsException, UnexpectedWebsvcException, HttpClientException, HttpServerException {
        HTTPConnection hTTPConnection;
        Object object;
        URL uRL = null;
        try {
            object = new URI(string);
            uRL = this.registerURLHandlers((URI)object);
            hTTPConnection = new HTTPConnection(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnexpectedWebsvcException(malformedURLException);
        }
        catch (ProtocolNotSuppException protocolNotSuppException) {
            throw new UnexpectedWebsvcException(protocolNotSuppException);
        }
        catch (ParseException parseException) {
            throw new UnexpectedWebsvcException(parseException);
        }
        hTTPConnection.setAllowUserInteraction(true);
        if (!bl && null != m_ocmConfig) {
            DefaultAuthHandler.setAuthorizationPrompter((AuthorizationPrompter)m_ocmConfig);
        }
        hTTPConnection.setTimeout(300000);
        hTTPConnection.setConnectionTimeout(60000);
        object = string2;
        if (object != null && ((String)object).trim().length() > 0) {
            int n = 80;
            String string6 = string3;
            if (string6 != null && string6.trim().length() > 0) {
                n = Integer.parseInt(string6);
            }
            hTTPConnection.setCurrentProxy((String)object, n);
        }
        if (this.isHttpsConnection(hTTPConnection)) {
            Webservice.initializeSSL();
            hTTPConnection.setSSLSocketFactory(s_ocmSslContext.getSocketFactory());
        }
        try {
            hTTPConnection.connect();
            if (this.isHttpsConnection(hTTPConnection)) {
                this.verifyConnection(hTTPConnection, uRL.getHost());
            }
            if (string5.equals(POST)) {
                if (string4 != null) {
                    HTTPResponse hTTPResponse = hTTPConnection.Post(uRL.getFile(), string4);
                    return new WebsvcResponse(hTTPResponse, contentHandler);
                }
                HTTPResponse hTTPResponse = hTTPConnection.Post(uRL.getFile(), nVPairArray);
                return new WebsvcResponse(hTTPResponse, contentHandler, false);
            }
            if (string5.equals(GET)) {
                HTTPResponse hTTPResponse = hTTPConnection.Get(string4);
                return new WebsvcResponse(hTTPResponse);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            throw new UnexpectedWebsvcException(runtimeException);
        }
        catch (IOException iOException) {
            throw new CommunicationsException(iOException);
        }
        catch (ModuleException moduleException) {
            throw new UnexpectedWebsvcException(moduleException);
        }
    }

    private URL registerURLHandlers(URI uRI) throws MalformedURLException, ProtocolNotSuppException {
        URL uRL = null;
        if (uRI.getScheme().equals("http")) {
            uRL = new URL(null, uRI.toExternalForm(), (URLStreamHandler)new HTTPClient.http.Handler());
        } else if (uRI.getScheme().equals("https")) {
            uRL = new URL(null, uRI.toExternalForm(), (URLStreamHandler)new Handler());
        } else {
            throw new MalformedURLException("Unknown Protocol: " + uRI.getScheme());
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSSL() throws UnexpectedWebsvcException {
        if (!s_bSSLInitialized) {
            Class clazz = class$oracle$sysman$ccr$ocmSDK$websvc$Webservice == null ? (class$oracle$sysman$ccr$ocmSDK$websvc$Webservice = Webservice.class$("oracle.sysman.ccr.ocmSDK.websvc.Webservice")) : class$oracle$sysman$ccr$ocmSDK$websvc$Webservice;
            synchronized (clazz) {
                if (!s_bSSLInitialized) {
                    boolean bl = !s_bUseSunJsseCtx;
                    try {
                        s_secureRandom = SecureRandomUtil.getSecureRandomInstance((boolean)bl);
                        s_caKeystore = Webservice.getTrustedCAKeystore();
                        s_ocmSslContext.init(s_caKeystore, s_secureRandom);
                        s_bSSLInitialized = true;
                    }
                    catch (oracle.sysman.ccr.common.network.SSLInitializationException sSLInitializationException) {
                        throw new UnexpectedWebsvcException(sSLInitializationException);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore getTrustedCAKeystore() throws UnexpectedWebsvcException {
        KeyStore keyStore = null;
        String string = System.getProperty(OCM_KEYSTORE_PROP);
        FileInputStream fileInputStream = null;
        if (string == null) {
            throw new UnexpectedWebsvcException(new SSLInitializationException(WebsvcExceptionMsgID.KEYSTORE_UNDEF, new String[]{OCM_KEYSTORE_PROP}));
        }
        try {
            try {
                keyStore = KeyStore.getInstance("JKS");
                fileInputStream = new FileInputStream(string);
                keyStore.load(fileInputStream, null);
                fileInputStream.close();
            }
            catch (KeyStoreException keyStoreException) {
                throw new UnexpectedWebsvcException(new SSLInitializationException(WebsvcExceptionMsgID.KEYSTORE_TYPE_ERR, (Throwable)keyStoreException));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new UnexpectedWebsvcException(new SSLInitializationException(WebsvcExceptionMsgID.TRUSTORE_FNF, (Throwable)fileNotFoundException));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new UnexpectedWebsvcException(new SSLInitializationException(WebsvcExceptionMsgID.TRUSTORE_VERIFICATION_ERR, (Throwable)noSuchAlgorithmException));
            }
            catch (CertificateException certificateException) {
                throw new UnexpectedWebsvcException(new SSLInitializationException(WebsvcExceptionMsgID.TRUSTORE_CERT_ERR, (Throwable)certificateException));
            }
            catch (IOException iOException) {
                throw new UnexpectedWebsvcException(new SSLInitializationException(WebsvcExceptionMsgID.TRUSTORE_RDRERR, (Throwable)iOException));
            }
            Object var5_3 = null;
            if (fileInputStream == null) return keyStore;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return keyStore;
    }

    private static TrustManager[] getTrustManagers(KeyStore keyStore) throws UnexpectedWebsvcException {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509");
            trustManagerFactory.init(keyStore);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnexpectedWebsvcException(new SSLInitializationException(WebsvcExceptionMsgID.TRUSTFACTORY_INIT_ERR, (Throwable)noSuchAlgorithmException));
        }
        catch (KeyStoreException keyStoreException) {
            throw new UnexpectedWebsvcException(new SSLInitializationException(WebsvcExceptionMsgID.TRUSTMGR_INIT_ERR, (Throwable)keyStoreException));
        }
        return trustManagerFactory.getTrustManagers();
    }

    private void verifyConnection(HTTPConnection hTTPConnection, String string) throws SSLPeerUnverifiedException {
        SSLSession sSLSession = hTTPConnection.getSSLSession();
        if (sSLSession != null) {
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            if (x509CertificateArray.length == 0) {
                throw new SSLPeerUnverifiedException(WebsvcException.formatMsg(WebsvcExceptionMsgID.PEER_CERT_NOT_FOUND));
            }
            Principal principal = x509CertificateArray[0].getSubjectDN();
            if (principal == null) {
                throw new SSLPeerUnverifiedException(WebsvcException.formatMsg(WebsvcExceptionMsgID.CERT_SUBJ_UNKNOWN));
            }
            String string2 = principal.getName();
            if (string2 == null) {
                throw new SSLPeerUnverifiedException(WebsvcException.formatMsg(WebsvcExceptionMsgID.CERT_NAME_UNKNOWN));
            }
            if (!this.DNequalURLhost(string2, string)) {
                throw new SSLPeerUnverifiedException(WebsvcException.formatMsg(WebsvcExceptionMsgID.CERT_MISMATCH));
            }
        } else {
            throw new SSLPeerUnverifiedException(WebsvcException.formatMsg(WebsvcExceptionMsgID.NOT_VERIFIED_NOSSL));
        }
    }

    private String extractCName(String string) {
        String string2 = null;
        if (s_patternCN.match(string)) {
            string2 = s_patternCN.getParen(1);
        }
        return string2;
    }

    private String escapePeerChars(String string) {
        String string2 = null;
        if (string != null) {
            string2 = s_patternDot.subst(string, "\\.");
            string2 = s_patternWildcard.subst(string2, ".*");
        }
        return string2;
    }

    private boolean DNequalURLhost(String string, String string2) {
        String string3 = this.extractCName(string);
        String string4 = this.escapePeerChars(string3);
        try {
            RE rE = new RE(string4.toLowerCase());
            return rE.match(string2.toLowerCase());
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException(WebsvcException.formatMsg(WebsvcExceptionMsgID.INV_CERT_CNAME, new String[]{string3}));
        }
    }

    private boolean isHttpsConnection(HTTPConnection hTTPConnection) {
        return hTTPConnection.getProtocol().equalsIgnoreCase("https");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        s_ocmSslContext = OCMSSLContextFactory.getOCMSSLContext();
        s_bUseSunJsseCtx = !(s_ocmSslContext instanceof OCMSSLContextJDK);
        CookieModule.setCookiePolicyHandler(null);
        try {
            s_patternCN = new RE("^CN=(.*?),\\s*(OU|O|L|S|C)=");
            s_patternDot = new RE("([.])");
            s_patternWildcard = new RE("([*])");
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
    }
}

