/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocmSDK.websvc;

import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.sysman.ccr.ocmSDK.websvc.CommunicationsException;
import oracle.sysman.ccr.ocmSDK.websvc.HttpClientException;
import oracle.sysman.ccr.ocmSDK.websvc.HttpServerException;
import oracle.sysman.ccr.ocmSDK.websvc.UnexpectedWebsvcException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WebsvcResponse
implements ContentHandler {
    private final String STATUS_ELEMENT = "STATUS";
    private final String STATUS_CODE_ATTR = "CODE";
    private final String STATUS_MESSAGE_ELEMENT = "MESSAGE";
    private final String REQUEST_DATA_ELEMENT = "REQUEST_DATA";
    public static final int SUCCESS = 0;
    private HTTPResponse m_response;
    private ContentHandler m_responseDataHandler = null;
    private boolean m_intercept = true;
    private int m_intHttpResponseCode = -1;
    private String m_strHttpResponseLine = null;
    private Integer m_IntRequestStatusCode = null;
    private StringBuffer m_sbRequestStatusLine = new StringBuffer();
    private String m_strCurrentElement = null;
    private Vector m_vectorLifoElements = new Vector();
    private static final int REQUEST_LIST_UNINITIALIZED = -1;
    private int m_intRequestLevel = -1;

    WebsvcResponse(HTTPResponse hTTPResponse) throws HttpClientException, HttpServerException, CommunicationsException, UnexpectedWebsvcException {
        try {
            this.m_response = hTTPResponse;
            this.m_intHttpResponseCode = hTTPResponse.getStatusCode();
            this.m_strHttpResponseLine = hTTPResponse.getReasonLine();
            this.checkHttpResponseCode(this.m_intHttpResponseCode);
        }
        catch (IOException iOException) {
            throw new CommunicationsException(iOException);
        }
        catch (ModuleException moduleException) {
            throw new UnexpectedWebsvcException(moduleException);
        }
    }

    WebsvcResponse(HTTPResponse hTTPResponse, ContentHandler contentHandler) throws HttpClientException, HttpServerException, CommunicationsException, UnexpectedWebsvcException {
        this.doWork(hTTPResponse, contentHandler);
    }

    WebsvcResponse(HTTPResponse hTTPResponse, ContentHandler contentHandler, boolean bl) throws HttpClientException, HttpServerException, CommunicationsException, UnexpectedWebsvcException {
        this.m_intercept = bl;
        this.doWork(hTTPResponse, contentHandler);
    }

    private void doWork(HTTPResponse hTTPResponse, ContentHandler contentHandler) throws HttpClientException, HttpServerException, CommunicationsException, UnexpectedWebsvcException {
        try {
            this.m_intHttpResponseCode = hTTPResponse.getStatusCode();
            this.m_strHttpResponseLine = hTTPResponse.getReasonLine();
            this.checkHttpResponseCode(this.m_intHttpResponseCode);
            this.m_responseDataHandler = contentHandler;
            this.parseResponse(hTTPResponse.getText());
        }
        catch (IOException iOException) {
            throw new CommunicationsException(iOException);
        }
        catch (ModuleException moduleException) {
            throw new UnexpectedWebsvcException(moduleException);
        }
        catch (SAXException sAXException) {
            throw new UnexpectedWebsvcException(sAXException);
        }
        catch (ParseException parseException) {
            throw new UnexpectedWebsvcException(parseException);
        }
    }

    public InputStream getInputStream() throws IOException, ModuleException {
        return this.m_response.getInputStream();
    }

    private void checkHttpResponseCode(int n) throws HttpClientException, HttpServerException, UnexpectedWebsvcException {
        if (n == 404) {
            throw new UnexpectedWebsvcException(new HttpClientException(n));
        }
        if (n >= 400 && n < 500) {
            throw new HttpClientException(n);
        }
        if (n >= 500 && n < 600) {
            throw new HttpServerException(n);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.m_intercept || this.inRequestSubDocument()) {
            if (this.m_responseDataHandler != null) {
                this.m_responseDataHandler.characters(cArray, n, n2);
            }
        } else if (this.m_strCurrentElement.equals("MESSAGE")) {
            this.m_sbRequestStatusLine.append(cArray, n, n2);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.m_intercept || this.inRequestSubDocument()) {
            if (this.m_responseDataHandler != null) {
                this.m_responseDataHandler.endElement(string, string2, string3);
            }
            this.endRequestSubDocument();
        }
        this.m_vectorLifoElements.remove(this.m_vectorLifoElements.size() - 1);
        this.m_strCurrentElement = this.m_vectorLifoElements.size() != 0 ? (String)this.m_vectorLifoElements.elementAt(this.m_vectorLifoElements.size() - 1) : null;
    }

    public void endPrefixMapping(String string) throws SAXException {
        if ((!this.m_intercept || this.inRequestSubDocument()) && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.endPrefixMapping(string);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if ((!this.m_intercept || this.inRequestSubDocument()) && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if ((!this.m_intercept || this.inRequestSubDocument()) && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.processingInstruction(string, string2);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if ((!this.m_intercept || this.inRequestSubDocument()) && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.skippedEntity(string);
        }
    }

    public void startDocument() throws SAXException {
        this.initializeRequestSubDocumentCounter();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.m_strCurrentElement = string3;
        this.m_vectorLifoElements.add(this.m_strCurrentElement);
        if (!this.m_intercept || this.inRequestSubDocument()) {
            this.beginRequestSubDocument();
            if (this.m_responseDataHandler != null) {
                this.m_responseDataHandler.startElement(string, string2, string3, attributes);
            }
        } else {
            if (string3.equals("STATUS")) {
                String string4 = attributes.getValue("CODE");
                this.m_IntRequestStatusCode = Integer.valueOf(string4);
            }
            if (string3.equals("REQUEST_DATA")) {
                this.beginRequestSubDocument();
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if ((!this.m_intercept || this.inRequestSubDocument()) && this.m_responseDataHandler != null) {
            this.m_responseDataHandler.startPrefixMapping(string, string2);
        }
    }

    public String getCurrentElement() {
        return this.m_strCurrentElement;
    }

    public int getHttpStatusCode() {
        return this.m_intHttpResponseCode;
    }

    public String getHttpResponseMessage() {
        return this.m_strHttpResponseLine;
    }

    public int getRequestStatusCode() {
        return this.m_IntRequestStatusCode;
    }

    public String getRequestResponseMessage() {
        return this.m_sbRequestStatusLine.toString();
    }

    void parseResponse(String string) throws SAXException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
        xMLReader.setContentHandler(this);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        InputSource inputSource = new InputSource(byteArrayInputStream);
        try {
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initializeRequestSubDocumentCounter() {
        this.m_intRequestLevel = -1;
    }

    private void beginRequestSubDocument() {
        ++this.m_intRequestLevel;
    }

    private void endRequestSubDocument() {
        --this.m_intRequestLevel;
    }

    private boolean inRequestSubDocument() {
        return this.m_intRequestLevel >= 0;
    }
}

