/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocmSDK.websvc.draftSR;

import oracle.sysman.ccr.ocmSDK.websvc.CSINotFoundException;
import oracle.sysman.ccr.ocmSDK.websvc.CSINotInProfileException;
import oracle.sysman.ccr.ocmSDK.websvc.InvalidCSIException;
import oracle.sysman.ccr.ocmSDK.websvc.InvalidCountryCodeException;
import oracle.sysman.ccr.ocmSDK.websvc.InvalidCredentialsException;
import oracle.sysman.ccr.ocmSDK.websvc.NoPermissionException;
import oracle.sysman.ccr.ocmSDK.websvc.UserFrozenException;
import oracle.sysman.ccr.ocmSDK.websvc.WebsvcResponse;
import oracle.sysman.ccr.ocmSDK.websvc.draftSR.CSINotValidForSRCreationException;
import oracle.sysman.ccr.ocmSDK.websvc.draftSR.DraftSRException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class DraftSRResponseParser
implements ContentHandler {
    private StringBuffer m_sbServiceRequest = new StringBuffer();
    private String m_strCurrentElement = null;
    private final String SERVICE_REQUEST_ELEMENT = "SERVICE_REQUEST";
    private static final int CSI_NOT_FOUND = 1;
    private static final int INVALID_CSI = 2;
    private static final int CSI_NOT_USABLE_FOR_SR = 3;
    private static final int INVALID_CREDS = 4;
    private static final int USER_FROZEN = 5;
    private static final int NO_PERMISSION = 6;
    private static final int CSI_NOT_IN_PROFILE = 7;
    private static final int INVALID_CC = 8;

    DraftSRResponseParser() {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_strCurrentElement != null && this.m_strCurrentElement.equals("SERVICE_REQUEST")) {
            this.m_sbServiceRequest.append(cArray, n, n2);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_strCurrentElement != null && this.m_strCurrentElement.equals("SERVICE_REQUEST")) {
            this.m_strCurrentElement = null;
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("SERVICE_REQUEST")) {
            this.m_strCurrentElement = string3;
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public String getServiceRequest(WebsvcResponse websvcResponse) throws InvalidCountryCodeException, InvalidCredentialsException, NoPermissionException, UserFrozenException, DraftSRException, CSINotInProfileException, InvalidCredentialsException, InvalidCSIException {
        int n = websvcResponse.getRequestStatusCode();
        if (n != 0) {
            switch (n) {
                case 1: {
                    throw new CSINotFoundException();
                }
                case 2: {
                    throw new InvalidCSIException();
                }
                case 3: {
                    throw new CSINotValidForSRCreationException();
                }
                case 4: {
                    throw new InvalidCredentialsException();
                }
                case 5: {
                    throw new UserFrozenException();
                }
                case 6: {
                    throw new NoPermissionException();
                }
                case 7: {
                    throw new CSINotInProfileException();
                }
                case 8: {
                    throw new InvalidCountryCodeException();
                }
            }
            throw new DraftSRException(websvcResponse.getRequestResponseMessage());
        }
        String string = this.m_sbServiceRequest.toString();
        return string.trim();
    }
}

