/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMPTZ;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLEncoder;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLFormat;
import oracle.xml.binxml.BinXMLInfosetWriter;
import oracle.xml.binxml.BinXMLOpcode;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLQNameToken;
import oracle.xml.binxml.BinXMLSchLocTag;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLSchemaResolver;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLToken;
import oracle.xml.binxml.BinXMLTokenManager;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.BinXMLVocabularyManager;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLLocator;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

class BinXMLEncoderImpl
implements BinXMLEncoder,
ContentHandler,
ErrorHandler,
DTDHandler,
DeclHandler,
LexicalHandler,
BinXMLConstants {
    boolean schemaAware = false;
    boolean inlineTokenDefs = true;
    boolean implicitSchemaReg = false;
    boolean saveSchemaValidationInfo = false;
    boolean midTierOpt = false;
    boolean schemaLocationAware;
    boolean notExtended;
    boolean xdbInlineTokens;
    boolean inlineTokenDefsSet;
    String schemaURL;
    BinXMLTokenManager tokenManager;
    BinXMLVocabularyManager vocabManager;
    BinXMLProcessorImpl binXMLProcessor;
    BinXMLStreamImpl binStream;
    BinXMLSectionState secState;
    BinXMLPageWriter writer;
    BinXMLSchemaResolver schemaResolver;
    XSDValidator validator;
    char[] charBuffer;
    int charLen = 0;
    Stack elementStack;
    Stack<BinXMLElement> freeElems;
    byte[] docId = null;
    Locator locator = null;
    byte[] page;
    boolean dtd = false;
    boolean xdbMode = false;
    int pfxsufix = 0;
    int opcodeCount = 0;
    HashMap inlinedTokensTable;
    String xmlVersion = null;
    String standalone = null;
    String encoding = null;
    PrintWriter debugWriter;
    XMLError validatorErr = new XMLError();
    int depth;
    int cdataDepth;
    BinXMLElement currentElem;
    BinXMLEncBuffer buffer = new BinXMLEncBuffer();
    oracle.xml.util.XMLError err;
    byte prev_event = 0;
    byte curr_event = 0;
    private boolean docEventCalled = false;
    private byte[] byteBuf = null;
    private int byteLen = 0;
    private myLong key = new myLong();
    static final byte NO_EVENT = 0;
    static final byte START_ELEM_EVENT = 1;
    static final byte END_ELEM_EVENT = 2;
    static final byte CHARS_EVENT = 3;
    static final byte DTD_EVENT = 4;
    static final byte OTHER_EVENT = 5;
    static final byte BUFSTATE_NONE = 1;
    static final byte BUFSTATE_GOTSTART = 2;
    static final byte BUFSTATE_GOTFIRSTTEXT = 3;
    static final byte BUFSTATE_GOTEND = 4;
    static final byte BUFSTATE_LAST = 5;
    static final byte SIMPLENODE_QNAMEID = 1;
    static final byte SIMPLENODE_ARRAY = 2;
    static final byte SIMPLENODE_DATAONLY = 3;
    static final byte SIMPLENODE_KIDNUM = 4;
    static final byte SIMPLENODE_SCHEMASEQ = 5;
    static final int CHAR_SIZE = 4096;
    static boolean isTextNode = false;
    static int schemaScopeLength = 0;
    static int flagPosition = -1;
    static final int TOKEN_DEF = 0;
    static final int PREFIX_DEF = 1;
    static final int NODE_DAT = 2;
    static final int BYTE_SIZE = 4096;

    @Override
    public void setProperty(int n, boolean bl) throws BinXMLException {
        switch (n) {
            case 1: {
                this.schemaAware = bl;
                if (!this.schemaAware) break;
                this.inlineTokenDefs = true;
                break;
            }
            case 2: {
                this.saveSchemaValidationInfo = bl;
                break;
            }
            case 3: {
                this.implicitSchemaReg = bl;
                break;
            }
            case 4: {
                this.inlineTokenDefsSet = true;
                this.inlineTokenDefs = this.schemaAware ? true : bl;
                if (!this.inlineTokenDefs) break;
                this.xdbInlineTokens = true;
                break;
            }
            case 5: {
                this.midTierOpt = bl;
                break;
            }
            case 6: {
                this.xdbMode = bl;
                break;
            }
            case 7: {
                this.schemaLocationAware = bl;
                break;
            }
            case 8: {
                if (!this.inlineTokenDefsSet || bl) {
                    this.xdbInlineTokens = bl;
                    if (this.xdbInlineTokens) break;
                    this.inlineTokenDefs = false;
                    break;
                }
                this.xdbInlineTokens = this.inlineTokenDefs;
            }
        }
    }

    @Override
    public void setSchema(String string) throws BinXMLException {
        this.schemaURL = string;
    }

    @Override
    public void setChunkMode(boolean bl) {
        this.writer.setChunkMode(bl);
    }

    public void setChunkBufSize(int n) {
        this.writer.setChunkBufSize(n);
    }

    @Override
    public ContentHandler getContentHandler() throws BinXMLException {
        if (this.schemaAware || this.saveSchemaValidationInfo || this.schemaLocationAware) {
            try {
                this.validator = new XSDValidator();
                this.validator.addContentHandler(this);
                this.schemaResolver = new BinXMLSchemaResolver(this.vocabManager);
                this.schemaResolver.setXMLError(this.err);
                this.validator.setProperty("SCHEMA_RESOLVER", this.schemaResolver);
                if (this.schemaLocationAware) {
                    this.validator.setXMLProperty("Schema Resolver", this.schemaResolver);
                }
                this.validatorErr.reset();
                this.validator.setError(this.validatorErr);
                if (this.schemaURL != null) {
                    BinXMLSchema binXMLSchema;
                    if (this.vocabManager.getMetadataProvider() instanceof DBBinXMLMetadataProviderImpl) {
                        binXMLSchema = this.schemaResolver.getSchema(this.schemaURL);
                    } else {
                        URL uRL = this.schemaResolver.createURL(this.schemaURL);
                        binXMLSchema = this.schemaResolver.getSchema(uRL);
                    }
                    this.validator.setXMLSchema(binXMLSchema.getXMLSchema());
                    binXMLSchema.setValidator(this.validator);
                }
                return this.validator;
            }
            catch (XSDException xSDException) {
                throw new BinXMLException(xSDException.getMessage());
            }
            catch (SAXException sAXException) {
                throw new BinXMLException(sAXException.getMessage());
            }
        }
        return this;
    }

    @Override
    public ErrorHandler getErrorHandler() throws BinXMLException {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() throws BinXMLException {
        return this;
    }

    @Override
    public DeclHandler getDeclHandler() throws BinXMLException {
        return this;
    }

    @Override
    public LexicalHandler getLexicalHandler() throws BinXMLException {
        return this;
    }

    @Override
    public InfosetWriter createInfosetWriter() throws BinXMLException {
        return new BinXMLInfosetWriter(this);
    }

    XSDValidator getValidator() {
        return this.validator;
    }

    private void validate() throws BinXMLException {
        if (this.validatorErr.getNumMessages() > 0) {
            int n = this.validatorErr.getFirstError();
            throw new BinXMLException(this.validatorErr.getMessage(n));
        }
    }

    BinXMLEncoderImpl(BinXMLStream binXMLStream) {
        this.charBuffer = new char[4096];
        this.elementStack = new Stack();
        this.freeElems = new Stack();
        this.binStream = (BinXMLStreamImpl)binXMLStream;
        this.page = this.binStream.getWriteBuffer();
        this.writer = new BinXMLPageWriter(this.page, this.binStream);
        this.binXMLProcessor = (BinXMLProcessorImpl)this.binStream.getBinXMLProcessor();
        this.tokenManager = this.binXMLProcessor.getTokenManager();
        this.vocabManager = this.binXMLProcessor.getVocabularyManager();
        this.inlinedTokensTable = new HashMap();
        schemaScopeLength = 0;
        flagPosition = -1;
        this.schemaLocationAware = false;
        this.xdbInlineTokens = true;
        this.inlineTokenDefsSet = false;
        this.notExtended = true;
        this.opcodeCount = 0;
        if (this.binXMLProcessor.getDebugMode()) {
            File file = new File("encoder.log");
            try {
                this.debugWriter = new PrintWriter(new FileWriter(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.docEventCalled = false;
        this.byteBuf = new byte[4096];
        this.byteLen = 0;
    }

    BinaryStream getStream() {
        return this.binStream;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.secState = new BinXMLSectionState(this.binStream);
            this.secState.encodeSectionHeader();
            if (this.locator != null && this.locator instanceof Locator2) {
                this.xmlVersion = ((Locator2)this.locator).getXMLVersion();
                if (this.locator instanceof XMLLocator) {
                    if (this.encoding == null) {
                        this.encoding = ((XMLLocator)this.locator).getDeclEncoding();
                    }
                    if (this.standalone == null) {
                        this.standalone = ((XMLLocator)this.locator).getStandalone();
                    }
                }
            }
            int n = 0;
            int n2 = 0;
            byte[] byArray = null;
            if (this.xmlVersion != null) {
                n = (short)(n | 2);
                if (this.standalone != null && this.standalone.equalsIgnoreCase("yes")) {
                    n = (short)(n | 1);
                    n = (short)(n | 0x10);
                }
                if (this.xmlVersion == "1.1") {
                    n = (short)(n | 0x1100);
                    n = (short)(n | 8);
                }
                if (this.encoding != null) {
                    n = (short)(n | 4);
                    byArray = this.encoding.getBytes("UTF-8");
                    n2 = byArray.length;
                }
            }
            this.writer.writeOpcode((short)158, 0);
            this.writer.writeByte((byte)n2, 0);
            if (n2 > 0) {
                this.writer.doc_plus_strtsec_size += n2;
            }
            this.writer.writeShort(n, 0);
            if (n2 != 0) {
                this.writer.writeByteArray(byArray, 0, byArray.length);
            }
            this.docEventCalled = true;
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.secState.encodeSectionEnd();
            this.inlinedTokensTable = null;
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    private void setSchemaInformation() throws BinXMLException {
        try {
            if (this.validator != null && this.validator.getXMLSchema() != null) {
                this.schemaResolver = (BinXMLSchemaResolver)this.validator.getXMLProperty("Schema Resolver");
                this.schemaResolver.setXMLError(this.err);
                this.validatorErr.reset();
                this.validator.setError(this.validatorErr);
                BinXMLSchema binXMLSchema = this.schemaResolver.getCurrentSchema();
                binXMLSchema.setValidator(this.validator);
                this.schemaAware = true;
                this.schemaLocationAware = false;
                if (this.xdbInlineTokens) {
                    this.inlineTokenDefs = true;
                }
                if (flagPosition != -1) {
                    if (this.writer.chunkmode && this.notExtended) {
                        this.writer.tokdefbuf[BinXMLEncoderImpl.flagPosition] = (byte)(this.writer.tokdefbuf[flagPosition] ^ 2);
                    } else {
                        this.writer.buf[BinXMLEncoderImpl.flagPosition] = (byte)(this.writer.buf[flagPosition] ^ 2);
                    }
                }
            }
        }
        catch (SAXException sAXException) {
            throw new BinXMLException(sAXException.getMessage());
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.charLen > 0) {
            if (!this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                isTextNode = true;
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        if (!this.docEventCalled && this.elementStack.empty()) {
            this.startDocument();
            this.docEventCalled = false;
        }
        try {
            short s;
            long l;
            Object object;
            String string4;
            String string5;
            String string6;
            int n;
            Object object2;
            Object object3;
            long l2;
            if (this.schemaLocationAware) {
                this.setSchemaInformation();
            }
            this.validate();
            this.prev_event = this.curr_event;
            this.curr_event = 1;
            boolean bl = false;
            BinXMLElement binXMLElement = null;
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
            this.currentElem = this.freeElems.empty() ? new BinXMLElement() : this.freeElems.pop();
            if (this.schemaAware) {
                this.currentElem.binSchema = this.schemaResolver.getCurrentSchema();
                if (this.currentElem.binSchema.getValidator() == null) {
                    this.currentElem.binSchema.setValidator(this.validator);
                }
            }
            ++this.depth;
            if (this.depth > 1) {
                binXMLElement = (BinXMLElement)this.elementStack.peek();
            } else if (this.schemaAware) {
                this.writeSchemaScopeStart(this.currentElem.binSchema);
            }
            this.elementStack.push(this.currentElem);
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            long l3 = 0L;
            if (string.length() > 0) {
                if (this.tokenManager.namespaceURITokens.get(string) == null) {
                    bl2 = false;
                }
                if (this.secState.addNamespaceId(l2 = this.tokenManager.getNamespaceTokenId(string))) {
                    this.encodeNamespace(l2, string);
                }
            } else {
                l2 = 7L;
            }
            if (this.schemaAware) {
                this.currentElem.prop = this.currentElem.binSchema.getCurrentProperty();
                if (this.currentElem.prop == null) {
                    this.currentElem.any = true;
                } else {
                    this.currentElem.kidNum = binXMLElement == null ? (short)-1 : ((object3 = binXMLElement.prop) != null ? this.currentElem.prop.getKidNum((BinXMLProperty)object3) : (short)-1);
                    if (this.currentElem.prop.isAnyElement() || this.currentElem.kidNum == -1) {
                        this.currentElem.any = true;
                    }
                }
            }
            if (!this.schemaAware) {
                object3 = this.tokenManager.getElementToken(string2, l2, string);
                if (object3 == null) {
                    object3 = this.tokenManager.putElement(string2, l2);
                }
                if (this.tokenManager.metaProvider != null && this.xdbInlineTokens || this.inlineTokenDefs) {
                    this.key.setValue(((BinXMLToken)object3).getTokenId());
                    if (!this.inlinedTokensTable.containsKey(this.key)) {
                        this.encodeToken((BinXMLQNameToken)object3, false);
                        object2 = new myLong();
                        ((myLong)object2).setValue(((BinXMLToken)object3).getTokenId());
                        this.inlinedTokensTable.put(object2, object3);
                    }
                }
                this.currentElem.qnameId = ((BinXMLToken)object3).getTokenId();
            }
            int n2 = attributes.getLength();
            short s2 = 0;
            boolean bl6 = false;
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                object2 = attributes.getLocalName(n);
                string6 = attributes.getURI(n);
                string5 = attributes.getValue(n);
                string4 = string6 != null && !string6.equals("") ? XMLUtil.getPrefix(attributes.getQName(n)) : "";
                if (this.schemaAware && string6.equals("http://www.w3.org/2001/XMLSchema-instance") && (((String)object2).equals("schemaLocation") || ((String)object2).equals("noNamespaceSchemaLocation"))) {
                    boolean bl7 = false;
                    if (((String)object2).equals("schemaLocation")) {
                        bl7 = true;
                    }
                    try {
                        object = this.schemaResolver.getCurrentSchema(string5, bl7, this);
                        if (object != null) {
                            if (object != this.currentElem.binSchema) {
                                this.writeSchemaScopeStart((BinXMLSchema)object);
                            }
                            this.currentElem.binSchema = object;
                        } else {
                            this.currentElem.binSchema = this.schemaResolver.getCurrentSchema();
                        }
                        BinXMLSchLocTag binXMLSchLocTag = new BinXMLSchLocTag(string, string2, string3, this.depth);
                        binXMLSchLocTag.setValidator(this.currentElem.binSchema.getValidator());
                        this.schemaResolver.pushSchLocTag(binXMLSchLocTag);
                        continue;
                    }
                    catch (XSDException xSDException) {
                        throw new BinXMLException(xSDException.getMessage());
                    }
                }
                if (this.schemaAware && this.currentElem.binSchema != null && string6.equals("http://www.w3.org/2001/XMLSchema-instance") && ((String)object2).equals("type")) {
                    bl6 = true;
                    if (this.currentElem.prop != null) {
                        this.currentElem.propId = this.currentElem.prop.getPropId();
                    }
                    this.currentElem.prop = this.currentElem.binSchema.getCurrentTypeProperty();
                    n3 = this.currentElem.prop.getTypeId();
                    continue;
                }
                if (!string4.equals("xmlns") && (string4.length() != 0 || !((String)object2).equals("xmlns"))) continue;
                if (((String)object2).length() > 255) {
                    throw new BinXMLException(this.err.getMessage0(35003));
                }
                l = this.tokenManager.getNamespaceTokenId(string5);
                if (l == l2) {
                    bl3 = true;
                }
                this.secState.addNamespaceId(l);
                if (this.inlineTokenDefs) {
                    this.encodeNamespace(l, string5);
                }
                if (string4.length() > 0) {
                    String string7 = XMLUtil.getPrefix(string3);
                    if (((String)object2).equals(string7) && !string5.equals(string)) {
                        bl2 = true;
                    }
                    s2 = this.secState.insertPrefix((String)object2, string5);
                    continue;
                }
                bl4 = true;
                s2 = this.secState.insertPrefix("", string5);
            }
            if (!bl3 && !bl2 && this.inlineTokenDefs) {
                bl5 = true;
                this.encodeNamespace(l2, string);
                String string8 = XMLUtil.getPrefix(string3);
                if (string8.length() > 0) {
                    l3 = this.secState.insertPrefix(string8, string);
                } else {
                    String string9 = "";
                    l3 = bl4 ? -1L : (long)this.secState.insertPrefix(string9, string);
                }
            }
            if (this.currentElem.prop != null && this.currentElem.prop.isSequential()) {
                this.currentElem.schemaSeqMode = true;
                this.currentElem.maxKidNum = this.currentElem.prop.getMaxKidNum();
            }
            if (!this.schemaAware || this.currentElem.prop == null || this.depth == 1 || this.currentElem.any || this.currentElem.prop.isSubstitutionGroupMember()) {
                if (this.currentElem.prop != null && (this.currentElem.prop.isElement() || this.currentElem.propId > 0)) {
                    n = bl6 ? this.currentElem.propId : this.currentElem.prop.getPropId();
                    this.currentElem.qnameId = 0xFFFFFFFFFFFFFFFFL & (long)(-n);
                } else {
                    BinXMLQNameToken binXMLQNameToken = this.tokenManager.getElementToken(string2, l2, string);
                    if (binXMLQNameToken == null) {
                        binXMLQNameToken = this.tokenManager.putElement(string2, l2);
                    }
                    if (this.tokenManager.metaProvider != null && this.xdbInlineTokens || this.inlineTokenDefs) {
                        this.key.setValue(binXMLQNameToken.getTokenId());
                        if (!this.inlinedTokensTable.containsKey(this.key)) {
                            this.encodeToken(binXMLQNameToken, false);
                            myLong myLong2 = new myLong();
                            myLong2.setValue(binXMLQNameToken.getTokenId());
                            this.inlinedTokensTable.put(myLong2, binXMLQNameToken);
                        }
                    }
                    this.currentElem.qnameId = binXMLQNameToken.getTokenId();
                }
            }
            short s3 = 0;
            boolean bl8 = false;
            if (string.length() > 0 && (s3 = this.secState.getPfxId((String)(object = XMLUtil.getPrefix(string3)), l2, false)) >= 0) {
                bl8 = true;
            }
            byte by = 0;
            if (bl8) {
                by = (byte)(by | 8);
            }
            if (bl6) {
                by = (byte)(by | 2);
            }
            if (this.currentElem.schemaSeqMode) {
                by = (byte)(by | 1);
            }
            if (binXMLElement != null) {
                if (binXMLElement.firstChild) {
                    binXMLElement.firstChild = false;
                    binXMLElement.kidNum = 0;
                } else if (!this.currentElem.any && this.currentElem.prop != null && binXMLElement.prevChildProp != null && this.currentElem.prop.getQName().equals(binXMLElement.prevChildProp.getQName()) || this.currentElem.prop == null && this.currentElem.qnameId == binXMLElement.prevChildQnameId && by == binXMLElement.prevChildFlag && (!bl8 || s3 == binXMLElement.prevChildPfxId) && n3 == binXMLElement.prevChildTypeId) {
                    bl = true;
                    if (!binXMLElement.arrayMode) {
                        this.writer.writeOpcode((short)215, 2);
                        binXMLElement.arrayMode = true;
                    }
                } else if (binXMLElement.arrayMode) {
                    this.writer.writeOpcode((short)216, 2);
                    binXMLElement.arrayMode = false;
                }
                if (!binXMLElement.arrayMode) {
                    binXMLElement.prevChildQnameId = this.currentElem.qnameId;
                    binXMLElement.prevChildProp = this.currentElem.prop;
                    binXMLElement.prevChildFlag = by;
                    binXMLElement.prevChildPfxId = s3;
                    binXMLElement.prevChildTypeId = n3;
                }
            }
            if (!bl5 && n2 == 0 && by == 0) {
                this.buffer.reset(this.currentElem.qnameId, bl8, bl, s3, by, bl6, n3);
                return;
            }
            boolean bl9 = false;
            if (bl) {
                this.writeELMST();
                bl9 = true;
            } else if (binXMLElement != null && binXMLElement.schemaSeqMode) {
                s = binXMLElement.maxKidNum;
                if (!(this.currentElem.any || this.currentElem.prop == null || this.currentElem.kidNum <= binXMLElement.kidNum || this.currentElem.kidNum > s || bl8 || bl6 || this.currentElem.prop.isSubstitutionGroupMember())) {
                    for (int i = 1; i < this.currentElem.kidNum - binXMLElement.kidNum; ++i) {
                        this.writer.writeOpcode((short)144, 2);
                    }
                    this.writeELMST();
                    bl9 = true;
                    binXMLElement.kidNum = this.currentElem.kidNum;
                } else {
                    this.writer.writeOpcode((short)218, 2);
                }
            }
            if (!bl9) {
                if (this.currentElem.prop != null && this.depth != 1 && !this.currentElem.any && !this.currentElem.prop.isSubstitutionGroupMember()) {
                    this.writeNodeStartKidnum(this.currentElem.kidNum, by, bl8, s3, bl6, n3);
                } else {
                    this.writeElementAttrStart(this.currentElem.qnameId, bl8, by, s3, bl6, n3);
                }
            }
            s = 0;
            BinXMLProperty binXMLProperty = null;
            if (bl5 && l3 >= 0L) {
                this.writer.writeOpcode((short)221, 2);
                this.writer.writeShort((short)l3, 2);
            }
            for (int i = 0; i < n2; ++i) {
                object2 = attributes.getLocalName(i);
                string6 = attributes.getURI(i);
                string5 = attributes.getValue(i);
                string4 = string6 != null && !string6.equals("") ? XMLUtil.getPrefix(attributes.getQName(i)) : "";
                if (string4.equals("xmlns") || string4.length() == 0 && ((String)object2).equals("xmlns")) {
                    l = string5 != null && string5.length() == 0 ? 7L : this.tokenManager.getNamespaceTokenId(string5);
                    s2 = string4.length() > 0 ? this.secState.getPfxId((String)object2, l, true) : this.secState.getPfxId("", l, true);
                    if (s2 < 0) continue;
                    this.writer.writeOpcode((short)221, 2);
                    this.writer.writeShort(s2, 2);
                    continue;
                }
                if (this.schemaAware) {
                    binXMLProperty = this.currentElem.binSchema.getAttrProperty(string6, (String)object2);
                    string5 = string5.trim();
                }
                if (string6.length() > 0) {
                    l = this.tokenManager.getNamespaceTokenId(string6);
                    this.secState.addNamespaceId(l);
                    s2 = this.secState.getPfxId(string4, l, false);
                    s = s2 >= 0;
                } else {
                    l = 7L;
                    s = 0;
                }
                short s4 = -1;
                BinXMLProperty binXMLProperty2 = this.currentElem.prop;
                if (binXMLProperty != null && binXMLProperty2 != null) {
                    s4 = binXMLProperty.getKidNum(binXMLProperty2);
                } else if (binXMLProperty != null) {
                    s4 = binXMLProperty.getKidNum();
                }
                if (binXMLProperty != null && !binXMLProperty.isAnyAttr()) {
                    this.writeNodeKidnum(s != 0, s2, false, 0, s4, (byte)0, this.currentElem.prop, binXMLProperty, string5);
                    continue;
                }
                BinXMLQNameToken binXMLQNameToken = this.tokenManager.getAttrToken((String)object2, l, string6);
                if (binXMLQNameToken == null) {
                    binXMLQNameToken = this.tokenManager.putAttr((String)object2, l);
                }
                if (this.tokenManager.metaProvider != null && this.xdbInlineTokens || this.inlineTokenDefs) {
                    this.key.setValue(binXMLQNameToken.getTokenId());
                    if (!this.inlinedTokensTable.containsKey(this.key)) {
                        this.encodeToken(binXMLQNameToken, true);
                        myLong myLong3 = new myLong();
                        myLong3.setValue(binXMLQNameToken.getTokenId());
                        this.inlinedTokensTable.put(myLong3, binXMLQNameToken);
                    }
                }
                this.writeElementAttr(binXMLQNameToken.getTokenId(), s != 0, s2, string5, false, 0);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (BinXMLException binXMLException) {
            throw new SAXException(binXMLException);
        }
    }

    private void stopArrayMode() throws SAXException {
        if (this.elementStack.empty()) {
            return;
        }
        BinXMLElement binXMLElement = (BinXMLElement)this.elementStack.peek();
        if (binXMLElement != null && binXMLElement.arrayMode && this.curr_event == 2) {
            try {
                this.writer.writeOpcode((short)216, 2);
                binXMLElement.arrayMode = false;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        if (this.validator != null) {
            object = this.validator.getLexicalValue();
            if (this.charLen > 0 && object != null && ((String)object).length() <= this.charLen) {
                this.chars(((String)object).toCharArray(), 0, ((String)object).length());
                this.charLen = 0;
            }
        }
        if (this.charLen > 0) {
            if (this.prev_event == 1 || !this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                isTextNode = true;
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        this.prev_event = this.curr_event;
        this.curr_event = (byte)2;
        try {
            this.validate();
            if (this.buffer != null && (this.buffer.state == 2 || this.buffer.state == 3)) {
                this.buffer.state = (byte)4;
                object = this.tokenManager.getElementToken(string2, this.tokenManager.getNamespaceTokenId(string), string);
                if (object == null) {
                    object = this.tokenManager.putElement(string2, this.tokenManager.getNamespaceTokenId(string));
                }
                if (this.tokenManager.metaProvider != null && this.xdbInlineTokens || this.inlineTokenDefs) {
                    this.key.setValue(((BinXMLToken)object).getTokenId());
                    if (!this.inlinedTokensTable.containsKey(this.key)) {
                        this.encodeToken((BinXMLQNameToken)object, false);
                        myLong myLong2 = new myLong();
                        myLong2.setValue(((BinXMLToken)object).getTokenId());
                        this.inlinedTokensTable.put(myLong2, object);
                    }
                }
                this.buffer.qnameid = this.currentElem.qnameId = ((BinXMLToken)object).getTokenId();
                this.buffer.flush();
            } else {
                if (this.currentElem.arrayMode) {
                    this.writer.writeOpcode((short)216, 2);
                }
                this.writer.writeOpcode((short)217, 2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (BinXMLException binXMLException) {
            throw new SAXException(binXMLException);
        }
        --this.depth;
        if (this.schemaAware && (object = this.schemaResolver.popSchLocTag(string, string2, string3, this.depth, this.validator)) != this.validator) {
            try {
                this.writer.writeOpcode((short)148, 2);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.validator = object;
        }
        this.currentElem.reset();
        this.freeElems.push(this.currentElem);
        this.currentElem = (BinXMLElement)this.elementStack.pop();
        this.currentElem = this.depth > 0 ? (BinXMLElement)this.elementStack.peek() : null;
        if (!this.docEventCalled && this.elementStack.empty()) {
            this.endDocument();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.stopArrayMode();
        if (this.cdataDepth > 0) {
            this.chars(cArray, n, n2);
        } else {
            if (this.charLen > 0 && n2 + this.charLen > 4096) {
                this.chars(this.charBuffer, 0, this.charLen);
                this.charLen = 0;
            }
            if (n2 > 4096) {
                this.chars(cArray, n, n2);
            } else {
                System.arraycopy(cArray, n, this.charBuffer, this.charLen, n2);
                this.charLen += n2;
            }
        }
    }

    void chars(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.validate();
            if (this.cdataDepth > 0) {
                if (this.buffer != null && this.buffer.state != 1) {
                    this.buffer.flush();
                }
                this.writeCDATA(cArray, n, n2);
                return;
            }
            if (this.buffer != null && this.buffer.state == 2) {
                int n3 = this.byteLengthOfCharArr(cArray, n, n2);
                if (n3 <= 16383) {
                    if (n2 < 4096 && this.buffer.textdata.length > 4096) {
                        this.buffer.shrinkTextDataBuf();
                    }
                    this.buffer.state = (byte)3;
                    this.buffer.textdatalen = 0;
                    int n4 = this.buffer.textdata.length;
                    while (this.buffer.textdatalen + n2 > n4) {
                        this.buffer.extendTextDataBuf();
                        n4 = this.buffer.textdata.length;
                    }
                    System.arraycopy(cArray, n, this.buffer.textdata, this.buffer.textdatalen, n2);
                    this.buffer.textdatalen += n2;
                } else {
                    this.buffer.flush();
                    this.writeText(cArray, n, n2);
                }
                return;
            }
            if (this.buffer != null && this.buffer.state == 3) {
                int n5;
                int n6 = this.byteLengthOfCharArr(cArray, n, n2);
                if (n6 + (n5 = this.byteLengthOfCharArr(this.buffer.textdata, 0, this.buffer.textdatalen)) > 16383) {
                    this.buffer.flush();
                } else {
                    int n7 = this.buffer.textdata.length;
                    while (this.buffer.textdatalen + n2 > n7) {
                        this.buffer.extendTextDataBuf();
                        n7 = this.buffer.textdata.length;
                    }
                    System.arraycopy(cArray, n, this.buffer.textdata, this.buffer.textdatalen, n2);
                    this.buffer.textdatalen += n2;
                    return;
                }
            }
            if (this.currentElem.arrayMode || this.currentElem.schemaSeqMode) {
                if (BinXMLUtil.isPureWhiteSpace(cArray, n, n2)) {
                    if (this.currentElem.kidNum < 1 || this.isValidLocation4WS()) {
                        this.writeWhiteSpace(cArray, n, n2);
                    } else {
                        this.writeText(cArray, n, n2);
                    }
                } else if (!this.schemaAware) {
                    this.writeText(cArray, n, n2);
                } else if (isTextNode) {
                    this.writeText(cArray, n, n2);
                    isTextNode = false;
                } else {
                    this.writeSimpleNode(0L, null, this.currentElem.prop, (short)0, cArray, n, n2, (byte)3);
                }
            } else {
                if (this.buffer != null && this.buffer.state == 1) {
                    this.buffer.flush();
                }
                if (BinXMLUtil.isPureWhiteSpace(cArray, n, n2)) {
                    this.writeWhiteSpace(cArray, n, n2);
                } else {
                    this.writeSimpleNode(0L, null, null, (short)0, cArray, n, n2, (byte)3);
                }
            }
            isTextNode = false;
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException(binXMLException);
        }
    }

    private int byteLengthOfCharArr(char[] cArray, int n, int n2) {
        int n3 = 0;
        char c = '\u0000';
        for (int i = n; i < n + n2; ++i) {
            c = cArray[i];
            if (c < '\u0080') {
                ++n3;
                continue;
            }
            if (c < '\u0800') {
                n3 += 2;
                continue;
            }
            if (c < '\u10000') {
                n3 += 3;
                continue;
            }
            n3 += 4;
        }
        return n3;
    }

    private boolean isValidLocation4WS() {
        if (this.prev_event == 1 && this.curr_event == 1) {
            return true;
        }
        if (this.prev_event == 1 && this.curr_event == 2) {
            return true;
        }
        if (this.prev_event == 2 && this.curr_event == 1) {
            return true;
        }
        return this.prev_event == 2 && this.curr_event == 2;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.stopArrayMode();
        if (this.charLen > 0) {
            if (!this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                isTextNode = true;
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        try {
            String string3;
            byte[] byArray;
            int n;
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
            if ((n = (byArray = this.convTextToCSXString(string3 = string.concat(string2))).length) <= 255) {
                this.writer.writeOpcode((short)169, 2);
                this.writer.writeByte((byte)n, 2);
                this.writer.writeByte((byte)string.length(), 2);
            } else {
                this.writer.writeOpcode((short)170, 2);
                this.writer.writeInt(n, 2);
                this.writer.writeShort(string.length(), 2);
            }
            this.writer.writeByteArray(byArray, 2, byArray.length);
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException(binXMLException);
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        try {
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null && (n2 = (byArray2 = string2.getBytes("UTF-8")).length) == 0) {
                bl = true;
            }
            if (string3 != null && (n3 = (byArray3 = string3.getBytes("UTF-8")).length) == 0) {
                bl = true;
            }
            if (bl) {
                this.writer.writeOpcode((short)254, 2);
                this.writer.writeOpcode((short)1, 2);
                this.writer.writeShort(n + n2 + n3 + 7, 2);
            } else {
                this.writer.writeOpcode((short)154, 2);
                this.writer.writeShort(n + n2 + n3 + 6, 2);
            }
            this.writeShortByteArray(n, byArray, 2);
            this.writeShortByteArray(n2, byArray2, 2);
            this.writeShortByteArray(n3, byArray3, 2);
            if (bl) {
                this.writer.writeByte(this.determineDTDFlag(string2, string3, null), 2);
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        try {
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null && (n2 = (byArray2 = string2.getBytes("UTF-8")).length) == 0) {
                bl = true;
            }
            if (string3 != null && (n3 = (byArray3 = string3.getBytes("UTF-8")).length) == 0) {
                bl = true;
            }
            if (string4 != null) {
                byArray4 = string4.getBytes("UTF-8");
                n4 = byArray4.length;
            }
            if (bl) {
                this.writer.writeOpcode((short)254, 2);
                this.writer.writeOpcode((short)2, 2);
                this.writer.writeShort(n + n2 + n3 + n4 + 11, 2);
            } else {
                this.writer.writeOpcode((short)152, 2);
                this.writer.writeShort(n + n2 + n3 + n4 + 10, 2);
            }
            this.writeShortByteArray(n, byArray, 2);
            this.writer.writeShort(0, 2);
            this.writeShortByteArray(n2, byArray2, 2);
            this.writeShortByteArray(n3, byArray3, 2);
            this.writeShortByteArray(n4, byArray4, 2);
            if (bl) {
                this.writer.writeByte(this.determineDTDFlag(string2, string3, null), 2);
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        try {
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            String string6 = "";
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            this.writer.writeOpcode((short)151, 2);
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            if (string3 != null) {
                string6 = string6 + string3;
            }
            if (string4 != null) {
                string6 = string6 + " " + string4;
            }
            if (string5 != null) {
                string6 = string6 + " \"" + string5 + "\"";
            }
            byArray3 = string6.getBytes("UTF-8");
            n3 = byArray3.length;
            this.writer.writeShort(n + n2 + n3 + 6, 2);
            this.writeShortByteArray(n, byArray, 2);
            this.writeShortByteArray(n2, byArray2, 2);
            this.writeShortByteArray(n3, byArray3, 2);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        try {
            this.writer.writeOpcode((short)150, 2);
            byte[] byArray = null;
            byte[] byArray2 = null;
            int n = 0;
            int n2 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            this.writer.writeShort(n + n2 + 4, 2);
            this.writeShortByteArray(n, byArray, 2);
            this.writeShortByteArray(n2, byArray2, 2);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    private void writeParameterEntity(String string, String string2, String string3, String string4) throws SAXException {
        try {
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            if (string3 != null) {
                byArray3 = string3.getBytes("UTF-8");
                n3 = byArray3.length;
            }
            if (string4 != null) {
                byArray4 = string4.getBytes("UTF-8");
                n4 = byArray4.length;
            }
            this.writer.writeOpcode((short)254, 2);
            this.writer.writeOpcode((short)3, 2);
            this.writer.writeShort(n + n2 + n3 + n4 + 9, 2);
            this.writeShortByteArray(n, byArray, 2);
            this.writeShortByteArray(n4, byArray4, 2);
            this.writeShortByteArray(n2, byArray2, 2);
            this.writeShortByteArray(n3, byArray3, 2);
            this.writer.writeByte(this.determineDTDFlag(string2, string3, string4), 2);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        try {
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            if (string != null && string.startsWith("%")) {
                this.writeParameterEntity(string.substring(1, string.length()), string2, string3, null);
                return;
            }
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null && (n2 = (byArray2 = string2.getBytes("UTF-8")).length) == 0) {
                bl = true;
            }
            if (string3 != null && (n3 = (byArray3 = string3.getBytes("UTF-8")).length) == 0) {
                bl = true;
            }
            if (bl) {
                this.writer.writeOpcode((short)254, 2);
                this.writer.writeOpcode((short)2, 2);
                this.writer.writeShort(n + n2 + n3 + 11, 2);
            } else {
                this.writer.writeOpcode((short)152, 2);
                this.writer.writeShort(n + n2 + n3 + 10, 2);
            }
            this.writeShortByteArray(n, byArray, 2);
            this.writer.writeShort(0, 2);
            this.writeShortByteArray(n2, byArray2, 2);
            this.writeShortByteArray(n3, byArray3, 2);
            this.writer.writeShort(0, 2);
            if (bl) {
                this.writer.writeByte(this.determineDTDFlag(string2, string3, null), 2);
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        try {
            byte[] byArray = null;
            byte[] byArray2 = null;
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            if (string != null && string.startsWith("%")) {
                this.writeParameterEntity(string.substring(1, string.length()), null, null, string2);
                return;
            }
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null && (n2 = (byArray2 = string2.getBytes("UTF-8")).length) == 0) {
                bl = true;
            }
            if (bl) {
                this.writer.writeOpcode((short)254, 2);
                this.writer.writeOpcode((short)2, 2);
                this.writer.writeShort(n + n2 + 11, 2);
            } else {
                this.writer.writeOpcode((short)152, 2);
                this.writer.writeShort(n + n2 + 10, 2);
            }
            this.writeShortByteArray(n, byArray, 2);
            this.writeShortByteArray(n2, byArray2, 2);
            this.writer.writeShort(0, 2);
            this.writer.writeShort(0, 2);
            this.writer.writeShort(0, 2);
            if (bl) {
                this.writer.writeByte(this.determineDTDFlag(null, null, string2), 2);
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.stopArrayMode();
        if (this.charLen > 0) {
            if (!this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                isTextNode = true;
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        try {
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
            this.convCharArrToCSXString(cArray, n, n2);
            if (this.byteLen <= 255) {
                this.writer.writeOpcode((short)171, 2);
                this.writer.writeByte((byte)this.byteLen, 2);
            } else if (this.byteLen <= 65535) {
                this.writer.writeOpcode((short)172, 2);
                this.writer.writeShort(this.byteLen, 2);
            } else {
                this.writer.writeOpcode((short)173, 2);
                this.writer.writeLong8(this.byteLen, 2);
            }
            if (this.byteLen > 0) {
                this.writer.writeByteArray(this.byteBuf, 2, this.byteLen);
            }
        }
        catch (Exception exception) {
            new SAXException(exception.getMessage(), exception);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        --this.cdataDepth;
    }

    @Override
    public void endDTD() throws SAXException {
        try {
            this.writer.writeOpcode((short)155, 2);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.cdataDepth == 0 && this.charLen > 0) {
            if (!this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        try {
            this.validate();
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException(binXMLException.getMessage(), binXMLException);
        }
        ++this.cdataDepth;
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        try {
            this.dtd = true;
            boolean bl = false;
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null && (n2 = (byArray2 = string2.getBytes("UTF-8")).length) == 0) {
                bl = true;
            }
            if (string3 != null && (n3 = (byArray3 = string3.getBytes("UTF-8")).length) == 0) {
                bl = true;
            }
            if (bl) {
                this.writer.writeOpcode((short)254, 2);
                this.writer.writeOpcode((short)0, 2);
                this.writer.writeShort(n + n2 + n3 + 7, 2);
            } else {
                this.writer.writeOpcode((short)149, 2);
                this.writer.writeShort(n + n2 + n3 + 6, 2);
            }
            this.writeShortByteArray(n, byArray, 2);
            this.writeShortByteArray(n2, byArray2, 2);
            this.writeShortByteArray(n3, byArray3, 2);
            if (bl) {
                this.writer.writeByte(this.determineDTDFlag(string2, string3, null), 2);
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    private int determineDTDFlag(String string, String string2, String string3) {
        int n = 0;
        if (string2 != null && string2.equals("")) {
            n |= 1;
        }
        if (string != null && string.equals("")) {
            n |= 2;
        }
        if (string3 != null && string3.equals("")) {
            n |= 4;
        }
        return n;
    }

    private void writeWhiteSpace(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        char c = ' ';
        boolean bl = true;
        for (int i = n; i < n + n2; ++i) {
            if (bl) {
                switch (cArray[i]) {
                    case '\t': {
                        c = '\t';
                        break;
                    }
                    case ' ': {
                        c = ' ';
                        break;
                    }
                    case '\r': {
                        c = '\r';
                        break;
                    }
                    case '\n': {
                        c = '\n';
                    }
                }
            }
            while (i < n + n2 && cArray[i] == c) {
                ++n3;
                bl = false;
                ++i;
            }
            if (i >= n + n2) continue;
            this.writeSPACEx(n3, c);
            n3 = 0;
            --i;
            bl = true;
        }
        this.writeSPACEx(n3, c);
    }

    void writeSPACEx(int n, char c) throws IOException {
        int n2 = 1;
        if (n > 32 && n < 8192) {
            n2 = 2;
        } else if (n > 8192) {
            n2 = 8;
        }
        int n3 = 0;
        switch (c) {
            case ' ': {
                break;
            }
            case '\t': {
                n3 = 1;
                break;
            }
            case '\n': {
                n3 = 2;
                break;
            }
            case '\r': {
                n3 = 3;
            }
        }
        switch (n2) {
            case 1: {
                byte by = (byte)((n3 << 5 & 0xFF) + (n >>> 0 & 0xFF));
                this.writer.writeOpcode((short)234, 2);
                this.writer.writeByte(by, 2);
                break;
            }
            case 2: {
                this.byteBuf[0] = (byte)((n3 << 5 & 0xFF) + (n >>> 8 & 0xFF));
                this.byteBuf[1] = (byte)(n >>> 0 & 0xFF);
                this.writer.writeOpcode((short)235, 2);
                this.writer.writeByteArray(this.byteBuf, 2, 2);
                break;
            }
            case 8: {
                this.byteBuf[0] = (byte)(n3 << 5 & 0xFF);
                this.byteBuf[1] = 0;
                this.byteBuf[2] = 0;
                this.byteBuf[3] = 0;
                this.byteBuf[4] = (byte)(n >>> 24 & 0xFF);
                this.byteBuf[5] = (byte)(n >>> 16 & 0xFF);
                this.byteBuf[6] = (byte)(n >>> 8 & 0xFF);
                this.byteBuf[7] = (byte)(n >>> 0 & 0xFF);
                this.writer.writeOpcode((short)236, 2);
                this.writer.writeByteArray(this.byteBuf, 2, 8);
            }
        }
    }

    void writeELMST() throws IOException {
        if (this.currentElem.schemaSeqMode) {
            this.writer.writeOpcode((short)214, 2);
        } else {
            this.writer.writeOpcode((short)213, 2);
        }
    }

    void writeElementAttrStart(long l, boolean bl, int n, short s, boolean bl2, int n2) throws IOException {
        if (n == 0) {
            if (l <= 65535L) {
                this.writer.writeOpcode((short)200, 2);
                this.writer.writeShort((int)l, 2);
            } else if (l <= 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)201, 2);
                this.writer.writeLong4(l, 2);
            } else {
                this.writer.writeOpcode((short)202, 2);
                this.writer.writeLong8(l, 2);
            }
        } else if (!bl && !bl2) {
            if (l <= 65535L) {
                this.writer.writeOpcode((short)205, 2);
                this.writer.writeShort((int)l, 2);
            } else if (l <= 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)206, 2);
                this.writer.writeLong4(l, 2);
            } else {
                this.writer.writeOpcode((short)207, 2);
                this.writer.writeLong8(l, 2);
            }
            this.writer.writeByte(n, 2);
        } else {
            int n3 = 0;
            if (bl) {
                n3 = (byte)(n3 + 2);
            }
            if (bl2) {
                n3 = (byte)(n3 + 4);
            }
            if (l <= 65535L) {
                this.writer.writeOpcode((short)210, 2);
                this.writer.writeByte(n3, 2);
                this.writer.writeShort((int)(l & 0xFFFFL), 2);
            } else if (l <= 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)211, 2);
                this.writer.writeByte(n3, 2);
                this.writer.writeLong4(l, 2);
            } else {
                this.writer.writeOpcode((short)212, 2);
                this.writer.writeByte(n3, 2);
                this.writer.writeLong8(l, 2);
            }
            this.writer.writeByte(n, 2);
            if (bl2) {
                this.writer.writeInt(n2, 2);
            }
            if (bl) {
                this.writer.writeShort(s, 2);
            }
        }
    }

    void writeElementAttr(long l, boolean bl, short s, String string, boolean bl2, int n) throws IOException, BinXMLException {
        long l2 = string.length();
        if (!bl && l2 <= 65535L) {
            this.writeSimpleNode(l, null, null, (short)0, string, (byte)1);
            return;
        }
        this.writeElementAttrStart(l, bl, bl ? 8 : 0, s, bl2, n);
        this.writeSimpleNode(0L, null, null, (short)0, string, (byte)3);
        this.writer.writeOpcode((short)217, 2);
    }

    void writeNodeKidnum(boolean bl, short s, boolean bl2, int n, short s2, byte by, BinXMLProperty binXMLProperty, BinXMLProperty binXMLProperty2, String string) throws IOException, BinXMLException {
        long l = string.length();
        if (!bl && !bl2 && l <= 65535L) {
            this.writeSimpleNode(0L, binXMLProperty, binXMLProperty2, s2, string, (byte)4);
            return;
        }
        if (bl) {
            by = (byte)(by | 8);
        }
        if (bl2) {
            by = (byte)(by | 2);
        }
        this.writeNodeStartKidnum(s2, by, bl, s, bl2, n);
        this.writeSimpleNode(0L, binXMLProperty, binXMLProperty2, s2, string, (byte)3);
        this.writer.writeOpcode((short)217, 2);
    }

    void writeNodeStartKidnum(short s, byte by, boolean bl, short s2, boolean bl2, int n) throws IOException {
        if (by == 0) {
            if (s <= 255) {
                this.writer.writeOpcode((short)198, 2);
                this.writer.writeByte((byte)s, 2);
            } else {
                this.writer.writeOpcode((short)199, 2);
                this.writer.writeShort(s, 2);
            }
        } else if (!bl && !bl2) {
            if (s <= 255) {
                this.writer.writeOpcode((short)203, 2);
                this.writer.writeByte((byte)s, 2);
                this.writer.writeByte(by, 2);
            } else {
                this.writer.writeOpcode((short)204, 2);
                this.writer.writeShort(s, 2);
                this.writer.writeByte(by, 2);
            }
        } else {
            int n2 = 0;
            if (bl) {
                n2 = (byte)(n2 + 2);
            }
            if (bl2) {
                n2 = (byte)(n2 + 4);
            }
            if (s <= 255) {
                this.writer.writeOpcode((short)208, 2);
                this.writer.writeByte(n2, 2);
                this.writer.writeByte((byte)s, 2);
                this.writer.writeByte(by, 2);
                if (bl2) {
                    this.writer.writeInt(n, 2);
                }
                if (bl) {
                    this.writer.writeShort(s2, 2);
                }
            } else {
                this.writer.writeOpcode((short)209, 2);
                this.writer.writeByte(n2, 2);
                this.writer.writeShort(s, 2);
                this.writer.writeByte(by, 2);
                if (bl2) {
                    this.writer.writeInt(n, 2);
                }
                if (bl) {
                    this.writer.writeShort(s2, 2);
                }
            }
        }
    }

    void writeSimpleNode(long l, BinXMLProperty binXMLProperty, BinXMLProperty binXMLProperty2, short s, String string, byte by) throws IOException, BinXMLException {
        byte[] byArray = null;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (binXMLProperty2 != null) {
            n2 = binXMLProperty2.getEncTypeId();
            n3 = binXMLProperty2.getCSXEncodingType();
            if (n3 == -1) {
                n3 = 1;
            }
        }
        if (string != null && binXMLProperty2 != null && n3 != 1) {
            if (this.currentElem.prop.enums != null) {
                n3 = 12;
            }
            if ((byArray = this.convTextToCSX(string, n2, n3, binXMLProperty2)) == null) {
                byArray = this.convTextToCSXString(string);
                n3 = 1;
            }
            l2 = byArray.length;
        } else if (this.validator != null && l == 18L) {
            n3 = 13;
            byArray = this.convTextToQName(string, null, this.secState);
            l2 = byArray.length;
        } else {
            n3 = 1;
            if (string != null) {
                byArray = this.convTextToCSXString(string);
                l2 = byArray.length;
            }
        }
        n = n3 == 2 && l2 <= 32L || n3 != 2 && l2 <= 64L ? 1 : (l2 <= 16383L ? 2 : 8);
        boolean bl = false;
        if (n == 1 && (by == 4 || by == 1)) {
            bl = true;
        }
        switch (by) {
            case 2: 
            case 3: 
            case 5: {
                if (n == 1) break;
                if (n == 2) {
                    this.writer.writeOpcode((short)138, 2);
                    break;
                }
                this.writer.writeOpcode((short)139, 2);
                break;
            }
            case 4: {
                if (s <= 255) {
                    if (n == 1) {
                        this.writer.writeOpcode((short)188, 2);
                        break;
                    }
                    if (n != 2) break;
                    this.writer.writeOpcode((short)189, 2);
                    break;
                }
                if (n == 1) {
                    this.writer.writeOpcode((short)190, 2);
                    break;
                }
                if (n != 2) break;
                this.writer.writeOpcode((short)191, 2);
                break;
            }
            case 1: {
                if (l <= 65535L) {
                    if (n == 1) {
                        this.writer.writeOpcode((short)192, 2);
                        break;
                    }
                    if (n != 2) break;
                    this.writer.writeOpcode((short)193, 2);
                    break;
                }
                if (l <= 0xFFFFFFFFL) {
                    if (n == 1) {
                        this.writer.writeOpcode((short)194, 2);
                        break;
                    }
                    if (n != 2) break;
                    this.writer.writeOpcode((short)195, 2);
                    break;
                }
                if (n == 1) {
                    this.writer.writeOpcode((short)196, 2);
                    break;
                }
                if (n != 2) break;
                this.writer.writeOpcode((short)197, 2);
                break;
            }
        }
        if (n == 1) {
            short s2 = 0;
            s2 = l2 == 0L ? (short)143 : (short)this.getSimpleNodeLen(n3, l2);
            if (bl) {
                this.writer.writeByte(s2, 2);
            } else {
                this.writer.writeOpcode(s2, 2);
            }
        } else if (l2 <= 16383L) {
            int n4 = (int)l2;
            this.writer.writeShort(n4 |= n3 == 1 ? 0 : 16384, 2);
        } else {
            long l3 = l2;
            this.writer.writeLong8(l3 |= n3 == 1 ? 0L : 0x4000000000000000L, 2);
        }
        switch (by) {
            case 4: {
                if (s <= 255) {
                    this.writer.writeByte(s, 2);
                    break;
                }
                this.writer.writeShort(s, 2);
                break;
            }
            case 1: {
                if (l <= 65535L) {
                    this.writer.writeShort((int)l, 2);
                    break;
                }
                if (l <= 0xFFFFFFFFL) {
                    this.writer.writeLong4(l, 2);
                    break;
                }
                this.writer.writeLong8(l, 2);
                break;
            }
        }
        if (l2 > 0L) {
            this.writer.setBigLength(l2);
            this.writer.writeByteArray(byArray, 2, byArray.length);
        }
    }

    void writeSimpleNode(long l, BinXMLProperty binXMLProperty, BinXMLProperty binXMLProperty2, short s, char[] cArray, int n, int n2, byte by) throws IOException, BinXMLException {
        byte[] byArray;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.byteLen = 0;
        if (binXMLProperty2 != null) {
            n4 = binXMLProperty2.getEncTypeId();
            n5 = binXMLProperty2.getCSXEncodingType();
            if (n5 == -1) {
                n5 = 1;
            }
        }
        if (cArray != null && binXMLProperty2 != null && n5 != 1) {
            if (this.currentElem.prop.enums != null) {
                n5 = 12;
            }
            if ((byArray = this.convTextToCSX(new String(cArray, n, n2), n4, n5, binXMLProperty2)) == null) {
                this.convCharArrToCSXString(cArray, n, n2);
                n5 = 1;
            } else {
                this.byteLen = byArray.length;
                while (this.byteLen > this.byteBuf.length) {
                    this.extendByteBuf(false);
                }
                System.arraycopy(byArray, 0, this.byteBuf, 0, this.byteLen);
            }
        } else if (this.validator != null && l == 18L) {
            n5 = 13;
            byArray = this.convTextToQName(new String(cArray, n, n2), null, this.secState);
            this.byteLen = byArray.length;
            while (this.byteLen > this.byteBuf.length) {
                this.extendByteBuf(false);
            }
            System.arraycopy(byArray, 0, this.byteBuf, 0, this.byteLen);
        } else {
            n5 = 1;
            if (cArray != null) {
                this.convCharArrToCSXString(cArray, n, n2);
            }
        }
        n3 = n5 == 2 && this.byteLen <= 32 || n5 != 2 && this.byteLen <= 64 ? 1 : (this.byteLen <= 16383 ? 2 : 8);
        boolean bl = false;
        if (n3 == 1 && (by == 4 || by == 1)) {
            bl = true;
        }
        switch (by) {
            case 2: 
            case 3: 
            case 5: {
                if (n3 == 1) break;
                if (n3 == 2) {
                    this.writer.writeOpcode((short)138, 2);
                    break;
                }
                this.writer.writeOpcode((short)139, 2);
                break;
            }
            case 4: {
                if (s <= 255) {
                    if (n3 == 1) {
                        this.writer.writeOpcode((short)188, 2);
                        break;
                    }
                    if (n3 != 2) break;
                    this.writer.writeOpcode((short)189, 2);
                    break;
                }
                if (n3 == 1) {
                    this.writer.writeOpcode((short)190, 2);
                    break;
                }
                if (n3 != 2) break;
                this.writer.writeOpcode((short)191, 2);
                break;
            }
            case 1: {
                if (l <= 65535L) {
                    if (n3 == 1) {
                        this.writer.writeOpcode((short)192, 2);
                        break;
                    }
                    if (n3 != 2) break;
                    this.writer.writeOpcode((short)193, 2);
                    break;
                }
                if (l <= 0xFFFFFFFFL) {
                    if (n3 == 1) {
                        this.writer.writeOpcode((short)194, 2);
                        break;
                    }
                    if (n3 != 2) break;
                    this.writer.writeOpcode((short)195, 2);
                    break;
                }
                if (n3 == 1) {
                    this.writer.writeOpcode((short)196, 2);
                    break;
                }
                if (n3 != 2) break;
                this.writer.writeOpcode((short)197, 2);
                break;
            }
        }
        if (n3 == 1) {
            short s2 = 0;
            s2 = this.byteLen == 0 ? (short)143 : (short)this.getSimpleNodeLen(n5, this.byteLen);
            if (bl) {
                this.writer.writeByte(s2, 2);
            } else {
                this.writer.writeOpcode(s2, 2);
            }
        } else if (this.byteLen <= 16383) {
            int n6 = this.byteLen;
            this.writer.writeShort(n6 |= n5 == 1 ? 0 : 16384, 2);
        } else {
            long l2 = this.byteLen;
            this.writer.writeLong8(l2 |= n5 == 1 ? 0L : 0x4000000000000000L, 2);
        }
        switch (by) {
            case 4: {
                if (s <= 255) {
                    this.writer.writeByte(s, 2);
                    break;
                }
                this.writer.writeShort(s, 2);
                break;
            }
            case 1: {
                if (l <= 65535L) {
                    this.writer.writeShort((int)l, 2);
                    break;
                }
                if (l <= 0xFFFFFFFFL) {
                    this.writer.writeLong4(l, 2);
                    break;
                }
                this.writer.writeLong8(l, 2);
                break;
            }
        }
        if (this.byteLen > 0) {
            this.writer.setBigLength(this.byteLen);
            this.writer.writeByteArray(this.byteBuf, 2, this.byteLen);
        }
    }

    private short getSimpleNodeLen(int n, long l) throws BinXMLException {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = (short)(0L + l - 1L);
                break;
            }
            case 2: {
                n2 = (short)(64L + l - 1L);
                break;
            }
            case 3: {
                n2 = 134;
                break;
            }
            case 4: {
                if (l != 1L && l != 2L && l != 4L && l != 8L) {
                    throw new BinXMLException(this.err.getMessage0(35004));
                }
                if (l != 8L) {
                    n2 = (short)(117L + l / 2L);
                    break;
                }
                n2 = 120;
                break;
            }
            case 5: {
                if (l != 1L && l != 2L && l != 4L && l != 8L) {
                    throw new BinXMLException(this.err.getMessage0(35004));
                }
                if (l != 8L) {
                    n2 = (short)(121L + l / 2L);
                    break;
                }
                n2 = 124;
                break;
            }
            case 6: {
                if (l != 4L) {
                    throw new BinXMLException(this.err.getMessage0(35004));
                }
                n2 = 125;
                break;
            }
            case 14: {
                if (l != 8L) {
                    throw new BinXMLException(this.err.getMessage0(35004));
                }
                n2 = 126;
                break;
            }
            case 7: {
                if (l > 22L) {
                    throw new BinXMLException(this.err.getMessage0(35004));
                }
                n2 = (short)(96L + l - 1L);
                break;
            }
            case 8: {
                n2 = 131;
                break;
            }
            case 9: {
                n2 = 132;
                break;
            }
            case 10: {
                if (l == 4L) {
                    n2 = 127;
                    break;
                }
                if (l == 8L) {
                    n2 = 128;
                    break;
                }
                throw new BinXMLException(this.err.getMessage0(35004));
            }
            case 11: {
                if (l == 6L) {
                    n2 = 129;
                    break;
                }
                if (l == 10L) {
                    n2 = 130;
                    break;
                }
                throw new BinXMLException(this.err.getMessage0(35004));
            }
            case 12: {
                if (l == 1L) {
                    n2 = 136;
                    break;
                }
                n2 = 137;
                break;
            }
            case 13: {
                n2 = 135;
                break;
            }
            default: {
                throw new BinXMLException(this.err.getMessage0(35005));
            }
        }
        return (short)n2;
    }

    void writeShortByteArray(int n, byte[] byArray, int n2) throws SAXException {
        try {
            this.writer.writeShort(n, n2);
            if (n != 0) {
                this.writer.writeByteArray(byArray, n2, n);
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    void writeText(char[] cArray, int n, int n2) throws IOException {
        this.convCharArrToCSXString(cArray, n, n2);
        if (this.byteLen <= 255) {
            this.writer.writeOpcode((short)163, 2);
            this.writer.writeByte((byte)this.byteLen, 2);
        } else if (this.byteLen <= 65535) {
            this.writer.writeOpcode((short)164, 2);
            this.writer.writeShort(this.byteLen, 2);
            this.writer.setBigLength(this.byteLen);
        } else {
            this.writer.writeOpcode((short)165, 2);
            this.writer.writeLong8(this.byteLen, 2);
            this.writer.setBigLength(this.byteLen);
        }
        this.writer.writeByteArray(this.byteBuf, 2, this.byteLen);
    }

    void writeCDATA(char[] cArray, int n, int n2) throws IOException {
        this.convCharArrToCSXString(cArray, n, n2);
        if (this.byteLen <= 255) {
            this.writer.writeOpcode((short)166, 2);
            this.writer.writeByte((byte)this.byteLen, 2);
        } else if (this.byteLen <= 65535) {
            this.writer.writeOpcode((short)167, 2);
            this.writer.writeShort(this.byteLen, 2);
        } else {
            this.writer.writeOpcode((short)168, 2);
            this.writer.writeLong8(this.byteLen, 2);
        }
        this.writer.writeByteArray(this.byteBuf, 2, this.byteLen);
        if (this.binXMLProcessor.getDebugMode()) {
            this.debugWriter.println("\t" + new String(cArray, n, n2));
            this.debugWriter.flush();
        }
    }

    void encodeNamespace(long l, String string) throws IOException, BinXMLException {
        byte[] byArray = this.convTextToCSXString(string);
        int n = byArray.length;
        if (n >= 65535) {
            throw new BinXMLException(this.err.getMessage0(35006));
        }
        if (n <= 255) {
            if (l < 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)174, 0);
                this.writer.writeByte((byte)n, 0);
                this.writer.writeInt((int)l, 0);
            } else {
                this.writer.writeOpcode((short)176, 0);
                this.writer.writeByte((byte)n, 0);
                this.writer.writeLong8(l, 0);
            }
        } else if (l < 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)175, 0);
            this.writer.writeShort(n, 0);
            this.writer.writeInt((int)l, 0);
        } else {
            this.writer.writeOpcode((short)177, 0);
            this.writer.writeShort(n, 0);
            this.writer.writeLong8(l, 0);
        }
        this.writer.writeByteArray(byArray, 0, n);
    }

    void encodeToken(BinXMLQNameToken binXMLQNameToken, boolean bl) throws IOException {
        long l = binXMLQNameToken.getTokenId();
        long l2 = binXMLQNameToken.getNamespaceId();
        String string = binXMLQNameToken.getLocalName();
        byte[] byArray = null;
        int n = 0;
        if (string != null) {
            byArray = string.getBytes("UTF-8");
            n = byArray.length;
        }
        if (n <= 255 && l <= 0xFFFFFFFFL && l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)180, 0);
            this.writer.writeByte((byte)n, 0);
            this.writer.writeBoolean(bl, 0);
            this.writer.writeLong4(l, 0);
            this.writer.writeLong4(l2, 0);
        } else if (l <= 0xFFFFFFFFL && l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)181, 0);
            this.writer.writeShort(n, 0);
            this.writer.writeBoolean(bl, 0);
            this.writer.writeLong4(l, 0);
            this.writer.writeLong4(l2, 0);
        } else if (n <= 255 && l <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)182, 0);
            this.writer.writeByte((byte)n, 0);
            this.writer.writeBoolean(bl, 0);
            this.writer.writeLong4(l, 0);
            this.writer.writeLong8(l2, 0);
        } else if (l <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)183, 0);
            this.writer.writeShort(n, 0);
            this.writer.writeBoolean(bl, 0);
            this.writer.writeLong4(l, 0);
            this.writer.writeLong8(l2, 0);
        } else if (n <= 255 && l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)184, 0);
            this.writer.writeByte((byte)n, 0);
            this.writer.writeBoolean(bl, 0);
            this.writer.writeLong8(l, 0);
            this.writer.writeLong4(l2, 0);
        } else if (l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)185, 0);
            this.writer.writeShort(n, 0);
            this.writer.writeBoolean(bl, 0);
            this.writer.writeLong8(l, 0);
            this.writer.writeLong4(l2, 0);
        } else if (n <= 255) {
            this.writer.writeOpcode((short)186, 0);
            this.writer.writeByte((byte)n, 0);
            this.writer.writeBoolean(bl, 0);
            this.writer.writeLong8(l, 0);
            this.writer.writeLong8(l2, 0);
        } else {
            this.writer.writeOpcode((short)187, 0);
            this.writer.writeShort(n, 0);
            this.writer.writeBoolean(bl, 0);
            this.writer.writeLong8(l, 0);
            this.writer.writeLong8(l2, 0);
        }
        if (n > 0) {
            this.writer.writeByteArray(byArray, 0, n);
        }
    }

    private void writeSchemaScopeStart(BinXMLSchema binXMLSchema) throws IOException {
        byte[] byArray = binXMLSchema.getSchemaId().getVocabID();
        int n = binXMLSchema.getSchemaVer();
        if (n <= 255) {
            this.writer.writeOpcode((short)145, 0);
            this.writer.writeByte(byArray.length, 0);
            this.writer.writeByte(n, 0);
            if (this.binXMLProcessor.getDebugMode()) {
                this.debugWriter.println("\tSCHSST1");
                this.debugWriter.flush();
            }
            schemaScopeLength = 3;
        } else {
            this.writer.writeOpcode((short)146, 0);
            this.writer.writeByte(byArray.length, 0);
            this.writer.writeInt(n, 0);
            if (this.binXMLProcessor.getDebugMode()) {
                this.debugWriter.println("\tSCHSST4");
                this.debugWriter.flush();
            }
            schemaScopeLength = 6;
        }
        this.writer.writeByteArray(byArray, 0, byArray.length);
        schemaScopeLength += byArray.length;
    }

    byte[] convTextToQName(String string, BinXMLProperty binXMLProperty, BinXMLSectionState binXMLSectionState) throws BinXMLException, IOException {
        String string2 = XMLUtil.getPrefix(string);
        String string3 = XMLUtil.getLocalName(string);
        String string4 = this.validator.resolve(string2);
        if (string4 != null && string4.equals("")) {
            string4 = null;
        }
        long l = string4 == null ? 7L : this.tokenManager.getNamespaceTokenId(string4);
        BinXMLQNameToken binXMLQNameToken = null;
        if (binXMLProperty != null && binXMLProperty.xnode instanceof XSDElement) {
            binXMLQNameToken = this.tokenManager.getElementToken(string3, l, string4);
            if (binXMLQNameToken == null) {
                binXMLQNameToken = this.tokenManager.putElement(string3, l);
                this.encodeToken(binXMLQNameToken, false);
            }
        } else {
            binXMLQNameToken = this.tokenManager.getAttrToken(string3, l, string4);
            if (binXMLQNameToken == null) {
                binXMLQNameToken = this.tokenManager.putAttr(string3, l);
                this.encodeToken(binXMLQNameToken, true);
            }
        }
        long l2 = binXMLQNameToken.getTokenId();
        binXMLSectionState.addNamespaceId(l);
        int n = binXMLSectionState.getPfxId(string2, l, true);
        int n2 = 8;
        if (l >= 0xFFFFFFFFL) {
            n2 = 12;
        }
        byte[] byArray = new byte[n2];
        if (n2 == 8) {
            byArray[0] = 4;
            this.writer.copyLong4ToArray(l2, byArray, 1);
        } else {
            byArray[0] = 4;
            this.writer.copyLong8ToArray(l2, byArray, 1);
        }
        if (string2 != null && !string2.equals("")) {
            byArray[n2 - 3] = 2;
            byArray[n2 - 1] = (byte)(n & 0xFF);
            byArray[n2 - 2] = (byte)((n >>= 8) & 0xFF);
        } else {
            byArray[n2 - 3] = 0;
        }
        return byArray;
    }

    byte[] convTextToCSXString(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    void convCharArrToCSXString(char[] cArray, int n, int n2) {
        this.byteLen = 0;
        if (n2 < 4096 && this.byteBuf.length > 4096) {
            this.shrinkByteBuf();
        }
        char c = '\u0000';
        for (int i = n; i < n + n2; ++i) {
            c = cArray[i];
            if (c < '\u0080') {
                if (this.byteLen >= this.byteBuf.length) {
                    this.extendByteBuf(true);
                }
                this.byteBuf[this.byteLen] = (byte)c;
                ++this.byteLen;
                continue;
            }
            if (c < '\u0800') {
                if (this.byteLen + 1 >= this.byteBuf.length) {
                    this.extendByteBuf(true);
                }
                this.byteBuf[this.byteLen] = (byte)(0xC0 | c >> 6);
                this.byteBuf[this.byteLen + 1] = (byte)(0x80 | c & 0x3F);
                this.byteLen += 2;
                continue;
            }
            if (c < '\u10000') {
                if (this.byteLen + 2 >= this.byteBuf.length) {
                    this.extendByteBuf(true);
                }
                this.byteBuf[this.byteLen] = (byte)(0xE0 | c >> 12);
                this.byteBuf[this.byteLen + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                this.byteBuf[this.byteLen + 2] = (byte)(0x80 | c & 0x3F);
                this.byteLen += 3;
                continue;
            }
            if (this.byteLen + 3 >= this.byteBuf.length) {
                this.extendByteBuf(true);
            }
            this.byteBuf[this.byteLen] = (byte)(0xF0 | c >> 18);
            this.byteBuf[this.byteLen + 1] = (byte)(0x80 | c >> 12 & 0x3F);
            this.byteBuf[this.byteLen + 2] = (byte)(0x80 | c >> 6 & 0x3F);
            this.byteBuf[this.byteLen + 3] = (byte)(0x80 | c & 0x3F);
            this.byteLen += 4;
        }
    }

    void extendByteBuf(boolean bl) {
        byte[] byArray = new byte[this.byteBuf.length + 4096];
        if (bl) {
            System.arraycopy(this.byteBuf, 0, byArray, 0, this.byteLen);
        }
        this.byteBuf = byArray;
    }

    void shrinkByteBuf() {
        this.byteBuf = new byte[4096];
        this.byteLen = 0;
    }

    byte[] convTextToCSX(String string, int n, int n2, BinXMLProperty binXMLProperty) throws BinXMLException, IOException {
        byte[] byArray = null;
        block6 : switch (n2) {
            case 1: {
                return this.convTextToCSXString(string);
            }
            case 2: {
                switch (n) {
                    case 15: {
                        byArray = BinXMLUtil.convHexStringToBytes(string);
                        break block6;
                    }
                    case 16: {
                        byArray = BinXMLUtil.convBase64StringToBytes(string);
                        break block6;
                    }
                }
                throw new BinXMLException(this.err.getMessage0(35007));
            }
            case 3: {
                byArray = new byte[1];
                boolean bl = Boolean.parseBoolean(string);
                if (bl) {
                    byArray[0] = 1;
                    break;
                }
                byArray[0] = 0;
                break;
            }
            case 4: {
                try {
                    int n3;
                    string = string.trim();
                    if (string.startsWith("+")) {
                        string = string.substring(1, string.length());
                    }
                    if ((n3 = Integer.parseInt(string)) <= 127 && n3 >= -128) {
                        byArray = new byte[]{(byte)n3};
                        break;
                    }
                    if (n3 <= Short.MAX_VALUE && n3 >= Short.MIN_VALUE) {
                        byArray = new byte[2];
                        this.writer.copyInt2ToArray(n3, byArray, 0);
                        break;
                    }
                    byArray = new byte[4];
                    this.writer.copyInt4ToArray(n3, byArray, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        long l = Long.parseLong(string);
                        byArray = new byte[8];
                        this.writer.copyLong8ToArray(l, byArray, 0);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        BigInteger bigInteger = new BigInteger(string);
                        byArray = bigInteger.toByteArray();
                    }
                }
                break;
            }
            case 5: {
                try {
                    string = string.trim();
                    int n4 = Integer.parseInt(string);
                    if (n4 <= 255) {
                        byArray = new byte[]{(byte)n4};
                        break;
                    }
                    if (n4 <= 65535) {
                        byArray = new byte[2];
                        this.writer.copyInt2ToArray(n4, byArray, 0);
                        break;
                    }
                    byArray = new byte[4];
                    this.writer.copyInt4ToArray(n4, byArray, 0);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        long l = Long.parseLong(string);
                        byArray = new byte[8];
                        this.writer.copyLong8ToArray(l, byArray, 0);
                        break;
                    }
                    catch (NumberFormatException numberFormatException3) {
                        BigInteger bigInteger = new BigInteger(string);
                        int n5 = bigInteger.bitLength();
                        byte[] byArray2 = bigInteger.toByteArray();
                        byArray = new byte[n5 / 8];
                        for (int i = 1; i < byArray2.length; ++i) {
                            byArray[i - 1] = byArray2[i];
                        }
                        break;
                    }
                }
            }
            case 6: {
                int n6 = Float.floatToRawIntBits(Float.parseFloat(string));
                byArray = new byte[4];
                this.writer.copyInt4ToArray(n6, byArray, 0);
                break;
            }
            case 7: {
                int n7 = 0;
                if (string.trim().indexOf(46) >= 0) {
                    n7 = string.length() - 1 - string.indexOf(46);
                }
                try {
                    NUMBER nUMBER = new NUMBER(string, n7);
                    byArray = nUMBER.toBytes();
                }
                catch (SQLException sQLException) {
                    byArray = this.convTextToCSXString(string);
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (this.tokenManager.metaProvider == null || !(this.tokenManager.metaProvider instanceof DBBinXMLMetadataProviderImpl)) break;
                Connection connection = ((DBBinXMLMetadataProviderImpl)this.tokenManager.metaProvider).getConnection();
                try {
                    TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ(connection, string);
                    byArray = tIMESTAMPTZ.toBytes();
                    break;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            case 12: {
                int n8 = binXMLProperty.getEnumID(string.trim());
                if (n8 < 255) {
                    byArray = new byte[]{(byte)n8};
                    break;
                }
                byArray = new byte[2];
                this.writer.copyInt2ToArray(n8, byArray, 0);
                break;
            }
            case 13: {
                byArray = this.convTextToQName(string, binXMLProperty, this.secState);
                break;
            }
            case 14: {
                long l = Double.doubleToRawLongBits(Double.parseDouble(string));
                byArray = new byte[8];
                this.writer.copyLong8ToArray(l, byArray, 0);
                break;
            }
            case 22: {
                byArray = BinXMLUtil.convHexStringToBytes(string);
                break;
            }
            case 23: {
                byArray = BinXMLUtil.convBase64StringToBytes(string);
                break;
            }
            default: {
                throw new BinXMLException(this.err.getMessage0(35007));
            }
        }
        return byArray;
    }

    void setXMLVersion(String string) {
        this.xmlVersion = string;
    }

    void setXMLError(oracle.xml.util.XMLError xMLError) {
        this.err = xMLError;
    }

    void setStandalone(String string) {
        this.standalone = string;
    }

    void setEncoding(String string) {
        this.encoding = string;
    }

    private class myLong {
        long value;

        private myLong() {
        }

        void setValue(long l) {
            this.value = l;
        }

        public boolean equals(Object object) {
            if (object instanceof myLong) {
                return this.value == ((myLong)object).value;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.value;
        }
    }

    private class BinXMLSectionState {
        BinXMLStreamImpl binStream;
        Vector nsTokenIds;
        Vector prefixMap;
        short nextPfxId = (short)65;

        BinXMLSectionState(BinXMLStreamImpl binXMLStreamImpl) {
            this.binStream = binXMLStreamImpl;
        }

        void encodeSectionHeader() throws IOException {
            if (!BinXMLEncoderImpl.this.inlineTokenDefs) {
                this.nsTokenIds = new Vector(5);
            }
            byte by = 0;
            BinXMLEncoderImpl.this.writer.writeOpcode((short)159, 0);
            BinXMLEncoderImpl.this.writer.writeByte(1, 0);
            if (!BinXMLEncoderImpl.this.inlineTokenDefs) {
                by = (byte)(by | 1);
            }
            if (!BinXMLEncoderImpl.this.schemaAware) {
                by = (byte)(by | 2);
            }
            if (BinXMLEncoderImpl.this.binXMLProcessor.getGUID() != null) {
                by = (byte)(by | 4);
            }
            if (BinXMLEncoderImpl.this.docId != null) {
                by = (byte)(by | 8);
            }
            if (BinXMLEncoderImpl.this.standalone != null) {
                by = (byte)(by | 0x40);
                if (BinXMLEncoderImpl.this.standalone.equalsIgnoreCase("yes")) {
                    by = (byte)(by | 0x80);
                }
            }
            if (BinXMLEncoderImpl.this.encoding != null) {
                by = (byte)(by | 0x100);
            }
            by = (byte)(by | 0x40);
            if (BinXMLEncoderImpl.this.schemaLocationAware) {
                flagPosition = BinXMLEncoderImpl.this.writer.chunkmode ? BinXMLEncoderImpl.this.writer.tokdefpos : BinXMLEncoderImpl.this.writer.writePos;
            }
            BinXMLEncoderImpl.this.writer.writeByte(by, 0);
            if (BinXMLEncoderImpl.this.docId != null) {
                BinXMLEncoderImpl.this.writer.writeByte((byte)BinXMLEncoderImpl.this.docId.length, 0);
                BinXMLEncoderImpl.this.writer.writeByteArray(BinXMLEncoderImpl.this.docId, 0, BinXMLEncoderImpl.this.docId.length);
            }
            if (BinXMLEncoderImpl.this.binXMLProcessor.getGUID() != null) {
                BinXMLEncoderImpl.this.writer.writeByteArray(BinXMLEncoderImpl.this.binXMLProcessor.getGUID(), 0, BinXMLEncoderImpl.this.binXMLProcessor.getGUID().length);
            }
        }

        void encodeSectionEnd() throws IOException {
            BinXMLEncoderImpl.this.schemaLocationAware = false;
            if (BinXMLEncoderImpl.this.schemaAware) {
                BinXMLEncoderImpl.this.writer.writeOpcode((short)148, 2);
            }
            BinXMLEncoderImpl.this.writer.writeOpcode((short)160, 2);
            BinXMLEncoderImpl.this.writer.flushToStream();
        }

        boolean addNamespaceId(long l) {
            BinXMLEncoderImpl.this.key.setValue(l);
            if (!BinXMLEncoderImpl.this.inlineTokenDefs && !this.nsTokenIds.contains(BinXMLEncoderImpl.this.key)) {
                myLong myLong2 = new myLong();
                myLong2.setValue(l);
                this.nsTokenIds.add(myLong2);
                return true;
            }
            return false;
        }

        Enumeration getNamespaceIdEnnumeration() {
            return this.nsTokenIds.elements();
        }

        short getReservedPrefixId(String string, long l) {
            if (l > 6L) {
                return -1;
            }
            switch ((int)l) {
                case 1: {
                    if (!string.equals("xml")) break;
                    return 1;
                }
                case 2: {
                    if (!string.equals("xmlns")) break;
                    return 2;
                }
                case 3: {
                    if (!string.equals("xsi")) break;
                    return 3;
                }
                case 4: {
                    if (string.equals("xsd")) {
                        return 4;
                    }
                    if (!string.equals("xs")) break;
                    return 5;
                }
                case 5: {
                    if (!string.equals("csx")) break;
                    return 6;
                }
            }
            return -1;
        }

        short insertPrefix(String string, String string2) throws IOException, BinXMLException {
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            long l = string2 == null || string2.length() == 0 ? 7L : BinXMLEncoderImpl.this.tokenManager.getNamespaceTokenId(string2);
            short s = -1;
            for (n = BinXMLEncoderImpl.this.depth; n > 0; --n) {
                if (this.prefixMap != null) {
                    for (int i = this.prefixMap.size() - 1; i >= 0; --i) {
                        BinXMLPrefix binXMLPrefix = (BinXMLPrefix)this.prefixMap.elementAt(i);
                        if (binXMLPrefix.nspid != l) continue;
                        if (binXMLPrefix.pfx.equals(string)) {
                            bl = true;
                            s = binXMLPrefix.pfxid;
                            bl2 = binXMLPrefix.dup;
                            break;
                        }
                        bl2 = true;
                        binXMLPrefix.dup = true;
                    }
                    if (!bl) continue;
                    break;
                }
                this.prefixMap = new Vector();
            }
            if (bl) {
                return s;
            }
            BinXMLPrefix binXMLPrefix = new BinXMLPrefix();
            binXMLPrefix.pfx = string;
            binXMLPrefix.nsuri = string2;
            binXMLPrefix.nspid = l;
            binXMLPrefix.dup = bl2;
            binXMLPrefix.pfxid = this.getReservedPrefixId(string, l);
            if (binXMLPrefix.pfxid < 0) {
                short s2 = this.nextPfxId;
                this.nextPfxId = (short)(s2 + 1);
                binXMLPrefix.pfxid = s2;
            }
            if (binXMLPrefix.pfxid < 0) {
                throw new BinXMLException("Maximum number of namespace prefix exceeded");
            }
            this.prefixMap.add(binXMLPrefix);
            binXMLPrefix.writePrefixDef();
            return binXMLPrefix.pfxid;
        }

        short getPfxId(String string, long l, boolean bl) {
            int n;
            boolean bl2 = false;
            if (l >= 1L && l <= 5L && bl && (n = this.getReservedPrefixId(string, l)) > 0) {
                return (short)n;
            }
            if (l == 4L && string.equals("xsd")) {
                return 4;
            }
            if (l == 4L && string.equals("xs")) {
                return 5;
            }
            if (this.prefixMap == null) {
                return -1;
            }
            for (n = this.prefixMap.size() - 1; n >= 0; --n) {
                BinXMLPrefix binXMLPrefix = (BinXMLPrefix)this.prefixMap.elementAt(n);
                if (binXMLPrefix.nspid != l) continue;
                if (!binXMLPrefix.dup && !bl) {
                    return -1;
                }
                if (binXMLPrefix.pfx.equals(string)) {
                    return binXMLPrefix.pfxid;
                }
                bl2 = true;
            }
            return -1;
        }
    }

    private class BinXMLPrefix {
        String pfx;
        String nsuri;
        long nspid;
        short pfxid;
        boolean dup;

        private BinXMLPrefix() {
        }

        private void writePrefixDef() throws IOException {
            boolean bl = this.nspid <= 0xFFFFFFFFL;
            byte[] byArray = null;
            int n = 0;
            if (this.pfx != null) {
                byArray = this.pfx.getBytes("UTF-8");
                n = byArray.length;
            }
            BinXMLEncoderImpl.this.writer.writeOpcode(bl ? (short)178 : 179, 1);
            BinXMLEncoderImpl.this.writer.writeByte(n, 1);
            if (bl) {
                BinXMLEncoderImpl.this.writer.writeLong4(this.nspid, 1);
            } else {
                BinXMLEncoderImpl.this.writer.writeLong8(this.nspid, 1);
            }
            BinXMLEncoderImpl.this.writer.writeShort(this.pfxid, 1);
            if (n > 0) {
                BinXMLEncoderImpl.this.writer.writeByteArray(byArray, 1, n);
            }
        }
    }

    private class BinXMLEncBuffer {
        byte state = 1;
        long qnameid;
        boolean needpfxid;
        boolean arrayMode;
        short pfxid;
        byte flag;
        boolean needtypeid;
        int xsitypeid;
        char[] textdata = new char[4096];
        int textdatalen = 0;

        private BinXMLEncBuffer() {
        }

        void reset(long l, boolean bl, boolean bl2, short s, byte by, boolean bl3, int n) {
            this.state = (byte)2;
            this.qnameid = l;
            this.flag = by;
            this.needpfxid = bl;
            this.pfxid = s;
            this.arrayMode = bl2;
            this.needtypeid = bl3;
            this.xsitypeid = n;
            this.textdatalen = 0;
        }

        void extendTextDataBuf() {
            char[] cArray = new char[this.textdata.length + 4096];
            System.arraycopy(this.textdata, 0, cArray, 0, this.textdatalen);
            this.textdata = cArray;
        }

        void shrinkTextDataBuf() {
            this.textdata = new char[4096];
            this.textdatalen = 0;
        }

        void flush() throws IOException, BinXMLException {
            BinXMLElement binXMLElement = (BinXMLElement)BinXMLEncoderImpl.this.elementStack.peek();
            BinXMLProperty binXMLProperty = binXMLElement.prop;
            BinXMLElement binXMLElement2 = null;
            if (BinXMLEncoderImpl.this.depth > 1) {
                binXMLElement2 = (BinXMLElement)BinXMLEncoderImpl.this.elementStack.get(BinXMLEncoderImpl.this.depth - 2);
            }
            switch (this.state) {
                case 1: {
                    return;
                }
                case 2: 
                case 3: {
                    boolean bl = false;
                    if (this.arrayMode) {
                        BinXMLEncoderImpl.this.writeELMST();
                        bl = true;
                    } else if (binXMLElement2 != null && binXMLElement2.schemaSeqMode) {
                        short s = binXMLElement2.maxKidNum;
                        if (!(binXMLElement.any || binXMLProperty == null || binXMLElement.kidNum <= binXMLElement2.kidNum || binXMLElement.kidNum > s || this.needpfxid || this.needtypeid || binXMLElement.prop.isSubstitutionGroupMember())) {
                            for (int i = 1; i < binXMLElement.kidNum - binXMLElement2.kidNum; ++i) {
                                BinXMLEncoderImpl.this.writer.writeOpcode((short)144, 2);
                            }
                            BinXMLEncoderImpl.this.writeELMST();
                            bl = true;
                            binXMLElement2.kidNum = binXMLElement.kidNum;
                        } else {
                            BinXMLEncoderImpl.this.writer.writeOpcode((short)218, 2);
                        }
                    }
                    if (!bl) {
                        if (binXMLProperty != null && BinXMLEncoderImpl.this.depth != 1 && !binXMLElement.any && !binXMLProperty.isSubstitutionGroupMember()) {
                            BinXMLEncoderImpl.this.writeNodeStartKidnum(BinXMLEncoderImpl.this.currentElem.kidNum, this.flag, this.needpfxid, this.pfxid, this.needtypeid, this.xsitypeid);
                        } else {
                            BinXMLEncoderImpl.this.writeElementAttrStart(this.qnameid, this.needpfxid, this.flag, this.pfxid, this.needtypeid, this.xsitypeid);
                        }
                    }
                    if (this.state != 3) break;
                    if (!BinXMLEncoderImpl.this.schemaAware) {
                        if (BinXMLUtil.isPureWhiteSpace(this.textdata, 0, this.textdatalen)) {
                            BinXMLEncoderImpl.this.writeWhiteSpace(this.textdata, 0, this.textdatalen);
                        } else {
                            BinXMLEncoderImpl.this.writeText(this.textdata, 0, this.textdatalen);
                        }
                    } else if (BinXMLUtil.isPureWhiteSpace(this.textdata, 0, this.textdatalen)) {
                        BinXMLEncoderImpl.this.writeWhiteSpace(this.textdata, 0, this.textdatalen);
                    } else {
                        BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2 != null ? binXMLElement2.prop : null, binXMLProperty, BinXMLEncoderImpl.this.currentElem.kidNum, this.textdata, 0, this.textdatalen, (byte)3);
                    }
                    this.textdatalen = 0;
                    break;
                }
                case 4: {
                    if (this.arrayMode) {
                        BinXMLEncoderImpl.this.writeSimpleNode(0L, null, null, (short)0, this.textdata, 0, this.textdatalen, (byte)2);
                        break;
                    }
                    if (binXMLElement2 != null && binXMLElement2.schemaSeqMode) {
                        short s = binXMLElement2.maxKidNum;
                        if (!(binXMLElement.any || binXMLElement.prop == null || binXMLElement.kidNum <= binXMLElement2.kidNum || binXMLElement.kidNum > s || this.needpfxid || this.needtypeid || binXMLElement.prop.isSubstitutionGroupMember())) {
                            for (int i = 1; i < binXMLElement.kidNum - binXMLElement2.kidNum; ++i) {
                                BinXMLEncoderImpl.this.writer.writeOpcode((short)144, 2);
                            }
                            BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2.prop, binXMLElement.prop, binXMLElement.kidNum, this.textdata, 0, this.textdatalen, (byte)5);
                            binXMLElement2.kidNum = binXMLElement.kidNum;
                            break;
                        }
                        BinXMLEncoderImpl.this.writer.writeOpcode((short)218, 2);
                        if (binXMLElement.prop != null && BinXMLEncoderImpl.this.depth != 1 && !binXMLElement.any && !binXMLElement.prop.isSubstitutionGroupMember()) {
                            BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2.prop, binXMLElement.prop, binXMLElement.kidNum, this.textdata, 0, this.textdatalen, (byte)4);
                        } else {
                            BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, null, null, (short)0, this.textdata, 0, this.textdatalen, (byte)1);
                        }
                        this.textdatalen = 0;
                        break;
                    }
                    if (this.qnameid != 0L && binXMLElement2 != null && binXMLElement2.prop != null && binXMLElement != null && binXMLElement.prop != null && binXMLElement.kidNum > 0) {
                        BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2.prop, binXMLElement.prop, binXMLElement.kidNum, this.textdata, 0, this.textdatalen, (byte)4);
                        break;
                    }
                    BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, null, null, (short)0, this.textdata, 0, this.textdatalen, (byte)1);
                }
            }
            this.state = 1;
        }
    }

    private class BinXMLElement {
        long qnameId;
        BinXMLSchema binSchema;
        BinXMLProperty prop;
        int propId;
        boolean any;
        boolean arrayMode = false;
        boolean firstChild = true;
        long prevChildQnameId;
        BinXMLProperty prevChildProp;
        byte prevChildFlag;
        short prevChildPfxId;
        int prevChildTypeId;
        boolean schemaSeqMode = false;
        short kidNum = 0;
        short maxKidNum;

        void reset() {
            this.arrayMode = false;
            this.firstChild = true;
            this.schemaSeqMode = false;
            this.kidNum = 0;
            this.maxKidNum = 0;
            this.qnameId = 0L;
            this.binSchema = null;
            this.prop = null;
            this.propId = 0;
            this.any = false;
            this.prevChildQnameId = 0L;
            this.prevChildProp = null;
            this.prevChildFlag = 0;
            this.prevChildPfxId = 0;
            this.prevChildTypeId = 0;
        }
    }

    private class BinXMLPageWriter {
        boolean chunkmode = false;
        int chunk_size = 4096;
        int doc_plus_strtsec_size = 7;
        int boundary = this.chunk_size - 6;
        int tokdefpos = 0;
        int noddatpos = 0;
        int pfxdefpos = 0;
        byte[] buffer;
        byte[] tokdefbuf;
        byte[] noddatbuf;
        byte[] pfxdefbuf;
        byte[] chunkHeader;
        boolean chunkrefflag = false;
        short lastopcode = (short)-1;
        int lasttokdefpos = 0;
        int lastnoddatpos = 0;
        int lastpfxdefpos = 0;
        long biglength = 0L;
        int defordat = 0;
        int lastLength = 0;
        int lastOpcodeCount = 0;
        byte[] buf;
        BinXMLStreamImpl bstream;
        int writePos;

        BinXMLPageWriter(byte[] byArray, BinXMLStreamImpl binXMLStreamImpl) {
            this.buf = byArray;
            this.bstream = binXMLStreamImpl;
            this.writePos = 0;
        }

        void chunk_init() {
            if (this.chunkmode) {
                this.buffer = new byte[this.chunk_size];
                this.tokdefbuf = new byte[this.chunk_size];
                this.noddatbuf = new byte[this.chunk_size];
                this.pfxdefbuf = new byte[this.chunk_size];
                this.chunkHeader = new byte[6];
                this.tokdefpos = 0;
                this.noddatpos = 0;
                this.chunkrefflag = false;
                this.lastopcode = (short)-1;
                this.lasttokdefpos = 0;
                this.lastnoddatpos = 0;
                this.defordat = 0;
                this.lastOpcodeCount = 0;
            }
        }

        void setChunkMode(boolean bl) {
            this.chunkmode = bl;
            if (this.chunkmode) {
                this.chunk_init();
            }
        }

        void setChunkBufSize(int n) {
            if (n >= 4096) {
                this.chunk_size = n;
            }
        }

        void setBigLength(long l) {
            this.biglength = l;
        }

        void flushToStream() throws IOException {
            if (this.chunkmode) {
                this.flushInChunkMode();
            } else {
                this.flushWriter(this.writePos);
            }
        }

        void flushByte(byte by, int n) throws IOException {
            if (this.chunkmode) {
                if (this.tokdefpos + this.noddatpos + this.pfxdefpos == this.boundary) {
                    if (this.lasttokdefpos != 0 || this.lastnoddatpos != 0 || this.lastpfxdefpos != 0) {
                        this.flushInChunkMode();
                        this.defordat = n;
                        this.lastnoddatpos = 0;
                        this.lasttokdefpos = 0;
                        this.lastpfxdefpos = 0;
                    }
                } else if (this.lastOpcodeCount != BinXMLEncoderImpl.this.opcodeCount && this.tokdefpos + this.noddatpos + this.pfxdefpos > this.boundary && (this.lastnoddatpos == 0 || this.lastnoddatpos == this.noddatpos) && n == 2) {
                    this.flushBytes(this.noddatbuf, 0, this.noddatpos);
                    this.noddatpos = 0;
                    this.noddatbuf = new byte[this.chunk_size];
                    this.lastnoddatpos = 0;
                }
                if (this.noddatpos != 0 && this.noddatpos % this.chunk_size == 0) {
                    this.extendNodBuffers();
                }
                if (n == 0) {
                    this.tokdefbuf[this.tokdefpos++] = by;
                } else if (n == 1) {
                    this.pfxdefbuf[this.pfxdefpos++] = by;
                } else {
                    this.noddatbuf[this.noddatpos++] = by;
                }
            } else {
                if (this.writePos != 0 && this.writePos % BinaryStream.BUFSIZE == 0) {
                    this.flushWriter(0);
                }
                this.buf[this.writePos++] = by;
            }
            this.lastOpcodeCount = BinXMLEncoderImpl.this.opcodeCount;
        }

        private void extendNodBuffers() {
            byte[] byArray = new byte[this.noddatbuf.length + BinaryStream.BUFSIZE];
            System.arraycopy(this.noddatbuf, 0, byArray, 0, this.noddatbuf.length);
            this.noddatbuf = byArray;
            if (this.buf.length < this.noddatbuf.length) {
                this.extendBuffers();
            }
        }

        private void flushBytes(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n2 - n;
            System.arraycopy(byArray, n, this.buf, this.lastLength, n3);
            this.lastLength += n3;
            this.flushWriter(this.lastLength);
        }

        private void flushInChunkMode() throws IOException {
            if (this.lastopcode == 160 && this.noddatpos - this.lastnoddatpos == 1 && this.noddatpos + this.tokdefpos + this.pfxdefpos <= this.boundary) {
                this.lastnoddatpos = this.noddatpos;
                this.lasttokdefpos = this.tokdefpos;
                this.lastpfxdefpos = this.pfxdefpos;
            }
            int n = this.lasttokdefpos + this.lastnoddatpos + this.lastpfxdefpos;
            if (!this.chunkrefflag) {
                this.chunkrefflag = true;
                this.doc_plus_strtsec_size += schemaScopeLength;
                this.writeChunkHeader(n -= this.doc_plus_strtsec_size);
                System.arraycopy(this.tokdefbuf, 0, this.buffer, 0, this.doc_plus_strtsec_size);
                System.arraycopy(this.chunkHeader, 0, this.buffer, this.doc_plus_strtsec_size, 6);
                System.arraycopy(this.tokdefbuf, this.doc_plus_strtsec_size, this.buffer, this.doc_plus_strtsec_size + 6, this.lasttokdefpos - this.doc_plus_strtsec_size);
                System.arraycopy(this.pfxdefbuf, 0, this.buffer, 6 + this.lasttokdefpos, this.lastpfxdefpos);
                System.arraycopy(this.noddatbuf, 0, this.buffer, 6 + this.lasttokdefpos + this.lastpfxdefpos, this.lastnoddatpos);
                this.flushBytes(this.buffer, 0, 6 + this.lasttokdefpos + this.lastnoddatpos + this.lastpfxdefpos);
                this.noddatpos -= this.lastnoddatpos;
                this.tokdefpos -= this.lasttokdefpos;
                this.pfxdefpos -= this.lastpfxdefpos;
                this.chunkrefflag = true;
            } else {
                this.writeChunkHeader(n);
                System.arraycopy(this.chunkHeader, 0, this.buffer, 0, 6);
                System.arraycopy(this.tokdefbuf, 0, this.buffer, 6, this.lasttokdefpos);
                System.arraycopy(this.pfxdefbuf, 0, this.buffer, 6 + this.lasttokdefpos, this.lastpfxdefpos);
                System.arraycopy(this.noddatbuf, 0, this.buffer, 6 + this.lasttokdefpos + this.lastpfxdefpos, this.lastnoddatpos);
                this.flushBytes(this.buffer, 0, 6 + this.lasttokdefpos + this.lastnoddatpos + this.lastpfxdefpos);
                this.noddatpos -= this.lastnoddatpos;
                this.tokdefpos -= this.lasttokdefpos;
                this.pfxdefpos -= this.lastpfxdefpos;
            }
            if (this.noddatpos > 0) {
                this.noddatbuf = this.collectRemainingData(this.lastnoddatpos, this.noddatpos, this.noddatbuf);
            }
            if (this.tokdefpos > 0) {
                this.tokdefbuf = this.collectRemainingData(this.lasttokdefpos, this.tokdefpos, this.tokdefbuf);
            }
            if (this.pfxdefpos > 0) {
                this.pfxdefbuf = this.collectRemainingData(this.lastpfxdefpos, this.pfxdefpos, this.pfxdefbuf);
            }
            if (this.lastopcode == 160 && this.noddatpos == 1) {
                this.flushBytes(this.noddatbuf, 0, 1);
            }
        }

        private byte[] collectRemainingData(int n, int n2, byte[] byArray) {
            byte[] byArray2 = new byte[this.chunk_size];
            int n3 = 0;
            for (int i = n; i < n + n2; ++i) {
                byArray2[n3++] = byArray[i];
            }
            return byArray2;
        }

        private void writeChunkHeader(int n) throws IOException {
            int n2 = 0;
            this.chunkHeader[n2++] = -95;
            byte by = this.chunkrefflag ? (byte)1 : 0;
            this.chunkHeader[n2++] = by;
            byte by2 = (byte)(n >>> 24 & 0xFF);
            byte by3 = (byte)(n >>> 16 & 0xFF);
            byte by4 = (byte)(n >>> 8 & 0xFF);
            byte by5 = (byte)(n >>> 0 & 0xFF);
            this.chunkHeader[n2++] = by2;
            this.chunkHeader[n2++] = by3;
            this.chunkHeader[n2++] = by4;
            this.chunkHeader[n2++] = by5;
        }

        private void extendBuffers() {
            byte[] byArray = new byte[this.buf.length + BinaryStream.BUFSIZE];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
            BinXMLEncoderImpl.this.notExtended = false;
        }

        private void flushWriter(int n) throws IOException {
            if (BinXMLEncoderImpl.this.schemaLocationAware) {
                this.extendBuffers();
            } else if (n == 0 || n > BinaryStream.BUFSIZE) {
                byte[] byArray = this.buf;
                int n2 = 0;
                int n3 = 0;
                if (n == 0) {
                    n2 = this.buf.length / BinaryStream.BUFSIZE;
                    n3 = byArray.length;
                } else {
                    n2 = (int)Math.ceil((double)n / (double)BinaryStream.BUFSIZE);
                    n3 = n;
                }
                this.buf = BinXMLEncoderImpl.this.binStream.getWriteBuffer();
                for (int i = 0; i < n2; ++i) {
                    if (i == 0) {
                        System.arraycopy(byArray, 0, this.buf, 0, BinaryStream.BUFSIZE);
                        n3 -= BinaryStream.BUFSIZE;
                        this.bstream.flushWriBuffer();
                        continue;
                    }
                    if (n3 < BinaryStream.BUFSIZE) {
                        System.arraycopy(byArray, BinaryStream.BUFSIZE * i, this.buf, 0, n3);
                        this.bstream.flushWriBuffer(n3);
                        continue;
                    }
                    System.arraycopy(byArray, BinaryStream.BUFSIZE * i, this.buf, 0, BinaryStream.BUFSIZE);
                    n3 -= BinaryStream.BUFSIZE;
                    this.bstream.flushWriBuffer();
                }
                this.writePos = 0;
                this.lastLength = 0;
            } else {
                this.bstream.flushWriBuffer(n);
                this.lastLength = 0;
            }
        }

        void writeByte(int n, int n2) throws IOException {
            this.flushByte((byte)(n & 0xFF), n2);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + n);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeBoolean(boolean bl, int n) throws IOException {
            this.flushByte((byte)(bl ? 1 : 0), n);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + bl);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeShort(int n, int n2) throws IOException {
            this.flushByte((byte)(n >>> 8 & 0xFF), n2);
            this.flushByte((byte)(n >>> 0 & 0xFF), n2);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + n);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeOpcode(short s, int n) throws IOException {
            ++BinXMLEncoderImpl.this.opcodeCount;
            boolean bl = false;
            if (this.lastopcode == 254) {
                bl = true;
            }
            this.lastopcode = s;
            this.lasttokdefpos = this.tokdefpos;
            this.lastnoddatpos = this.noddatpos;
            this.lastpfxdefpos = this.pfxdefpos;
            if (s < 255) {
                this.flushByte((byte)s, n);
            } else {
                this.flushByte((byte)(s >>> 8 & 0xFF), n);
                this.flushByte((byte)(s >>> 0 & 0xFF), n);
            }
            BinXMLOpcode binXMLOpcode = null;
            binXMLOpcode = bl ? BinXMLFormat.extendedOpcodes[s] : (s == 254 ? BinXMLFormat.opcodes[s - 12] : BinXMLFormat.opcodes[s]);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.print(n);
                BinXMLEncoderImpl.this.debugWriter.print(' ');
                BinXMLEncoderImpl.this.debugWriter.println(binXMLOpcode.name);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeByteArray(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                return;
            }
            for (int i = 0; i < n2; ++i) {
                this.flushByte(byArray[i], n);
            }
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + new String(byArray));
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeInt(int n, int n2) throws IOException {
            this.flushByte((byte)(n >>> 24 & 0xFF), n2);
            this.flushByte((byte)(n >>> 16 & 0xFF), n2);
            this.flushByte((byte)(n >>> 8 & 0xFF), n2);
            this.flushByte((byte)(n >>> 0 & 0xFF), n2);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + n);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeLong4(long l, int n) throws IOException {
            byte[] byArray = new byte[4];
            this.copyLong4ToArray(l, byArray, 0);
            this.writeByteArray(byArray, n, 4);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + l);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeLong8(long l, int n) throws IOException {
            byte[] byArray = new byte[8];
            this.copyLong8ToArray(l, byArray, 0);
            this.writeByteArray(byArray, n, 8);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + l);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void copyByteArray(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
            while (n2 > 0) {
                byArray2[n3++] = byArray[n++];
                --n2;
            }
        }

        void copyInt2ToArray(int n, byte[] byArray, int n2) {
            byArray[n2 + 1] = (byte)(n & 0xFF);
            byArray[n2] = (byte)((n >>= 8) & 0xFF);
        }

        void copyInt4ToArray(int n, byte[] byArray, int n2) {
            n2 += 3;
            byArray[n2--] = (byte)(n & 0xFF);
            byArray[n2--] = (byte)((n >>= 8) & 0xFF);
            byArray[n2--] = (byte)((n >>= 8) & 0xFF);
            byArray[n2] = (byte)((n >>= 8) & 0xFF);
        }

        void copyLong4ToArray(long l, byte[] byArray, int n) {
            n += 3;
            byArray[n--] = (byte)(l & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n] = (byte)((l >>= 8) & 0xFFL);
        }

        void copyLong8ToArray(long l, byte[] byArray, int n) {
            n += 7;
            byArray[n--] = (byte)(l & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n] = (byte)((l >>= 8) & 0xFFL);
        }
    }
}

