/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnalyzerContext;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.util.FastVector;
import oracle.xml.util.QxName;

public class XMLSchema
extends XSDNode {
    private HashMap schemaNodeTable;
    private HashSet<String> tableNames;
    private HashMap schemas;
    private HashMap notationTable;
    private String schemaNS;
    private BuildState bstate;
    private HashSet<XMLSchema> schemaSet;
    String schemaTargetNS;
    XSDBuilder builder;
    int annoFlag;

    public XMLSchema() throws XSDException {
        this.init(100);
    }

    XMLSchema(int n) throws XSDException {
        this.init(n);
    }

    XMLSchema(XMLSchema xMLSchema) {
        this.schemaNodeTable = xMLSchema.schemaNodeTable;
        this.tableNames = xMLSchema.tableNames;
        this.schemas = xMLSchema.schemas;
        this.notationTable = xMLSchema.notationTable;
        this.schemaNS = xMLSchema.schemaNS;
        this.bstate = xMLSchema.bstate;
        this.schemaTargetNS = xMLSchema.schemaTargetNS;
        this.builder = xMLSchema.builder;
        this.annoFlag = xMLSchema.annoFlag;
        this.schemaSet = xMLSchema.schemaSet;
        this.schemaSet.add(this);
    }

    boolean isSameSchemaSet(XMLSchema xMLSchema) {
        return this.schemaSet.contains(xMLSchema);
    }

    public String[] getXMLSchemaURLS() {
        String[] stringArray = new String[this.schemas.size()];
        int n = 0;
        for (String string : this.schemas.keySet()) {
            if (string.indexOf(" ") >= 0) continue;
            stringArray[n++] = string;
        }
        if (n < stringArray.length) {
            String[] stringArray2 = stringArray;
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
        }
        return stringArray;
    }

    public Hashtable getXMLSchemaNodeTable() {
        return new Hashtable(this.schemaNodeTable);
    }

    String getSchemaNS() {
        return this.schemaNS;
    }

    String newTableName(String string) {
        if (this.tableNames == null) {
            this.tableNames = new HashSet();
        }
        if (string.length() > 20) {
            string = string.substring(0, 20);
        }
        int n = 0;
        String string2 = string;
        while (this.tableNames.contains(string2)) {
            string2 = string + ++n;
        }
        this.tableNames.add(string2);
        return string2;
    }

    boolean isNewSchemaNS(String string, String string2) {
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        if ((string3 = (String)this.schemas.get(string)) != null) {
            if (string3.equals(string2)) {
                return false;
            }
            String string4 = string + " " + string2;
            if (this.schemas.get(string4) != null) {
                return false;
            }
            this.schemas.put(string4, string2);
            return true;
        }
        this.schemas.put(string, string2);
        return true;
    }

    public XMLSchemaNode getSchemaByTargetNS(String string) {
        if (string == null) {
            string = "";
        }
        return (XMLSchemaNode)this.schemaNodeTable.get(string);
    }

    boolean setXMLSchemaNode(String string, XMLSchemaNode xMLSchemaNode) {
        xMLSchemaNode.setTargetNS(string);
        xMLSchemaNode.parent = this;
        return this.schemaNodeTable.put(string, xMLSchemaNode) != null;
    }

    void mergeXMLSchemaNode(String string, XMLSchemaNode xMLSchemaNode) throws XSDException {
        XMLSchemaNode xMLSchemaNode2 = (XMLSchemaNode)this.schemaNodeTable.get(string);
        if (xMLSchemaNode2 == null) {
            xMLSchemaNode2 = new XMLSchemaNode();
            xMLSchemaNode2.setTargetNS(string);
            xMLSchemaNode2.parent = this;
            this.schemaNodeTable.put(string, xMLSchemaNode2);
        }
        xMLSchemaNode2.mergeSchemaNode(xMLSchemaNode);
    }

    void setSchemaNS(String string) {
        this.schemaNS = string;
    }

    XSDNode getComponent(String string, String string2, int n) {
        XMLSchemaNode xMLSchemaNode = this.getSchemaByTargetNS(string);
        if (xMLSchemaNode == null) {
            return null;
        }
        return xMLSchemaNode.getComponent(string2, n);
    }

    public XSDNode getType(String string, String string2, int n) {
        XMLSchemaNode xMLSchemaNode;
        if (string.equals(this.schemaNS)) {
            if (string2.intern() == "anyType") {
                return XSDComplexType.urType;
            }
            if (string2.intern() == "anySimpleType") {
                return XSDSimpleType.urType;
            }
        }
        if ((xMLSchemaNode = this.getSchemaByTargetNS(string)) == null) {
            return null;
        }
        return xMLSchemaNode.getType(string2, n);
    }

    public XSDNode getType(String string, String string2) {
        XMLSchemaNode xMLSchemaNode;
        if (string.intern() == this.schemaNS) {
            if (string2.intern() == "anyType") {
                return XSDComplexType.urType;
            }
            if (string2.intern() == "anySimpleType") {
                return XSDSimpleType.urType;
            }
        }
        if ((xMLSchemaNode = this.getSchemaByTargetNS(string)) == null) {
            return null;
        }
        return xMLSchemaNode.getType(string2);
    }

    public XSDElement getElement(String string, String string2) {
        XMLSchemaNode xMLSchemaNode = this.getSchemaByTargetNS(string);
        if (xMLSchemaNode == null) {
            return null;
        }
        return xMLSchemaNode.getElement(string2);
    }

    public XSDAttribute getAttribute(String string, String string2) {
        XMLSchemaNode xMLSchemaNode = this.getSchemaByTargetNS(string);
        if (xMLSchemaNode == null) {
            return null;
        }
        return xMLSchemaNode.getAttribute(string2);
    }

    void mergeXMLSchema(XMLSchema xMLSchema) throws XSDException {
        for (XMLSchemaNode xMLSchemaNode : xMLSchema.getXMLSchemaNodeTable().values()) {
            this.mergeXMLSchemaNode(xMLSchemaNode.getTargetNS(), xMLSchemaNode);
        }
        this.schemas.putAll(xMLSchema.schemas);
    }

    public void printSchema() {
        for (XMLSchemaNode xMLSchemaNode : this.schemaNodeTable.values()) {
            if (xMLSchemaNode.getTargetNS() == "http://www.w3.org/2001/XMLSchema") continue;
            xMLSchemaNode.print();
        }
    }

    public void printSchema(boolean bl) {
        if (bl) {
            for (XMLSchemaNode xMLSchemaNode : this.schemaNodeTable.values()) {
                xMLSchemaNode.print();
            }
        } else {
            this.printSchema();
        }
    }

    public String[] getAllTargetNS() {
        int n = 0;
        String[] stringArray = new String[this.schemaNodeTable.size()];
        Iterator iterator = this.schemaNodeTable.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public String getSchemaTargetNS() {
        return this.schemaTargetNS;
    }

    void postProcessSchema() throws Exception {
        FastVector fastVector = new FastVector();
        Hashtable hashtable = new Hashtable();
        Iterator iterator = this.schemaNodeTable.values().iterator();
        while (iterator.hasNext()) {
            ((XMLSchemaNode)iterator.next()).postProcessSchema(fastVector, hashtable, this);
        }
        this.bstate.isPathTableBuilt = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void buildSchemaPathTable() throws Exception {
        BuildState buildState = this.bstate;
        synchronized (buildState) {
            if (this.bstate.isPathTableBuilt) {
                return;
            }
            for (XMLSchemaNode xMLSchemaNode : this.schemaNodeTable.values()) {
                xMLSchemaNode.buildSchemaPathTable();
            }
            this.bstate.isPathTableBuilt = true;
        }
    }

    void calculateSQLTableSize(XSDAnalyzerContext xSDAnalyzerContext) throws Exception {
        XMLSchemaNode xMLSchemaNode;
        boolean bl;
        if (!this.bstate.isPathTableBuilt) {
            this.buildSchemaPathTable();
        }
        this.annoFlag = xSDAnalyzerContext.annotationFlag;
        String string = xSDAnalyzerContext.topSchemaNS;
        boolean bl2 = bl = (this.annoFlag & 1) == 1;
        if (bl) {
            xMLSchemaNode = (XMLSchemaNode)this.schemaNodeTable.get(string);
            xMLSchemaNode.calculateSQLTableSize(xSDAnalyzerContext);
        }
        for (String string2 : this.schemaNodeTable.keySet()) {
            xMLSchemaNode = (XMLSchemaNode)this.schemaNodeTable.get(string2);
            if (!bl) {
                xMLSchemaNode.calculateSQLTableSize(xSDAnalyzerContext);
                continue;
            }
            if (string.equals(string2) || string.equals("http://www.w3.org/2001/XMLSchema")) continue;
            xMLSchemaNode.pruneElements(xSDAnalyzerContext);
        }
    }

    boolean isPathTableBuilt() {
        return this.bstate.isPathTableBuilt;
    }

    void setBuilder(XSDBuilder xSDBuilder) {
        this.builder = xSDBuilder;
    }

    XSDBuilder getBuilder() {
        return this.builder;
    }

    void addNotationValue(QxName qxName) {
        if (this.notationTable == null) {
            this.notationTable = new HashMap(20);
        }
        this.notationTable.put(qxName, qxName);
    }

    QxName checkNotation() {
        if (this.notationTable == null) {
            return null;
        }
        for (QxName qxName : this.notationTable.keySet()) {
            XMLSchemaNode xMLSchemaNode;
            String string = qxName.getNamespaceURI();
            if (string == null) {
                string = "";
            }
            if ((xMLSchemaNode = (XMLSchemaNode)this.schemaNodeTable.get(string)) != null && xMLSchemaNode.getComponent(qxName.getLocalPart(), 25) != null) continue;
            return qxName;
        }
        return null;
    }

    private void init(int n) throws XSDException {
        this.schemaNodeTable = new HashMap(n);
        this.schemas = new HashMap(n);
        HashMap hashMap = XSDSimpleType.getBuiltInDatatypesAsHashMap();
        XMLSchemaNode xMLSchemaNode = new XMLSchemaNode(50);
        this.setXMLSchemaNode("http://www.w3.org/2001/XMLSchema", xMLSchemaNode);
        xMLSchemaNode.typeDefinitionSet.putAll(hashMap);
        this.bstate = new BuildState();
        XSDComplexType.init();
        this.schemaSet = new HashSet();
        this.schemaSet.add(this);
    }

    static class BuildState {
        boolean isPathTableBuilt = false;

        BuildState() {
        }
    }
}

