/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAnalyzerContext;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDNotation;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.util.FastVector;

public class XMLSchemaNode
extends XSDNode {
    HashMap typeDefinitionSet;
    HashMap elemSet;
    HashMap groupSet;
    HashMap attributeSet;
    HashMap attrGroupSet;
    HashMap notationSet;
    String schemaLocation;

    public XMLSchemaNode() {
        this.init(10);
    }

    XMLSchemaNode(int n) {
        this.init(n);
    }

    void postProcessSchema(FastVector fastVector, Hashtable hashtable, XMLSchema xMLSchema) throws Exception {
        Iterator iterator = this.elemSet.values().iterator();
        while (iterator.hasNext()) {
            ((XSDElement)iterator.next()).postProcess(fastVector, hashtable, xMLSchema);
        }
        for (XSDNode xSDNode : this.typeDefinitionSet.values()) {
            if (xSDNode instanceof XSDComplexType) {
                ((XSDComplexType)xSDNode).postProcess(fastVector, hashtable, xMLSchema);
                continue;
            }
            ((XSDSimpleType)xSDNode).parseDerivation(xMLSchema);
        }
        while (fastVector.size() > 0) {
            XSDNode xSDNode;
            xSDNode = ((XSDElement)fastVector.popElement()).getType();
            if (!(xSDNode instanceof XSDComplexType)) continue;
            ((XSDComplexType)xSDNode).postProcess(fastVector, hashtable, xMLSchema);
        }
    }

    void buildSchemaPathTable() throws Exception {
        Iterator iterator = this.elemSet.values().iterator();
        while (iterator.hasNext()) {
            ((XSDElement)iterator.next()).buildPathTable(null, null, 0);
        }
        for (XSDNode xSDNode : this.typeDefinitionSet.values()) {
            if (!(xSDNode instanceof XSDComplexType)) continue;
            ((XSDComplexType)xSDNode).getGroup().buildPathTable(null, null, 0);
        }
    }

    void mergeSchemaNode(XMLSchemaNode xMLSchemaNode) throws XSDException {
        XSDNode xSDNode;
        XSDNode xSDNode2;
        for (String string : xMLSchemaNode.elemSet.keySet()) {
            xSDNode2 = (XSDNode)xMLSchemaNode.elemSet.get(string);
            xSDNode = (XSDNode)this.elemSet.get(string);
            if (xSDNode != null) {
                if (xSDNode2 == xSDNode) continue;
                throw new XSDException(xSDNode.getName());
            }
            this.elemSet.put(string, xSDNode2);
        }
        for (String string : xMLSchemaNode.typeDefinitionSet.keySet()) {
            xSDNode2 = (XSDNode)xMLSchemaNode.typeDefinitionSet.get(string);
            xSDNode = (XSDNode)this.typeDefinitionSet.get(string);
            if (xSDNode != null) {
                if (xSDNode2 == xSDNode) continue;
                throw new XSDException(xSDNode.getName());
            }
            this.typeDefinitionSet.put(string, xSDNode2);
        }
        for (String string : xMLSchemaNode.attributeSet.keySet()) {
            xSDNode2 = (XSDNode)xMLSchemaNode.attributeSet.get(string);
            xSDNode = (XSDNode)this.attributeSet.get(string);
            if (xSDNode != null) {
                if (xSDNode2 == xSDNode) continue;
                throw new XSDException(xSDNode.getName());
            }
            this.attributeSet.put(string, xSDNode2);
        }
        for (String string : xMLSchemaNode.groupSet.keySet()) {
            xSDNode2 = (XSDNode)xMLSchemaNode.groupSet.get(string);
            xSDNode = (XSDNode)this.groupSet.get(string);
            if (xSDNode != null) {
                if (xSDNode2 == xSDNode) continue;
                throw new XSDException(xSDNode.getName());
            }
            this.groupSet.put(string, xSDNode2);
        }
        for (String string : xMLSchemaNode.attrGroupSet.keySet()) {
            xSDNode2 = (XSDNode)xMLSchemaNode.attrGroupSet.get(string);
            xSDNode = (XSDNode)this.attrGroupSet.get(string);
            if (xSDNode != null) {
                if (xSDNode2 == xSDNode) continue;
                throw new XSDException(xSDNode.getName());
            }
            this.attrGroupSet.put(string, xSDNode2);
        }
        for (String string : xMLSchemaNode.notationSet.keySet()) {
            xSDNode2 = (XSDNode)xMLSchemaNode.notationSet.get(string);
            xSDNode = (XSDNode)this.notationSet.get(string);
            if (xSDNode != null) {
                if (xSDNode2 == xSDNode) continue;
                throw new XSDException(xSDNode.getName());
            }
            this.notationSet.put(string, xSDNode2);
        }
    }

    void calculateSQLTableSize(XSDAnalyzerContext xSDAnalyzerContext) {
        int n = xSDAnalyzerContext.tableSize;
        for (XSDNode xSDNode : this.elemSet.values()) {
            XMLElement xMLElement = ((XSDElement)xSDNode).domNode;
            int n2 = ((XSDElement)xSDNode).getSQLTableSize(n);
            ++xSDAnalyzerContext.totalElements;
        }
        for (XSDNode xSDNode : this.typeDefinitionSet.values()) {
            int n3 = xSDNode.getSQLTableSize(n);
            if (!(xSDNode instanceof XSDComplexType)) continue;
            ++xSDAnalyzerContext.totalTypes;
        }
    }

    void pruneElements(XSDAnalyzerContext xSDAnalyzerContext) {
        XMLNode xMLNode;
        XMLNode xMLNode2;
        XMLElement xMLElement;
        for (XSDNode xSDNode : this.elemSet.values()) {
            ++xSDAnalyzerContext.totalElements;
            if (xSDNode.inUsed) continue;
            xMLElement = xSDNode.domNode;
            xMLNode2 = (XMLNode)xMLElement.getPreviousSibling();
            xMLNode = (XMLNode)xMLElement.getParentNode();
            xMLNode.removeChild(xMLElement);
            if (xMLNode2 != null && xMLNode2 instanceof XMLText) {
                xMLNode.removeChild(xMLNode2);
            }
            ++xSDAnalyzerContext.removedElements;
        }
        for (XSDNode xSDNode : this.typeDefinitionSet.values()) {
            xMLElement = xSDNode.domNode;
            if (xSDNode instanceof XSDComplexType) {
                ++xSDAnalyzerContext.totalTypes;
            }
            if (xSDNode.inUsed || xMLElement == null || !(xSDNode instanceof XSDComplexType)) continue;
            while (!xMLElement.getLocalName().equals("complexType")) {
                xMLElement = (XMLElement)xMLElement.getParentNode();
            }
            xMLNode = (XMLNode)xMLElement.getParentNode();
            xMLNode2 = (XMLNode)xMLElement.getPreviousSibling();
            xMLNode.removeChild(xMLElement);
            if (xMLNode2 != null && xMLNode2 instanceof XMLText) {
                xMLNode.removeChild(xMLNode2);
            }
            ++xSDAnalyzerContext.removedTypes;
        }
    }

    public Hashtable getTypeDefinitionTable() {
        return new Hashtable(this.typeDefinitionSet);
    }

    public Hashtable getSimpleTypeTable() {
        Hashtable<String, XSDNode> hashtable = new Hashtable<String, XSDNode>();
        for (XSDNode xSDNode : this.typeDefinitionSet.values()) {
            if (!xSDNode.isNodeType(2)) continue;
            hashtable.put(xSDNode.getName(), xSDNode);
        }
        return hashtable;
    }

    public Hashtable getComplexTypeTable() {
        Hashtable<String, XSDNode> hashtable = new Hashtable<String, XSDNode>();
        for (XSDNode xSDNode : this.typeDefinitionSet.values()) {
            if (!xSDNode.isNodeType(1)) continue;
            hashtable.put(xSDNode.getName(), xSDNode);
        }
        return hashtable;
    }

    void setTargetNS(String string) {
        this.targetNS = string.intern();
    }

    @Override
    public String getTargetNS() {
        return this.targetNS;
    }

    boolean addComponent(XSDNode xSDNode) {
        xSDNode.parent = this;
        xSDNode.targetNS = this.targetNS;
        boolean bl = false;
        switch (xSDNode.nodeType) {
            case 4: {
                if (this.attributeSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.attributeSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 3: {
                if (this.elemSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.elemSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 1: 
            case 2: {
                if (this.typeDefinitionSet.containsKey(xSDNode.name)) {
                    bl = true;
                    if (this.targetNS == "http://www.w3.org/2001/XMLSchema") break;
                }
                this.typeDefinitionSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 6: {
                if (this.attrGroupSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.attrGroupSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 5: {
                if (this.groupSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.groupSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 25: {
                if (this.notationSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.notationSet.put(xSDNode.name, xSDNode);
            }
        }
        if (this.targetNS == "http://www.w3.org/2001/XMLSchema") {
            return false;
        }
        return bl;
    }

    XSDNode getComponent(String string, int n) {
        switch (n) {
            case 4: {
                return (XSDNode)this.attributeSet.get(string);
            }
            case 3: {
                return (XSDNode)this.elemSet.get(string);
            }
            case 1: 
            case 2: {
                XSDNode xSDNode = (XSDNode)this.typeDefinitionSet.get(string);
                if (xSDNode != null && xSDNode.isNodeType(n)) {
                    return xSDNode;
                }
                return null;
            }
            case 6: {
                return (XSDNode)this.attrGroupSet.get(string);
            }
            case 5: {
                return (XSDNode)this.groupSet.get(string);
            }
            case 25: {
                return (XSDNode)this.notationSet.get(string);
            }
        }
        return null;
    }

    XSDNode removeComponent(String string, int n) {
        switch (n) {
            case 4: {
                return (XSDNode)this.attributeSet.remove(string);
            }
            case 3: {
                return (XSDNode)this.elemSet.remove(string);
            }
            case 1: 
            case 2: {
                XSDNode xSDNode = (XSDNode)this.typeDefinitionSet.remove(string);
                if (xSDNode != null && xSDNode.isNodeType(n)) {
                    return xSDNode;
                }
                return null;
            }
            case 6: {
                return (XSDNode)this.attrGroupSet.remove(string);
            }
            case 5: {
                return (XSDNode)this.groupSet.remove(string);
            }
            case 25: {
                return (XSDNode)this.notationSet.remove(string);
            }
        }
        return null;
    }

    XSDNode getType(String string, int n) {
        XSDNode xSDNode = (XSDNode)this.typeDefinitionSet.get(string = string.intern());
        if (xSDNode != null && xSDNode.isNodeType(n)) {
            return xSDNode;
        }
        return null;
    }

    XSDNode getType(String string) {
        string = string.intern();
        return (XSDNode)this.typeDefinitionSet.get(string);
    }

    public XSDElement getElement(String string) {
        return (XSDElement)this.elemSet.get(string);
    }

    XSDAttribute getAttribute(String string) {
        return (XSDAttribute)this.attributeSet.get(string);
    }

    XSDAttrGroup getAttrGroup(String string) {
        return (XSDAttrGroup)this.attrGroupSet.get(string);
    }

    int getElementSetSize() {
        return this.elemSet.size();
    }

    int getAttributeSetSize() {
        return this.attributeSet.size();
    }

    public int getNotationSetSize() {
        return this.notationSet.size();
    }

    int getGroupSetSize() {
        return this.groupSet.size();
    }

    public XSDNode[] getElementSet() {
        XSDNode[] xSDNodeArray = new XSDNode[this.elemSet.size()];
        int n = 0;
        Iterator iterator = this.elemSet.values().iterator();
        while (iterator.hasNext()) {
            xSDNodeArray[n] = (XSDNode)iterator.next();
            ++n;
        }
        return xSDNodeArray;
    }

    public XSDNode[] getGroupSet() {
        XSDNode[] xSDNodeArray = new XSDNode[this.groupSet.size()];
        int n = 0;
        Iterator iterator = this.groupSet.values().iterator();
        while (iterator.hasNext()) {
            xSDNodeArray[n] = (XSDNode)iterator.next();
            ++n;
        }
        return xSDNodeArray;
    }

    public XSDNode[] getAttributeSet() {
        XSDNode[] xSDNodeArray = new XSDNode[this.attributeSet.size()];
        int n = 0;
        Iterator iterator = this.attributeSet.values().iterator();
        while (iterator.hasNext()) {
            xSDNodeArray[n] = new XSDElement((XSDAttribute)iterator.next());
            ++n;
        }
        return xSDNodeArray;
    }

    public XSDAttribute[] getAttributeDeclarations() {
        XSDAttribute[] xSDAttributeArray = new XSDAttribute[this.attributeSet.size()];
        int n = 0;
        Iterator iterator = this.attributeSet.values().iterator();
        while (iterator.hasNext()) {
            xSDAttributeArray[n] = (XSDAttribute)iterator.next();
            ++n;
        }
        return xSDAttributeArray;
    }

    public XSDNode[] getComplexTypeSet() {
        XSDNode[] xSDNodeArray = new XSDNode[this.typeDefinitionSet.size()];
        int n = 0;
        for (XSDNode xSDNode : this.typeDefinitionSet.values()) {
            if (!xSDNode.isNodeType(1)) continue;
            xSDNodeArray[n++] = xSDNode;
        }
        XSDNode[] xSDNodeArray2 = new XSDNode[n];
        System.arraycopy(xSDNodeArray, 0, xSDNodeArray2, 0, n);
        return xSDNodeArray2;
    }

    public XSDNode[] getSimpleTypeSet() {
        XSDNode[] xSDNodeArray = new XSDNode[this.typeDefinitionSet.size()];
        int n = 0;
        for (XSDNode xSDNode : this.typeDefinitionSet.values()) {
            if (!xSDNode.isNodeType(2)) continue;
            xSDNodeArray[n++] = xSDNode;
        }
        XSDNode[] xSDNodeArray2 = new XSDNode[n];
        System.arraycopy(xSDNodeArray, 0, xSDNodeArray2, 0, n);
        return xSDNodeArray2;
    }

    private void init(int n) {
        this.typeDefinitionSet = new HashMap(n);
        this.groupSet = new HashMap(n);
        this.elemSet = new HashMap(n);
        this.attrGroupSet = new HashMap(n);
        this.attributeSet = new HashMap(n);
        this.notationSet = new HashMap(n);
        this.targetNS = "";
    }

    @Override
    void print() {
        System.out.println(" === Start XMLSchemaNode === ");
        System.out.println("Target NameSpace =" + this.targetNS);
        System.out.println("SchemaLocation =" + this.schemaLocation);
        for (XSDNode xSDNode : this.typeDefinitionSet.values()) {
            if (xSDNode.isNodeType(1)) {
                ((XSDComplexType)xSDNode).print(0);
                continue;
            }
            ((XSDSimpleType)xSDNode).print(0);
        }
        Iterator iterator = this.elemSet.values().iterator();
        while (iterator.hasNext()) {
            ((XSDElement)iterator.next()).print(0);
        }
        iterator = this.groupSet.values().iterator();
        while (iterator.hasNext()) {
            ((XSDGroup)iterator.next()).print(0);
        }
        iterator = this.attributeSet.values().iterator();
        while (iterator.hasNext()) {
            ((XSDAttribute)iterator.next()).print(0);
        }
        iterator = this.attrGroupSet.values().iterator();
        while (iterator.hasNext()) {
            ((XSDAttrGroup)iterator.next()).print(0);
        }
        iterator = this.notationSet.values().iterator();
        while (iterator.hasNext()) {
            ((XSDNotation)iterator.next()).print(0);
        }
        System.out.println(" === End XMLSchemaNode === ");
    }
}

