/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;

class XSDAttrGroup
extends XSDNode {
    String refNamespace;
    String refLocalname;
    int refState;
    XSDNode[] nodeVector;
    int vectorSize = 0;
    XSDAny wildcard;
    XSDAttrGroup base;
    boolean restriction;
    boolean resolved;

    XSDAttrGroup(int n) {
        this.nodeType = 6;
        this.nodeVector = new XSDNode[10];
        this.refState = 0;
    }

    void setAttribute(XSDNode xSDNode, int n) {
        this.nodeVector[n] = xSDNode;
    }

    void setWildcard(XSDAny xSDAny) {
        this.wildcard = xSDAny;
        if (xSDAny.parent == null) {
            xSDAny.parent = this;
        }
    }

    XSDAny getWildcard() {
        return this.wildcard;
    }

    XSDAttribute[] copyAttrDefs(XSDAttribute[] xSDAttributeArray) {
        if (xSDAttributeArray.length < this.vectorSize) {
            xSDAttributeArray = new XSDAttribute[this.vectorSize];
        }
        System.arraycopy(this.nodeVector, 0, xSDAttributeArray, 0, this.vectorSize);
        return xSDAttributeArray;
    }

    void addNode(XSDNode xSDNode) {
        this.ensureCapacity(this.vectorSize + 1);
        this.nodeVector[this.vectorSize++] = xSDNode;
        if (xSDNode.parent == null) {
            xSDNode.parent = this;
        }
    }

    XSDNode getNode(String string, String string2) {
        XSDNode xSDNode = null;
        for (int i = 0; i < this.vectorSize; ++i) {
            xSDNode = this.nodeVector[i];
            if (!xSDNode.getName().equals(string2) || !xSDNode.getTargetNS().equals(string)) continue;
            return xSDNode;
        }
        return null;
    }

    void setRef(String string, String string2) {
        this.refLocalname = string2;
        this.refNamespace = string;
        this.refState = 1;
    }

    int getVectorSize() {
        return this.vectorSize;
    }

    boolean isValidRestriction(XSDAttrGroup xSDAttrGroup) {
        XSDAttribute xSDAttribute;
        int n;
        int n2 = xSDAttrGroup.length();
        for (n = 0; n < this.length(); ++n) {
            XSDAttribute xSDAttribute2 = (XSDAttribute)this.item(n);
            xSDAttribute = (XSDAttribute)xSDAttrGroup.item(xSDAttribute2);
            if (xSDAttribute != null) {
                if (xSDAttribute.minOccurs > xSDAttribute2.minOccurs) {
                    return false;
                }
                if (!xSDAttribute2.simpleType.isDerivedFrom(xSDAttribute.simpleType, XSDComplexType.BFNONE)) {
                    return false;
                }
                if (xSDAttribute.fixedVal == null || xSDAttribute.fixedVal.equals(xSDAttribute2.fixedVal)) continue;
                return false;
            }
            if (xSDAttrGroup.wildcard != null && xSDAttrGroup.wildcard.isMatched(xSDAttribute2.getTargetNS())) continue;
            return false;
        }
        for (n = 0; n < n2; ++n) {
            xSDAttribute = (XSDAttribute)xSDAttrGroup.item(n);
            if (xSDAttribute.minOccurs <= 0 || this.item(xSDAttribute) != null) continue;
            return false;
        }
        return this.wildcard == null || xSDAttrGroup.wildcard != null && xSDAttrGroup.wildcard.isSubSet(this.wildcard);
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDAttrGroup xSDAttrGroup = (XSDAttrGroup)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDAttrGroup != null && xSDAttrGroup.refState == 0) {
            this.name = xSDAttrGroup.name;
            this.refState = 0;
            this.ensureCapacity(xSDAttrGroup.vectorSize);
            this.vectorSize = xSDAttrGroup.vectorSize;
            System.arraycopy(xSDAttrGroup.nodeVector, 0, this.nodeVector, 0, this.vectorSize);
            this.wildcard = xSDAttrGroup.wildcard;
        }
    }

    void resolveGroup(XMLSchema xMLSchema) throws XSDException {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        XSDNode xSDNode = null;
        Object var3_3 = null;
        if (this.wildcard != null) {
            this.wildcard.resolveTargetNS();
        }
        int n = this.vectorSize;
        for (int i = 0; i < n; ++i) {
            xSDNode = this.nodeVector[i];
            if (xSDNode instanceof XSDAttrGroup) {
                XSDAttrGroup xSDAttrGroup = (XSDAttrGroup)xSDNode;
                xSDAttrGroup.resolveGroup(xMLSchema);
                this.nodeVector[i] = null;
                this.mergeGroup(xSDAttrGroup, true);
                if (this.wildcard == null && xSDAttrGroup.wildcard != null) {
                    this.wildcard = xSDAttrGroup.wildcard;
                    continue;
                }
                if (xSDAttrGroup.wildcard == null) continue;
                this.wildcard = this.wildcard.intersectWith(xSDAttrGroup.wildcard);
                continue;
            }
            if (!(xSDNode instanceof XSDAttribute)) continue;
            for (int j = i + 1; j < n; ++j) {
                XSDNode xSDNode2 = this.nodeVector[j];
                if (xSDNode2 == null || xSDNode2.name != xSDNode.name || xSDNode2.getTargetNS() != xSDNode.getTargetNS()) continue;
                throw new XSDException(24509, xSDNode.getName(), xSDNode.domNode);
            }
        }
        if (this.base != null) {
            this.resolveDerivation(xMLSchema);
        }
        this.compactNodes();
        for (int i = 0; i < this.vectorSize; ++i) {
            XSDAttribute xSDAttribute = (XSDAttribute)this.nodeVector[i];
            XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDAttribute.getType();
            if (xSDSimpleType != null) {
                xSDSimpleType.parseDerivation(xMLSchema);
            }
            xSDAttribute.checkConstraints();
        }
    }

    private void resolveDerivation(XMLSchema xMLSchema) throws XSDException {
        this.base.resolveGroup(xMLSchema);
        this.mergeGroup(this.base, !this.restriction);
        if (this.base.wildcard != null && !this.restriction) {
            this.wildcard = this.wildcard == null ? this.base.wildcard : this.wildcard.unionWith(this.base.wildcard);
        }
    }

    private void compactNodes() {
        int n = 0;
        for (int i = 0; i < this.vectorSize; ++i) {
            if (this.nodeVector[i] == null || ((XSDAttribute)this.nodeVector[i]).maxOccurs == 0) continue;
            this.nodeVector[n++] = this.nodeVector[i];
        }
        this.vectorSize = n;
    }

    private XSDNode item(XSDNode xSDNode) {
        for (int i = 0; i < this.vectorSize; ++i) {
            XSDNode xSDNode2 = this.nodeVector[i];
            if (xSDNode2 == null || xSDNode == null || xSDNode.name != xSDNode2.name || xSDNode.getTargetNS() != xSDNode2.getTargetNS()) continue;
            return xSDNode2;
        }
        return null;
    }

    XSDAttribute getAttributeDeclaration(String string, String string2) {
        XSDAttribute xSDAttribute = null;
        for (int i = 0; i < this.vectorSize; ++i) {
            xSDAttribute = (XSDAttribute)this.nodeVector[i];
            if (!string2.equals(xSDAttribute.name) || !string.equals(xSDAttribute.getTargetNS())) continue;
            return xSDAttribute;
        }
        return null;
    }

    void mergeGroup(XSDAttrGroup xSDAttrGroup, boolean bl) throws XSDException {
        int n = xSDAttrGroup.length();
        this.ensureCapacity(n + this.vectorSize);
        for (int i = 0; i < n; ++i) {
            XSDNode xSDNode = xSDAttrGroup.item(i);
            XSDNode xSDNode2 = this.item(xSDNode);
            if (xSDNode2 == null) {
                this.nodeVector[this.vectorSize++] = xSDNode;
                continue;
            }
            if (!bl || ((XSDAttribute)xSDNode).maxOccurs <= 0 || ((XSDAttribute)xSDNode2).maxOccurs <= 0) continue;
            throw new XSDException(24509, xSDNode.getName(), xSDNode.domNode);
        }
    }

    XSDNode item(int n) {
        if (n >= 0 && n < this.vectorSize) {
            return this.nodeVector[n];
        }
        return null;
    }

    int length() {
        return this.vectorSize;
    }

    private void ensureCapacity(int n) {
        int n2;
        for (n2 = this.nodeVector.length; n2 < n; n2 *= 2) {
        }
        XSDNode[] xSDNodeArray = this.nodeVector;
        this.nodeVector = new XSDNode[n2];
        System.arraycopy(xSDNodeArray, 0, this.nodeVector, 0, this.vectorSize);
    }

    @Override
    void print(int n) {
        boolean bl = false;
        if (this.refLocalname != null) {
            bl = true;
        }
        if (!bl && this.vectorSize == 0) {
            return;
        }
        this.printSTag(n);
        this.printSTagEnd(n);
        if (!bl) {
            for (int i = 0; i < this.vectorSize; ++i) {
                this.nodeVector[i].print(n + 3);
            }
        }
        if (this.wildcard != null) {
            this.wildcard.print(n + 3);
        }
        this.printETag(n);
    }
}

