/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.ContentModel;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDTDLexerReader;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNotation;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.pullparser.XMLCoreStreamReader;
import oracle.xml.pullparser.XMLLexer;
import oracle.xml.pullparser.XMLPullParserConstants;
import oracle.xml.util.QxNameHash;
import org.xml.sax.DTDHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XMLDTDStreamReader
implements XMLConstants,
XMLPullParserConstants {
    private XMLReader reader;
    private XMLLexer lexer;
    private XMLCoreStreamReader host;
    private DTD dtd;
    private XMLError err;
    public String sysId;
    public String pubId;
    public String dtdtag;
    char[] charBuffer = new char[1024];
    URL baseURL = null;
    int valMode = 0;
    int externalDTD = 0;
    boolean fixedDTD = true;
    boolean deterministic = true;
    boolean expanderef = true;
    boolean standalone = false;
    DTDHandler dtdHandler = null;
    DeclHandler declHandler = null;
    LexicalHandler lexHandler = null;

    public DTD parseDTD(XMLLexer xMLLexer, XMLCoreStreamReader xMLCoreStreamReader) throws XMLStreamException {
        this.host = xMLCoreStreamReader;
        this.lexer = xMLLexer;
        this.err = this.host.err;
        this.reader = new XMLDTDLexerReader(xMLLexer, this.err);
        this.sysId = null;
        this.pubId = null;
        this.dtdtag = null;
        this.externalDTD = 0;
        this.parseDoctypeDecl();
        return this.dtd;
    }

    void parseDoctypeDecl() throws XMLStreamException {
        String string = null;
        String string2 = null;
        this.dtd = new DTD();
        String string3 = this.parseQName();
        XMLLexer.Token token = this.lexer.nextDTDToken();
        if (token.id == 36) {
            if (token.eq(cSYSTEM)) {
                token = this.checkDTDToken(25);
                string = token.toString();
            } else if (token.eq(cPUBLIC)) {
                string2 = this.parsePubIdLiteral();
                token = this.checkDTDToken(25);
                string = token.toString();
            } else {
                this.error0(197, 0);
            }
            token = this.lexer.nextDTDToken();
        }
        if (this.lexHandler != null) {
            try {
                this.lexHandler.startDTD(string3, string2, string);
            }
            catch (SAXException sAXException) {
                throw new XMLStreamException(sAXException.toString());
            }
        }
        if (token.id == 30) {
            this.parseMarkupDecl();
            token = this.lexer.nextDTDToken();
        }
        if (token.id != 32) {
            this.error0(191, 0);
        }
        if (this.lexHandler != null) {
            try {
                this.lexHandler.endDTD();
            }
            catch (SAXException sAXException) {
                throw new XMLStreamException(sAXException.toString());
            }
        }
    }

    void parseMarkupDecl() throws XMLStreamException {
        XMLLexer.Token token = this.lexer.nextDTDToken();
        while (this.externalDTD == 0 && token.id == 38) {
            this.error1(198, 0, "Entity not supported");
            token = this.lexer.nextDTDToken();
        }
        boolean bl = true;
        while (bl) {
            switch (token.id) {
                case 41: {
                    this.parseElementDecl();
                    break;
                }
                case 42: {
                    this.parseAttlistDecl();
                    break;
                }
                case 43: {
                    this.parseEntityDecl();
                    break;
                }
                case 44: {
                    this.parseNotationDecl();
                    break;
                }
                case 12: {
                    break;
                }
                case 10: {
                    break;
                }
                case 30: {
                    if (this.externalDTD == 0) {
                        this.error0(192, 0);
                    }
                    if ((token = this.lexer.nextDTDToken()).isKeyword(cINCLUDE)) {
                        this.checkDTDToken(30);
                        this.parseMarkupDecl();
                        break;
                    }
                    if (token.isKeyword(cIGNORE)) break;
                    this.error2(101, 0, "IGNORE", "INCLUDE");
                    break;
                }
                case 31: {
                    bl = false;
                    break;
                }
                case 21: {
                    bl = false;
                    break;
                }
                default: {
                    this.error0(192, 0);
                    bl = false;
                }
            }
            if (!bl) continue;
            token = this.lexer.nextDTDToken();
        }
    }

    void parseElementDecl() throws XMLStreamException {
        String string = this.parseQName();
        ElementDecl elementDecl = this.dtd.findElementDecl(string);
        if (elementDecl != null && elementDecl.isNodeFlag(65536)) {
            this.error1(131, 0, string);
        }
        if (elementDecl == null) {
            elementDecl = this.dtd.createElementDecl(string);
            this.dtd.addElementDecl(elementDecl);
        } else {
            elementDecl.setNodeFlag(65536);
        }
        this.parseContentSpec(elementDecl.xdkGetContentModel());
    }

    void parseContentSpec(ContentModel contentModel) throws XMLStreamException {
        XMLDTDLexerReader xMLDTDLexerReader = (XMLDTDLexerReader)this.reader;
        contentModel.setDeterministic(this.deterministic);
        try {
            if (this.reader.tryRead(cEMPTY, 0, cEMPTY.length)) {
                contentModel.type = 1;
            } else if (this.reader.tryRead(cANY, 0, cANY.length)) {
                contentModel.type = (byte)2;
            } else if (xMLDTDLexerReader.tok.id == 28) {
                contentModel.parseContentModel(this.err, this.reader);
            } else {
                this.error0(197, 0);
            }
            if (!this.reader.tryRead(62)) {
                this.error1(100, 0, ">");
            }
        }
        catch (Exception exception) {
            throw new XMLStreamException(exception.toString());
        }
    }

    void parseAttlistDecl() throws XMLStreamException {
        ElementDecl elementDecl = null;
        String string = this.parseQName();
        elementDecl = this.dtd.findElementDecl(string);
        if (elementDecl == null) {
            elementDecl = this.dtd.createElementDecl(string, (byte)2);
            elementDecl.resetNodeFlag(65536);
            this.dtd.addElementDecl(elementDecl);
            if (this.externalDTD > 0) {
                elementDecl.setNodeFlag(128);
            }
        }
        while (true) {
            XMLLexer.Token token = this.lexer.nextDTDToken();
            if (token.id == 32) break;
            if (token.id != 37 && token.id != 36) {
                this.error0(197, 0);
            }
            String string2 = token.toString();
            AttrDecl attrDecl = this.parseAttrDecl(elementDecl, string2);
            int n = elementDecl.getAttrDeclIndex(string2);
            if (n != -1) {
                this.error1(135, 2, string2);
                if (!this.fixedDTD) continue;
                elementDecl.removeAttrDeclAt(n);
                elementDecl.addAttrDecl(attrDecl);
                continue;
            }
            if (this.externalDTD > 0) {
                attrDecl.setNodeFlag(128);
            }
            elementDecl.addAttrDecl(attrDecl);
            if (this.declHandler == null) continue;
            try {
                this.declHandler.attributeDecl(string, string2, AttrDecl.attrDeclTypes[attrDecl.atttype], AttrDecl.attrDeclPresence[attrDecl.attpres], attrDecl.getDefaultValue());
            }
            catch (SAXException sAXException) {
                throw new XMLStreamException(sAXException.toString());
            }
        }
    }

    AttrDecl parseAttrDecl(ElementDecl elementDecl, String string) throws XMLStreamException {
        String string2;
        AttrDecl attrDecl = null;
        boolean bl = false;
        attrDecl = (AttrDecl)elementDecl.getDocument().createNodeFromType((short)14);
        attrDecl.xdkSetQxName(QxNameHash.create("", string, "", string));
        XMLLexer.Token token = this.lexer.nextDTDToken();
        if (token.id == 36) {
            string2 = token.toString();
            if (string2.equals("CDATA")) {
                attrDecl.atttype = 0;
            } else if (string2.equals("IDREFS")) {
                attrDecl.atttype = 3;
            } else if (string2.equals("IDREF")) {
                attrDecl.atttype = 2;
            } else if (string2.equals("ID")) {
                attrDecl.atttype = 1;
            } else if (string2.equals("ENTITY")) {
                attrDecl.atttype = 4;
            } else if (string2.equals("ENTITIES")) {
                attrDecl.atttype = 5;
            } else if (string2.equals("NMTOKENS")) {
                attrDecl.atttype = 7;
            } else if (string2.equals("NMTOKEN")) {
                attrDecl.atttype = 6;
            } else if (string2.equals("NOTATION")) {
                attrDecl.atttype = 8;
                token = this.checkDTDToken(28);
            } else {
                this.error0(133, 0);
            }
        } else if (token.id == 28) {
            attrDecl.atttype = 9;
        } else {
            this.error0(133, 0);
            attrDecl.atttype = 0;
        }
        if (attrDecl.atttype == 8 || attrDecl.atttype == 9) {
            string2 = null;
            Vector<String> vector = new Vector<String>();
            attrDecl.xdkSetEnumValue(vector);
            while (true) {
                token = this.lexer.nextDTDToken();
                if (attrDecl.atttype == 8 && (token.id == 37 || token.id == 36)) {
                    string2 = token.toString();
                } else if (token.id == 40 || token.id == 36) {
                    string2 = token.toString();
                } else {
                    this.error0(197, 0);
                }
                vector.addElement(string2);
                token = this.lexer.nextDTDToken();
                if (token.id == 29) break;
                if (token.id == 27) continue;
                this.error2(101, 0, ")", "|");
                this.flushErrors1();
            }
        }
        token = this.lexer.nextDTDToken();
        switch (token.id) {
            case 50: {
                attrDecl.attpres = 3;
                token = this.checkDTDToken(25);
                break;
            }
            case 48: {
                attrDecl.attpres = 1;
                break;
            }
            case 49: {
                attrDecl.attpres = 2;
                break;
            }
            case 25: {
                attrDecl.attpres = 0;
                break;
            }
            default: {
                this.error0(288, 0);
            }
        }
        if (attrDecl.attpres == 3 || attrDecl.attpres == 0) {
            string2 = token.toString();
            string2 = this.normalizeAttrValue(string2, attrDecl, true);
            attrDecl.xdkSetAttrDeclDefault(string2);
        }
        return attrDecl;
    }

    String normalizeAttrValue(String string, AttrDecl attrDecl, boolean bl) {
        if (attrDecl != null && attrDecl.atttype != 0) {
            int n;
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            for (n = 0; n < n2 && cArray[n] == ' '; ++n) {
            }
            for (int i = n + 1; i < n2; ++i) {
                if (n3 != 0) {
                    cArray[i - n3] = cArray[i];
                }
                if (cArray[i] != ' ' || cArray[i - 1] != ' ') continue;
                ++n3;
            }
            if ((n2 = n2 - n - n3) != 0 && cArray[n + n2 - 1] == ' ') {
                --n2;
            }
            return new String(cArray, n, n2);
        }
        return string;
    }

    XMLEntity parseEntityDecl() throws XMLStreamException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = null;
        String string4 = null;
        XMLLexer.Token token = this.lexer.nextDTDToken();
        if (token.id == 33) {
            bl = true;
            token = this.lexer.nextDTDToken();
        }
        if (token.id == 36 || token.id == 37) {
            string = bl ? "%" + token.toString() : token.toString();
        } else {
            this.error1(100, 0, "name");
        }
        XMLEntity xMLEntity = (XMLEntity)this.dtd.findEntity(string, bl);
        if (xMLEntity != null) {
            this.error1(116, 2, string);
            xMLEntity = this.dtd.createEntityDecl(string, bl);
            bl3 = true;
            if (this.fixedDTD) {
                this.dtd.addEntity(xMLEntity, bl);
                xMLEntity.expanderef = this.expanderef;
                if (this.externalDTD > 0) {
                    xMLEntity.setNodeFlag(128);
                }
            }
        } else {
            xMLEntity = this.dtd.createEntityDecl(string, bl);
            xMLEntity.expanderef = this.expanderef;
            this.dtd.addEntity(xMLEntity, bl);
            if (this.externalDTD > 0) {
                xMLEntity.setNodeFlag(128);
            }
        }
        if ((token = this.lexer.nextDTDToken()).isKeyword(cPUBLIC)) {
            bl2 = true;
            string4 = this.parsePubIdLiteral();
            xMLEntity.xdkSetPublicId(string4);
            token = this.checkDTDToken(25);
            string3 = token.toString();
            xMLEntity.xdkSetSystemId(string3);
            token = this.lexer.nextDTDToken();
        } else if (token.isKeyword(cSYSTEM)) {
            bl2 = true;
            token = this.checkDTDToken(25);
            string3 = token.toString();
            xMLEntity.xdkSetSystemId(string3);
            token = this.lexer.nextDTDToken();
        }
        if (bl2) {
            String string5 = xMLEntity.getSystemId();
            try {
                URL uRL = new URL(this.getBaseURL(), string5);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            boolean bl4 = false;
            if (token.isKeyword(cNDATA)) {
                if (bl) {
                    this.error0(117, 0);
                }
                xMLEntity.setNotationName(this.parseQName());
                if (!bl && xMLEntity.getNotationName() == null) {
                    this.error0(118, 0);
                }
                if (this.dtdHandler != null) {
                    try {
                        this.dtdHandler.unparsedEntityDecl(string, xMLEntity.getPublicId(), xMLEntity.getSystemId(), xMLEntity.getNotationName());
                    }
                    catch (SAXException sAXException) {
                        throw new XMLStreamException(sAXException.toString());
                    }
                }
                bl4 = true;
            } else if (!bl3 && this.declHandler != null) {
                try {
                    this.declHandler.externalEntityDecl(string2, xMLEntity.getPublicId(), string5);
                }
                catch (SAXException sAXException) {
                    throw new XMLStreamException(sAXException.toString());
                }
            }
            if (!(this.standalone || bl4 || string3.equals(""))) {
                URL uRL = null;
                try {
                    uRL = new URL(this.getBaseURL(), xMLEntity.getSystemId());
                    InputStream inputStream = this.reader.openURL(uRL);
                    if (inputStream.available() != 0) {
                        this.reader.pushXMLReader(inputStream, xMLEntity.getSystemId(), xMLEntity.getPublicId());
                        xMLEntity.setInputEncoding(this.reader.encoding);
                        xMLEntity.setXmlEncoding(this.reader.xmlDeclEncoding);
                        xMLEntity.setXmlVersion(this.reader.xmlDeclVersion);
                        this.reader.popXMLReader();
                    }
                }
                catch (Exception exception) {}
            }
        } else if (token.id == 25) {
            String string6 = this.parseEntityValue(token);
            xMLEntity.setNodeValue(string6);
            xMLEntity.setNodeFlag(131072);
            this.dtd.addStreamEntity(string, string6, true);
            if (!bl3 && this.declHandler != null) {
                try {
                    this.declHandler.internalEntityDecl(string2, string6);
                }
                catch (SAXException sAXException) {
                    throw new XMLStreamException(sAXException.toString());
                }
            }
        } else {
            this.error1(100, 0, "entity-value");
        }
        this.checkDTDToken(32);
        return xMLEntity;
    }

    void printEntity(XMLNode xMLNode) {
        while (xMLNode != null) {
            System.out.println("    ### (" + xMLNode.getNodeType() + ")" + xMLNode.getNodeName() + " - " + xMLNode.getNodeValue());
            this.printEntity((XMLNode)xMLNode.getFirstChild());
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
    }

    void parseNotationDecl() throws XMLStreamException {
        Object object;
        String string = this.parseQName();
        XMLNotation xMLNotation = (XMLNotation)this.dtd.findNotation(string);
        if (xMLNotation != null) {
            if (this.valMode == 2) {
                this.error1(136, 1, string);
            } else {
                this.error1(136, 2, string);
            }
            xMLNotation = this.dtd.createNotationDecl(string);
        } else {
            xMLNotation = this.dtd.createNotationDecl(string);
            this.dtd.addNotation(xMLNotation);
            if (this.externalDTD > 0) {
                xMLNotation.setNodeFlag(128);
            }
        }
        XMLLexer.Token token = this.checkDTDToken(36);
        if (token.eq(cPUBLIC)) {
            object = this.parsePubIdLiteral();
            xMLNotation.setPublicId((String)object);
            token = this.lexer.nextDTDToken();
            if (token.id == 25) {
                xMLNotation.setSystemId(token.toString());
                token = this.lexer.nextDTDToken();
            }
            if (token.id != 32) {
                this.error1(100, 0, ">");
            }
        } else if (token.eq(cSYSTEM)) {
            token = this.checkDTDToken(25);
            xMLNotation.setSystemId(token.toString());
            token = this.checkDTDToken(32);
        } else {
            this.error2(101, 0, "PUBLIC", "SYSTEM");
            this.flushErrors1();
        }
        try {
            object = this.baseURL != null ? new URL(this.baseURL, xMLNotation.getSystemId()) : new URL(new URL(this.reader.getSystemId()), xMLNotation.getSystemId());
            xMLNotation.setSystemId(((URL)object).toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this.dtdHandler != null) {
            try {
                this.dtdHandler.notationDecl(string, xMLNotation.getPublicId(), xMLNotation.getSystemId());
            }
            catch (SAXException sAXException) {
                throw new XMLStreamException(sAXException.toString());
            }
        }
    }

    String parseQName() throws XMLStreamException {
        XMLLexer.Token token = this.lexer.nextDTDToken();
        if (token.id != 37 && token.id != 36) {
            this.error0(197, 0);
        }
        return token.toString();
    }

    char nextChar() {
        return (char)this.lexer.nextChar();
    }

    String parsePubIdLiteral() throws XMLStreamException {
        int n;
        int n2;
        char c;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        char c2 = this.nextChar();
        while (Character.isWhitespace(c2 = this.nextChar())) {
        }
        if (c2 != '\"' && c2 != '\'') {
            this.error2(206, 0, "'", "\"");
            this.flushErrors1();
        }
        while ((c = this.nextChar()) != c2) {
            switch (c) {
                case '\"': {
                    if (c2 == '\'') {
                        this.error1(282, 0, "\"");
                        this.flushErrors1();
                    }
                }
                case '\n': 
                case '\r': {
                    c = ' ';
                    break;
                }
                case '\t': 
                case '&': 
                case '<': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    this.error1(282, 0, "" + c);
                    this.flushErrors1();
                }
            }
            this.charBuffer[n3++] = c;
        }
        for (n2 = n = 0; n2 < n3 && this.charBuffer[n2] == ' '; ++n2) {
        }
        n = n2;
        for (n2 = n3 - 1; n2 >= n && this.charBuffer[n2] == ' '; --n2) {
        }
        n3 = n2;
        for (n2 = n; n2 <= n3; ++n2) {
            if (n5 != 0) {
                this.charBuffer[n2 - n5] = this.charBuffer[n2];
            }
            if (this.charBuffer[n2] != ' ' || this.charBuffer[n2 - 1] != ' ') continue;
            ++n5;
        }
        n4 = n3 - n - n5 + 1;
        return new String(this.charBuffer, n, n4);
    }

    String parseEntityValue(XMLLexer.Token token) throws XMLStreamException {
        return token.toString();
    }

    URL getBaseURL() throws MalformedURLException {
        return new URL(this.sysId);
    }

    XMLLexer.Token checkDTDToken(int n) throws XMLStreamException {
        XMLLexer.Token token = this.lexer.nextDTDToken();
        if (token.id != n) {
            this.error0(197, 0);
        }
        return token;
    }

    void flushErrors1() throws XMLStreamException {
        try {
            this.err.flushErrors1();
        }
        catch (Exception exception) {
            throw new XMLStreamException(exception.toString());
        }
    }

    void error0(int n, int n2) throws XMLStreamException {
        this.err.error0(n, n2);
        this.host.error0(n);
        if (n2 == 0 || n2 == 1) {
            throw new XMLStreamException("FATAL ERROR: " + n);
        }
    }

    void error1(int n, int n2, String string) throws XMLStreamException {
        this.err.error1(n, n2, string);
        this.host.error1(n, string);
        try {
            this.err.flushErrors();
        }
        catch (Exception exception) {
            throw new XMLStreamException(exception.toString());
        }
        if (n2 == 0 || n2 == 1) {
            throw new XMLStreamException("FATAL ERROR: " + n);
        }
    }

    void error2(int n, int n2, String string, String string2) throws XMLStreamException {
        this.err.error2(n, n2, string, string2);
        this.host.error2(n, string, string2);
        if (n2 == 0 || n2 == 1) {
            throw new XMLStreamException("FATAL ERROR: " + n);
        }
    }
}

