/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pullparser;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import oracle.xml.pullparser.XMLCoreStreamReader;
import oracle.xml.pullparser.XMLLexer;
import oracle.xml.pullparser.XMLLexerLib;

public class XMLByteLexer
extends XMLLexer
implements XMLStreamConstants {
    private int charK = 0;
    protected int[] ttable;
    protected int pushed;

    public XMLByteLexer(XMLCoreStreamReader xMLCoreStreamReader) {
        this.host = xMLCoreStreamReader;
        this.in = null;
    }

    @Override
    public boolean set(InputStream inputStream, String string) throws XMLStreamException {
        this.ttable = XMLLexerLib.getDecodingTable(string);
        if (this.ttable == null) {
            return false;
        }
        this.in = inputStream;
        this.pushed = 0;
        this.bufsize = 8192;
        this.curline = 1;
        return true;
    }

    public boolean set(InputStream inputStream, int[] nArray) throws XMLStreamException {
        this.ttable = nArray;
        this.in = inputStream;
        this.pushed = 0;
        this.bufsize = 8192;
        this.curline = 1;
        return true;
    }

    public void set(XMLLexer xMLLexer, String string) throws XMLStreamException {
        this.ttable = XMLLexerLib.getDecodingTable(string);
        if (this.ttable == null) {
            this.host.error1(66, string);
        }
        if (xMLLexer != this) {
            this.in = xMLLexer.in;
            this.byteBuffer = xMLLexer.byteBuffer;
            this.byteinx = xMLLexer.byteinx;
            this.lastbyte = xMLLexer.lastbyte;
            this.bufsize = xMLLexer.bufsize;
            this.curline = xMLLexer.curline;
        }
    }

    @Override
    public void open() throws XMLStreamException {
        this.readBuffer(0);
    }

    @Override
    public int nextToken(int n, int n2) throws XMLStreamException {
        int[] nArray = this.ttable;
        int[] nArray2 = lextbl32;
        byte[] byArray = this.byteBuffer;
        char[] cArray = this.host.charBuffer;
        int n3 = this.byteinx;
        int n4 = 0;
        try {
            while (true) {
                n4 = nArray[byArray[n3] & 0xFF];
                int n5 = n4 >> 16;
                n4 &= 0xFFFF;
                if (n5 >= 100) {
                    if (n4 == 10) {
                        this.curlineinx = n3;
                        ++this.curline;
                        n5 = 12;
                    } else if (n4 == 13) {
                        n4 = 10;
                        if (byArray[n3 + 1] == 10) {
                            // empty if block
                        }
                        this.curlineinx = ++n3;
                        ++this.curline;
                        n5 = 12;
                    } else {
                        if (n4 == 255) {
                            return this.checkDocumentEnd(n, n3);
                        }
                        n4 = this.getCharRef(n3, n);
                        n5 = 25;
                        n3 = this.byteinx;
                    }
                }
                if ((n = nArray2[(n << 5) + n5]) <= 99) {
                    if (n > 32) {
                        cArray[n2++] = (char)n4;
                    }
                    ++n3;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.readBuffer(n3) <= 0) {
                return this.checkDocumentEnd(n, n3);
            }
            return this.nextToken(n, n2);
        }
        this.byteinx = n > 104 ? n3 + 1 : n3;
        this.host.charinx = n2;
        return n - 100;
    }

    @Override
    int parseAttrValue(int n) throws XMLStreamException {
        int[] nArray = this.ttable;
        int[] nArray2 = lextbl32;
        byte[] byArray = this.byteBuffer;
        char[] cArray = this.host.charBuffer;
        int n2 = this.byteinx;
        int n3 = this.lastbyte;
        int n4 = 0;
        while (true) {
            if (n2 > this.lastbyte) {
                if (this.readBuffer(4) <= 0) {
                    this.host.error0(193);
                }
                n2 = this.byteinx;
                n3 = 0;
            }
            int n5 = nArray[byArray[n2]];
            int n6 = n5 >> 16;
            n5 &= 0xFFFF;
            if (n6 >= 100) {
                if (n5 == 10) {
                    this.curlineinx = n2;
                    ++this.curline;
                    n6 = 12;
                } else if (n5 == 13) {
                    n5 = 10;
                    if (byArray[n2 + 1] == 10) {
                        // empty if block
                    }
                    this.curlineinx = ++n2;
                    ++this.curline;
                    n6 = 12;
                } else {
                    n5 = this.parseCharRef(n2);
                    n2 = this.byteinx;
                    n3 = this.lastbyte;
                    n6 = 25;
                }
            }
            if ((n = nArray2[(n << 5) + n6]) > 99) break;
            if (n > 32) {
                cArray[n4++] = (char)n5;
            }
            ++n2;
        }
        if (n != 117) {
            ++n2;
        }
        this.byteinx = n2;
        this.host.charinx = n4;
        return n - 100;
    }

    @Override
    public int nextDTDToken(int n, int n2) throws XMLStreamException {
        int n3;
        int[] nArray = this.ttable;
        int[] nArray2 = dtdlextbl32;
        byte[] byArray = this.byteBuffer;
        char[] cArray = this.host.charBuffer;
        int n4 = this.byteinx;
        int n5 = 0;
        try {
            while (true) {
                n5 = nArray[byArray[n4] & 0xFF];
                n3 = dtdUTF8table[byArray[n4] & 0xFF];
                n5 &= 0xFFFF;
                if (n3 >= 100) {
                    if (n5 == 10) {
                        this.curlineinx = n4;
                        ++this.curline;
                        n3 = 12;
                    } else if (n5 == 13) {
                        n5 = 10;
                        if (byArray[n4 + 1] == 10) {
                            // empty if block
                        }
                        this.curlineinx = ++n4;
                        ++this.curline;
                        n3 = 12;
                    } else {
                        if (n5 == 255) {
                            return this.checkDocumentEnd(n, n4);
                        }
                        if (n5 == 38) {
                            n3 = 31;
                        }
                    }
                }
                if ((n = nArray2[(n << 5) + n3]) <= 99) {
                    if (n >= 12) {
                        cArray[n2++] = (char)n5;
                    }
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.readBuffer(n4) <= 0) {
                return this.checkDocumentEnd(n, n4);
            }
            return this.nextToken(n, n2);
        }
        this.byteinx = n <= 133 || n3 == 12 ? n4 + 1 : n4;
        this.host.charinx = n2;
        return n - 100;
    }

    int getCharRef(int n, int n2) throws XMLStreamException {
        if (n2 == 0 || n2 >= 66) {
            return this.parseCharRef(n);
        }
        this.host.error0(197);
        return 0;
    }

    @Override
    public void scanXMLDecl() {
    }

    @Override
    public int nextChar() {
        byte by;
        if (this.byteinx > this.lastbyte && this.readBuffer(4) <= 0) {
            return -1;
        }
        if ((by = this.byteBuffer[this.byteinx++]) == 10) {
            ++this.curline;
            this.curlineinx = this.byteinx;
        }
        return by;
    }

    @Override
    protected void pushBytes(int[] nArray, int n, int n2) {
        int n3 = n2 - n;
        for (int i = n; i < n3; ++i) {
            this.byteBuffer[i] = (byte)(nArray[n + i] & 0xFF);
        }
        if (n3 > 0) {
            this.pushed = n3;
        }
    }

    protected int readBuffer(int n) {
        if (this.bufsize < 8192) {
            return 0;
        }
        this.byteinx = 0;
        int n2 = 8192 - this.pushed;
        try {
            this.bufsize = this.in.read(this.byteBuffer, this.pushed, n2);
            if (this.bufsize < n2) {
                this.in.close();
                if (this.bufsize == -1) {
                    this.bufsize = 0;
                }
                this.byteBuffer[this.bufsize + this.pushed] = -1;
            }
            this.bufsize += this.pushed;
            this.pushed = 0;
        }
        catch (IOException iOException) {
            this.bufsize = 0;
        }
        this.lastbyte = this.bufsize - 1;
        return this.bufsize;
    }
}

