/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pullparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import oracle.xml.pullparser.XMLCoreStreamReader;
import oracle.xml.pullparser.XMLLexer;

public class XMLCharLexer
extends XMLLexer {
    protected static final int[] charTable = new int[]{25, 25, 25, 25, 25, 25, 25, 25, 25, 12, 12, 25, 25, 101, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 12, 22, 20, 25, 25, 25, 101, 21, 25, 25, 25, 25, 25, 11, 25, 24, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 19, 25, 13, 23, 14, 18, 25, 7, 9, 5, 6, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 8, 9, 9, 9, 9, 9, 9, 15, 25, 16, 25, 9, 25, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 2, 1, 3, 9, 9, 9, 9, 4, 9, 9, 9, 9, 0, 9, 9, 25, 25, 25, 25, 25, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101};
    private int charK = 0;
    protected static final int INBUF_SIZE = 8192;
    protected char[] inBuffer;

    public XMLCharLexer(XMLCoreStreamReader xMLCoreStreamReader) {
        this.host = xMLCoreStreamReader;
        this.inBuffer = null;
        this.rdr = null;
        this.in = null;
    }

    public void set(Reader reader) {
        this.rdr = reader;
        if (this.inBuffer == null) {
            this.inBuffer = new char[8192];
        }
        this.bufsize = 8192;
        this.curline = 1;
    }

    @Override
    public boolean set(InputStream inputStream, String string) throws XMLStreamException {
        InputStreamReader inputStreamReader;
        this.in = inputStream;
        try {
            inputStreamReader = new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.host.error1(66, unsupportedEncodingException.toString());
            inputStreamReader = null;
        }
        this.set(inputStreamReader);
        return true;
    }

    @Override
    public void open() throws XMLStreamException {
        this.readBuffer(0);
    }

    @Override
    public int nextToken(int n, int n2) throws XMLStreamException {
        int[] nArray = charTable;
        int[] nArray2 = lextbl32;
        char[] cArray = this.host.charBuffer;
        int n3 = this.byteinx;
        int n4 = this.lastbyte;
        n2 = 0;
        while (true) {
            int n5;
            int n6;
            if (n3 > n4) {
                if (this.readBuffer(3) <= 0) {
                    return 21;
                }
                n3 = this.byteinx;
                n4 = this.lastbyte;
            }
            int n7 = n6 = (n5 = this.inBuffer[n3]) < 256 ? nArray[n5] : 101;
            if (n6 > 99) {
                if (n5 == 10) {
                    this.curlineinx = n3;
                    ++this.curline;
                    n6 = 12;
                } else if (n5 == 13) {
                    n5 = 10;
                    if (this.inBuffer[n3 + 1] == '\n') {
                        // empty if block
                    }
                    this.curlineinx = ++n3;
                    ++this.curline;
                    n6 = 12;
                } else if (n5 == 38) {
                    n5 = this.getMultibyteChar(n3, n);
                    n6 = this.charK;
                    n3 = this.byteinx;
                    n4 = this.lastbyte;
                } else {
                    n6 = this.getCharClass(n5);
                }
            }
            if ((n = nArray2[(n << 5) + n6]) > 99) break;
            if (n > 32) {
                cArray[n2++] = (char)n5;
            }
            ++n3;
        }
        if (n > 104) {
            ++n3;
        }
        this.byteinx = n3;
        this.host.charinx = n2;
        return n - 100;
    }

    @Override
    int parseAttrValue(int n) throws XMLStreamException {
        int[] nArray = charTable;
        int[] nArray2 = lextbl32;
        char[] cArray = this.host.charBuffer;
        int n2 = 0;
        int n3 = this.byteinx;
        int n4 = this.lastbyte;
        while (true) {
            int n5;
            int n6;
            if (n3 > this.lastbyte) {
                if (this.readBuffer(4) <= 0) {
                    this.host.error0(193);
                }
                n3 = this.byteinx;
                n4 = this.lastbyte;
            }
            int n7 = n6 = (n5 = this.inBuffer[n3]) < 256 ? nArray[n5] : 101;
            if (n6 >= 100) {
                if (n5 == 13) {
                    n5 = 10;
                    if (this.inBuffer[n3 + 1] == '\n') {
                        ++n3;
                    }
                } else if (n5 == 10) {
                    this.curlineinx = n3;
                    ++this.curline;
                    n6 = 12;
                } else {
                    n5 = this.getMultibyteChar(n3, n);
                    n3 = this.byteinx;
                    n4 = this.lastbyte;
                    n6 = 25;
                }
            }
            if ((n = nArray2[(n << 5) + n6]) > 99) break;
            if (n > 32) {
                cArray[n2++] = (char)n5;
            }
            ++n3;
        }
        if (n != 117) {
            ++n3;
        }
        this.byteinx = n3;
        this.host.charinx = n2;
        return n - 100;
    }

    @Override
    public int nextDTDToken(int n, int n2) throws XMLStreamException {
        int n3;
        int[] nArray = charTable;
        int[] nArray2 = dtdlextbl32;
        char[] cArray = this.host.charBuffer;
        int n4 = this.byteinx;
        int n5 = this.lastbyte;
        n2 = 0;
        while (true) {
            int n6;
            if (n4 > n5) {
                if (this.readBuffer(3) <= 0) {
                    return 21;
                }
                n4 = this.byteinx;
                n5 = this.lastbyte;
            }
            int n7 = (n6 = this.inBuffer[n4]) < 128 ? dtdUTF8table[n6] : (n3 = n6 < 256 ? nArray[n6] : 101);
            if (n3 > 99) {
                if (n6 == 10) {
                    this.curlineinx = n4;
                    ++this.curline;
                    n3 = 12;
                } else if (n6 == 13) {
                    n6 = 10;
                    if (this.inBuffer[n4 + 1] == '\n') {
                        // empty if block
                    }
                    this.curlineinx = ++n4;
                    ++this.curline;
                    n3 = 12;
                } else {
                    n3 = n6 == 38 ? 31 : this.getCharClass(n6);
                }
            }
            if ((n = nArray2[(n << 5) + n3]) > 99) break;
            if (n > 12) {
                cArray[n2++] = (char)n6;
            }
            ++n4;
        }
        this.byteinx = n <= 133 || n3 == 12 ? n4 + 1 : n4;
        this.host.charinx = n2;
        return n - 100;
    }

    protected int getMultibyteChar(int n, int n2) throws XMLStreamException {
        return this.parseCharRef(n);
    }

    @Override
    public void scanXMLDecl() {
    }

    @Override
    public int nextChar() {
        char c;
        if (this.byteinx > this.lastbyte && this.readBuffer(4) <= 0) {
            return -1;
        }
        if ((c = this.inBuffer[this.byteinx++]) == '\n') {
            ++this.curline;
            this.curlineinx = this.byteinx;
        }
        return c;
    }

    @Override
    void pushBytes(int[] nArray, int n, int n2) {
    }

    protected int readBuffer(int n) {
        if (this.bufsize < 8192) {
            return 0;
        }
        this.byteinx = 0;
        try {
            this.bufsize = this.rdr.read(this.inBuffer, 0, 8192);
            if (this.bufsize < 8192) {
                this.rdr.close();
            }
        }
        catch (IOException iOException) {
            this.bufsize = 0;
        }
        this.lastbyte = this.bufsize - 1;
        return this.bufsize;
    }
}

