/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pullparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDTDStreamReader;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.pullparser.DTDByteLexer;
import oracle.xml.pullparser.DTDCharLexer;
import oracle.xml.pullparser.DTDUTF8Lexer;
import oracle.xml.pullparser.SymTable;
import oracle.xml.pullparser.XMLByteLexer;
import oracle.xml.pullparser.XMLCharLexer;
import oracle.xml.pullparser.XMLLexer;
import oracle.xml.pullparser.XMLLexerLib;
import oracle.xml.pullparser.XMLPullParserConstants;
import oracle.xml.pullparser.XMLUTF8Lexer;

public class XMLCoreStreamReader
implements XMLPullParserConstants {
    XMLUTF8Lexer utf8lex = null;
    XMLCharLexer charlex = null;
    XMLByteLexer bytelex = null;
    XMLLexer lexer = null;
    public XMLError err;
    boolean hasnext;
    int event;
    int next;
    XMLDTDStreamReader dtdreader = null;
    public DTD dtd;
    String sysId;
    String pubId;
    String dtdtag;
    private String string_empty;
    private String string_xml;
    private String string_xmlns;
    private static final int ELEM_STACK_SIZE = 128;
    private static final int ATTR_STACK_SIZE = 384;
    Element elem;
    private Element[] elemstack;
    private int elemstacksize;
    private int elemstacksp;
    protected Attribute[] attrstack;
    private int attrstacksize;
    protected int attrstacksp;
    protected Attribute[] nsstack;
    private int nsstacksize;
    protected int nsstacksp;
    protected Attribute attrdns;
    private Attribute attr;
    private static final int ATTR = 0;
    private static final int DEFAULT_NS_ATTR = 1;
    private static final int NS_ATTR = 2;
    String piTarget;
    String piData;
    private int declInx;
    private char[] attrValue = new char[128];
    static final boolean T = true;
    static final boolean F = false;
    static final boolean[] whiteSpaceChar = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    static final char[] cDOCUMENT = new char[]{'#', 'd', 'o', 'c', 'u', 'm', 'e', 'n', 't'};
    static final char[] cENCODING = new char[]{'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g'};
    static final char[] cVERSION = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n'};
    static final char[] cSTANDALONE = new char[]{'s', 't', 'a', 'n', 'd', 'a', 'l', 'o', 'n', 'e'};
    static final char[] cDOCTYPE = new char[]{'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    static final int[] CP037ToUTF8 = new int[]{-1, -1, -1, -1, -1, 9, -1, -1, -1, -1, -1, -1, -1, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46, 60, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 95, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, -1, -1, 34, 61, 34, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, -1, -1, -1, -1, -1, -1, -1, 106, 107, 108, 109, 110, 111, 112, 113, 114, -1, -1, -1, -1, -1, -1, -1, -1, 115, 116, 117, 118, 119, 120, 121, 122, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, -1, -1, -1, -1, -1, -1, -1, 74, 75, 76, 77, 78, 79, 80, 81, 82, -1, -1, -1, -1, -1, -1, -1, -1, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -1, -1, -1, -1, -1};
    private static final String[] intToString = new String[]{"error", "STagCNameAttr", "STagQNameAttr", "ws", "chars", "STagCName", "STagETagCName", "STagQName", "STagETagQName", "ETag", "comment", "CDATA", "PI", "attrNS", "attrDNS", "attrCName", "attrQName", "literal", "literalSTagETag", "literalSTag", "doctype", "end", "plus", "star", "qmark", "strlit", "comma", "or", "lpar", "rpar", "lsqb", "rsqb", "lg", "percent", "markup", "pCName", "CName", "QName", "PERef", "condSect", "NMToken", "markElement", "markAttlist", "markEntity", "markNotation", "condIgnore", "condInclude", "pPCdata", "pRequired", "pImplied", "pFixed", "invalid"};
    String xmlDeclVersion = null;
    String xmlDeclStandalone = null;
    String xmlDeclEncoding = null;
    String publicId = null;
    String systemId = null;
    String encoding = null;
    boolean xmlDecl = false;
    boolean standalone = false;
    private static final int CHARBUF_SIZE = 24576;
    protected char[] charBuffer = new char[24576];
    protected int charinx;
    private static final int DEFAULT_HASHSIZE_BIG = 600;
    SymTable names = new SymTable(600);
    private int runnum;

    public XMLCoreStreamReader() {
        this.string_xml = this.names.create("xml");
        this.string_xmlns = this.names.create("xmlns");
        this.string_empty = this.names.create("");
        this.initStacks();
        this.runnum = 0;
        this.err = new XMLError();
    }

    public void set(InputStream inputStream, String string, String string2) throws XMLStreamException {
        this.reset();
        this.systemId = string2;
        this.lexer = this.getLexer(inputStream, string2, null, string);
        this.lexer.open();
        this.next = 7;
    }

    public void set(Reader reader, String string) throws XMLStreamException {
        this.reset();
        this.systemId = string;
        this.lexer = this.setCharLexer(reader);
        this.lexer.open();
        this.next = 7;
    }

    public void set(String string) throws XMLStreamException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.set(fileInputStream, null, null);
        }
        catch (Exception exception) {
            throw new XMLStreamException(exception.toString());
        }
    }

    public void reset() {
        this.resetStacks();
        this.hasnext = true;
        this.next = -1;
        this.event = 7;
        this.xmlDeclVersion = null;
        this.xmlDeclStandalone = null;
        this.xmlDeclEncoding = null;
        this.publicId = null;
        this.systemId = null;
        this.encoding = null;
        this.xmlDecl = false;
        this.standalone = false;
        this.dtd = null;
        ++this.runnum;
        if (this.runnum >= 1000) {
            this.names = new SymTable(600);
            this.string_xml = this.names.create("xml");
            this.string_xmlns = this.names.create("xmlns");
            this.string_empty = this.names.create("");
            this.runnum = 0;
        }
    }

    public int next() throws XMLStreamException {
        if (this.next >= 0) {
            this.event = this.next;
            this.next = -1;
            return this.event;
        }
        int n = this.lexer.nextToken(0, 0);
        switch (n) {
            case 9: {
                this.popElem();
                char[] cArray = this.elem.chars;
                if (cArray.length != this.charinx) {
                    this.error1(121, new String(cArray));
                } else {
                    for (int i = 0; i < this.charinx; ++i) {
                        if (this.charBuffer[i] == cArray[i]) continue;
                        this.error1(121, new String(cArray));
                    }
                }
                this.event = 2;
                return 2;
            }
            case 3: {
                if (this.elemstacksp == 0) {
                    return this.next();
                }
                this.event = 6;
                return 6;
            }
            case 5: {
                this.pushElemName();
                this.event = 1;
                return 1;
            }
            case 4: {
                this.event = 4;
                return 4;
            }
            case 6: {
                this.pushElemName();
                --this.elemstacksp;
                this.next = 2;
                this.event = 1;
                return 1;
            }
            case 1: {
                this.pushElemName();
                return this.parseAttributes(false);
            }
            case 2: {
                this.pushElemQName();
                return this.parseAttributes(true);
            }
            case 7: {
                this.pushElemQName();
                this.resolvePrefixes();
                this.event = 1;
                return 1;
            }
            case 8: {
                this.pushElemQName();
                this.resolvePrefixes();
                --this.elemstacksp;
                this.next = 2;
                this.event = 1;
                return 1;
            }
            case 10: {
                this.charinx -= 2;
                this.event = 5;
                return 5;
            }
            case 11: {
                this.charinx -= 2;
                this.event = 12;
                return 12;
            }
            case 12: {
                int n2;
                --this.charinx;
                for (n2 = 0; n2 < this.charinx && this.charBuffer[n2] != ' '; ++n2) {
                }
                this.piTarget = new String(this.charBuffer, 0, n2);
                this.piData = new String(this.charBuffer, n2 + 1, this.charinx - n2 - 1);
                this.event = 3;
                return 3;
            }
            case 20: {
                if (cDOCTYPE.length != this.charinx) {
                    this.error1(100, "DOCTYPE");
                } else {
                    for (int i = 0; i < this.charinx; ++i) {
                        if (this.charBuffer[i] == cDOCTYPE[i]) continue;
                        this.error1(100, "DOCTYPE");
                    }
                }
                this.parseDoctypeDecl();
                if (this.lexer instanceof XMLUTF8Lexer) {
                    this.lexer = new DTDUTF8Lexer((XMLUTF8Lexer)this.lexer);
                } else if (this.lexer instanceof XMLByteLexer) {
                    this.lexer = new DTDByteLexer((XMLByteLexer)this.lexer);
                } else if (this.lexer instanceof XMLCharLexer) {
                    this.lexer = new DTDCharLexer((XMLCharLexer)this.lexer);
                }
                return 11;
            }
            case 21: {
                this.hasnext = false;
                this.event = 8;
                return 8;
            }
            case 0: {
                this.error0(197);
                return 8;
            }
        }
        this.error1(198, "Internal error");
        return 8;
    }

    int parseAttributes(boolean bl) throws XMLStreamException {
        this.event = 1;
        while (true) {
            int n = this.lexer.nextToken(46, 0);
            block0 : switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.error0(197);
                    break;
                }
                case 15: {
                    this.pushAttrName();
                    switch (this.lexer.parseAttrValue(24)) {
                        case 19: {
                            this.pushAttrValue();
                            if (bl) {
                                this.resolvePrefixes();
                            }
                            return 1;
                        }
                        case 17: {
                            this.pushAttrValue();
                            break block0;
                        }
                        case 18: {
                            this.pushAttrValue();
                            if (bl) {
                                this.resolvePrefixes();
                            }
                            this.popElem();
                            this.next = 2;
                            return 1;
                        }
                    }
                    break;
                }
                case 13: {
                    this.pushNSAttr();
                    switch (this.lexer.parseAttrValue(24)) {
                        case 19: {
                            this.pushAttrValue();
                            if (bl) {
                                this.resolvePrefixes();
                            }
                            return 1;
                        }
                        case 17: {
                            this.pushAttrValue();
                            break block0;
                        }
                        case 18: {
                            this.pushAttrValue();
                            if (bl) {
                                this.resolvePrefixes();
                            }
                            this.popElem();
                            this.next = 2;
                            return 1;
                        }
                    }
                    break;
                }
                case 14: {
                    this.pushDefaultNSAttr();
                    switch (this.lexer.parseAttrValue(24)) {
                        case 17: {
                            this.pushAttrValue();
                            if (this.elem.prefix != null) break;
                            this.elem.ns = this.attrdns.value;
                            break block0;
                        }
                        case 19: {
                            this.pushAttrValue();
                            if (this.elem.prefix == null) {
                                this.elem.ns = this.attrdns.value;
                            }
                            if (bl) {
                                this.resolvePrefixes();
                            }
                            return 1;
                        }
                        case 18: {
                            this.pushAttrValue();
                            if (this.elem.prefix == null) {
                                this.elem.ns = this.attrdns.value;
                            }
                            if (bl) {
                                this.resolvePrefixes();
                            }
                            this.popElem();
                            this.next = 2;
                            return 1;
                        }
                    }
                    break;
                }
                case 16: {
                    this.pushAttrQName();
                    bl = true;
                    switch (this.lexer.parseAttrValue(24)) {
                        case 17: {
                            this.pushAttrValue();
                            break block0;
                        }
                        case 19: {
                            this.pushAttrValue();
                            if (bl) {
                                this.resolvePrefixes();
                            }
                            return 1;
                        }
                        case 18: {
                            this.pushAttrValue();
                            if (bl) {
                                this.resolvePrefixes();
                            }
                            this.popElem();
                            this.next = 2;
                            return 1;
                        }
                    }
                    break;
                }
                case 21: {
                    this.error0(122);
                }
            }
        }
    }

    DTD parseDoctypeDecl() throws XMLStreamException {
        if (this.dtdreader == null) {
            this.dtdreader = new XMLDTDStreamReader();
        }
        this.dtd = this.dtdreader.parseDTD(this.lexer, this);
        return this.dtd;
    }

    private void resetStacks() {
        this.elemstacksp = 0;
        this.attrstacksp = 0;
        this.nsstacksp = 1;
        this.attrdns = this.nsstack[0];
    }

    private void initStacks() {
        this.elemstacksp = 0;
        this.elemstacksize = 128;
        this.elemstack = new Element[this.elemstacksize];
        this.attrstacksp = 0;
        for (int i = 0; i < this.elemstacksize; ++i) {
            this.elemstack[i] = new Element();
        }
        SymTable.Entry entry = this.names.createEntry(cDOCUMENT, 0, 9);
        this.elemstack[0].name = entry.key;
        this.elemstack[0].chars = entry.keyChars;
        this.elemstack[0].local = entry.key;
        this.elemstack[0].prefix = null;
        this.elemstack[0].attrinx = 0;
        this.elemstack[0].nsattrnum = 1;
        this.nsstacksize = 384;
        this.attrstacksize = 384;
        this.attrstack = new Attribute[this.attrstacksize];
        this.nsstack = new Attribute[this.nsstacksize];
        for (int i = 0; i < this.attrstacksize; ++i) {
            this.attrstack[i] = new Attribute(i);
            this.nsstack[i] = new Attribute(i);
        }
        this.attrstacksp = 0;
        Attribute attribute = this.nsstack[1];
        attribute.name = this.names.create("xmlns:xml");
        attribute.local = this.string_xml;
        attribute.prefix = this.string_xmlns;
        attribute.value = "http://www.w3.org/XML/1998/namespace";
        attribute.prev = null;
        this.attrdns = this.nsstack[0];
        this.attrdns.value = this.string_empty;
        this.attrdns.local = this.string_empty;
        this.attrdns.name = this.string_xmlns;
        this.attrdns.prefix = this.string_empty;
        this.attrdns.prev = null;
        this.nsstacksp = 1;
    }

    private void pushElemName() {
        ++this.elemstacksp;
        Element element = this.elem = this.elemstack[this.elemstacksp];
        element = this.elem;
        SymTable.Entry entry = this.names.createEntry(this.charBuffer, 0, this.charinx);
        element.name = entry.key;
        element.chars = entry.keyChars;
        element.local = element.name;
        element.prefix = null;
        element.ns = this.attrdns.value;
        element.attrinx = this.attrstacksp;
        element.nsinx = this.nsstacksp;
        element.attrnum = 0;
        element.nsattrnum = 0;
    }

    private void pushElemQName() {
        ++this.elemstacksp;
        Element element = this.elem = this.elemstack[this.elemstacksp];
        SymTable.Entry entry = this.names.createEntry(this.charBuffer, 0, this.charinx);
        element.name = entry.key;
        element.chars = entry.keyChars;
        int n = element.name.indexOf(58);
        element.prefix = this.names.create(this.charBuffer, 0, n);
        element.local = new String(this.charBuffer, n + 1, this.charinx - n - 1);
        element.attrinx = this.attrstacksp;
        element.nsinx = this.nsstacksp;
        element.attrnum = 0;
        element.nsattrnum = 0;
    }

    private void popElem() {
        Element element = this.elem = this.elemstack[this.elemstacksp];
        if (this.attrdns.id > element.nsinx) {
            this.attrdns = this.attrdns.prev;
        }
        this.attrstacksp = element.attrinx;
        this.nsstacksp = element.nsinx;
        --this.elemstacksp;
    }

    private void pushAttrName() throws XMLStreamException {
        String string;
        Attribute attribute = this.attrstack[this.attrstacksp + 1];
        attribute.name = string = this.names.create(this.charBuffer, 0, this.charinx);
        attribute.local = string;
        attribute.prefix = null;
        attribute.ns = this.string_empty;
        if (this.elem.attrnum > 0) {
            for (int i = this.elem.attrinx + 1; i <= this.attrstacksp; ++i) {
                if (this.attrstack[i].name != attribute.name) continue;
                this.error1(196, string);
            }
        }
        this.attr = attribute;
        ++this.elem.attrnum;
        ++this.attrstacksp;
    }

    private void pushAttrQName() throws XMLStreamException {
        Attribute attribute = this.attrstack[this.attrstacksp + 1];
        String string = this.names.create(this.charBuffer, 0, this.charinx);
        int n = string.indexOf(58);
        attribute.name = string;
        attribute.prefix = this.names.create(this.charBuffer, 0, n);
        attribute.local = new String(this.charBuffer, n + 1, this.charinx - n - 1);
        if (this.elem.attrnum > 0) {
            for (int i = this.elem.attrinx + 1; i <= this.attrstacksp; ++i) {
                if (this.attrstack[i].name != attribute.name) continue;
                this.error1(96, string);
            }
        }
        this.attr = attribute;
        ++this.elem.attrnum;
        ++this.attrstacksp;
    }

    private void pushNSAttr() throws XMLStreamException {
        String string;
        Attribute attribute = this.nsstack[this.nsstacksp + 1];
        attribute.name = string = this.names.create(this.charBuffer, 0, this.charinx);
        attribute.local = this.names.create(this.charBuffer, 6, this.charinx - 6);
        attribute.prefix = this.string_xmlns;
        if (this.elem.nsattrnum > 0) {
            for (int i = this.elem.nsinx + 1; i <= this.nsstacksp; ++i) {
                if (this.nsstack[i].name != attribute.name) continue;
                this.error1(196, string);
            }
        }
        this.attr = attribute;
        ++this.elem.nsattrnum;
        ++this.nsstacksp;
    }

    private void pushDefaultNSAttr() throws XMLStreamException {
        Attribute attribute = this.nsstack[this.nsstacksp + 1];
        if (this.attrdns.id > this.elem.nsinx) {
            this.error0(124);
        }
        attribute.name = this.string_xmlns;
        attribute.local = this.string_empty;
        attribute.prefix = this.string_empty;
        attribute.prev = this.attrdns;
        this.attrdns = attribute;
        ++this.elem.nsattrnum;
        ++this.nsstacksp;
        this.attr = attribute;
    }

    private void pushAttrValue() {
        this.attr.value = new String(this.charBuffer, 0, this.charinx);
    }

    void resolvePrefixes() throws XMLStreamException {
        Attribute attribute;
        int n;
        if (this.elem.prefix != null) {
            for (n = this.nsstacksp; n >= 0; --n) {
                attribute = this.nsstack[n];
                if (this.elem.prefix != attribute.local) continue;
                this.elem.ns = attribute.value;
                break;
            }
            if (n < 0) {
                this.error1(129, this.elem.prefix);
            }
        }
        if (this.elem.attrnum > 0) {
            for (int i = this.elem.attrinx + 1; i <= this.attrstacksp; ++i) {
                Attribute attribute2 = this.attrstack[i];
                if (attribute2.prefix == null) continue;
                for (n = this.nsstacksp; n >= 0; --n) {
                    attribute = this.nsstack[n];
                    if (attribute2.prefix != attribute.local) continue;
                    attribute2.ns = attribute.value;
                    break;
                }
                if (n >= 0) continue;
                this.error1(129, attribute2.prefix);
            }
        }
    }

    XMLLexer setCharLexer(Reader reader) {
        if (this.charlex == null) {
            this.charlex = new XMLCharLexer(this);
        }
        this.charlex.set(reader);
        return this.charlex;
    }

    XMLLexer setCharLexer(InputStream inputStream, String string) throws XMLStreamException {
        if (this.charlex == null) {
            this.charlex = new XMLCharLexer(this);
        }
        this.charlex.set(inputStream, string);
        return this.charlex;
    }

    XMLLexer setUTF8Lexer(InputStream inputStream) throws XMLStreamException {
        if (this.utf8lex == null) {
            this.utf8lex = new XMLUTF8Lexer(this);
        }
        this.utf8lex.set(inputStream, this.encoding);
        return this.utf8lex;
    }

    XMLLexer setByteLexer(XMLLexer xMLLexer, String string) throws XMLStreamException {
        if (this.bytelex == null) {
            this.bytelex = new XMLByteLexer(this);
        }
        this.bytelex.set(xMLLexer, string);
        return this.bytelex;
    }

    XMLLexer setByteLexer(InputStream inputStream, String string) throws XMLStreamException {
        if (this.bytelex == null) {
            this.bytelex = new XMLByteLexer(this);
        }
        if (!this.bytelex.set(inputStream, string)) {
            this.error1(66, string);
        }
        return this.bytelex;
    }

    XMLLexer setByteLexer(InputStream inputStream, int[] nArray) throws XMLStreamException {
        if (this.bytelex == null) {
            this.bytelex = new XMLByteLexer(this);
        }
        this.bytelex.set(inputStream, nArray);
        return this.bytelex;
    }

    XMLLexer getLexer(InputStream inputStream, String string, String string2, String string3) throws XMLStreamException {
        try {
            int[] nArray = new int[]{-1, -1, -1, -1, -1, -1};
            int n = 4;
            int n2 = 0;
            int n3 = nArray[0] = inputStream.read();
            int n4 = nArray[1] = inputStream.read();
            int n5 = nArray[2] = inputStream.read();
            int n6 = nArray[3] = inputStream.read();
            XMLLexer xMLLexer = null;
            if (n3 == 60 && n4 == 63 && n5 == 120 && n6 == 109) {
                nArray[4] = inputStream.read();
                int n7 = nArray[5] = inputStream.read();
                if (nArray[4] == 108 && whiteSpaceChar[n7 & 0x7F] && n7 < 127) {
                    char[] cArray = this.charBuffer;
                    n = 0;
                    while (true) {
                        int n8;
                        if ((n8 = inputStream.read()) == 63) {
                            n8 = inputStream.read();
                            if (n8 == 62) break;
                            this.error1(100, "?>");
                            break;
                        }
                        cArray[n++] = (char)n8;
                    }
                    cArray[n] = 65535;
                    this.parseXMLDecl(cArray, 0);
                    if (this.xmlDeclEncoding == null) {
                        this.xmlDeclEncoding = string3;
                    }
                    if (this.xmlDeclEncoding == null || this.xmlDeclEncoding.toUpperCase().equals("UTF8") || this.xmlDeclEncoding.toUpperCase().equals("UTF-8")) {
                        this.encoding = "UTF-8";
                        return this.setUTF8Lexer(inputStream);
                    }
                    this.encoding = this.xmlDeclEncoding;
                    int[] nArray2 = XMLLexerLib.getDecodingTable(this.xmlDeclEncoding);
                    return nArray2 != null ? this.setByteLexer(inputStream, nArray2) : this.setCharLexer(inputStream, this.encoding);
                }
                this.encoding = "UTF-8";
                xMLLexer = this.setUTF8Lexer(inputStream);
                xMLLexer.pushBytes(nArray, 0, 6);
                return xMLLexer;
            }
            if (n3 == 60 && n4 != 0) {
                int[] nArray3 = null;
                if (string3 != null) {
                    nArray3 = XMLLexerLib.getDecodingTable(string3);
                }
                if (nArray3 != null) {
                    this.encoding = string3;
                    xMLLexer = this.setByteLexer(inputStream, nArray3);
                } else {
                    this.encoding = "UTF-8";
                    xMLLexer = this.setUTF8Lexer(inputStream);
                }
                xMLLexer.pushBytes(nArray, 0, 4);
                return xMLLexer;
            }
            if (n3 == 239 && n4 == 187 && n5 == 191) {
                this.encoding = "UTF-8";
                xMLLexer = this.setUTF8Lexer(inputStream);
                xMLLexer.pushBytes(nArray, 3, 4);
                return xMLLexer;
            }
            if (nArray[0] == 76 && nArray[1] == 111 && nArray[2] == 167 && nArray[3] == 148) {
                nArray[4] = inputStream.read();
                nArray[5] = inputStream.read();
                int n9 = CP037ToUTF8[nArray[4]];
                int n10 = CP037ToUTF8[nArray[5]];
                if (n9 == 108 && whiteSpaceChar[n10 & 0x7F] && n10 < 127) {
                    char[] cArray = this.charBuffer;
                    n = 0;
                    while (true) {
                        int n11;
                        if ((n11 = CP037ToUTF8[inputStream.read()]) == 63) {
                            n11 = CP037ToUTF8[inputStream.read()];
                            if (n11 == 62) break;
                            this.error1(100, "?>");
                            break;
                        }
                        cArray[n++] = (char)n11;
                    }
                    cArray[n] = 65535;
                    this.parseXMLDecl(cArray, 0);
                    this.encoding = this.xmlDeclEncoding != null ? this.xmlDeclEncoding : "EBCDIC";
                    int[] nArray4 = XMLLexerLib.getDecodingTable(this.encoding);
                    return nArray4 != null ? this.setByteLexer(inputStream, nArray4) : this.setCharLexer(inputStream, this.encoding);
                }
                this.encoding = "EBCDIC";
                xMLLexer = this.setByteLexer(inputStream, this.encoding);
                xMLLexer.pushBytes(nArray, 0, 6);
                return xMLLexer;
            }
            if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 60 || nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 254 && nArray[3] == 255) {
                this.encoding = "UCS-4";
                if (nArray[3] == 255) {
                    n2 = 4;
                }
                xMLLexer = this.setCharLexer(inputStream, this.encoding);
            } else if (nArray[0] == 60 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0 || nArray[0] == 255 && nArray[1] == 254 && nArray[2] == 0 && nArray[3] == 0) {
                this.encoding = "UCS-4";
                if (nArray[0] == 255) {
                    n2 = 4;
                }
                xMLLexer = this.setCharLexer(inputStream, this.encoding);
            } else if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 60 && nArray[3] == 0 || nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 255 && nArray[3] == 254) {
                this.encoding = "UCS-4";
                if (nArray[2] == 255) {
                    n2 = 4;
                }
                xMLLexer = this.setCharLexer(inputStream, this.encoding);
            } else if (nArray[0] == 0 && nArray[1] == 60 && nArray[2] == 0 && nArray[3] == 0 || nArray[0] == 254 && nArray[1] == 255 && nArray[2] == 0 && nArray[3] == 0) {
                this.encoding = "UCS-4";
                if (nArray[1] == 255) {
                    n2 = 4;
                }
                xMLLexer = this.setCharLexer(inputStream, this.encoding);
            } else if (nArray[0] == 0 && nArray[1] == 60 && nArray[2] == 0 && nArray[3] == 63) {
                this.encoding = "UCS-2";
                xMLLexer = this.setCharLexer(inputStream, this.encoding);
            } else if (nArray[0] == 60 && nArray[1] == 0 && nArray[2] == 63 && nArray[3] == 0) {
                this.encoding = "UCS-2";
                xMLLexer = this.setCharLexer(inputStream, this.encoding);
            } else if (nArray[0] == 254 && nArray[1] == 255) {
                this.encoding = "UTF-16";
                n2 = 2;
                xMLLexer = this.setCharLexer(inputStream, this.encoding);
            } else if (nArray[0] == 255 && nArray[1] == 254) {
                this.encoding = "UTF-16";
                n2 = 2;
                xMLLexer = this.setCharLexer(inputStream, this.encoding);
            } else {
                this.error1(241, string);
            }
            if (n2 < 4) {
                xMLLexer.pushBytes(nArray, n2, n);
            }
        }
        catch (IOException iOException) {
            this.error1(241, string);
        }
        return null;
    }

    private void checkForXMLDecl() throws XMLStreamException {
    }

    private String getAttrValue(char[] cArray, char[] cArray2, int n) throws XMLStreamException {
        int n2 = 0;
        while (n2 < cArray2.length) {
            if (cArray[n] != cArray2[n2]) {
                this.error1(100, new String(cArray2));
            }
            ++n2;
            ++n;
        }
        char c = cArray[n];
        while (whiteSpaceChar[c & 0x7F] && c < '\u007f') {
            c = cArray[++n];
        }
        if (c != '=') {
            this.error1(100, "=");
        }
        c = cArray[++n];
        while (whiteSpaceChar[c & 0x7F] && c < '\u007f') {
            c = cArray[++n];
        }
        char c2 = c;
        char[] cArray3 = this.attrValue;
        if (c2 != '\"' && c2 != '\'') {
            this.error2(206, "'", "\"");
        }
        n2 = 0;
        while ((c = cArray[++n]) != c2) {
            if (c == '\uffffffff' || n2 >= 128) {
                this.error1(198, "Invalid attribute value");
            }
            cArray3[n2++] = c;
        }
        this.declInx = n;
        return new String(cArray3, 0, n2);
    }

    private void parseXMLDecl(char[] cArray, int n) throws XMLStreamException {
        char c = cArray[n];
        while (whiteSpaceChar[c & 0x7F] && c < '\u007f') {
            c = cArray[++n];
        }
        this.xmlDeclVersion = this.getAttrValue(cArray, cVERSION, n);
        if (!this.xmlDeclVersion.equals("1.0")) {
            this.error1(100, "version '1.0'");
        }
        n = this.declInx;
        c = cArray[++n];
        while (whiteSpaceChar[c & 0x7F] && c < '\u007f') {
            c = cArray[++n];
        }
        if (c == cENCODING[0]) {
            this.xmlDeclEncoding = this.getAttrValue(cArray, cENCODING, n);
            n = this.declInx;
            c = cArray[++n];
            while (whiteSpaceChar[c & 0x7F] && c < '\u007f') {
                c = cArray[++n];
            }
        }
        if (c == cSTANDALONE[0]) {
            this.xmlDeclStandalone = this.getAttrValue(cArray, cSTANDALONE, n);
            if (this.xmlDeclStandalone.equals("yes")) {
                this.standalone = true;
            } else if (this.xmlDeclStandalone.equals("no")) {
                this.standalone = false;
            } else {
                this.error2(202, "standalone", "'yes' or 'no'");
            }
        }
        n = this.declInx;
        c = cArray[++n];
        while (whiteSpaceChar[c & 0x7F] && c < '\u007f') {
            c = cArray[++n];
        }
        if (c != '\uffff') {
            this.error1(100, "?>");
        }
    }

    void setEncoding(String string) throws XMLStreamException {
    }

    URL createURL(String string) throws MalformedURLException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Cannot create url for: " + string);
                System.exit(0);
            }
        }
        return uRL;
    }

    InputStream openURL(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            if (uRL.getProtocol().toLowerCase().equals("file")) {
                String string = uRL.getFile();
                inputStream = new FileInputStream(string);
            } else {
                inputStream = uRL.openStream();
            }
        }
        catch (Exception exception) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    public void error0(int n) throws XMLStreamException {
        String string = this.formatErrorMessage(this.err.getMessage0(n), n);
        throw new XMLStreamException(string);
    }

    public void error1(int n, String string) throws XMLStreamException {
        String string2 = this.formatErrorMessage(this.err.getMessage1(n, string), n);
        throw new XMLStreamException(string2);
    }

    public void error2(int n, String string, String string2) throws XMLStreamException {
        String string3 = this.formatErrorMessage(this.err.getMessage2(n, string, string2), n);
        throw new XMLStreamException(string3);
    }

    String formatErrorMessage(String string, int n) {
        int n2 = this.lexer != null ? this.lexer.getLine() : 0;
        int n3 = this.lexer != null ? this.lexer.getPosition() : 0;
        return "at [" + n2 + ", " + n3 + "] " + "XML-20" + n + ": " + string;
    }

    void printTokState(int n) {
        if (n == 21) {
            System.out.println("tokEnd");
        } else {
            String string = new String(this.charBuffer, 0, this.charinx);
            System.out.println(intToString[n] + ": '" + string + "'");
        }
    }

    class Attribute {
        String name;
        String local;
        String prefix;
        String ns;
        String value;
        Attribute prev;
        int id;

        Attribute(int n) {
            this.id = n;
            this.name = null;
            this.local = null;
            this.prefix = null;
            this.prev = null;
        }

        void print() {
            System.out.println(this.name + "='" + this.value + "'");
        }
    }

    class Element {
        String name = null;
        String local = null;
        String prefix = null;
        String ns;
        int attrinx = 0;
        int nsinx;
        int attrnum = 0;
        int nsattrnum = 0;
        char[] chars;

        Element() {
        }

        void print() {
            System.out.print("<" + this.name);
            int n = this.attrinx + this.attrnum + this.nsattrnum;
            for (int i = this.attrinx + 1; i <= n; ++i) {
                Attribute attribute = XMLCoreStreamReader.this.attrstack[i];
                System.out.print(" " + attribute.name + "='" + attribute.value + "'");
            }
            System.out.println(">");
            if (XMLCoreStreamReader.this.attrdns != null) {
                System.out.println("    ATTRDNS: " + XMLCoreStreamReader.this.attrdns.name + "=" + XMLCoreStreamReader.this.attrdns.value);
            }
        }
    }
}

