/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pullparser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import oracle.xml.pullparser.XMLCoreStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLSAXParser
extends XMLCoreStreamReader
implements XMLReader,
Attributes {
    boolean features_namespaces = true;
    boolean features_namespace_prefixes = false;
    EntityResolver entRslvr = null;
    ErrorHandler errHndl = null;
    DTDHandler dtdHndl = null;
    ContentHandler contHndl = null;
    DocumentHandler docHndl = null;

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.docHndl = documentHandler;
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return this.features_namespaces;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this.features_namespace_prefixes;
        }
        throw new SAXNotSupportedException(this.err.getMessage1(501, string));
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            this.features_namespaces = bl;
        } else if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this.features_namespace_prefixes = bl;
        } else {
            throw new SAXNotSupportedException(this.err.getMessage1(501, string));
        }
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHndl = dTDHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHndl;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contHndl = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contHndl;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errHndl = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errHndl;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        String string = inputSource.getSystemId();
        String string2 = inputSource.getPublicId();
        try {
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream != null) {
                this.set(inputStream, inputSource.getEncoding(), string);
            } else {
                Reader reader = inputSource.getCharacterStream();
                if (reader != null) {
                    this.set(reader, string);
                } else if (string != null) {
                    try {
                        inputStream = this.openURL(new URL(string));
                        this.set(inputStream, null, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.error0(220);
                    }
                } else {
                    this.error0(220);
                }
            }
            this.parse();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException.getMessage());
        }
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        try {
            InputStream inputStream;
            try {
                inputStream = new FileInputStream(string);
            }
            catch (Exception exception) {
                try {
                    inputStream = this.openURL(this.createURL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new XMLStreamException("Can't open: " + string);
                }
            }
            this.set(inputStream, null, string);
            this.parse();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException.getMessage());
        }
    }

    void parse() throws SAXException {
        boolean bl = false;
        try {
            block11: while (!bl) {
                switch (this.next()) {
                    case 7: {
                        if (this.contHndl == null) continue block11;
                        this.contHndl.startDocument();
                        continue block11;
                    }
                    case 8: {
                        if (this.contHndl != null) {
                            this.contHndl.endDocument();
                        }
                        bl = true;
                        continue block11;
                    }
                    case 1: {
                        XMLCoreStreamReader.Attribute attribute;
                        int n;
                        if (this.contHndl == null) continue block11;
                        if (this.features_namespaces) {
                            for (n = 0; n < this.elem.nsattrnum; ++n) {
                                attribute = this.nsstack[this.elem.nsinx + 1 + n];
                                this.contHndl.startPrefixMapping(attribute.local, attribute.value);
                            }
                        }
                        this.contHndl.startElement(this.elem.ns, this.elem.local, this.elem.name, this);
                        continue block11;
                    }
                    case 2: {
                        XMLCoreStreamReader.Attribute attribute;
                        int n;
                        if (this.contHndl == null) continue block11;
                        this.contHndl.endElement(this.elem.ns, this.elem.local, this.elem.name);
                        if (!this.features_namespaces) continue block11;
                        for (n = 0; n < this.elem.nsattrnum; ++n) {
                            attribute = this.nsstack[this.elem.nsinx + 1 + n];
                            this.contHndl.endPrefixMapping(attribute.local);
                        }
                        continue block11;
                    }
                    case 6: {
                        if (this.contHndl == null) continue block11;
                        this.contHndl.ignorableWhitespace(this.charBuffer, 0, this.charinx);
                        continue block11;
                    }
                    case 4: 
                    case 12: {
                        if (this.contHndl == null) continue block11;
                        this.contHndl.characters(this.charBuffer, 0, this.charinx);
                        continue block11;
                    }
                    case 3: {
                        if (this.contHndl == null) continue block11;
                        this.contHndl.processingInstruction(this.piTarget, this.piData);
                        continue block11;
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException.getMessage());
        }
    }

    @Override
    public int getLength() {
        if (this.features_namespace_prefixes) {
            return this.elem.attrnum + this.elem.nsattrnum;
        }
        return this.elem.attrnum;
    }

    @Override
    public String getURI(int n) {
        XMLCoreStreamReader.Attribute attribute = this.getattribute(n);
        if (attribute == null) {
            return null;
        }
        return attribute.ns;
    }

    @Override
    public String getLocalName(int n) {
        XMLCoreStreamReader.Attribute attribute = this.getattribute(n);
        if (attribute == null) {
            return null;
        }
        return attribute.local;
    }

    @Override
    public String getQName(int n) {
        XMLCoreStreamReader.Attribute attribute = this.getattribute(n);
        if (attribute == null) {
            return null;
        }
        return attribute.name;
    }

    @Override
    public String getType(int n) {
        XMLCoreStreamReader.Attribute attribute = this.getattribute(n);
        if (attribute == null) {
            return null;
        }
        return "CDATA";
    }

    @Override
    public String getValue(int n) {
        XMLCoreStreamReader.Attribute attribute = this.getattribute(n);
        if (attribute == null) {
            return null;
        }
        return attribute.value;
    }

    @Override
    public int getIndex(String string, String string2) {
        XMLCoreStreamReader.Attribute attribute;
        int n;
        if (string == null) {
            string = "";
        }
        for (n = 1; n <= this.elem.attrnum; ++n) {
            attribute = this.attrstack[this.elem.attrinx + n];
            if (!attribute.local.equals(string2) || !attribute.ns.equals(string)) continue;
            return n - 1;
        }
        if (this.features_namespace_prefixes) {
            for (n = 1; n <= this.elem.nsattrnum; ++n) {
                attribute = this.nsstack[this.elem.nsinx + n];
                if (!string.equals(attribute.ns) || !string2.equals(attribute.local)) continue;
                return this.elem.attrnum + n - 1;
            }
        }
        return -1;
    }

    @Override
    public int getIndex(String string) {
        XMLCoreStreamReader.Attribute attribute;
        int n;
        for (n = 1; n <= this.elem.attrnum; ++n) {
            attribute = this.attrstack[this.elem.attrinx + n];
            if (!string.equals(attribute.name)) continue;
            return n - 1;
        }
        if (this.features_namespace_prefixes) {
            for (n = 1; n <= this.elem.nsattrnum; ++n) {
                attribute = this.nsstack[this.elem.nsinx + n];
                if (!string.equals(attribute.name)) continue;
                return this.elem.attrnum + n - 1;
            }
        }
        return -1;
    }

    @Override
    public String getType(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (this.getIndex(string, string2) >= 0) {
            return "CDATA";
        }
        return null;
    }

    @Override
    public String getType(String string) {
        if (this.getIndex(string) >= 0) {
            return "CDATA";
        }
        return null;
    }

    @Override
    public String getValue(String string, String string2) {
        XMLCoreStreamReader.Attribute attribute;
        int n;
        if (string == null) {
            string = "";
        }
        for (n = 1; n <= this.elem.attrnum; ++n) {
            attribute = this.attrstack[this.elem.attrinx + n];
            if (!attribute.local.equals(string2) || !attribute.ns.equals(string)) continue;
            return attribute.value;
        }
        if (this.features_namespaces) {
            for (n = 1; n <= this.elem.nsattrnum; ++n) {
                attribute = this.nsstack[this.elem.nsinx + n];
                if (!string.equals(attribute.ns) || !string2.equals(attribute.local)) continue;
                return attribute.value;
            }
        }
        return null;
    }

    @Override
    public String getValue(String string) {
        XMLCoreStreamReader.Attribute attribute;
        int n;
        for (n = 1; n <= this.elem.attrnum; ++n) {
            attribute = this.attrstack[this.elem.attrinx + n];
            if (!string.equals(attribute.name)) continue;
            return attribute.value;
        }
        if (this.features_namespaces) {
            for (n = 1; n <= this.elem.nsattrnum; ++n) {
                attribute = this.nsstack[this.elem.nsinx + n];
                if (!string.equals(attribute.name)) continue;
                return attribute.value;
            }
        }
        return null;
    }

    XMLCoreStreamReader.Attribute getattribute(int n) {
        if (n < 0) {
            return null;
        }
        if (n < this.elem.attrnum) {
            return this.attrstack[this.elem.attrinx + n + 1];
        }
        if (this.features_namespace_prefixes && (n -= this.elem.attrnum) < this.elem.nsattrnum) {
            return this.nsstack[this.elem.nsinx + n + 1];
        }
        return null;
    }
}

