/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pullparser;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import oracle.xml.pullparser.XMLCoreStreamReader;
import oracle.xml.pullparser.XMLLexer;

public class XMLUTF8Lexer
extends XMLLexer
implements XMLStreamConstants {
    protected char[] charBuffer;
    protected static final int[] UTF8table = new int[]{31, 31, 31, 31, 31, 31, 31, 31, 31, 12, 101, 31, 31, 101, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 12, 22, 20, 30, 31, 31, 101, 21, 28, 29, 27, 31, 25, 11, 10, 24, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 19, 31, 13, 23, 14, 18, 31, 7, 9, 5, 6, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 8, 9, 9, 9, 9, 9, 9, 15, 31, 16, 31, 9, 31, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 2, 1, 3, 9, 9, 9, 9, 4, 9, 9, 9, 9, 0, 9, 9, 31, 26, 31, 31, 31, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101};
    protected int charK = 0;
    protected int pushed;

    public XMLUTF8Lexer(XMLCoreStreamReader xMLCoreStreamReader) {
        this.host = xMLCoreStreamReader;
        this.in = null;
        this.charBuffer = this.host.charBuffer;
    }

    @Override
    public boolean set(InputStream inputStream, String string) throws XMLStreamException {
        this.in = inputStream;
        this.pushed = 0;
        this.bufsize = 8192;
        this.totalinx = 0;
        this.curline = 1;
        return true;
    }

    @Override
    public void open() throws XMLStreamException {
        this.readBuffer(0);
    }

    @Override
    public int nextToken(int n, int n2) throws XMLStreamException {
        int[] nArray = UTF8table;
        int[] nArray2 = lextbl32;
        byte[] byArray = this.byteBuffer;
        char[] cArray = this.host.charBuffer;
        int n3 = this.byteinx;
        int n4 = 0;
        try {
            while (true) {
                int n5;
                if ((n5 = nArray[n4 = byArray[n3] & 0xFF]) >= 100) {
                    if (n4 == 10) {
                        this.curlineinx = n3;
                        ++this.curline;
                        n5 = 12;
                    } else if (n4 == 13) {
                        n4 = 10;
                        if (byArray[n3 + 1] == 10) {
                            // empty if block
                        }
                        this.curlineinx = ++n3;
                        ++this.curline;
                        n5 = 12;
                    } else {
                        if (n4 == 255) {
                            return this.checkDocumentEnd(n, n3);
                        }
                        n4 = this.getMultibyteChar(n3, n, n2);
                        n5 = this.charK;
                        n3 = this.byteinx;
                    }
                }
                if ((n = nArray2[(n << 5) + n5]) <= 99) {
                    if (n > 32) {
                        cArray[n2++] = (char)n4;
                    }
                    ++n3;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.readBuffer(n3) <= 0) {
                return this.checkDocumentEnd(n, n3);
            }
            return this.nextToken(n, n2);
        }
        this.byteinx = n > 104 ? n3 + 1 : n3;
        this.host.charinx = n2;
        return n - 100;
    }

    @Override
    int parseAttrValue(int n) throws XMLStreamException {
        int[] nArray = UTF8table;
        int[] nArray2 = lextbl32;
        byte[] byArray = this.byteBuffer;
        char[] cArray = this.host.charBuffer;
        int n2 = 0;
        int n3 = this.byteinx;
        int n4 = this.lastbyte;
        while (true) {
            int n5;
            int n6;
            if (n3 > n4) {
                n4 = this.readBuffer(n3);
                if (n4 <= 0) {
                    this.host.error0(193);
                }
                n3 = this.byteinx;
            }
            if ((n6 = nArray[n5 = byArray[n3]]) >= 100) {
                if (n5 == 10) {
                    this.curlineinx = n3;
                    ++this.curline;
                    n6 = 12;
                } else if (n5 == 13) {
                    n5 = 10;
                    if (byArray[n3 + 1] == 10) {
                        // empty if block
                    }
                    this.curlineinx = ++n3;
                    ++this.curline;
                    n6 = 12;
                } else {
                    n5 = this.getMultibyteChar(n3);
                    n3 = this.byteinx;
                    n4 = this.lastbyte;
                    n6 = 25;
                }
            }
            if ((n = nArray2[(n << 5) + n6]) > 99) break;
            if (n > 32) {
                cArray[n2++] = (char)n5;
            }
            ++n3;
        }
        if (n != 117) {
            ++n3;
        }
        this.byteinx = n3;
        this.host.charinx = n2;
        return n - 100;
    }

    @Override
    public int nextDTDToken(int n, int n2) throws XMLStreamException {
        int n3;
        int[] nArray = dtdUTF8table;
        int[] nArray2 = dtdlextbl32;
        byte[] byArray = this.byteBuffer;
        char[] cArray = this.host.charBuffer;
        int n4 = this.byteinx;
        int n5 = 0;
        try {
            while (true) {
                if ((n3 = nArray[n5 = byArray[n4] & 0xFF]) >= 100) {
                    if (n5 == 10) {
                        this.curlineinx = n4;
                        ++this.curline;
                        n3 = 12;
                    } else if (n5 == 13) {
                        n5 = 10;
                        if (byArray[n4 + 1] == 10) {
                            // empty if block
                        }
                        this.curlineinx = ++n4;
                        ++this.curline;
                        n3 = 12;
                    } else if (n5 == 38) {
                        n3 = 31;
                    } else {
                        if (n5 == 255) {
                            return 21;
                        }
                        n5 = this.getMultibyteChar(n4, n);
                        n3 = this.charK;
                        n4 = this.byteinx;
                    }
                }
                if ((n = nArray2[(n << 5) + n3]) <= 99) {
                    if (n >= 12) {
                        cArray[n2++] = (char)n5;
                    }
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.readBuffer(n4) <= 0) {
                return 21;
            }
            return this.nextDTDToken(n, n2);
        }
        this.byteinx = n <= 133 || n3 == 12 ? n4 + 1 : n4;
        this.host.charinx = n2;
        return n - 100;
    }

    int getMultibyteChar(int n, int n2, int n3) throws XMLStreamException {
        int n4 = 0;
        char c = (char)this.byteBuffer[n];
        if (c == '&') {
            if (n2 == 0 || n2 >= 66) {
                n4 = this.parseCharRef(n);
                this.charK = 25;
            } else {
                this.host.error0(197);
            }
        } else {
            n4 = this.getUTF8Char(n);
            this.charK = this.getCharClass(n4);
        }
        return n4;
    }

    int getMultibyteChar(int n, int n2) throws XMLStreamException {
        int n3 = 0;
        char c = (char)this.byteBuffer[n];
        if (c == '&') {
            if (n2 == 0 || n2 >= 66) {
                n3 = this.parseCharRef(n);
                this.charK = 25;
            } else {
                this.host.error0(197);
            }
        } else {
            n3 = this.getUTF8Char(n);
            this.charK = this.getCharClass(n3);
        }
        return n3;
    }

    int getMultibyteChar(int n) throws XMLStreamException {
        int n2 = 0;
        if (this.byteBuffer[n] == 38) {
            n2 = this.parseCharRef(n);
        } else {
            n2 = this.getUTF8Char(n);
            this.charK = this.getCharClass(n2);
        }
        return n2;
    }

    int getUTF8Char(int n) throws XMLStreamException {
        int n2;
        byte[] byArray = this.byteBuffer;
        if (n + 3 > this.lastbyte) {
            this.pushBytes(n, this.bufsize);
            n = 0;
        }
        if ((byArray[n] & 0xE0) == 192) {
            n2 = ((byArray[n] & 0x1F) << 6) + (byArray[n + 1] & 0x3F);
            if (n2 < 128) {
                this.host.error1(171, Integer.toHexString(n2));
            }
            ++n;
        } else if ((byArray[n] & 0xF0) == 224) {
            n2 = ((byArray[n] & 0xF) << 12) + ((byArray[n + 1] & 0x3F) << 6) + (byArray[n + 2] & 0x3F);
            if (n2 >= 55296 && n2 < 57344 || n2 == 65535 || n2 == 65534 || n2 < 2048) {
                this.host.error1(171, Integer.toHexString(n2));
            }
            n += 2;
        } else if ((byArray[n] & 0xF8) == 240) {
            n2 = ((byArray[n] & 7) << 18) + ((byArray[n + 1] & 0x3F) << 12) + ((byArray[n + 2] & 0x3F) << 6) + (byArray[n + 3] & 0x3F);
            if (n2 >= 65536 && n2 <= 0x10FFFF) {
                n2 = (n2 - 65536 >> 10) + 55296;
            } else {
                this.host.error1(171, Integer.toHexString(n2));
            }
            n += 3;
        } else {
            n2 = byArray[n];
            this.host.error1(171, Integer.toHexString(n2));
        }
        this.byteinx = n;
        return n2;
    }

    @Override
    public void scanXMLDecl() {
    }

    @Override
    public int nextChar() {
        byte by;
        if (this.byteinx > this.lastbyte && this.readBuffer(4) <= 0) {
            return -1;
        }
        if ((by = this.byteBuffer[this.byteinx++]) == 10) {
            ++this.curline;
            this.curlineinx = this.byteinx;
        }
        return by;
    }

    @Override
    protected void pushBytes(int[] nArray, int n, int n2) {
        int n3 = n2 - n;
        for (int i = n; i < n3; ++i) {
            this.byteBuffer[i] = (byte)(nArray[n + i] & 0xFF);
        }
        if (n3 > 0) {
            this.pushed = n3;
        }
    }

    void pushBytes(int n, int n2) {
        int n3 = n2 - n;
        for (int i = 0; i < n3; ++i) {
            this.byteBuffer[i] = this.byteBuffer[n + i];
        }
        if (n3 > 0) {
            this.pushed = n3;
        }
        this.readBuffer(0);
    }

    protected int readBuffer(int n) {
        if (this.bufsize < 8192) {
            return 0;
        }
        this.byteinx = 0;
        int n2 = 8192 - this.pushed;
        try {
            this.bufsize = this.in.read(this.byteBuffer, this.pushed, n2);
            if (this.bufsize < n2) {
                this.in.close();
                if (this.bufsize == -1) {
                    this.bufsize = 0;
                }
                this.byteBuffer[this.bufsize + this.pushed] = -1;
            }
            this.bufsize += this.pushed;
            this.totalinx += this.bufsize;
            this.pushed = 0;
        }
        catch (IOException iOException) {
            this.bufsize = 0;
        }
        this.lastbyte = this.bufsize - 1;
        return this.lastbyte;
    }
}

