/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.ExprSingle;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLExtFunctions;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xslt.XSLException;

public class XPathExtFunction
extends XSLExprBase {
    String classname;
    String fnname;
    FastVector exprVector;
    OXMLFunction func = null;
    private Hashtable methodHash;
    private boolean oraExtNS = false;
    static final int CONSTRUCTOR = 0;
    static final int INST_METHOD = 1;
    static final int STATIC_METHOD = 2;
    static final int CACHE_SIZE = 64;

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        int n = xSLParseString.peekToken();
        if (n != 113 || xSLParseString.getFunctionType() != 601) {
            return null;
        }
        XPathExtFunction xPathExtFunction = new XPathExtFunction();
        String string = xSLParseString.getNamespace();
        if (string.equals("http://www.oracle.com/XSL/Transform/java")) {
            xPathExtFunction.oraExtNS = true;
        } else if (string.startsWith("http://www.oracle.com/XSL/Transform/java/")) {
            xPathExtFunction.classname = string.substring("http://www.oracle.com/XSL/Transform/java/".length());
            xPathExtFunction.oraExtNS = true;
        } else {
            xPathExtFunction.classname = string;
        }
        xPathExtFunction.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        n = xSLParseString.nextToken();
        xPathExtFunction.setExprType(0x800000);
        xPathExtFunction.fnname = xSLParseString.getLocalName();
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsWithStringParam(301, 0, string, xPathExtFunction.fnname, xPathExtFunction.classname);
        }
        xPathExtFunction.exprVector = new FastVector();
        if (xSLParseString.peekToken() != 26) {
            XSLExprBase xSLExprBase = ExprSingle.parse(xSLParseString);
            if (xSLParseString.isCachingExpr() && xSLExprBase.canCacheExpr()) {
                xSLExprBase = xSLExprBase.createCachedExpr();
            }
            xPathExtFunction.exprVector.addElement(xSLExprBase);
            while (xSLParseString.peekToken() != 26) {
                if (xSLParseString.nextToken() != 1) {
                    throw new XPathException(1020);
                }
                xSLExprBase = ExprSingle.parse(xSLParseString);
                if (xSLParseString.isCachingExpr() && xSLExprBase.canCacheExpr()) {
                    xSLExprBase = xSLExprBase.createCachedExpr();
                }
                xPathExtFunction.exprVector.addElement(xSLExprBase);
            }
        }
        xSLParseString.nextToken();
        xPathExtFunction.func = xSLParseString.getFunction(string, xPathExtFunction.fnname, xPathExtFunction.exprVector.size());
        xPathExtFunction.methodHash = new Hashtable(20);
        if (xPathExtFunction.fnname == "node-set") {
            xPathExtFunction.setExprType(0x2200000);
            if (xSLParseString.getXSLTVersion() >= 20) {
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsNoParam(301, 1);
                }
                return (XSLExprBase)xPathExtFunction.exprVector.elementAt(0);
            }
        }
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(301, 1);
        }
        return xPathExtFunction;
    }

    @Override
    void cacheSubExpr() {
    }

    @Override
    boolean canCacheExpr() {
        return false;
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        int n = this.exprVector.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.classname);
        stringBuffer.append('.');
        stringBuffer.append(this.fnname);
        stringBuffer.append('(');
        if (n > 0) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(0);
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(',');
                xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
                stringBuffer.append(xSLExprBase.getNormalizedExpr());
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    int checkPosLastFN() {
        for (int i = 0; i < this.exprVector.size(); ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            this.flag |= xSLExprBase.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        int n = this.exprVector.size();
        if (this.fnname == "node-set") {
            ((XSLExprBase)this.exprVector.elementAt(0)).evaluate(xPathRuntimeContext);
            OXMLSequence oXMLSequence = xPathRuntimeContext.peekExprValue();
            XMLDocumentFragment xMLDocumentFragment = XPathSequence.getResultTreeValue(oXMLSequence);
            if (xMLDocumentFragment == null) {
                throw new XPathException(1019, "result-tree-fragment", XPathSequence.getTypeString(oXMLSequence));
            }
            oXMLSequence.reset();
            XPathSequence.addNode(oXMLSequence, xMLDocumentFragment);
        } else {
            if (this.func == null && !this.oraExtNS && this.fnname != null) {
                throw new XPathException(1015, this.fnname);
            }
            if (this.func == null && !this.oraExtNS) {
                throw new XPathException(1016, "http://www.oracle.com/XSL/Transform/java/");
            }
            if (this.func != null) {
                OXMLSequence[] oXMLSequenceArray = new OXMLSequence[n];
                for (int i = 0; i < n; ++i) {
                    ((XSLExprBase)this.exprVector.elementAt(i)).evaluate(xPathRuntimeContext);
                    oXMLSequenceArray[i] = xPathRuntimeContext.peekExprValue();
                }
                xPathRuntimeContext.popExprValue(n);
                xPathRuntimeContext.pushExprValue(this.func.invoke((OXMLFunctionContext)xPathRuntimeContext, oXMLSequenceArray));
            } else {
                OXMLSequence oXMLSequence = xPathRuntimeContext.pushExprValue();
                FastVector fastVector = new FastVector(n);
                for (int i = 0; i < this.exprVector.size(); ++i) {
                    ((XSLExprBase)this.exprVector.elementAt(i)).evaluate(xPathRuntimeContext);
                    fastVector.addElement(xPathRuntimeContext.peekExprValue());
                }
                this.evaluateMethod(this.classname, this.fnname, fastVector, oXMLSequence);
                xPathRuntimeContext.popExprValue(n);
            }
        }
        if (this.predicates != null) {
            this.filterPredicates(xPathRuntimeContext);
        }
    }

    void evaluateMethod(String string, String string2, FastVector fastVector, OXMLSequence oXMLSequence) throws XPathException, XQException {
        Method method = null;
        Constructor constructor = null;
        int n = -1;
        Object var8_8 = null;
        Thread thread = Thread.currentThread();
        if (thread != null) {
            var8_8 = this.methodHash.get(thread);
        }
        if (var8_8 == null) {
            if (this.methodHash.size() >= 64) {
                this.methodHash.clear();
            }
            if (string2.equals("new")) {
                constructor = XSLExtFunctions.getConstructor(string, fastVector);
                n = 0;
                if (thread != null) {
                    this.methodHash.put(thread, constructor);
                }
            } else {
                method = XSLExtFunctions.getMethod(string, string2, fastVector);
                if (thread != null) {
                    this.methodHash.put(thread, method);
                }
            }
        } else if (var8_8 instanceof Method) {
            method = var8_8;
        } else {
            constructor = var8_8;
            n = 0;
        }
        if (n == -1) {
            n = Modifier.isStatic(method.getModifiers()) ? 2 : 1;
        }
        switch (n) {
            case 0: {
                XSLExtFunctions.callConstructor(constructor, fastVector, oXMLSequence);
                break;
            }
            case 1: {
                XSLExtFunctions.callMethod(method, fastVector, oXMLSequence);
                break;
            }
            case 2: {
                XSLExtFunctions.callStaticMethod(method, fastVector, oXMLSequence);
            }
        }
    }
}

