/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xslt.XSLNamespace;

public class XPathItem
extends OXMLItem
implements XSLExprConstants {
    public XPathItem prevItem = null;
    public XPathItem nextItem = null;
    int version;
    boolean bkwdCompFlag;
    boolean fwdCompFlag;
    XPathRuntimeContext context;
    boolean typeResultTreeValue = false;

    public XPathItem() {
        this.stype = OXMLSequenceType.TUNTYPED;
    }

    public void setContext(XPathRuntimeContext xPathRuntimeContext) {
        this.context = xPathRuntimeContext;
    }

    @Override
    public OXMLFunctionContext getContext() {
        return this.context;
    }

    @Override
    public void reset() {
        super.reset();
        this.typeResultTreeValue = false;
    }

    @Override
    public void atomize(OXMLSequence oXMLSequence) throws XQException {
        if (this.nodeValue != null) {
            this.setUntypedLexical(this.nodeValue.getText());
            if (oXMLSequence != null) {
                oXMLSequence.appendItem(this);
            }
        }
    }

    public XPathItem copy() {
        XPathItem xPathItem = new XPathItem();
        xPathItem.version = this.version;
        xPathItem.bkwdCompFlag = this.bkwdCompFlag;
        xPathItem.fwdCompFlag = this.fwdCompFlag;
        xPathItem.copyItem(this);
        return xPathItem;
    }

    @Override
    public void copyItem(OXMLItem oXMLItem) {
        super.copyItem(oXMLItem);
        if (this.getXSLTVersion() < 20) {
            this.typeResultTreeValue = ((XPathItem)oXMLItem).typeResultTreeValue;
        }
    }

    @Override
    public OXMLSequence atomize() throws XQException {
        return null;
    }

    public OXMLItem atomizeItem() throws XQException {
        if (this.nodeValue != null) {
            XPathItem xPathItem = new XPathItem();
            xPathItem.setUntypedLexical(this.nodeValue.getText());
            xPathItem.version = this.version;
            xPathItem.bkwdCompFlag = this.bkwdCompFlag;
            xPathItem.fwdCompFlag = this.fwdCompFlag;
            return xPathItem;
        }
        return this;
    }

    @Override
    public void setNode(XMLNode xMLNode) throws XQException {
        super.setNode(xMLNode);
        if (xMLNode == null) {
            this.stype = OXMLSequenceType.NODE_ONE;
        }
    }

    @Override
    public void setExternalObject(Object object) throws XQException {
        if (object instanceof XMLDocumentFragment) {
            this.setNode((XMLDocumentFragment)object);
        } else if (object instanceof String) {
            this.setString(OXMLSequenceType.TSTRING, (String)object);
        } else if (object instanceof Number) {
            this.setDouble(OXMLSequenceType.TDOUBLE, ((Number)object).doubleValue());
        } else if (object instanceof Boolean) {
            this.setBoolean(OXMLSequenceType.TBOOLEAN, (Boolean)object);
        } else {
            super.setExternalObject(object);
        }
    }

    void setDocumentFragmentValue(XMLDocumentFragment xMLDocumentFragment) throws XQException {
        this.typeResultTreeValue = true;
        this.setNode(xMLDocumentFragment);
    }

    public static boolean getBooleanValue(OXMLItem oXMLItem) throws XQException {
        int n = oXMLItem.getPrimitiveType();
        boolean bl = false;
        switch (n) {
            case 2: {
                return oXMLItem.getBoolean();
            }
            case 3: 
            case 4: {
                if (Double.isNaN(oXMLItem.getDouble()) || oXMLItem.getDouble() == 0.0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 5: 
            case 22: {
                if (oXMLItem.getBoolean()) {
                    bl = oXMLItem.getDecimal().intValue() != 0;
                    break;
                }
                bl = oXMLItem.getInt() != 0;
                break;
            }
            case 1: {
                bl = oXMLItem.getLexicalValue().length() != 0;
                break;
            }
            case 90: {
                bl = oXMLItem.getNode() != null;
            }
        }
        oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
        return bl;
    }

    public static String getStringValue(OXMLItem oXMLItem) throws XQException {
        String string = oXMLItem.getLexicalValue();
        oXMLItem.setString(OXMLSequenceType.TSTRING, string);
        return string;
    }

    private boolean isNumericType(int n) {
        if (n == 4) {
            return true;
        }
        if (n == 3) {
            return true;
        }
        if (n == 22) {
            return true;
        }
        return n == 5;
    }

    @Override
    public String getLexicalValue() {
        if (this.isNode() && !this.isXPath20Compatible()) {
            this.lexicalValue = this.nodeValue.getText();
            return this.lexicalValue;
        }
        if (this.stype == null && !this.isXPath20Compatible()) {
            this.lexicalValue = "";
            return this.lexicalValue;
        }
        int n = this.getPrimitiveType();
        if (this.isXPath20Compatible() && !this.isNumericType(n)) {
            return super.getLexicalValue();
        }
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 22: {
                if (this.isXPath20Compatible()) {
                    switch (n) {
                        case 3: 
                        case 4: {
                            if (Double.isNaN(this.doubleValue)) {
                                this.lexicalValue = "NaN";
                                break;
                            }
                            if (Double.isInfinite(this.doubleValue)) {
                                this.lexicalValue = this.doubleValue > 0.0 ? "INF" : "-INF";
                                break;
                            }
                            double d = n == 4 ? this.doubleValue : Double.parseDouble(Float.toString((float)this.doubleValue));
                            double d2 = Math.abs(d);
                            if (d2 != 0.0 && (d2 >= 1000000.0 || d2 < 1.0E-6)) {
                                DecimalFormat decimalFormat = new DecimalFormat("0.0################E0##");
                                this.lexicalValue = decimalFormat.format(d);
                                break;
                            }
                            DecimalFormat decimalFormat = this.getDecimalFormat();
                            this.lexicalValue = decimalFormat.format(d);
                            break;
                        }
                        case 5: 
                        case 22: {
                            if (this.booleanValue) {
                                this.lexicalValue = this.getBigDecimalLexical((BigDecimal)this.objValue);
                                break;
                            }
                            DecimalFormat decimalFormat = this.getDecimalFormat();
                            this.lexicalValue = decimalFormat.format(this.intValue);
                        }
                    }
                    break;
                }
                if (Double.isNaN(this.doubleValue) || Double.isInfinite(this.doubleValue)) {
                    this.lexicalValue = Double.toString(this.doubleValue);
                    break;
                }
                if (new Double(this.doubleValue).equals(new Double(-0.0))) {
                    this.lexicalValue = "0";
                    break;
                }
                if (n != 4) {
                    this.convert(OXMLSequenceType.TDOUBLE);
                    this.lexicalValue = this.getDecimalFormat().format(this.doubleValue);
                    break;
                }
                this.lexicalValue = this.getDecimalFormat().format(this.doubleValue);
                break;
            }
            case 2: {
                this.lexicalValue = this.booleanValue ? "true" : "false";
            }
        }
        return this.lexicalValue;
    }

    private DecimalFormat getDecimalFormat() {
        if (this.context == null) {
            return numberFormat;
        }
        DecimalFormat decimalFormat = this.context.getNumberFormat();
        return decimalFormat;
    }

    public static double getNumberValue(OXMLItem oXMLItem) throws XQException {
        XPathItem xPathItem = (XPathItem)oXMLItem;
        int n = oXMLItem.getPrimitiveType();
        double d = -1.0;
        switch (n) {
            case 4: {
                return oXMLItem.getDouble();
            }
            case 5: 
            case 22: {
                d = oXMLItem.getBoolean() ? oXMLItem.getDecimal().doubleValue() : (double)oXMLItem.getInt();
                break;
            }
            case 3: {
                d = oXMLItem.getDouble();
                break;
            }
            case 2: {
                d = oXMLItem.getBoolean() ? 1.0 : 0.0;
                break;
            }
            case 1: 
            case 90: {
                String string = oXMLItem.getLexicalValue().trim();
                try {
                    d = Double.parseDouble(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    if (xPathItem.getXSLTVersion() == 20 && !xPathItem.isBackwardCompatibilityMode() || xPathItem.getXSLTVersion() == 10 && xPathItem.isForwardCompatibilityMode()) {
                        throw new XQException(new XPathException(1036, string, "number"));
                    }
                    d = Double.NaN;
                }
            }
        }
        oXMLItem.setDouble(OXMLSequenceType.TDOUBLE, d);
        return d;
    }

    @Override
    public Object getExternalObject() {
        if (this.stype == null) {
            return super.getExternalObject();
        }
        return null;
    }

    @Override
    public int compareValue(OXMLItem oXMLItem) throws XQException {
        if (this.isXPath20Compatible()) {
            return super.compareValue(oXMLItem);
        }
        int n = this.getPrimitiveType();
        int n2 = oXMLItem.getPrimitiveType();
        if (n == 4 || n2 == 4) {
            if (n != 4) {
                XPathItem.getNumberValue(this);
            }
            if (n2 != 4) {
                XPathItem.getNumberValue(oXMLItem);
            }
            if (Double.isNaN(this.getDouble()) || Double.isNaN(oXMLItem.getDouble())) {
                return 2;
            }
            return super.compareVal(oXMLItem, 4);
        }
        if (n == 2 || n2 == 2) {
            XPathItem.getBooleanValue(this);
            XPathItem.getBooleanValue(oXMLItem);
            return super.compareVal(oXMLItem, 2);
        }
        XPathItem.getStringValue(this);
        XPathItem.getStringValue(oXMLItem);
        return super.compareVal(oXMLItem, 1);
    }

    @Override
    public void convert2Boolean() throws XQException {
        if (this.isXPath20Compatible()) {
            super.convert2Boolean();
            return;
        }
        int n = this.getPrimitiveType();
        boolean bl = false;
        switch (n) {
            case 2: {
                return;
            }
            case 3: 
            case 4: {
                if (Double.isNaN(this.doubleValue) || this.doubleValue == 0.0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 5: 
            case 22: {
                if (this.booleanValue) {
                    bl = ((BigDecimal)this.objValue).intValue() != 0;
                    break;
                }
                bl = this.intValue != 0;
                break;
            }
            case 0: 
            case 1: {
                bl = this.getLexicalValue().length() != 0;
                break;
            }
            case 90: {
                bl = this.nodeValue != null;
            }
        }
        this.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
    }

    @Override
    protected void convert2Double() throws XQException {
        if (this.isXPath20Compatible()) {
            super.convert2Double();
            return;
        }
        int n = this.getPrimitiveType();
        double d = -1.0;
        switch (n) {
            case 4: {
                return;
            }
            case 5: 
            case 22: {
                d = this.booleanValue ? ((BigDecimal)this.objValue).doubleValue() : (double)this.intValue;
                break;
            }
            case 3: {
                d = this.doubleValue;
                break;
            }
            case 2: {
                d = this.booleanValue ? 1.0 : 0.0;
                break;
            }
            case 0: 
            case 1: 
            case 90: {
                String string = this.getLexicalValue().trim();
                try {
                    d = Double.parseDouble(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.isXPath20Compatible()) {
                        throw new XQException(new XPathException(1036, string, "number"));
                    }
                    d = Double.NaN;
                }
            }
        }
        this.setDouble(OXMLSequenceType.TDOUBLE, d);
    }

    @Override
    protected void convert2QName() throws XQException {
    }

    static String getTypeString(OXMLItem oXMLItem) {
        String string = null;
        switch (oXMLItem.getPrimitiveType()) {
            case 90: {
                short s = oXMLItem.getNode().getNodeType();
                if (s == 11) {
                    string = "result tree fragment";
                    break;
                }
                string = "node-set";
                break;
            }
            case 2: {
                string = "boolean";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: {
                string = "number";
                break;
            }
            case 1: {
                string = "string";
            }
        }
        return string;
    }

    public void setCompatibilityFlags(int n, boolean bl, boolean bl2) {
        this.version = n;
        this.bkwdCompFlag = bl;
        this.fwdCompFlag = bl2;
    }

    int getXSLTVersion() {
        return this.version;
    }

    boolean isBackwardCompatibilityMode() {
        return this.bkwdCompFlag;
    }

    boolean isForwardCompatibilityMode() {
        return this.fwdCompFlag;
    }

    static boolean isEqualValue(OXMLItem oXMLItem, OXMLItem oXMLItem2) {
        int n = oXMLItem.getPrimitiveType();
        if (n != oXMLItem2.getPrimitiveType()) {
            return false;
        }
        switch (n) {
            case 90: {
                if (oXMLItem.getNode() == oXMLItem2.getNode()) break;
                return false;
            }
            case 3: 
            case 4: {
                if (oXMLItem.getDouble() == oXMLItem2.getDouble()) break;
                return false;
            }
            case 5: {
                if (oXMLItem.getDecimal().compareTo(oXMLItem2.getDecimal()) == 0) break;
                return false;
            }
            case 22: {
                if (oXMLItem.getInt() == oXMLItem2.getInt()) break;
                return false;
            }
            case 2: {
                if (oXMLItem.getBoolean() == oXMLItem2.getBoolean()) break;
                return false;
            }
            case 20: {
                if (oXMLItem.getYearMonthDuration() == oXMLItem2.getYearMonthDuration()) break;
                return false;
            }
            case 21: {
                if (oXMLItem.getDayTimeDuration() == oXMLItem2.getDayTimeDuration()) break;
                return false;
            }
            case 7: 
            case 8: 
            case 9: {
                if (oXMLItem.getCalendar().getTime().compareTo(oXMLItem2.getCalendar().getTime()) == 0) break;
                return false;
            }
            case 10: {
                GregorianCalendar gregorianCalendar = oXMLItem.getCalendar();
                GregorianCalendar gregorianCalendar2 = oXMLItem2.getCalendar();
                if (gregorianCalendar.get(1) == gregorianCalendar2.get(1) && gregorianCalendar.get(2) == gregorianCalendar2.get(2)) break;
                return false;
            }
            case 11: {
                if (oXMLItem.getCalendar().get(1) == oXMLItem2.getCalendar().get(1)) break;
                return false;
            }
            case 12: {
                if (oXMLItem.getCalendar().get(2) == oXMLItem2.getCalendar().get(2)) break;
                return false;
            }
            case 13: {
                GregorianCalendar gregorianCalendar = oXMLItem.getCalendar();
                GregorianCalendar gregorianCalendar3 = oXMLItem2.getCalendar();
                if (gregorianCalendar.get(2) == gregorianCalendar3.get(2) && gregorianCalendar.get(5) == gregorianCalendar3.get(5)) break;
                return false;
            }
            case 14: {
                if (oXMLItem.getCalendar().get(5) == oXMLItem2.getCalendar().get(5)) break;
                return false;
            }
            case 18: {
                QName qName = oXMLItem.getQName();
                QName qName2 = oXMLItem2.getQName();
                if (qName.getPrefix() == qName2.getPrefix() && qName.getNamespaceURI() == qName2.getNamespaceURI() && qName.getLocalPart() == qName2.getLocalPart()) break;
                return false;
            }
        }
        return true;
    }

    static boolean isValidXPathNode(XMLNode xMLNode) {
        if (xMLNode == null) {
            return false;
        }
        if (xMLNode instanceof XSLNamespace) {
            return true;
        }
        switch (xMLNode.getNodeType()) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    static void nodeCheck(OXMLItem oXMLItem) throws XQException {
        XPathItem xPathItem = (XPathItem)oXMLItem;
        XMLNode xMLNode = xPathItem.getNode();
        if (xMLNode == null && xPathItem.stype != OXMLSequenceType.NODE_ONE || xMLNode instanceof XMLDocumentFragment && xPathItem.typeResultTreeValue && xPathItem.version < 20) {
            throw new XQException(new XPathException(1036, XPathItem.getTypeString(xPathItem), "NodeSet"));
        }
    }

    private boolean isXPath20Compatible() {
        return this.getXSLTVersion() == 20 && !this.isBackwardCompatibilityMode() || this.getXSLTVersion() == 10 && this.isForwardCompatibilityMode();
    }
}

