/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.util.Hashtable;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.util.FastVector;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTemplate;
import oracle.xml.xslt.XSLVariable;

class XSLApplyImport
extends XSLNode
implements XSLConstants {
    private FastVector paramList;
    private int nParams;

    XSLApplyImport(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.localName = "apply-imports";
        this.elementType = 4;
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        XSLNode xSLNode;
        int n;
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataBefore(xSLTContext, this, "xsl:apply-imports", "", (byte)-1);
        }
        this.setContextBaseURL(xSLTContext);
        this.setDefaultCollation(xSLTContext);
        Hashtable hashtable = null;
        if (this.nParams > 0) {
            hashtable = xSLTContext.allocHashtable();
            for (n = 0; n < this.nParams; ++n) {
                xSLNode = (XSLVariable)this.paramList.elementAt(n);
                hashtable.put(((XSLVariable)xSLNode).getName(), ((XSLVariable)xSLNode).getValue(xSLTContext));
            }
        }
        xSLNode = null;
        n = xSLTContext.getCurrentTmpl();
        if (n > -1) {
            xSLNode = this.xss.getMatchingImportTemplate(xSLTContext);
        } else if (n == -2) {
            xSLNode = this.xss.getImportedNamedTemplate(xSLTContext, this.getCurrentTemplate());
        }
        if (xSLNode != null) {
            ((XSLTemplate)xSLNode).setParams(hashtable, xSLTContext);
            ((XSLTemplate)xSLNode).processAction(xSLTContext);
        } else {
            XMLError xMLError = xSLTContext.getError();
            xMLError.error0(1046, 1);
        }
        xSLTContext.setCurrentTmpl(n);
        if (hashtable != null) {
            xSLTContext.freeHashtable(hashtable);
        }
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataAfter(this, (byte)-1, null);
        }
    }

    @Override
    public void appendChild(XSLNode xSLNode) throws XSLException {
        if (this.version == 10) {
            return;
        }
        super.appendChild(xSLNode);
        if (xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform" && xSLNode.localName == "with-param") {
            if (this.paramList == null) {
                this.paramList = new FastVector(4);
            }
            this.paramList.addElement(xSLNode);
            ++this.nParams;
            this.children.setSize(this.children.size() - 1);
        }
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).finalizeXSLNode();
        }
        super.finalizeXSLNode();
    }
}

