/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.PrintWriter;
import java.util.Hashtable;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLSort;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTemplate;
import oracle.xml.xslt.XSLVariable;

class XSLApplyTemplates
extends XSLNode
implements XSLConstants {
    private XSLSort sortnode;
    private FastVector paramList;
    private int nParams;
    private XSLExprBase expr;
    private NSName mode;
    private XSLTemplate linkedTemplate;

    XSLApplyTemplates(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.localName = "apply-templates";
        this.elementType = 4;
        this.linkedTemplate = null;
    }

    @Override
    XSLExprBase getContextExpr() {
        return this.expr;
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        this.processAction(xSLTContext, this.mode);
    }

    private void processAction(XSLTContext xSLTContext, NSName nSName) throws XSLException, XQException {
        XSLNode xSLNode;
        Object object;
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataBefore(xSLTContext, this, "xsl:apply-templates", "", (byte)-1);
        }
        this.setContextBaseURL(xSLTContext);
        this.setDefaultCollation(xSLTContext);
        XMLNode xMLNode = xSLTContext.getContextNode();
        boolean bl = false;
        if (xMLNode.getNodeType() == 1) {
            object = ((XMLElement)xMLNode).getAttributeNS("http://www.w3.org/XML/1998/namespace", "space");
            boolean bl2 = bl = !((String)object).equals("");
            if (bl) {
                if (((String)object).equals("preserve")) {
                    xSLTContext.setSrcWhiteSpaceMode(true);
                } else if (((String)object).equals("default")) {
                    xSLTContext.setSrcWhiteSpaceMode(false);
                } else {
                    bl = false;
                }
            }
        }
        this.expr.evaluate(xSLTContext);
        if (this.sortnode != null) {
            this.sortnode.sortNodes(xSLTContext);
        }
        object = xSLTContext.peekExprValue();
        xSLTContext.removeWhiteSpace((OXMLSequence)object);
        Hashtable hashtable = null;
        if (this.nParams > 0 && !this.xss.is2029Compatible()) {
            hashtable = xSLTContext.allocHashtable();
            for (int i = 0; i < this.nParams; ++i) {
                xSLNode = (XSLVariable)this.paramList.elementAt(i);
                hashtable.put(((XSLVariable)xSLNode).getName(), ((XSLVariable)xSLNode).getValue(xSLTContext));
            }
        }
        xSLNode = this.linkedTemplate;
        int n = xSLTContext.setContextSize(XPathSequence.getLength((OXMLSequence)object));
        int n2 = xSLTContext.getContextPosition();
        int n3 = 1;
        while (((OXMLSequence)object).next()) {
            XSLNode xSLNode2;
            XMLNode xMLNode2 = XPathSequence.nextNode((OXMLSequence)object);
            xSLTContext.setContextPosition(n3++);
            xSLTContext.setContextNode(xMLNode2);
            xSLTContext.setCurrentNode(xMLNode2);
            if (this.xss.is2029Compatible() && this.nParams > 0) {
                hashtable = xSLTContext.allocHashtable();
                for (int i = 0; i < this.nParams; ++i) {
                    xSLNode2 = (XSLVariable)this.paramList.elementAt(i);
                    hashtable.put(((XSLVariable)xSLNode2).getName(), ((XSLVariable)xSLNode2).getValue(xSLTContext));
                }
            }
            if (this.linkedTemplate == null) {
                xSLNode = this.xss.getMatchingTemplate(xMLNode2, nSName, xSLTContext);
            }
            if (((XSLTemplate)xSLNode).isBuiltInElementTemplate) {
                xSLNode2 = (XSLApplyTemplates)((XSLTemplate)xSLNode).children.elementAt(0);
                ((XSLApplyTemplates)xSLNode2).processAction(xSLTContext, nSName);
                continue;
            }
            int n4 = xSLTContext.getCurrentTmpl();
            xSLTContext.setCurrentTmpl(((XSLTemplate)xSLNode).index);
            ((XSLTemplate)xSLNode).setParams(hashtable, xSLTContext);
            ((XSLTemplate)xSLNode).processAction(xSLTContext);
            xSLTContext.setCurrentTmpl(n4);
        }
        xSLTContext.setContextSize(n);
        xSLTContext.setContextPosition(n2);
        xSLTContext.setContextNode(xMLNode);
        xSLTContext.setCurrentNode(xMLNode);
        xSLTContext.popExprValue();
        if (bl) {
            xSLTContext.resetSrcWhiteSpaceMode();
        }
        if (hashtable != null) {
            xSLTContext.freeHashtable(hashtable);
        }
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataAfter(this, (byte)-1, null);
        }
    }

    @Override
    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform") {
            if (xSLNode.localName == "sort") {
                if (this.sortnode == null) {
                    this.sortnode = (XSLSort)xSLNode;
                } else {
                    this.sortnode.addSecondaryKey((XSLSort)xSLNode);
                }
                this.children.setSize(this.children.size() - 1);
            }
            if (xSLNode.localName == "with-param") {
                if (this.paramList == null) {
                    this.paramList = new FastVector(4);
                }
                this.paramList.addElement(xSLNode);
                ++this.nParams;
                this.children.setSize(this.children.size() - 1);
            }
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "") {
            if (string3 == "select") {
                this.expr = XSLExprBase.createExpression(string4, (NSResolver)this, this.xss);
            } else if (string3 == "mode") {
                this.mode = this.resolveQname(string4);
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    @Override
    public void startContent() throws XSLException, XQException {
        if (this.expr == null) {
            this.expr = XSLExprBase.createExpression("node()", (NSResolver)this, this.xss);
        }
        if (this.mode == null) {
            this.mode = new NSNameImpl();
        }
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        if (this.sortnode != null) {
            this.sortnode.finalizeXSLNode();
        }
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).finalizeXSLNode();
        }
        super.finalizeXSLNode();
        this.linkedTemplate = this.xss.getMatchingTemplate(this.getContextExpr(), this.mode);
    }

    @Override
    void printChildren(PrintWriter printWriter, int n) {
        if (this.sortnode != null) {
            this.sortnode.printXSLNode(printWriter, n);
        }
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).printXSLNode(printWriter, n);
        }
        super.printChildren(printWriter, n);
    }
}

