/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import oracle.xml.scalable.ContentManager;
import oracle.xml.xti.XTIDecoder;
import oracle.xml.xti.XTIEncoder;
import oracle.xml.xti.XTIException;

public class XTIContentManager
implements ContentManager {
    XTIEncoder encoder = null;
    XTIDecoder decoder = null;
    int xtinAddress = 0;

    XTIContentManager(XTIEncoder xTIEncoder, XTIDecoder xTIDecoder) {
        this.encoder = xTIEncoder;
        this.decoder = xTIDecoder;
    }

    @Override
    public void seek(Object object) throws XTIException {
        this.xtinAddress = (Integer)object;
    }

    @Override
    public Object getParent() throws XTIException {
        Integer n = this.decoder.getParentAddress(this.xtinAddress);
        if (n == 0) {
            return null;
        }
        return n;
    }

    @Override
    public Object getFirstChild() throws XTIException {
        Integer n = this.decoder.getChildAddress(this.xtinAddress);
        if (n == 0) {
            return null;
        }
        return n;
    }

    @Override
    public Object getNextSibling() throws XTIException {
        Integer n = this.decoder.getNextAddress(this.xtinAddress);
        if (n == 0) {
            return null;
        }
        return n;
    }

    @Override
    public boolean isNamespaceNode() throws XTIException {
        return this.decoder.isNamespaceNode(this.xtinAddress);
    }

    @Override
    public Object getPreviousSibling() throws XTIException {
        Integer n = this.decoder.getPreviousAddress(this.xtinAddress);
        if (n == 0) {
            return null;
        }
        return n;
    }

    @Override
    public Object getFirstAttribute() throws XTIException {
        Integer n = this.decoder.getAttributeAddress(this.xtinAddress);
        if (n == 0) {
            return null;
        }
        return n;
    }

    @Override
    public String getQName() throws XTIException {
        return this.decoder.getQName(this.xtinAddress);
    }

    @Override
    public String getNamespaceURI() throws XTIException {
        return this.decoder.getNamespaceURI(this.xtinAddress);
    }

    @Override
    public String getPrefix() throws XTIException {
        return this.decoder.getPrefix(this.xtinAddress);
    }

    @Override
    public String getLocalName() throws XTIException {
        return this.decoder.getLocalName(this.xtinAddress);
    }

    @Override
    public String getNodeValue() throws XTIException {
        return this.decoder.getNodeValue(this.xtinAddress);
    }

    @Override
    public Object createAttribute(String string, String string2) throws XTIException {
        return this.encoder.createAttribute(string, string2);
    }

    @Override
    public void setNodeValue(String string) throws XTIException {
        this.encoder.setNodeValue(string, this.xtinAddress);
    }

    @Override
    public Object init() throws XTIException {
        int n = this.decoder.readHeader();
        if (n == 0) {
            n = this.encoder.createDocument();
        }
        return n;
    }

    @Override
    public byte getNodeType() throws XTIException {
        return this.decoder.getNodeType(this.xtinAddress);
    }

    @Override
    public Object createElement(String string, String string2) throws XTIException {
        return this.encoder.createElement(string, string2);
    }

    @Override
    public Object createTextNode(String string) throws XTIException {
        return this.encoder.createTextNode(string, 0);
    }

    @Override
    public Object createCDATASection(String string) throws XTIException {
        return this.encoder.createTextNode(string, 1);
    }

    @Override
    public Object createProcessingInstruction(String string, String string2) throws XTIException {
        return this.encoder.createProcessingInstruction(string, string2);
    }

    @Override
    public Object createComment(String string) throws XTIException {
        return this.encoder.createTextNode(string, 2);
    }

    @Override
    public void setParent(Object object) throws XTIException {
        this.encoder.setNavigationNode(this.xtinAddress, (Integer)object, 0);
    }

    @Override
    public void setFirstChild(Object object) throws XTIException {
        this.encoder.setNavigationNode(this.xtinAddress, (Integer)object, 3);
    }

    public void setFirstChild(Object object, boolean bl) throws XTIException {
        this.encoder.setNavigationNode(this.xtinAddress, (Integer)object, 3);
        if (bl) {
            this.encoder.setIsLastChildFlag((Integer)object);
        }
    }

    @Override
    public void setNextSibling(Object object) throws XTIException {
        this.encoder.setNavigationNode(this.xtinAddress, (Integer)object, 1);
    }

    public void setNextSibling(Object object, boolean bl) throws XTIException {
        this.encoder.setNavigationNode(this.xtinAddress, (Integer)object, 1);
        if (bl) {
            this.encoder.setIsLastChildFlag((Integer)object);
        }
    }

    @Override
    public void setPreviousSibling(Object object) throws XTIException {
        this.encoder.setNavigationNode(this.xtinAddress, (Integer)object, 2);
    }

    public void setPreviousSibling(Object object, boolean bl) throws XTIException {
        this.encoder.setNavigationNode(this.xtinAddress, (Integer)object, 2);
        if (bl) {
            this.encoder.unsetIsLastChildFlag((Integer)object);
        }
    }

    @Override
    public void setFirstAttribute(Object object) throws XTIException {
        this.encoder.setNavigationNode(this.xtinAddress, (Integer)object, 4);
    }

    @Override
    public void setQName(String string, String string2) throws XTIException {
        this.encoder.setQName(this.xtinAddress, string, string2);
    }
}

