/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.UnsupportedEncodingException;
import java.util.Stack;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIStream;
import oracle.xml.xti.XTIUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.ext.LexicalHandler;

public class XTIDecoder
implements XTIConstants {
    XTIStream xtiStream = null;
    byte[] currentPage = null;
    int currentPageNumber = 0;
    SAXAttrList attrlist = new SAXAttrList(100);
    private Stack<DecodeElem> elements = new Stack();
    LexicalHandler lexHdlr = null;

    XTIDecoder(XTIStream xTIStream) {
        this.xtiStream = xTIStream;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexHdlr = lexicalHandler;
    }

    public void decode(ContentHandler contentHandler, ErrorHandler errorHandler) throws XTIException {
        try {
            int n = this.readHeader();
            int n2 = 0;
            DecodeElem decodeElem = null;
            byte by = 0;
            do {
                by = this.decodeNodes(n, contentHandler, errorHandler);
                n2 = n;
                n = this.getChildAddress(n);
                if (by == 1 && n == 0 && !this.elements.empty()) {
                    decodeElem = this.elements.pop();
                    contentHandler.endElement(decodeElem.getURI(), decodeElem.getLocalname(), decodeElem.getQname());
                }
                while (n == 0 && n2 != 0) {
                    n = this.getNextAddress(n2);
                    if (n != 0) continue;
                    n2 = this.getParentAddress(n2);
                    if (this.elements.empty()) continue;
                    decodeElem = this.elements.pop();
                    contentHandler.endElement(decodeElem.getURI(), decodeElem.getLocalname(), decodeElem.getQname());
                }
            } while (n != 0);
            while (!this.elements.empty()) {
                decodeElem = this.elements.pop();
                contentHandler.endElement(decodeElem.getURI(), decodeElem.getLocalname(), decodeElem.getQname());
            }
            contentHandler.endDocument();
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    boolean isLastChild(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = this.currentPage[n2];
        return (by & 0x10) > 0;
    }

    int readHeader() {
        byte[] byArray = this.xtiStream.readXTINPage(0);
        byte by = (byte)(byArray[0] & 0xF);
        byte by2 = (byte)(by & 9);
        if ((by & 9) > 0) {
            this.xtiStream.setInterleaving(true);
        }
        int n = XTIUtil.byteArrayToInt(byArray, 8);
        int n2 = XTIUtil.byteArrayToInt(byArray, 4);
        this.xtiStream.setTotalXTINPages(n2);
        this.xtiStream.readXTICPage(0);
        return n;
    }

    int getChildAddress(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = (n & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n2 + 12);
    }

    int getNextAddress(int n) {
        this.getXTINPageFromAddress(n);
        if (this.isLastChild(n)) {
            return 0;
        }
        int n2 = (n & 0xFF) * 32;
        int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 24);
        return n3;
    }

    int getPreviousAddress(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = (n & 0xFF) * 32;
        int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 16);
        if (this.isLastChild(n3)) {
            return 0;
        }
        return n3;
    }

    int getParentAddress(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = (n & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n2 + 20);
    }

    int getAttributeAddress(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = (n & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n2 + 28);
    }

    String getPrefix(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
        byte[] byArray = this.getXTICPageFromAddress(n3);
        int n4 = n3 & 0xFFF;
        int n5 = byArray[--n4];
        String string = "";
        if (n5 != 0) {
            string = new String(byArray, n4 + 1, --n5);
        }
        return string;
    }

    String getLocalName(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
        byte[] byArray = this.getXTICPageFromAddress(n3);
        int n4 = n3 & 0xFFF;
        byte by = byArray[--n4];
        String string = null;
        int n5 = 0;
        n5 = n4 + by + 1;
        string = this.getStringFromArray(byArray, n5);
        return string;
    }

    String getQName(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = (byte)(this.currentPage[n2] & 0xF);
        String string = null;
        switch (by) {
            case 1: 
            case 2: {
                int n3;
                int n4 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n4);
                int n5 = n3 = n4 & 0xFFF;
                byte by2 = byArray[n3 - 1];
                if (by2 == 1) {
                    ++n5;
                }
                string = this.getStringFromArray(byArray, n5);
                break;
            }
            case 7: {
                int n6 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n6);
                int n7 = n6 & 0xFFF;
                string = this.getStringFromArray(byArray, n7);
            }
        }
        return string;
    }

    String getNamespaceURI(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        int n3 = 0;
        n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 4);
        byte[] byArray = this.getXTICPageFromAddress(n3);
        int n4 = n3 & 0xFFF;
        String string = this.getStringFromArray(byArray, n4);
        return string;
    }

    String getNodeValue(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = (byte)(this.currentPage[n2] & 0xF);
        String string = null;
        switch (by) {
            case 3: 
            case 4: 
            case 8: {
                int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n3);
                int n4 = n3 & 0xFFF;
                string = this.getStringFromArray(byArray, n4);
                break;
            }
            case 7: {
                int n5 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 4);
                byte[] byArray = this.getXTICPageFromAddress(n5);
                int n6 = n5 & 0xFFF;
                string = this.getStringFromArray(byArray, n6);
                break;
            }
            case 2: {
                int n7 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 4 + 12);
                byte[] byArray = this.getXTICPageFromAddress(n7);
                int n8 = n7 & 0xFFF;
                string = this.getStringFromArray(byArray, n8);
                break;
            }
            default: {
                return null;
            }
        }
        return string;
    }

    byte getNodeType(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = (byte)(this.currentPage[n2] & 0xF);
        return by;
    }

    public boolean isNamespaceNode(int n) {
        byte by = this.getNodeType(n);
        if (by == 2) {
            this.getXTINPageFromAddress(n);
            int n2 = n & 0xFF;
            n2 = 32 * n2;
            byte by2 = this.currentPage[n2 + 29];
            if (by2 == 2 || by2 == 4) {
                return true;
            }
        }
        return false;
    }

    private byte decodeNodes(int n, ContentHandler contentHandler, ErrorHandler errorHandler) throws Exception {
        this.getXTINPageFromAddress(n);
        int n2 = n & 0xFF;
        n2 = 32 * n2;
        byte by = (byte)(this.currentPage[n2] & 0xF);
        switch (by) {
            case 9: {
                contentHandler.startDocument();
                break;
            }
            case 1: {
                int n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n3);
                int n4 = n3 & 0xFFF;
                int n5 = byArray[--n4];
                String string = "";
                String string2 = null;
                int n6 = 0;
                if (n5 != 0) {
                    string = new String(byArray, n4 + 1, --n5);
                    n6 = n4 + n5 + 2;
                } else {
                    n6 = n4 + 1;
                }
                string2 = this.getStringFromArray(byArray, n6);
                n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 4);
                byArray = this.getXTICPageFromAddress(n3);
                n4 = n3 & 0xFFF;
                String string3 = this.getStringFromArray(byArray, n4);
                n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 28);
                this.decodeAttributes(n3);
                this.elements.push(new DecodeElem(string3, string, string2));
                if (n5 == 0) {
                    contentHandler.startElement(string3, string2, string2, this.attrlist);
                } else {
                    contentHandler.startElement(string3, string2, string + ":" + string2, this.attrlist);
                }
                this.attrlist.reset();
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                String string = this.getNodeValue(n);
                if (by == 3) {
                    contentHandler.characters(string.toCharArray(), 0, string.length());
                    break;
                }
                if (by == 8) {
                    this.lexHdlr.comment(string.toCharArray(), 0, string.length());
                    break;
                }
                if (by != 4) break;
                this.lexHdlr.startCDATA();
                contentHandler.characters(string.toCharArray(), 0, string.length());
                this.lexHdlr.endCDATA();
                break;
            }
            case 7: {
                String string = this.getNodeValue(n);
                int n7 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n7);
                int n8 = n7 & 0xFFF;
                String string4 = this.getStringFromArray(byArray, n8);
                contentHandler.processingInstruction(string4, string);
                break;
            }
            default: {
                System.out.println("Should not reach here");
            }
        }
        return by;
    }

    private void decodeAttributes(int n) {
        if (n == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n != 0) {
            this.getXTINPageFromAddress(n);
            n2 = n & 0xFF;
            n2 = 32 * n2;
            n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 8);
            byte[] byArray = this.getXTICPageFromAddress(n3);
            int n4 = n3 & 0xFFF;
            int n5 = byArray[--n4];
            String string = "";
            String string2 = null;
            int n6 = 0;
            if (n5 != 0) {
                string = new String(byArray, n4 + 1, --n5);
                n6 = n4 + n5 + 2;
            } else {
                n6 = n4 + 1;
            }
            string2 = this.getStringFromArray(byArray, n6);
            n3 = XTIUtil.byteArrayToInt(this.currentPage, n2 + 4);
            byArray = this.getXTICPageFromAddress(n3);
            n6 = n4 = n3 & 0xFFF;
            String string3 = this.getStringFromArray(byArray, n4);
            String string4 = this.getNodeValue(n);
            if (n5 == 0) {
                this.attrlist.addAttr(string, string2, string2, string4, true, 0, string3);
            } else {
                this.attrlist.addAttr(string, string2, string + ":" + string2, string4, true, 0, string3);
            }
            n = XTIUtil.byteArrayToInt(this.currentPage, n2 + 24);
        }
    }

    private String getStringFromArray(byte[] byArray, int n) {
        try {
            int n2 = 0;
            int n3 = n;
            while (byArray[n3] != 0) {
                ++n2;
                ++n3;
            }
            String string = new String(byArray, n, n2, "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private void getXTINPageFromAddress(int n) {
        int n2 = (n &= Integer.MAX_VALUE) >> 8;
        if (n2 != this.currentPageNumber) {
            this.currentPageNumber = n2;
            this.currentPage = this.xtiStream.readXTINPage(n >> 8);
        }
    }

    private byte[] getXTICPageFromAddress(int n) {
        return this.xtiStream.readXTICPage(n >> 12);
    }

    class DecodeElem
    implements XTIConstants {
        String uri = null;
        String prefix = null;
        String localname = null;

        DecodeElem(String string, String string2, String string3) {
            this.uri = string;
            this.prefix = string2;
            this.localname = string3;
        }

        String getURI() {
            return this.uri;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getLocalname() {
            return this.localname;
        }

        String getQname() {
            if (this.prefix == null || this.prefix.equals("")) {
                return this.localname;
            }
            return this.prefix + ":" + this.localname;
        }
    }
}

