/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import oracle.xml.util.XMLUtil;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIStream;
import oracle.xml.xti.XTIUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XTIEncoder
implements ContentHandler,
ErrorHandler,
DTDHandler,
DeclHandler,
LexicalHandler,
XTIConstants {
    private XTIStream xtiStream;
    private byte compression = 0;
    private boolean cdata = false;
    private byte[] rootPageHeader = null;
    private Stack<Integer> parent = new Stack();
    private int curParentAddress = 0;
    private HashMap<Integer, Integer> parentFirstChild = new HashMap(10);
    private int currentXTINpageNumber = 1;
    private int currentXTINArraySlot = -1;
    private int previousXTINAddress = 0;
    private int currentXTINAddress = 0;
    private int freeBytesQname = 4096;
    private int totalXTICPages = 0;
    private int freeBytesText = 4092;
    private int lastTextPage = 1;
    private int lastQnamePage = 1;
    private char[] charBuffer = new char[4096];
    private int charLength = 0;
    private int xtinPagesBeforeUpdate = 0;
    private int xticPagesBeforeUpdate = 0;

    XTIEncoder(XTIStream xTIStream) {
        this.xtiStream = xTIStream;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        System.arraycopy(cArray, n, this.charBuffer, this.charLength, n2);
        this.charLength += n2;
    }

    private void printAddressRelations() {
        Set<Integer> set = this.parentFirstChild.keySet();
        for (int n : set) {
            int n2 = this.parentFirstChild.get(n);
            System.out.println(n + "'s first is: " + n2);
        }
    }

    private boolean isLastChild(int n) {
        int n2 = (n & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n2);
        int n3 = n & 0xFF;
        byte by = byArray[n3 = 32 * n3];
        return (by & 0x10) > 0;
    }

    void setIsLastChildFlag(int n) {
        int n2 = (n & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n2);
        int n3 = n & 0xFF;
        n3 = 32 * n3;
        byte by = byArray[n3];
        byArray[n3] = by = (byte)(by | 0x10);
        this.xtiStream.setXTINPageNumber(n2, byArray);
    }

    void unsetIsLastChildFlag(int n) {
        int n2 = (n & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n2);
        int n3 = n & 0xFF;
        n3 = 32 * n3;
        byte by = byArray[n3];
        byArray[n3] = by = (byte)(by & 0xEF);
        this.xtiStream.setXTINPageNumber(n2, byArray);
    }

    private void updateParentFirstChild(int n) {
        if (n == 0) {
            return;
        }
        Integer n2 = this.parentFirstChild.get(this.curParentAddress);
        if (n2 == null) {
            this.parentFirstChild.put(this.curParentAddress, n);
        }
    }

    private void flushCharacters() throws SAXException {
        try {
            int n;
            byte[] byArray = new byte[32];
            byArray[0] = this.cdata ? 4 : 3;
            String string = new String(this.charBuffer, 0, this.charLength);
            int[] nArray = this.getXTICTextAddress(string.getBytes("UTF-8").length);
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            if (this.previousXTINAddress == 0 && this.parent.size() != 0) {
                this.updateChildForXTIN(this.currentXTINAddress);
            }
            byArray2 = this.previousXTINAddress != 0 ? XTIUtil.intToByteArray(this.previousXTINAddress) : XTIUtil.intToByteArray(this.currentXTINAddress);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[16 + n] = byArray2[n];
            }
            if (this.parent.size() != 0) {
                n = this.parent.peek();
                byArray2 = XTIUtil.intToByteArray(n);
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[20 + i] = byArray2[i];
                }
            }
            if (this.previousXTINAddress != 0) {
                this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
            } else {
                this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
            }
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, true);
            this.previousXTINAddress = this.currentXTINAddress;
            this.charLength = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        int n;
        if (this.xtiStream.isInterleaving()) {
            this.compression = (byte)9;
        }
        this.rootPageHeader[0] = (byte)(0x10 | this.compression);
        this.rootPageHeader[1] = this.currentXTINArraySlot >= 256 ? (byte)0 : (byte)this.currentXTINArraySlot;
        byte[] byArray = XTIUtil.intToByteArray(++this.currentXTINpageNumber);
        for (n = 0; n < byArray.length; ++n) {
            this.rootPageHeader[4 + n] = byArray[n];
        }
        this.xtiStream.setXTINPageNumber(0, this.rootPageHeader);
        this.rootPageHeader = this.xtiStream.getXTICPageNumber(0);
        this.rootPageHeader[0] = 1;
        byArray = XTIUtil.shortToByteArray(this.freeBytesQname);
        this.rootPageHeader[2] = byArray[0];
        this.rootPageHeader[3] = byArray[1];
        byArray = XTIUtil.intToByteArray(this.totalXTICPages);
        for (n = 0; n < byArray.length; ++n) {
            this.rootPageHeader[4 + n] = byArray[n];
        }
        byArray = XTIUtil.intToByteArray(this.freeBytesText);
        for (n = 0; n < byArray.length; ++n) {
            this.rootPageHeader[8 + n] = byArray[n];
        }
        byArray = XTIUtil.intToByteArray(this.lastTextPage);
        for (n = 0; n < byArray.length; ++n) {
            this.rootPageHeader[12 + n] = byArray[n];
        }
        byArray = XTIUtil.intToByteArray(this.lastQnamePage);
        for (n = 0; n < byArray.length; ++n) {
            this.rootPageHeader[16 + n] = byArray[n];
        }
        this.xtiStream.setXTICPageNumber(0, this.rootPageHeader);
        try {
            this.xtiStream.flushToStream();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.previousXTINAddress = this.parent.pop();
        this.curParentAddress = this.parent.peek();
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            int n;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 7;
            int[] nArray = new int[]{this.getXTICTextAddress(string2.length())[0], this.getXTICTextAddress(string.length())[0]};
            this.xtiStream.writePIToAddress(nArray, string2, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            if (this.previousXTINAddress == 0 && this.parent.size() != 0) {
                this.updateChildForXTIN(this.currentXTINAddress);
            }
            if (this.previousXTINAddress != 0) {
                byArray2 = XTIUtil.intToByteArray(this.previousXTINAddress);
                for (n = 0; n < byArray2.length; ++n) {
                    byArray[16 + n] = byArray2[n];
                }
            }
            if (this.parent.size() != 0) {
                n = this.parent.peek();
                byArray2 = XTIUtil.intToByteArray(n);
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[20 + i] = byArray2[i];
                }
            }
            if (this.previousXTINAddress != 0) {
                this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
            } else {
                this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
            }
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.rootPageHeader = this.xtiStream.getXTINPageNumber(0);
            byte[] byArray = new byte[32];
            byArray[0] = 9;
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            this.parent.push(this.currentXTINAddress);
            this.curParentAddress = this.parent.peek();
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n;
            int n2;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 1;
            int[] nArray = this.getXTICQnameAddress(string.length(), XMLUtil.getPrefix(string3).length(), string2.length());
            this.xtiStream.writeQnameTOAddress(nArray, string, XMLUtil.getPrefix(string3), string2);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[4 + n2] = byArray2[n2];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[8 + n2] = byArray2[n2];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            if (this.previousXTINAddress == 0 && this.parent.size() != 0) {
                this.updateChildForXTIN(this.currentXTINAddress);
            }
            byArray2 = this.previousXTINAddress != 0 ? XTIUtil.intToByteArray(this.previousXTINAddress) : XTIUtil.intToByteArray(this.currentXTINAddress);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[16 + n2] = byArray2[n2];
            }
            if (this.parent.size() != 0) {
                n2 = this.parent.peek();
                byArray2 = XTIUtil.intToByteArray(n2);
                for (n = 0; n < byArray2.length; ++n) {
                    byArray[20 + n] = byArray2[n];
                }
            }
            if (this.previousXTINAddress != 0) {
                this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
            } else {
                this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
            }
            n2 = this.updateAttributeNode(attributes);
            byArray2 = XTIUtil.intToByteArray(n2);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[28 + n] = byArray2[n];
            }
            this.parent.push(this.currentXTINAddress);
            this.curParentAddress = this.parent.peek();
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, true);
            this.previousXTINAddress = 0;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private int updateAttributeNode(Attributes attributes) throws XTIException {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                int n4;
                n3 = n2;
                n2 = this.getXTINAddress();
                if (i == 0) {
                    n = n2;
                }
                byArray = new byte[32];
                byArray[0] = 2;
                int[] nArray = this.getXTICQnameAddress(attributes.getURI(i).length(), XMLUtil.getPrefix(attributes.getQName(i)).length(), attributes.getLocalName(i).length());
                this.xtiStream.writeQnameTOAddress(nArray, attributes.getURI(i), XMLUtil.getPrefix(attributes.getQName(i)), attributes.getLocalName(i));
                byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[4 + n4] = byArray2[n4];
                }
                byArray2 = XTIUtil.intToByteArray(nArray[1]);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[8 + n4] = byArray2[n4];
                }
                nArray = this.getXTICTextAddress(attributes.getValue(i).getBytes("UTF-8").length);
                this.xtiStream.writeTextToAddress(nArray, attributes.getValue(i));
                byArray2 = XTIUtil.intToByteArray(nArray[0]);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[16 + n4] = byArray2[n4];
                }
                byArray2 = XTIUtil.intToByteArray(nArray[1]);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[12 + n4] = byArray2[n4];
                }
                byArray2 = XTIUtil.intToByteArray(this.currentXTINAddress);
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byArray[20 + n4] = byArray2[n4];
                }
                if (i != 0) {
                    this.updateNextAttributeForXTIN(n3, n2);
                }
                if (XMLUtil.getPrefix(attributes.getQName(i)).equals("xmlns")) {
                    byArray[29] = 2;
                } else if (XMLUtil.getPrefix(attributes.getQName(i)).length() == 0 && attributes.getLocalName(i).equals("xmlns")) {
                    byArray[29] = 4;
                }
                this.xtiStream.writeToXTINAddress(n2, byArray, false);
            }
            return n;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    private void updateNextAttributeForXTIN(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = (n & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 24;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
    }

    private void updateLastFirst4XTINLink(int n, int n2) {
        if (n == 0) {
            n = n2;
        }
        int n3 = n2 & 0xFF;
        int n4 = (n2 & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4);
        int n5 = n3 * 32 + 24;
        byArray[n5] = (byte)(n >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n >>> 0 & 0xFF);
        int n6 = n & 0xFF;
        int n7 = (n & 0x7FFFFF00) >>> 8;
        int n8 = n6 * 32 + 16;
        if (n4 == n7) {
            byArray[n8] = (byte)(n2 >>> 24 & 0xFF);
            byArray[n8 + 1] = (byte)(n2 >>> 16 & 0xFF);
            byArray[n8 + 2] = (byte)(n2 >>> 8 & 0xFF);
            byArray[n8 + 3] = (byte)(n2 >>> 0 & 0xFF);
            this.xtiStream.setXTINPageNumber(n4, byArray);
        } else {
            this.xtiStream.setXTINPageNumber(n4, byArray);
            byte[] byArray2 = this.xtiStream.getXTINPageNumber(n7);
            byArray2[n8] = (byte)(n2 >>> 24 & 0xFF);
            byArray2[n8 + 1] = (byte)(n2 >>> 16 & 0xFF);
            byArray2[n8 + 2] = (byte)(n2 >>> 8 & 0xFF);
            byArray2[n8 + 3] = (byte)(n2 >>> 0 & 0xFF);
            this.xtiStream.setXTINPageNumber(n7, byArray2);
        }
    }

    private void updatePreviousForXTIN(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = (n & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 16;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
    }

    private void updateNextForXTIN(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = (n & 0x7FFFFF00) >>> 8;
        int n5 = n3 * 32 + 24;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n4);
        byArray[n5] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n5 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n5 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n5 + 3] = (byte)(n2 >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n4, byArray);
        if (n != n2 && n != 0) {
            this.unsetIsLastChildFlag(n);
        }
    }

    private void updateChildForXTIN(int n) {
        int n2 = this.parent.peek() & 0xFF;
        int n3 = (this.parent.peek() & 0x7FFFFF00) >>> 8;
        int n4 = n2 * 32 + 12;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n3);
        byArray[n4] = (byte)(n >>> 24 & 0xFF);
        byArray[n4 + 1] = (byte)(n >>> 16 & 0xFF);
        byArray[n4 + 2] = (byte)(n >>> 8 & 0xFF);
        byArray[n4 + 3] = (byte)(n >>> 0 & 0xFF);
        this.xtiStream.setXTINPageNumber(n3, byArray);
    }

    private int getXTINAddress() {
        int n = 0;
        boolean bl = false;
        if (this.currentXTINpageNumber == 1 && this.currentXTINArraySlot == -1) {
            bl = true;
        }
        if (this.currentXTINArraySlot + 1 >= 256) {
            this.currentXTINArraySlot = 0;
            ++this.currentXTINpageNumber;
        } else {
            ++this.currentXTINArraySlot;
        }
        int n2 = n << 32 | this.currentXTINpageNumber << 8 | this.currentXTINArraySlot;
        if (bl) {
            this.updateRootAddress(n2);
        }
        return n2;
    }

    private void updateRootAddress(int n) {
        byte[] byArray = XTIUtil.intToByteArray(n);
        for (int i = 0; i < byArray.length; ++i) {
            this.rootPageHeader[8 + i] = byArray[i];
        }
    }

    private int[] getXTICTextAddress(int n) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[2];
        ++n;
        if (this.freeBytesText == 4092) {
            this.lastTextPage = ++this.totalXTICPages;
        }
        if (n < this.freeBytesText) {
            n3 = this.lastTextPage;
            n2 = 4096 - this.freeBytesText;
            this.freeBytesText -= n;
            nArray[1] = 0;
        } else if (n <= 4092) {
            ++this.totalXTICPages;
            this.lastTextPage = this.totalXTICPages;
            this.freeBytesText = 4092 - n;
            n3 = this.lastTextPage;
            n2 = 4;
            nArray[1] = 0;
        } else {
            int n4 = n / 4092;
            n3 = this.totalXTICPages + 1;
            this.totalXTICPages += n4;
            this.lastTextPage = this.totalXTICPages;
            this.freeBytesText = 4092 - n % 4092;
            nArray[1] = n;
        }
        nArray[0] = n3 << 12 | n2;
        return nArray;
    }

    private int[] getXTICQnameAddress(int n, int n2, int n3) {
        int[] nArray = new int[2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (this.freeBytesQname == 4096) {
            this.lastQnamePage = ++this.totalXTICPages;
        }
        if (++n < this.freeBytesQname) {
            n4 = 4096 - this.freeBytesQname;
            n5 = this.lastQnamePage;
            this.freeBytesQname -= n;
            bl = true;
        }
        int n8 = n2 + n3 + 2;
        if (++n8 < this.freeBytesQname) {
            n6 = 4096 - this.freeBytesQname;
            n7 = this.lastQnamePage;
            this.freeBytesQname -= n8;
            bl2 = true;
        }
        if (!bl) {
            ++this.totalXTICPages;
            this.lastQnamePage = this.totalXTICPages;
            n4 = 0;
            n5 = this.lastQnamePage;
            this.freeBytesQname = 4096 - n;
            bl = true;
        }
        if (!bl2) {
            if (n8 < this.freeBytesQname) {
                n6 = 4096 - this.freeBytesQname;
                n7 = this.lastQnamePage;
                bl2 = true;
                this.freeBytesQname -= n8;
            } else {
                ++this.totalXTICPages;
                this.lastQnamePage = this.totalXTICPages;
                n6 = 0;
                n7 = this.lastQnamePage;
                this.freeBytesQname = 4096 - n8;
                bl2 = true;
            }
        }
        nArray[0] = n5 << 12 | n4;
        nArray[1] = n7 << 12 | ++n6;
        return nArray;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            int n3;
            if (this.charLength > 0) {
                this.flushCharacters();
            }
            byte[] byArray = new byte[32];
            byArray[0] = 8;
            String string = new String(cArray, n, n2);
            int[] nArray = this.getXTICTextAddress(string.getBytes("UTF-8").length);
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray[8 + n3] = byArray2[n3];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray[4 + n3] = byArray2[n3];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            if (this.previousXTINAddress == 0 && this.parent.size() != 0) {
                this.updateChildForXTIN(this.currentXTINAddress);
            }
            if (this.previousXTINAddress != 0) {
                byArray2 = XTIUtil.intToByteArray(this.previousXTINAddress);
                for (n3 = 0; n3 < byArray2.length; ++n3) {
                    byArray[16 + n3] = byArray2[n3];
                }
            }
            if (this.parent.size() != 0) {
                n3 = this.parent.peek();
                byArray2 = XTIUtil.intToByteArray(n3);
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[20 + i] = byArray2[i];
                }
            }
            if (this.previousXTINAddress != 0) {
                this.updateNextForXTIN(this.previousXTINAddress, this.currentXTINAddress);
            } else {
                this.updateNextForXTIN(this.currentXTINAddress, this.currentXTINAddress);
            }
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.previousXTINAddress = this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.cdata = false;
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.charLength > 0) {
            this.flushCharacters();
        }
        this.cdata = true;
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    private void initXTINForUpdate() {
        byte[] byArray = this.xtiStream.readXTINPage(0);
        int n = byArray[0] & 0xF;
        if (n == 9) {
            this.xtiStream.setInterleaving(true);
        }
        this.currentXTINArraySlot = byArray[1] & 0xFF;
        this.xtinPagesBeforeUpdate = this.currentXTINpageNumber = XTIUtil.byteArrayToInt(byArray, 4) - 1;
        this.xtiStream.setTotalXTINPages(this.currentXTINpageNumber);
    }

    private void initXTICForUpdate() {
        byte[] byArray = this.xtiStream.readXTICPage(0);
        this.freeBytesQname = XTIUtil.byteArrayToShort(byArray, 2);
        this.totalXTICPages = XTIUtil.byteArrayToInt(byArray, 4);
        this.freeBytesText = XTIUtil.byteArrayToInt(byArray, 8);
        this.lastTextPage = XTIUtil.byteArrayToInt(byArray, 12);
        this.xticPagesBeforeUpdate = this.totalXTICPages;
        this.lastQnamePage = XTIUtil.byteArrayToInt(byArray, 16);
    }

    private void endXTINForUpdate() {
        byte[] byArray = this.xtiStream.readXTINPage(0);
        byArray[1] = (byte)this.currentXTINArraySlot;
        byte[] byArray2 = XTIUtil.intToByteArray(++this.currentXTINpageNumber);
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[4 + i] = byArray2[i];
        }
        this.xtiStream.setXTINPageNumber(0, byArray);
    }

    private void endXTICForUpdate() {
        int n;
        byte[] byArray = this.xtiStream.readXTICPage(0);
        byte[] byArray2 = XTIUtil.shortToByteArray(this.freeBytesQname);
        byArray[2] = byArray2[0];
        byArray[3] = byArray2[1];
        byArray2 = XTIUtil.intToByteArray(this.totalXTICPages);
        for (n = 0; n < byArray2.length; ++n) {
            byArray[4 + n] = byArray2[n];
        }
        byArray2 = XTIUtil.intToByteArray(this.freeBytesText);
        for (n = 0; n < byArray2.length; ++n) {
            byArray[8 + n] = byArray2[n];
        }
        byArray2 = XTIUtil.intToByteArray(this.lastTextPage);
        for (n = 0; n < byArray2.length; ++n) {
            byArray[12 + n] = byArray2[n];
        }
        byArray2 = XTIUtil.intToByteArray(this.lastQnamePage);
        for (n = 0; n < byArray2.length; ++n) {
            byArray[16 + n] = byArray2[n];
        }
        this.xtiStream.setXTICPageNumber(0, byArray);
    }

    private void loadPage(int n, int n2) {
        if (n == 0 && n2 <= this.xtinPagesBeforeUpdate) {
            this.xtiStream.readXTINPage(n2);
        } else if (n == 1 && n2 <= this.xticPagesBeforeUpdate) {
            this.xtiStream.readXTICPage(n2);
        }
    }

    private void flushData(int n, int[] nArray) throws Exception {
        if (this.totalXTICPages > this.xticPagesBeforeUpdate || this.currentXTINpageNumber > this.xtinPagesBeforeUpdate || !this.xtiStream.isSeekSupported()) {
            this.xtiStream.loadAllXTIN(this.xtinPagesBeforeUpdate);
            this.xtiStream.loadAllXTIC(this.xticPagesBeforeUpdate);
            this.xtiStream.flushPageWiseToStream();
        } else {
            this.xtiStream.flushPageToStream(0, 0);
            this.xtiStream.flushPageToStream(0, 1);
            this.xtiStream.flushPageToStream(n >> 8, 1);
            if (nArray != null) {
                this.xtiStream.flushPageToStream(nArray[0] >> 12, 1);
                this.xtiStream.flushPageToStream(nArray[1] >> 12, 1);
            }
        }
    }

    int createDocument() throws XTIException {
        try {
            int n;
            this.rootPageHeader = this.xtiStream.getXTINPageNumber(0);
            byte[] byArray = new byte[32];
            byArray[0] = 9;
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            if (this.xtiStream.isInterleaving()) {
                this.compression = (byte)9;
            }
            this.rootPageHeader[0] = (byte)(0x10 | this.compression);
            this.rootPageHeader[1] = this.currentXTINArraySlot >= 256 ? (byte)0 : (byte)this.currentXTINArraySlot;
            byte[] byArray2 = XTIUtil.intToByteArray(++this.currentXTINpageNumber);
            for (n = 0; n < byArray2.length; ++n) {
                this.rootPageHeader[4 + n] = byArray2[n];
            }
            this.xtiStream.setXTINPageNumber(0, this.rootPageHeader);
            this.rootPageHeader = this.xtiStream.getXTICPageNumber(0);
            this.rootPageHeader[0] = 1;
            byArray2 = XTIUtil.shortToByteArray(4096);
            this.rootPageHeader[2] = byArray2[0];
            this.rootPageHeader[3] = byArray2[1];
            byArray2 = XTIUtil.intToByteArray(0);
            for (n = 0; n < byArray2.length; ++n) {
                this.rootPageHeader[4 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(4092);
            for (n = 0; n < byArray2.length; ++n) {
                this.rootPageHeader[8 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(1);
            for (n = 0; n < byArray2.length; ++n) {
                this.rootPageHeader[12 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(1);
            for (n = 0; n < byArray2.length; ++n) {
                this.rootPageHeader[16 + n] = byArray2[n];
            }
            this.xtiStream.setXTICPageNumber(0, this.rootPageHeader);
            this.xtiStream.flushToStream();
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
        return this.currentXTINAddress;
    }

    int createAttribute(String string, String string2) throws XTIException {
        try {
            int n;
            this.initXTINForUpdate();
            this.initXTICForUpdate();
            int n2 = this.getXTINAddress();
            byte[] byArray = new byte[32];
            byArray[0] = 2;
            if (string == null) {
                string = "";
            }
            int[] nArray = this.getXTICQnameAddress(string.length(), XMLUtil.getPrefix(string2).length(), XMLUtil.getLocalName(string2).length());
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writeQnameTOAddress(nArray, string, XMLUtil.getPrefix(string2), XMLUtil.getLocalName(string2));
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            if (XMLUtil.getPrefix(string2).equals("xmlns")) {
                byArray[29] = 2;
            } else if (XMLUtil.getPrefix(string2).length() == 0 && XMLUtil.getLocalName(string2).equals("xmlns")) {
                byArray[29] = 4;
            }
            this.loadPage(0, n2 >> 8);
            this.xtiStream.writeToXTINAddress(n2, byArray, false);
            this.endXTINForUpdate();
            this.endXTICForUpdate();
            this.flushData(n2, nArray);
            return n2;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    int createElement(String string, String string2) throws XTIException {
        try {
            int n;
            this.initXTINForUpdate();
            this.initXTICForUpdate();
            byte[] byArray = new byte[32];
            byArray[0] = 1;
            int[] nArray = this.getXTICQnameAddress(string.length(), XMLUtil.getPrefix(string2).length(), XMLUtil.getLocalName(string2).length());
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writeQnameTOAddress(nArray, string, XMLUtil.getPrefix(string2), XMLUtil.getLocalName(string2));
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.endXTINForUpdate();
            this.endXTICForUpdate();
            this.flushData(this.currentXTINAddress, nArray);
            return this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    int createTextNode(String string, int n) throws XTIException {
        try {
            int n2;
            this.initXTINForUpdate();
            this.initXTICForUpdate();
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            byte[] byArray = new byte[32];
            byArray[0] = n == 0 ? 3 : (n == 1 ? 4 : 8);
            if (string == null) {
                string = "";
            }
            int[] nArray = this.getXTICTextAddress(string.getBytes("UTF-8").length);
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[8 + n2] = byArray2[n2];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[4 + n2] = byArray2[n2];
            }
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.endXTINForUpdate();
            this.endXTICForUpdate();
            this.flushData(this.currentXTINAddress, nArray);
            return this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    int createProcessingInstruction(String string, String string2) throws XTIException {
        try {
            int n;
            this.initXTINForUpdate();
            this.initXTICForUpdate();
            this.currentXTINAddress = this.getXTINAddress();
            this.updateParentFirstChild(this.currentXTINAddress);
            this.updateLastFirst4XTINLink(this.parentFirstChild.get(this.curParentAddress), this.currentXTINAddress);
            byte[] byArray = new byte[32];
            byArray[0] = 7;
            int[] nArray = new int[]{this.getXTICTextAddress(string2.length())[0], this.getXTICTextAddress(string.length())[0]};
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writePIToAddress(nArray, string2, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            this.endXTINForUpdate();
            this.endXTICForUpdate();
            this.flushData(this.currentXTINAddress, nArray);
            return this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    void setNodeValue(String string, int n) throws XTIException {
        try {
            int n2;
            if (string == null) {
                return;
            }
            this.initXTINForUpdate();
            this.initXTICForUpdate();
            byte[] byArray = this.xtiStream.readXTINPage(n >> 8);
            int n3 = n & 0xFF;
            n3 = 32 * n3;
            int[] nArray = this.getXTICTextAddress(string.getBytes("UTF-8").length);
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            if ((byArray[n3] & 0xF) == 2) {
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    byArray[n3 + 16 + n2] = byArray2[n2];
                }
                byArray2 = XTIUtil.intToByteArray(nArray[1]);
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    byArray[n3 + 12 + n2] = byArray2[n2];
                }
            } else if ((byArray[n3] & 0xF) == 4 || (byArray[n3] & 0xF) == 3 || (byArray[n3] & 0xF) == 8) {
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    byArray[n3 + 8 + n2] = byArray2[n2];
                }
                byArray2 = XTIUtil.intToByteArray(nArray[1]);
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    byArray[n3 + 4 + n2] = byArray2[n2];
                }
            }
            if ((byArray[n3] & 0xF) == 7) {
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    byArray[n3 + 4 + n2] = byArray2[n2];
                }
            }
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.setXTINPageNumber(n >> 8, byArray);
            this.endXTINForUpdate();
            this.endXTICForUpdate();
            this.flushData(this.currentXTINAddress, nArray);
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    void setNavigationNode(int n, int n2, int n3) throws XTIException {
        try {
            this.initXTINForUpdate();
            this.initXTICForUpdate();
            byte[] byArray = this.xtiStream.readXTINPage(n >> 8);
            int n4 = n & 0xFF;
            if (n3 == 0) {
                n4 = 32 * n4 + 20;
            } else if (n3 == 1) {
                n4 = 32 * n4 + 24;
            } else if (n3 == 2) {
                n4 = 32 * n4 + 16;
            } else if (n3 == 3) {
                n4 = 32 * n4 + 12;
            } else if (n3 == 4) {
                n4 = 32 * n4 + 28;
            }
            byte[] byArray2 = XTIUtil.intToByteArray(n2);
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[n4 + i] = byArray2[i];
            }
            this.xtiStream.setXTINPageNumber(n >> 8, byArray);
            this.endXTINForUpdate();
            this.endXTICForUpdate();
            this.flushData(this.currentXTINAddress, null);
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    void setQName(int n, String string, String string2) throws XTIException {
        try {
            int n2;
            this.initXTINForUpdate();
            this.initXTICForUpdate();
            byte[] byArray = this.xtiStream.readXTINPage(n >> 8);
            int n3 = n & 0xFF;
            n3 = 32 * n3;
            if (string == null) {
                string = "";
            }
            int[] nArray = this.getXTICQnameAddress(string.length(), XMLUtil.getPrefix(string2).length(), XMLUtil.getLocalName(string2).length());
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writeQnameTOAddress(nArray, string, XMLUtil.getPrefix(string2), XMLUtil.getLocalName(string2));
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[n3 + 4 + n2] = byArray2[n2];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[n3 + 8 + n2] = byArray2[n2];
            }
            if ((byArray[n3] & 0xF) == 2 && XMLUtil.getPrefix(string2).equals("xmlns")) {
                byArray[n3 + 29] = 2;
            } else if ((byArray[n3] & 0xF) == 2 && XMLUtil.getPrefix(string2).length() == 0 && XMLUtil.getLocalName(string2).equals("xmlns")) {
                byArray[n3 + 29] = 4;
            }
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.setXTINPageNumber(n, byArray);
            this.endXTINForUpdate();
            this.endXTICForUpdate();
            this.flushData(this.currentXTINAddress, nArray);
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }
}

