/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.xti.XTICompressor;
import oracle.xml.xti.XTIContentManager;
import oracle.xml.xti.XTIDecoder;
import oracle.xml.xti.XTIDecompressor;
import oracle.xml.xti.XTIEncoder;
import oracle.xml.xti.XTIException;

public class XTIStream
extends BinaryStream {
    HashMap<Integer, byte[]> xtic = new HashMap();
    HashMap<Integer, byte[]> xtin = new HashMap();
    static final int XTIN_STREAM = 0;
    static final int XTIC_STREAM = 1;
    private int totalXTINPages = 0;
    private boolean isInterleaving = false;
    XTIEncoder encoder = null;
    XTIDecoder decoder = null;

    XTIStream() {
    }

    public XTIEncoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new XTIEncoder(this);
        }
        return this.encoder;
    }

    public XTIDecoder getDecoder() {
        if (this.decoder == null) {
            this.decoder = new XTIDecoder(this);
        }
        return this.decoder;
    }

    @Override
    public XTIContentManager getContentManager() {
        return new XTIContentManager(this.getEncoder(), this.getDecoder());
    }

    byte[] getXTINPageNumber(int n) {
        byte[] byArray = null;
        byArray = this.xtin.containsKey(n) ? this.xtin.get(n) : new byte[8192];
        this.setXTINPageNumber(n, byArray);
        return byArray;
    }

    void setXTINPageNumber(int n, byte[] byArray) {
        this.xtin.put(n, byArray);
    }

    void setXTICPageNumber(int n, byte[] byArray) {
        this.xtic.put(n, byArray);
    }

    byte[] getXTICPageNumber(int n) {
        byte[] byArray = null;
        byArray = this.xtic.containsKey(n) ? this.xtic.get(n) : new byte[4096];
        this.setXTICPageNumber(n, byArray);
        return byArray;
    }

    void writeToXTINAddress(int n, byte[] byArray, boolean bl) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        n3 = 32 * n3;
        byte[] byArray2 = this.getXTINPageNumber(n2);
        byArray2 = this.copyData(byArray, byArray2, n3, 0, byArray.length);
        byte by = byArray2[n3];
        if (bl) {
            byArray2[n3] = by = (byte)(by | 0x10);
        }
        this.setXTINPageNumber(n2, byArray2);
    }

    void writePIToAddress(int[] nArray, String string, String string2) throws Exception {
        int n = 0;
        int n2 = 0;
        n = nArray[0] >> 12;
        n2 = nArray[0] & 0xFFF;
        byte[] byArray = this.getXTICPageNumber(n);
        byArray = this.copyData(string.getBytes("UTF-8"), byArray, n2, 0, string.getBytes("UTF-8").length);
        byArray[string.getBytes((String)"UTF-8").length + n2] = 0;
        this.setXTICPageNumber(n, byArray);
        n = nArray[1] >> 12;
        n2 = nArray[1] & 0xFFF;
        byArray = this.getXTICPageNumber(n);
        byArray = this.copyData(string2.getBytes("UTF-8"), byArray, n2, 0, string2.getBytes("UTF-8").length);
        byArray[string2.getBytes((String)"UTF-8").length + n2] = 0;
        this.setXTICPageNumber(n, byArray);
    }

    void writeTextToAddress(int[] nArray, String string) throws XTIException {
        try {
            int n = 0;
            int n2 = 0;
            byte[] byArray = null;
            int n3 = string.getBytes("UTF-8").length;
            if (n3 <= 4092) {
                n = nArray[0] >> 12;
                n2 = nArray[0] & 0xFFF;
                byArray = this.getXTICPageNumber(n);
                byArray = this.copyData(string.getBytes("UTF-8"), byArray, n2, 0, n3);
                byArray[n3 + n2] = 0;
                this.setXTICPageNumber(n, byArray);
            } else {
                n3 = nArray[1];
                int n4 = (n3 - n2) / 4096;
                n = nArray[0] >> 12;
                n2 = nArray[0] & 0xFFF;
                byArray = this.getXTICPageNumber(n);
                byArray = this.copyData(string.getBytes("UTF-8"), byArray, n2, 0, 4092 - n2);
                this.setXTICPageNumber(n, byArray);
                for (int i = 0; i < n4; ++i) {
                    byArray = this.xtic.containsKey(++n) ? this.xtic.get(n) : new byte[4096];
                    if (i + 1 == n4) {
                        int n5 = n3 - 4096 * (i - 1) - (4092 - n2);
                        byArray = this.copyData(string.getBytes("UTF-8"), byArray, 0, 4092 - n2 + 4096 * i, n5);
                    } else {
                        byArray = this.copyData(string.getBytes("UTF-8"), byArray, 0, 4092 - n2 + 4096 * i, 4096);
                    }
                    this.setXTICPageNumber(n, byArray);
                }
            }
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    void writeQnameTOAddress(int[] nArray, String string, String string2, String string3) throws XTIException {
        try {
            int n = nArray[0] >> 12;
            byte[] byArray = this.getXTICPageNumber(n);
            int n2 = nArray[0] & 0xFFF;
            byte[] byArray2 = string.getBytes("UTF-8");
            byArray = this.copyData(byArray2, byArray, n2, 0, byArray2.length);
            byArray[n2 + byArray2.length] = 0;
            this.setXTICPageNumber(n, byArray);
            n = nArray[1] >> 12;
            byArray = this.getXTICPageNumber(n);
            n2 = nArray[1] & 0xFFF;
            byArray2 = (string2 + ":" + string3).getBytes("UTF-8");
            byArray[--n2] = (byte)(string2.length() + 1);
            byArray = this.copyData(byArray2, byArray, n2 + 1, 0, byArray2.length);
            byArray[byArray2.length + 1 + n2] = 0;
            this.setXTICPageNumber(n, byArray);
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    private byte[] copyData(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            byArray2[n + i] = byArray[i];
        }
        return byArray2;
    }

    void flushInterleavingToStream() throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[BUFSIZE];
        int n = this.getMaxKey(0);
        int n2 = this.getMaxKey(1);
        int n3 = 0;
        do {
            byArray2 = (byArray2 = this.xtin.get(n3)) == null ? byArray3 : XTICompressor.compressXTINPage(byArray2, n3);
            this.flushBuffer(byArray2, BUFSIZE);
            byArray = this.xtic.get(n3);
            if (byArray == null) {
                byArray = byArray3;
            }
            this.flushBuffer(byArray, BUFSIZE);
        } while (++n3 <= n || n3 <= n2);
    }

    void flushToStream() throws IOException {
        int n;
        if (this.isInterleaving) {
            this.flushInterleavingToStream();
            return;
        }
        byte[] byArray = new byte[BUFSIZE];
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[8192];
        int n2 = this.getMaxKey(0);
        for (n = 0; n <= n2; ++n) {
            byArray2 = this.xtin.get(n);
            if (byArray2 == null) {
                byArray2 = byArray3;
            }
            this.flushBuffer(byArray2, BUFSIZE);
            System.arraycopy(byArray2, BUFSIZE, byArray, 0, BUFSIZE);
            this.flushBuffer(byArray, BUFSIZE);
        }
        n2 = this.getMaxKey(1);
        for (n = 0; n <= n2; ++n) {
            byArray2 = this.xtic.get(n);
            if (byArray2 == null) {
                byArray2 = byArray3;
            }
            this.flushBuffer(byArray2, BUFSIZE);
        }
    }

    void flushPageWiseToStream() throws IOException {
        int n;
        byte[] byArray = null;
        byte[] byArray2 = new byte[8192];
        int n2 = this.getMaxKey(0);
        for (n = 0; n <= n2; ++n) {
            byArray = this.xtin.get(n);
            if (byArray == null) {
                byArray = byArray2;
                this.xtin.put(n, byArray);
            }
            this.flushPageToStream(n, 0);
        }
        n2 = this.getMaxKey(1);
        for (n = 0; n <= n2; ++n) {
            byArray = this.xtic.get(n);
            if (byArray == null) {
                byArray = byArray2;
                this.xtic.put(n, byArray2);
            }
            this.flushPageToStream(n, 1);
        }
    }

    void flushPageToStream(int n, int n2) throws IOException {
        byte[] byArray = new byte[BUFSIZE];
        byte[] byArray2 = null;
        if (n2 == 0) {
            byArray2 = this.xtin.get(n);
            if (byArray2 == null) {
                return;
            }
            if (this.isInterleaving) {
                this.flushBuffer(XTICompressor.compressXTINPage(byArray2, n), n * 2, BUFSIZE);
            } else {
                this.flushBuffer(byArray2, n * 2, BUFSIZE);
                System.arraycopy(byArray2, BUFSIZE, byArray, 0, BUFSIZE);
                this.flushBuffer(byArray, n * 2 + 1, BUFSIZE);
            }
        }
        if (n2 == 1) {
            byArray2 = this.xtic.get(n);
            if (byArray2 == null) {
                return;
            }
            if (this.isInterleaving) {
                this.flushBuffer(byArray2, n * 2 + 1, BUFSIZE);
            } else {
                this.flushBuffer(byArray2, this.totalXTINPages * 2 + n, BUFSIZE);
            }
        }
    }

    void cleanUp() {
        if (this.xtin != null && this.xtin.size() > 0) {
            this.xtin.clear();
        }
        if (this.xtic != null && this.xtic.size() > 0) {
            this.xtic.clear();
        }
        this.totalXTINPages = 0;
        this.isInterleaving = false;
    }

    private int getMaxKey(int n) {
        Set<Integer> set = null;
        set = n == 0 ? this.xtin.keySet() : this.xtic.keySet();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(set);
        Collections.sort(arrayList);
        int n2 = arrayList.get(arrayList.size() - 1);
        return n2;
    }

    byte[] readXTINPage(int n) {
        if (!this.xtin.containsKey(n)) {
            this.loadXTINPage(n);
        }
        return this.xtin.get(n);
    }

    byte[] readXTICPage(int n) {
        if (!this.xtic.containsKey(n)) {
            this.loadXTICPage(n);
        }
        return this.xtic.get(n);
    }

    void loadAllXTIN(int n) {
        for (int i = 1; i <= n; ++i) {
            this.readXTINPage(n);
        }
    }

    void loadAllXTIC(int n) {
        for (int i = 1; i <= n; ++i) {
            this.readXTICPage(n);
        }
    }

    private byte[] loadXTINPage(int n) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (this.isInterleaving) {
            byArray = this.load(n * 2, true);
            byArray3 = XTIDecompressor.uncompressXTINPage(byArray, n);
        } else {
            byArray = this.load(n * 2, true);
            byArray2 = this.load(n * 2 + 1, true);
            byArray3 = new byte[8192];
            System.arraycopy(byArray, 0, byArray3, 0, BUFSIZE);
            System.arraycopy(byArray2, 0, byArray3, BUFSIZE, BUFSIZE);
        }
        this.xtin.put(n, byArray3);
        return byArray3;
    }

    void setTotalXTINPages(int n) {
        this.totalXTINPages = n;
    }

    boolean isInterleaving() {
        return this.isInterleaving;
    }

    void setInterleaving(boolean bl) {
        this.isInterleaving = bl;
    }

    private byte[] loadXTICPage(int n) {
        byte[] byArray = null;
        byArray = this.isInterleaving ? this.load(n * 2 + 1, true) : this.load(this.totalXTINPages * 2 + n, true);
        this.xtic.put(n, byArray);
        return byArray;
    }
}

