/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.util.Map;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.Message;
import javax.security.auth.Subject;

public class ServerSynchroMessageConnectionImpl
implements ServerSynchroMessageConnection {
    private transient int[] connectionLock = new int[0];
    private transient MessageConnection connection;
    private transient ServerAdmin serverAdmin = null;
    private Map env;
    private transient SynchroCallback callback;
    private transient ThreadService threads;
    private transient MessageReader reader;
    private static final int UNCONNECTED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int FAILED = 4;
    private static final int TERMINATED = 5;
    private int state = 1;
    private int[] stateLock = new int[0];
    private long waitConnectedState;
    private final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SynchroMessageConnectionImpl");

    public ServerSynchroMessageConnectionImpl(MessageConnection messageConnection, Map map) throws IOException {
        if (messageConnection == null) {
            throw new IllegalArgumentException("Null message connection.");
        }
        this.env = map;
        this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(map);
        this.serverAdmin = DefaultConfig.getServerAdmin(this.env);
        this.connection = messageConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map map) throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state != 1) {
                this.waitConnected();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.state = 2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.connection.connect(map);
            this.connection = this.serverAdmin.connectionOpen(this.connection);
            nArray = this.stateLock;
            synchronized (this.stateLock) {
                if (this.state != 2) {
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new IOException("The connecting is stooped by another thread.");
                }
                this.state = 3;
                this.stateLock.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOneWay(Message message) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("sendOneWay", "Send a message without response.");
        }
        this.waitConnected();
        int[] nArray = this.connectionLock;
        synchronized (this.connectionLock) {
            this.connection.writeMessage(message);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setCallback(SynchroCallback synchroCallback) {
        if (this.logger.traceOn()) {
            this.logger.trace("setCallback", "be called.");
        }
        if (this.callback != null) {
            throw new IllegalArgumentException("The callback has been assigned.");
        }
        if (synchroCallback == null) {
            throw new IllegalArgumentException("Null callback.");
        }
        this.callback = synchroCallback;
        this.threads = new ThreadService(DefaultConfig.getServerMinThreads(this.env), DefaultConfig.getServerMaxThreads(this.env));
        this.reader = new MessageReader();
        this.threads.handoff(this.reader);
    }

    public String getConnectionId() {
        return this.connection.getConnectionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("close", "Closing this SynchroMessageConnection.");
        }
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 5) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 5;
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Close the callback reader.");
            }
            if (this.reader != null) {
                this.reader.stop();
            }
            if (this.threads != null) {
                this.threads.terminate();
                this.threads = null;
            }
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Closing the underlying connection.");
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.serverAdmin.connectionClosed(this.connection);
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Clean all threads waiting theire responses.");
            }
            this.stateLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public MessageConnection getAsynchroConnection() {
        return this.connection;
    }

    public Subject getSubject() {
        return this.serverAdmin.getSubject(this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitConnected() throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state != 2) {
                throw new IOException("The connection was closed or failed.");
            }
            long l = System.currentTimeMillis();
            long l2 = this.waitConnectedState;
            while (this.state == 2 && this.waitConnectedState > 0L) {
                try {
                    this.stateLock.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                l2 = this.waitConnectedState - (System.currentTimeMillis() - l);
            }
            if (this.state != 3) {
                throw new IOException("The connection is not connected.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class RemoteJob
    implements Runnable {
        private Message msg;

        public RemoteJob(Message message) {
            this.msg = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                    ServerSynchroMessageConnectionImpl.this.logger.trace("RemoteJob-run", "Receive a new request.");
                }
                try {
                    Message message = ServerSynchroMessageConnectionImpl.this.callback.execute(this.msg);
                    if (message == null) break block10;
                    int[] nArray = ServerSynchroMessageConnectionImpl.this.connectionLock;
                    synchronized (nArray) {
                        ServerSynchroMessageConnectionImpl.this.connection.writeMessage(message);
                    }
                }
                catch (Exception exception) {
                    int[] nArray = ServerSynchroMessageConnectionImpl.this.stateLock;
                    synchronized (nArray) {
                        if (ServerSynchroMessageConnectionImpl.this.state != 3 && ServerSynchroMessageConnectionImpl.this.callback != null) {
                            ServerSynchroMessageConnectionImpl.this.callback.connectionException(exception);
                        }
                    }
                }
            }
        }
    }

    private class MessageReader
    implements Runnable {
        private Thread executingThread;
        private boolean executingThreadInterrupted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            block12: {
                try {
                    this.executingThread = Thread.currentThread();
                    while (!this.stopped()) {
                        if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                            ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "Waiting a coming message...");
                        }
                        object = null;
                        try {
                            object = ServerSynchroMessageConnectionImpl.this.connection.readMessage();
                        }
                        catch (Exception exception) {
                            if (!this.stopped()) {
                                ServerSynchroMessageConnectionImpl.this.callback.connectionException(exception);
                            }
                            break;
                        }
                        if (!this.stopped()) {
                            ServerSynchroMessageConnectionImpl.this.threads.handoff(new RemoteJob((Message)object));
                            if (!(object instanceof CloseMessage)) continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!ServerSynchroMessageConnectionImpl.this.logger.traceOn()) break block12;
                    ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "stops.");
                }
            }
            object = ServerSynchroMessageConnectionImpl.this.stateLock;
            synchronized (object) {
                this.executingThreadInterrupted = true;
            }
            if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "ended.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-terminated", "be called.");
            }
            int[] nArray = ServerSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                if (Thread.currentThread() != this.executingThread && this.executingThread != null && !this.executingThreadInterrupted) {
                    this.executingThreadInterrupted = true;
                    this.executingThread.interrupt();
                }
            }
            if (ServerSynchroMessageConnectionImpl.this.logger.traceOn()) {
                ServerSynchroMessageConnectionImpl.this.logger.trace("MessageReader-terminated", "done.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stopped() {
            int[] nArray = ServerSynchroMessageConnectionImpl.this.stateLock;
            synchronized (nArray) {
                return ServerSynchroMessageConnectionImpl.this.state != 3 || this.executingThreadInterrupted;
            }
        }
    }
}

