/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ObjectWrappingImpl;
import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServerImpl;
import com.sun.jmx.remote.opt.internal.ArrayNotificationBuffer;
import com.sun.jmx.remote.opt.internal.NotificationBuffer;
import com.sun.jmx.remote.opt.security.MBeanServerFileAccessController;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.generic.MessageConnectionServer;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.generic.ServerIntermediary;
import javax.security.auth.Subject;

public class GenericConnectorServer
extends JMXConnectorServer {
    public static final String OBJECT_WRAPPING = "jmx.remote.object.wrapping";
    public static final String MESSAGE_CONNECTION_SERVER = "jmx.remote.message.connection.server";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.generic", "GenericConnectorServer");
    private Receiver receiver;
    private SynchroMessageConnectionServer sMsgServer;
    private ObjectWrapping objectWrapping;
    private Map env;
    private ClassLoader defaultClassLoader = null;
    private ThreadService threads = new ThreadService(0, 10);
    private ArrayList clientList = new ArrayList();
    private static final int DEFAULT_NOTIF_BUFFER_SIZE = 1000;
    private static final int CREATED = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private int state = 0;
    private int[] lock = new int[0];
    private static long clientIDCount = 0L;
    private static final int[] clientIDCountLock = new int[0];
    private NotificationBuffer notifBuffer;
    private final long connectingTimeout;
    private static Timer cancelConnecting = new Timer(true);

    public GenericConnectorServer(Map map, MBeanServer mBeanServer) {
        super(mBeanServer);
        if (map == null) {
            this.env = Collections.EMPTY_MAP;
        } else {
            EnvHelp.checkAttributes(map);
            this.env = Collections.unmodifiableMap(map);
        }
        this.connectingTimeout = DefaultConfig.getConnectingTimeout(this.env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientClosing(ServerIntermediary serverIntermediary, String string, String string2, Object object) {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            this.clientList.remove(serverIntermediary);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            super.connectionClosed(string, string2, object);
            return;
        }
    }

    public JMXServiceURL getAddress() {
        if (!this.isActive()) {
            return null;
        }
        return this.sMsgServer.getAddress();
    }

    public Map getAttributes() {
        Map map = EnvHelp.filterAttributes(this.env);
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        boolean bl = logger.traceOn();
        int[] nArray = this.lock;
        synchronized (this.lock) {
            Object object;
            Object object2;
            MBeanServer mBeanServer;
            if (this.state == 1) {
                if (bl) {
                    logger.trace("start", "already started");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.state == 2) {
                if (bl) {
                    logger.trace("start", "already stopped");
                }
                throw new IOException("The server has been stopped.");
            }
            if (bl) {
                logger.trace("start", "starting...");
            }
            if (bl) {
                logger.trace("start", "setting MBeanServer...");
            }
            if ((mBeanServer = this.getMBeanServer()) == null) {
                throw new IllegalStateException("This connector server is not attached to an MBean server");
            }
            if (this.env != null && (object2 = (String)this.env.get("jmx.remote.x.access.file")) != null) {
                object = null;
                try {
                    object = new MBeanServerFileAccessController((String)object2);
                }
                catch (IOException iOException) {
                    throw (IllegalArgumentException)EnvHelp.initCause(new IllegalArgumentException(iOException.getMessage()), iOException);
                }
                this.setMBeanServerForwarder((MBeanServerForwarder)object);
                mBeanServer = this.getMBeanServer();
            }
            if (bl) {
                logger.trace("start", "setting default ClassLoader...");
            }
            try {
                this.defaultClassLoader = EnvHelp.resolveServerClassLoader(this.env, mBeanServer);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (bl) {
                    logger.debug("start", "ClassLoader not found: " + instanceNotFoundException);
                }
                object = new IllegalArgumentException("ClassLoader not found: " + instanceNotFoundException);
                throw (IllegalArgumentException)EnvHelp.initCause((Throwable)object, instanceNotFoundException);
            }
            if (bl) {
                logger.trace("start", "setting ObjectWrapping...");
            }
            this.objectWrapping = (ObjectWrapping)this.env.get(OBJECT_WRAPPING);
            if (this.objectWrapping == null) {
                this.objectWrapping = new ObjectWrappingImpl();
            }
            if ((object2 = (MessageConnectionServer)this.env.get(MESSAGE_CONNECTION_SERVER)) == null) {
                this.sMsgServer = DefaultConfig.getSynchroMessageConnectionServer(this.env);
                if (this.sMsgServer == null) {
                    throw new IllegalArgumentException("No message connection server");
                }
            } else {
                this.sMsgServer = new SynchroMessageConnectionServerImpl((MessageConnectionServer)object2, this.env);
            }
            this.sMsgServer.start(this.env);
            this.state = 1;
            if (bl) {
                logger.trace("start", "Connector Server Address = " + this.sMsgServer.getAddress());
                logger.trace("start", "started.");
            }
            this.receiver = new Receiver();
            this.receiver.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        boolean bl = logger.traceOn();
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 2) {
                if (bl) {
                    logger.trace("stop", "already stopped.");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.state == 0 && bl) {
                logger.trace("stop", "not started yet.");
            }
            this.state = 2;
            boolean bl2 = logger.debugOn();
            if (bl) {
                logger.trace("stop", "stoping.");
            }
            Object var4_4 = null;
            if (bl) {
                logger.trace("stop", "stop MessageConnectionServer...");
            }
            if (this.sMsgServer != null) {
                this.sMsgServer.stop();
            }
            if (bl) {
                logger.trace("stop", "stop clients...");
            }
            if (bl) {
                logger.trace("stop", this.clientList.size() + "client(s) found...");
            }
            while (this.clientList.size() > 0) {
                try {
                    ServerIntermediary serverIntermediary = (ServerIntermediary)this.clientList.remove(0);
                    serverIntermediary.terminate();
                }
                catch (Exception exception) {
                    logger.warning("stop", "Failed to stop client: " + exception);
                    if (!bl2) continue;
                    logger.debug("stop", exception);
                }
            }
            if (this.notifBuffer != null) {
                this.notifBuffer.dispose();
            }
            this.threads.terminate();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            cancelConnecting.cancel();
            if (bl) {
                logger.trace("stop", "stopped.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 1;
        }
    }

    void failedConnectionNotif(String string, String string2, Object object) {
        super.connectionFailed(string, string2, object);
    }

    synchronized NotificationBuffer getNotifBuffer() {
        if (this.notifBuffer == null) {
            this.notifBuffer = ArrayNotificationBuffer.getNotificationBuffer(this.getMBeanServer(), this.env);
        }
        return this.notifBuffer;
    }

    private class ConnectingStopper
    extends TimerTask {
        private final ClientCreation cc;

        public ConnectingStopper(ClientCreation clientCreation) {
            this.cc = clientCreation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: {
                ClientCreation clientCreation = this.cc;
                synchronized (clientCreation) {
                    if (this.cc.done) {
                        return;
                    }
                    this.cc.done = true;
                }
                if (logger.traceOn()) {
                    logger.trace("ConnectingStopper.run", "Connecting timeout for: " + this.cc.connection);
                }
                System.out.println("---jsl-server-stopper: close a timeout connecting...");
                try {
                    this.cc.connection.close();
                }
                catch (Exception exception) {
                    if (!logger.debugOn()) break block7;
                    logger.debug("ConnectingStoper.run", exception);
                }
            }
            System.out.println("---jsl-server-stopper: close a timeout connecting DONE!!!");
        }
    }

    private class ClientCreation
    implements Runnable {
        ServerSynchroMessageConnection connection;
        private boolean done = false;
        private ConnectingStopper stopper;

        public ClientCreation(ServerSynchroMessageConnection serverSynchroMessageConnection) {
            this.connection = serverSynchroMessageConnection;
        }

        public void setStopper(ConnectingStopper connectingStopper) {
            this.stopper = connectingStopper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            Subject subject;
            boolean bl2;
            block26: {
                bl2 = logger.traceOn();
                subject = null;
                bl = false;
                try {
                    this.connection.connect(GenericConnectorServer.this.env);
                    if (bl2) {
                        logger.trace("ClientCreation.run", "opening connection.");
                    }
                    subject = this.connection.getSubject();
                }
                catch (Throwable throwable) {
                    bl = true;
                    logger.warning("ClientCreation.run", "Failed to open connection: " + throwable, throwable);
                    if (bl2) {
                        logger.debug("ClientCreation.run", throwable);
                    }
                    try {
                        if (bl2) {
                            logger.debug("ClientCreation.run", "cleaning up...");
                        }
                        this.connection.close();
                    }
                    catch (Exception exception) {
                        if (logger.debugOn()) {
                            logger.debug("ClientCreation.run", "Failed to cleanup: " + exception);
                        }
                        if (!logger.debugOn()) break block26;
                        logger.debug("ClientCreation.run", exception);
                    }
                }
            }
            Object object = this;
            synchronized (object) {
                if (this.done) {
                    bl = true;
                } else {
                    this.done = true;
                    if (this.stopper != null) {
                        this.stopper.cancel();
                    }
                }
            }
            if (bl) {
                return;
            }
            if (bl2) {
                logger.trace("ClientCreation.run", "connection opened.");
            }
            object = new ServerIntermediary(GenericConnectorServer.this.getMBeanServer(), GenericConnectorServer.this, this.connection, GenericConnectorServer.this.objectWrapping, subject, GenericConnectorServer.this.defaultClassLoader, GenericConnectorServer.this.env);
            Object object2 = GenericConnectorServer.this.lock;
            synchronized (object2) {
                if (GenericConnectorServer.this.state != 1) {
                    block27: {
                        try {
                            if (logger.debugOn()) {
                                logger.debug("ClientCreation.run", "connector already stopped.");
                            }
                            if (bl2) {
                                logger.trace("ClientCreation.run", "cleaning up...");
                            }
                            ((ServerIntermediary)object).terminate();
                        }
                        catch (Exception exception) {
                            if (logger.debugOn()) {
                                logger.debug("ClientCreation.run", "Failed to cleanup: " + exception);
                            }
                            if (!logger.debugOn()) break block27;
                            logger.debug("ClientCreation.run", exception);
                        }
                    }
                    return;
                }
                if (bl2) {
                    logger.trace("ClientCreation.run", "adding connection to client list.");
                }
                GenericConnectorServer.this.clientList.add(object);
            }
            object2 = this.connection.getConnectionId();
            GenericConnectorServer.this.connectionOpened((String)object2, "New client connection " + (String)object2 + " has been established", null);
            ((ServerIntermediary)object).start();
        }
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            if (logger.debugOn()) {
                logger.debug("Receiver.run", "starting receiver.");
            }
            while (GenericConnectorServer.this.isActive()) {
                boolean bl = logger.traceOn();
                ServerSynchroMessageConnection serverSynchroMessageConnection = null;
                boolean bl2 = logger.debugOn();
                if (bl) {
                    logger.trace("Receiver.run", "waiting for connection.");
                }
                try {
                    serverSynchroMessageConnection = GenericConnectorServer.this.sMsgServer.accept();
                }
                catch (IOException iOException) {
                    if (GenericConnectorServer.this.isActive()) {
                        logger.error("Receiver.run", "Unexpected IOException: " + iOException);
                        if (bl2) {
                            logger.debug("Receiver.run", iOException);
                        }
                        try {
                            logger.error("Receiver.run", "stopping server");
                            GenericConnectorServer.this.stop();
                        }
                        catch (IOException iOException2) {
                            logger.warning("Receiver.run", "Failed to stop server: " + iOException2);
                            if (!bl2) break;
                            logger.debug("Receiver.run", iOException2);
                        }
                        break;
                    }
                    if (!bl) break;
                    logger.trace("Receiver.run", "interrupted: " + iOException);
                    break;
                }
                if (!GenericConnectorServer.this.isActive()) {
                    return;
                }
                if (bl) {
                    logger.trace("Receiver.run", "received connection request.");
                }
                ClientCreation clientCreation = new ClientCreation(serverSynchroMessageConnection);
                if (GenericConnectorServer.this.connectingTimeout <= 0L) {
                    GenericConnectorServer.this.threads.handoff(clientCreation);
                    continue;
                }
                System.out.println("---jsl-Server: add stopper, timeout = " + GenericConnectorServer.this.connectingTimeout);
                ConnectingStopper connectingStopper = new ConnectingStopper(clientCreation);
                clientCreation.setStopper(connectingStopper);
                GenericConnectorServer.this.threads.handoff(clientCreation);
                cancelConnecting.schedule((TimerTask)connectingStopper, GenericConnectorServer.this.connectingTimeout);
            }
            if (logger.debugOn()) {
                logger.debug("Receiver.run", "receiver terminated");
            }
        }
    }
}

