/*
 * Decompiled with CFR 0.152.
 */
package com.sun.srs.im;

import com.sun.srs.im.MessageContent;
import java.io.File;

public class GenericData
implements MessageContent {
    private byte[] content;
    private String mimeType;
    private File contentFile;

    public GenericData(String mimeType, byte[] content) {
        if (mimeType == null) {
            throw new IllegalArgumentException("null mimeType");
        }
        if (content == null || content.length == 0) {
            throw new IllegalArgumentException("null or empty content");
        }
        this.mimeType = mimeType;
        this.content = content;
        this.contentFile = null;
    }

    public GenericData(String mimeType, File contentFile) {
        if (mimeType == null) {
            throw new IllegalArgumentException("null mimeType");
        }
        if (contentFile == null || !contentFile.canRead()) {
            throw new IllegalArgumentException("inaccessible file");
        }
        this.mimeType = mimeType;
        this.contentFile = contentFile;
        this.content = null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public File getContentFile() {
        return this.contentFile;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    byte[] getMsgContent() {
        if (this.content != null) {
            return this.content;
        }
        if (this.contentFile != null) {
            return this.contentFile.getAbsolutePath().getBytes();
        }
        throw new RuntimeException("invalid GenericData object?!");
    }

    public boolean contentIsFile() {
        return this.contentFile != null;
    }
}

