/*
 * Decompiled with CFR 0.152.
 */
package com.sun.srs.im;

import com.sun.srs.im.AlarmData;
import com.sun.srs.im.CallbackParams;
import com.sun.srs.im.EventData;
import com.sun.srs.im.FileAccessException;
import com.sun.srs.im.GenericData;
import com.sun.srs.im.MessageContent;
import com.sun.srs.im.MessageData;
import com.sun.srs.im.NoDiskSpaceException;
import com.sun.srs.im.NoMemoryException;
import com.sun.srs.im.ProxyException;
import com.sun.srs.im.ProxyIOException;
import com.sun.srs.im.ProxyMaintenanceException;
import com.sun.srs.im.RegistrationException;
import com.sun.srs.im.SRSMockProxy;
import com.sun.srs.im.SRSProxyListener;
import com.sun.srs.im.StatusData;
import com.sun.srs.im.SupportInstanceData;
import java.util.List;

class ProxyConnection {
    private static final int MSGTYPE_ALARM = 1;
    private static final int MSGTYPE_EVENT = 2;
    private static final int MSGTYPE_DATA = 3;
    private static final int INT_HANDLEIDX = 0;
    private static final int INT_MSGTYPE = 1;
    private static final int INT_QPRI = 2;
    private static final int INT_QPERSIST = 3;
    private static final int INT_QEXPIRES = 4;
    private static final int INT_EVTTIME = 5;
    private static final int INT_EVTSEVERITY = 6;
    private static final int NUMINTS = 7;
    private static final int BOOL_HASDATA = 0;
    private static final int BOOL_DATAISFILE = 1;
    private static final int NUMBOOLS = 2;
    private static final int STRING_MGMTID = 0;
    private static final int STRING_SUBTYPE = 1;
    private static final int STRING_REFID = 2;
    private static final int STRING_MIMETYPE = 3;
    private static final int STRING_EVTSRCID = 4;
    private static final int STRING_EVTTEXT = 5;
    private static final int STRING_ALARMID = 6;
    private static final int STRING_ALARMSTATE = 7;
    private static final int NUMSTRINGS = 8;
    private int jhandle;

    static native int setRetries(int var0, int var1);

    private native int registerIM(String var1, String var2, int var3, int var4, int var5, int var6);

    private native int register(SRSProxyListener var1, boolean var2, String var3, String var4);

    private native void close(int var1);

    private native int senddata(boolean[] var1, int[] var2, String[] var3, byte[] var4);

    private native int sendstatus(int var1, int var2, int[] var3, String[] var4);

    private native int registersis(int var1, int var2, int var3, String[] var4, byte[][] var5);

    private native int deregistersi(int var1, String var2);

    ProxyConnection(String name, String version, CallbackParams cbparams, SRSMockProxy moxy) throws ProxyException, ProxyIOException {
        this.jhandle = moxy == null ? this.register(cbparams.getListener(), false, null, null) : this.register(cbparams.getListener(), true, moxy.getInfileName(), moxy.getOutfileName());
        if (this.jhandle == -1) {
            throw new IllegalArgumentException("invalid listener");
        }
        int rc = this.registerIM(name, version, cbparams.getWDInterval(), cbparams.getHBInterval(), cbparams.getDisposition().getValue(), this.jhandle);
        if (rc != 0) {
            this.close();
        }
        this.checkNativeReturn(rc);
    }

    private void checkNativeReturn(int rc) throws ProxyException, ProxyIOException {
        switch (rc) {
            case 0: {
                break;
            }
            case 1: {
                throw new ProxyException("generic/unspecified error");
            }
            case 2: {
                throw new RegistrationException("IM is not registered");
            }
            case 3: {
                throw new ProxyException("invalid parameter");
            }
            case 4: {
                throw new ProxyIOException();
            }
            case 5: {
                throw new ProxyMaintenanceException();
            }
            case 6: {
                throw new ProxyException("internal error");
            }
            case 7: {
                throw new RegistrationException("already registered");
            }
            case 8: {
                throw new ProxyException("invalid callbacks");
            }
            case 9: {
                throw new FileAccessException("file access error");
            }
            case 10: {
                throw new RegistrationException("unregistered mgmt id");
            }
            case 11: {
                throw new NoMemoryException("memory allocation failure");
            }
            case 12: {
                throw new NoDiskSpaceException("proxy out of disk space");
            }
            case 13: {
                throw new ProxyException("callback function not implemented");
            }
            case 14: {
                throw new ProxyException("can't make forward calls from callback function");
            }
            default: {
                throw new ProxyException("unknown/unexpected return value: " + rc);
            }
        }
    }

    void sendData(String mgmtId, MessageData data) throws ProxyException, ProxyIOException {
        int i;
        String[] strings = new String[8];
        int[] ints = new int[7];
        boolean[] bools = new boolean[2];
        byte[] dataContent = null;
        for (i = 0; i < 8; ++i) {
            strings[i] = null;
        }
        for (i = 0; i < 2; ++i) {
            bools[i] = false;
        }
        for (i = 0; i < 7; ++i) {
            ints[i] = 0;
        }
        ints[0] = this.jhandle;
        ints[2] = data.getQHints().getPriority().getValue();
        ints[3] = data.getQHints().getPersistence().getValue();
        ints[4] = data.getQHints().getExpireTime().getSecondsSinceEpoch();
        strings[0] = mgmtId;
        strings[1] = data.getSubtype();
        strings[2] = data.getRefId();
        MessageContent content = data.getContent();
        GenericData gd = null;
        EventData ed = null;
        if (content instanceof AlarmData) {
            ed = (EventData)content;
            ints[1] = 1;
            strings[6] = ((AlarmData)content).getAlarmId();
            strings[7] = ((AlarmData)content).getAlarmState();
        } else if (content instanceof EventData) {
            ed = (EventData)content;
            ints[1] = 2;
        } else if (content instanceof GenericData) {
            gd = (GenericData)content;
            ints[1] = 3;
        }
        if (ed != null) {
            gd = ed.getData();
            strings[4] = ed.getSrcId();
            strings[5] = ed.getText();
            ints[6] = ed.getSeverity().getValue();
            ints[5] = ed.getTimestamp().getSecondsSinceEpoch();
        }
        if (gd != null) {
            bools[0] = true;
            bools[1] = gd.contentIsFile();
            strings[3] = gd.getMimeType();
            dataContent = gd.getMsgContent();
        }
        this.checkNativeReturn(this.senddata(bools, ints, strings, dataContent));
    }

    void sendStatus(List componentStatuses) throws ProxyException, ProxyIOException {
        int[] ints = new int[componentStatuses.size()];
        String[] strings = new String[componentStatuses.size()];
        for (int i = 0; i < componentStatuses.size(); ++i) {
            StatusData sd = (StatusData)componentStatuses.get(i);
            ints[i] = sd.getStatus().getValue();
            strings[i] = sd.getMgmtId();
        }
        this.checkNativeReturn(this.sendstatus(this.jhandle, componentStatuses.size(), ints, strings));
    }

    void registerSI(List supportInstances) throws ProxyException, ProxyIOException {
        int stringsPerInstance = 3;
        int numStrings = 3 * supportInstances.size();
        String[] strings = new String[numStrings];
        byte[][] blobs = new byte[supportInstances.size()][];
        for (int i = 0; i < supportInstances.size(); ++i) {
            SupportInstanceData sid = (SupportInstanceData)supportInstances.get(i);
            int stridx = 3 * i;
            strings[stridx++] = sid.getMgmtId();
            strings[stridx++] = sid.getVersion();
            strings[stridx++] = sid.getMimeType();
            blobs[i] = sid.getData();
        }
        this.checkNativeReturn(this.registersis(this.jhandle, numStrings, supportInstances.size(), strings, blobs));
    }

    void deregisterSI(String mgmtId) throws ProxyException, ProxyIOException {
        this.checkNativeReturn(this.deregistersi(this.jhandle, mgmtId));
    }

    void close() {
        this.close(this.jhandle);
    }

    static {
        System.loadLibrary("cctagent");
    }
}

