/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ocm.reg;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.netmgr.EndPoint;

public class ConnectionThread
extends Thread {
    NetworkConfiguration nc;
    EndPoint endPoint = null;
    Throwable failure = null;
    volatile int retries;
    Logger logger;

    public ConnectionThread(NetworkConfiguration networkConfiguration, int n, Logger logger) {
        this.nc = networkConfiguration;
        this.retries = n;
        this.logger = logger;
    }

    public void run() {
        while (this.retries > 0) {
            try {
                --this.retries;
                this.logger.log(Level.INFO, "Executing OCM connection test, retries left {0}", this.retries);
                this.endPoint = this.nc.testExtendedConnection();
                return;
            }
            catch (SocketException socketException) {
                this.failure = socketException;
                this.logger.log(Level.WARNING, "Test of connection failed: {0}", this.failure.getMessage());
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                this.failure = sSLPeerUnverifiedException;
                this.retries = 0;
            }
            catch (UnknownHostException unknownHostException) {
                this.failure = unknownHostException;
                this.retries = 0;
            }
            catch (ConnectionException connectionException) {
                this.failure = connectionException;
                this.logger.log(Level.WARNING, "Test of connection failed: {0}", this.failure.getMessage());
            }
            catch (IOException iOException) {
                this.failure = iOException;
                this.logger.log(Level.WARNING, "Test of connection failed: {0}", this.failure.getMessage());
            }
        }
    }

    public void interrupt() {
        this.logger.log(Level.INFO, "interrupt called, setting retries to 0");
        this.retries = 0;
        if (this.failure == null) {
            this.failure = new TimeoutException("Unable to connect in allowed time period");
        }
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public Throwable getLastException() {
        return this.failure;
    }
}

