/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ocm.reg;

import com.oracle.ocm.reg.ConnectionThread;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.sysman.ccr.collector.install.AnonymousMailRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ConfigResponse;
import oracle.sysman.ccr.collector.install.MetaLinkEmailPrincipal;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;

public class OCMsetupCLI {
    private static final Logger LOGGER = Logger.getLogger(OCMsetupCLI.class.getName());
    private static final int ONE_SECOND = 1000;
    private static String mosUserID = null;
    private static byte[] mosPasswd = null;
    private static char[] proxyPasswd = null;
    private static final int RET_OK = 0;
    private static final int RET_FAILURE = 1;
    private static final int RET_MOS_REG_FAILURE = 2;
    private static final int RET_USAGE_FAILURE = 3;
    private static final String ANONYMOUS_USERID = "anonymous@oracle.com";

    public static void outputStandardException(Throwable throwable) {
        OCMsetupCLI.outputStandardException(null, throwable);
    }

    public static void outputStandardException(String string, Throwable throwable) {
        if (string != null && string.length() > 0) {
            System.err.println(String.format(string, throwable.getMessage()));
        } else {
            System.err.println(throwable.getMessage());
        }
    }

    public static void outputUnexpectedException(Throwable throwable) {
        System.err.println("An unexpected condition has occurred.  If this problem persists please file a bug.  Details: ");
        throwable.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readInput(String string) throws IOException {
        Properties properties = new Properties();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                if (string2.matches("^oracle_user=.*")) {
                    mosUserID = string2.substring(string2.indexOf(61) + 1);
                    continue;
                }
                if (string2.matches("^oracle_pw=.*")) {
                    mosPasswd = string2.substring(string2.indexOf(61) + 1).getBytes();
                    continue;
                }
                if (string2.matches("^http_proxy_host=.+")) {
                    string3 = string2.substring(string2.indexOf(61) + 1);
                    if (string3.length() == 0) continue;
                    properties.setProperty("http.proxyHost", string3);
                    continue;
                }
                if (string2.matches("^http_proxy_port=.+")) {
                    string3 = string2.substring(string2.indexOf(61) + 1);
                    if (string3.length() == 0) continue;
                    properties.setProperty("http.proxyPort", string3);
                    continue;
                }
                if (string2.matches("^http_proxy_user=.*")) {
                    string3 = string2.substring(string2.indexOf(61) + 1);
                    if (string3.length() == 0) continue;
                    properties.setProperty("http.proxyUser", string3);
                    continue;
                }
                if (!string2.matches("^http_proxy_pw=.*")) continue;
                proxyPasswd = string2.substring(string2.indexOf(61) + 1).toCharArray();
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            if (mosUserID != null && mosUserID.length() != 0) {
                LOGGER.log(Level.INFO, "MOS UserID: {0}", mosUserID);
            }
            if (mosPasswd != null && mosPasswd.length != 0) {
                LOGGER.log(Level.INFO, "MOS Password: <provided>");
            }
            if (proxyPasswd != null && proxyPasswd.length != 0) {
                LOGGER.log(Level.INFO, "Proxy Password: <provided>");
            }
            if (properties.size() != 0) {
                LOGGER.log(Level.INFO, "OCM Registration Properties: {0}", properties.toString());
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int setupOCM(Properties properties, String string, int n, int n2) {
        int n3;
        AnonymousMailRegistrationPrincipal anonymousMailRegistrationPrincipal;
        NetworkConfiguration networkConfiguration;
        block31: {
            EndPoint endPoint;
            block30: {
                int n4;
                String string2 = "Unable to contact ccr.oracle.com: %s";
                endPoint = null;
                ConfigResponse.init();
                if (proxyPasswd != null && proxyPasswd.length > 0) {
                    properties.setProperty("http.proxyPassword", new String(proxyPasswd));
                }
                networkConfiguration = new NetworkConfiguration(properties);
                try {
                    ConnectionThread connectionThread = new ConnectionThread(networkConfiguration, n2, LOGGER);
                    connectionThread.start();
                    LOGGER.log(Level.INFO, "Waiting {0} seconds for connection thread to complete", n);
                    connectionThread.join((long)n * 1000L);
                    if (connectionThread.isAlive()) {
                        LOGGER.log(Level.INFO, "Sending interrupt request to connection thread, waiting for thread to terminate");
                        connectionThread.interrupt();
                        while (connectionThread.isAlive()) {
                            Thread.sleep(100L);
                        }
                    }
                    LOGGER.log(Level.INFO, "Operation completed");
                    endPoint = connectionThread.getEndPoint();
                    if (endPoint != null) break block30;
                    Throwable throwable = connectionThread.getLastException();
                    if (throwable != null) {
                        OCMsetupCLI.outputStandardException(string2, throwable);
                    } else {
                        System.err.println("Unable to establish connection.");
                    }
                    n4 = 1;
                }
                catch (InterruptedException interruptedException) {
                    OCMsetupCLI.outputStandardException(string2, interruptedException);
                    int n5 = 1;
                    properties.clear();
                    properties = null;
                    for (int i = 0; i < proxyPasswd.length; ++i) {
                        OCMsetupCLI.proxyPasswd[i] = '\u0000';
                    }
                    proxyPasswd = null;
                    return n5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    OCMsetupCLI.outputStandardException(string2, illegalArgumentException);
                    int n6 = 1;
                    properties.clear();
                    properties = null;
                    for (int i = 0; i < proxyPasswd.length; ++i) {
                        OCMsetupCLI.proxyPasswd[i] = '\u0000';
                    }
                    proxyPasswd = null;
                    return n6;
                    {
                        catch (Throwable throwable) {
                            properties.clear();
                            properties = null;
                            for (int i = 0; i < proxyPasswd.length; ++i) {
                                OCMsetupCLI.proxyPasswd[i] = '\u0000';
                            }
                            proxyPasswd = null;
                            throw throwable;
                        }
                    }
                }
                properties.clear();
                properties = null;
                for (int i = 0; i < proxyPasswd.length; ++i) {
                    OCMsetupCLI.proxyPasswd[i] = '\u0000';
                }
                proxyPasswd = null;
                return n4;
            }
            properties.clear();
            properties = null;
            for (int i = 0; i < proxyPasswd.length; ++i) {
                OCMsetupCLI.proxyPasswd[i] = '\u0000';
            }
            proxyPasswd = null;
            anonymousMailRegistrationPrincipal = null;
            n3 = 0;
            try {
                if (mosUserID == null || mosUserID.length() == 0) {
                    mosUserID = ANONYMOUS_USERID;
                    break block31;
                }
                if (mosPasswd == null || mosPasswd.length == 0) break block31;
                try {
                    LOGGER.log(Level.INFO, "Attempting to authenticate MOS user");
                    OCMEndPoint oCMEndPoint = new OCMEndPoint(endPoint);
                    String string3 = oCMEndPoint.authenticateUser(mosUserID, mosPasswd);
                    LOGGER.log(Level.INFO, "Attempt to register MOS user");
                    anonymousMailRegistrationPrincipal = new MetaLinkEmailPrincipal(mosUserID, mosPasswd, string3);
                    System.out.println("Successfully registered with specified My Oracle Support username and password.");
                }
                catch (NetworkException networkException) {
                    n3 = 2;
                    OCMsetupCLI.outputStandardException("Registration using specified My Oracle Support Support username and password failed: %s\n", networkException);
                }
            }
            catch (Throwable throwable) {
                for (int i = 0; i < mosPasswd.length; ++i) {
                    OCMsetupCLI.mosPasswd[i] = 0;
                }
                mosPasswd = null;
                throw throwable;
            }
        }
        for (int i = 0; i < mosPasswd.length; ++i) {
            OCMsetupCLI.mosPasswd[i] = 0;
        }
        mosPasswd = null;
        if (anonymousMailRegistrationPrincipal == null) {
            if (!MetaLinkEmailPrincipal.validAddress((String)mosUserID)) {
                if (n3 != 2) {
                    n3 = 2;
                    System.err.println("Invalid email address specified for My Oracle Support username.");
                }
                mosUserID = ANONYMOUS_USERID;
            }
            LOGGER.log(Level.INFO, "Attempting Anonymous Mail Registration");
            anonymousMailRegistrationPrincipal = new AnonymousMailRegistrationPrincipal(mosUserID);
            System.out.print("Successfully registered anonymously ");
            if (!mosUserID.equals(ANONYMOUS_USERID)) {
                System.out.println("using unathenticated My Oracle Support username.");
            } else {
                System.out.printf("using %s\n", ANONYMOUS_USERID);
            }
        }
        try {
            ConfigResponse.createResponseFile((String)string, (NetworkConfiguration)networkConfiguration, anonymousMailRegistrationPrincipal);
        }
        catch (IOException iOException) {
            OCMsetupCLI.outputStandardException("failed to create response file: %s", iOException);
            n3 = 1;
            return 1;
        }
        return n3;
    }

    public static void printUsage() {
        System.err.printf("Usage: OCMSetupCLI <ocm_config_file> <ocm_resp_file> [<timeout_in_sec>] [<retries>]\n", new Object[0]);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            if (stringArray.length < 2) {
                System.err.println("Missing required parameters.");
                OCMsetupCLI.printUsage();
                System.exit(3);
            }
            if (stringArray.length > 4) {
                System.err.println("Too many arguments specified.");
            }
            LOGGER.setLevel(Level.OFF);
            String string = System.getenv("OCM_DEBUG");
            if (string != null && string.length() != 0 && Boolean.valueOf(string).booleanValue()) {
                LOGGER.setLevel(Level.INFO);
            }
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n2 = 300;
            int n3 = 5;
            try {
                if (stringArray.length >= 3) {
                    n2 = Integer.parseInt(stringArray[2]);
                }
                if (stringArray.length >= 4) {
                    n3 = Integer.parseInt(stringArray[3]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.printf("Unable to convert specified value: %s", numberFormatException.getMessage());
                OCMsetupCLI.printUsage();
                System.exit(3);
            }
            Properties properties = null;
            try {
                properties = OCMsetupCLI.readInput(string2);
                n = OCMsetupCLI.setupOCM(properties, string3, n2, n3);
            }
            catch (IOException iOException) {
                OCMsetupCLI.outputStandardException("Failed to process configuration file: %s", iOException);
                n = 1;
            }
        }
        catch (Exception exception) {
            OCMsetupCLI.outputUnexpectedException(exception);
            n = 1;
        }
        System.exit(n);
    }
}

