/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.domain.types.IOUnitInfo;
import com.sun.hss.domain.types.IOUnitInfoSet;
import com.sun.hss.type.server.Server;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.ocharvester.FRUFetcher;
import oracle.sysman.ccr.ocharvester.Metric_ECM_HW_COMPONENT;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import org.apache.log4j.Category;

public class FRU_IOUnit
implements FRUFetcher {
    private static final Category slog = Category.getInstance((String)FRU_IOUnit.class.getName());
    private static final String OC_RETRIEVAL_ERROR = "Error retrieving I/O Unit Data from Ops Center";

    static void populate_iounit(int n, ValueRow valueRow, int n2, IOUnitInfo iOUnitInfo, String string) {
        try {
            switch (n) {
                case 1: {
                    String string2 = iOUnitInfo.getName();
                    if (string2 == null) break;
                    valueRow.setValue(n2, string2.trim());
                    break;
                }
                case 2: {
                    String string3 = iOUnitInfo.getManufacturer();
                    if (OpsCenterHarvesterUtil.is_empty(string3)) break;
                    valueRow.setValue(n2, string3.trim());
                    break;
                }
                case 3: {
                    valueRow.setValue(n2, string);
                    break;
                }
                case 5: {
                    String string4 = iOUnitInfo.getPartNumber();
                    if (OpsCenterHarvesterUtil.is_empty(string4)) break;
                    valueRow.setValue(n2, string4.trim());
                    break;
                }
                case 6: {
                    String string5 = iOUnitInfo.getSerialNumber();
                    if (OpsCenterHarvesterUtil.is_empty(string5)) break;
                    valueRow.setValue(n2, string5.trim());
                    break;
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)(OC_RETRIEVAL_ERROR + exception));
        }
    }

    @Override
    public int fetch(Server server, MetricResult metricResult, Vector vector, String string) {
        int n = 0;
        try {
            IOUnitInfo[] iOUnitInfoArray;
            IOUnitInfoSet iOUnitInfoSet = server.getIOUnitSet();
            if (iOUnitInfoSet != null && (iOUnitInfoArray = iOUnitInfoSet.getValues()) != null) {
                for (int i = 0; i < iOUnitInfoArray.length; ++i) {
                    if (iOUnitInfoArray[i] == null || iOUnitInfoArray[i].getName() == null) continue;
                    ++n;
                    ValueRow valueRow = metricResult.addValueRow();
                    for (int j = 0; j < vector.size(); ++j) {
                        ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(j);
                        String string2 = columnDescriptor.getColumnName();
                        Integer n2 = Metric_ECM_HW_COMPONENT.OCM_to_oc_map.get(string2.toUpperCase());
                        if (n2 == null) continue;
                        int n3 = n2;
                        FRU_IOUnit.populate_iounit(n3, valueRow, j, iOUnitInfoArray[i], string);
                    }
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)(OC_RETRIEVAL_ERROR + exception));
        }
        return n;
    }
}

