/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.domain.types.MemoryInfo;
import com.sun.hss.domain.types.MemoryInfoSet;
import com.sun.hss.type.server.Server;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.ocharvester.FRUFetcher;
import oracle.sysman.ccr.ocharvester.Metric_ECM_HW_COMPONENT;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import org.apache.log4j.Category;

public class FRU_Memory
implements FRUFetcher {
    private static final Category slog = Category.getInstance((String)FRU_Memory.class.getName());
    private static final String OC_RETRIEVAL_ERROR = "Error retrieving Memory component data from Ops Center";

    static void populate_memory(int n, ValueRow valueRow, int n2, MemoryInfo memoryInfo, String string) {
        try {
            switch (n) {
                case 1: {
                    String string2 = memoryInfo.getName();
                    if (string2 == null) break;
                    valueRow.setValue(n2, string2.trim());
                    break;
                }
                case 2: {
                    String string3 = memoryInfo.getManufacturer();
                    if (OpsCenterHarvesterUtil.is_empty(string3)) break;
                    valueRow.setValue(n2, string3.trim());
                    break;
                }
                case 3: {
                    valueRow.setValue(n2, string);
                    break;
                }
                case 5: {
                    String string4 = memoryInfo.getPartNumber();
                    if (OpsCenterHarvesterUtil.is_empty(string4)) break;
                    valueRow.setValue(n2, string4.trim());
                    break;
                }
                case 6: {
                    String string5 = memoryInfo.getSerialNumber();
                    if (OpsCenterHarvesterUtil.is_empty(string5)) break;
                    valueRow.setValue(n2, string5.trim());
                    break;
                }
                case 4: {
                    Long l = memoryInfo.getSize();
                    if (l == null) break;
                    long l2 = l;
                    valueRow.setValue(n2, (float)(l2 / 8L));
                    break;
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)(OC_RETRIEVAL_ERROR + exception));
        }
    }

    @Override
    public int fetch(Server server, MetricResult metricResult, Vector vector, String string) {
        int n = 0;
        try {
            MemoryInfo[] memoryInfoArray;
            MemoryInfoSet memoryInfoSet = server.getMemoryInfos();
            if (memoryInfoSet != null && (memoryInfoArray = memoryInfoSet.getValues()) != null) {
                for (int i = 0; i < memoryInfoArray.length; ++i) {
                    if (memoryInfoArray[i] == null || memoryInfoArray[i].getName() == null) continue;
                    ++n;
                    ValueRow valueRow = metricResult.addValueRow();
                    for (int j = 0; j < vector.size(); ++j) {
                        ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(j);
                        String string2 = columnDescriptor.getColumnName();
                        Integer n2 = Metric_ECM_HW_COMPONENT.OCM_to_oc_map.get(string2.toUpperCase());
                        if (n2 == null) continue;
                        int n3 = n2;
                        FRU_Memory.populate_memory(n3, valueRow, j, memoryInfoArray[i], string);
                    }
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)(OC_RETRIEVAL_ERROR + exception));
        }
        return n;
    }
}

