/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.domain.types.CpuInfo;
import com.sun.hss.domain.types.CpuInfoSet;
import com.sun.hss.domain.types.FanInfo;
import com.sun.hss.domain.types.FanInfoSet;
import com.sun.hss.domain.types.LocalDiskInfo;
import com.sun.hss.domain.types.MemoryInfo;
import com.sun.hss.domain.types.MemoryInfoSet;
import com.sun.hss.domain.types.PowerSupplyInfo;
import com.sun.hss.domain.types.PowerSupplyInfoSet;
import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_HW
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_HW.class.getName());
    private static final String METRIC_NAME = "ECM_HW";
    private static final int OC_METRIC_HOSTNAME = 1;
    private static final int OC_METRIC_DOMAIN = 2;
    private static final int OC_METRIC_MACHINE_ARCHITECTURE = 3;
    private static final int OC_METRIC_CLOCK_FREQ = 4;
    private static final int OC_METRIC_MEMORY_SIZE = 5;
    private static final int OC_METRIC_LOCAL_DISK_SPACE = 6;
    private static final int OC_METRIC_CPU_COUNT = 7;
    private static final int OC_METRIC_FAN_COUNT = 8;
    private static final int OC_METRIC_POWER_SUPPLY_COUNT = 9;
    private static final int OC_METRIC_SYSTEM_SERIAL_NUMBER = 10;
    private static final int OC_METRIC_HOSTID = 11;
    private static final int OC_METRIC_VENDOR = 12;
    private static final int OC_METRIC_SYSTEM_CONFIG = 13;
    private static final int OC_METRIC_PHYSICAL_CPU_COUNT = 14;
    private static final int OC_METRIC_LOGICAL_CPU_COUNT = 15;
    private static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("HOSTNAME", 1);
            this.put("DOMAIN", 2);
            this.put("MACHINE_ARCHITECTURE", 3);
            this.put("MEMORY_SIZE_IN_MB", 5);
            this.put("LOCAL_DISK_SPACE_IN_GB", 6);
            this.put("CPU_COUNT", 7);
            this.put("FAN_COUNT", 8);
            this.put("POWER_SUPPLY_COUNT", 9);
            this.put("SYSTEM_SERIAL_NUMBER", 10);
            this.put("HOST_ID", 11);
            this.put("VENDOR_NAME", 12);
            this.put("SYSTEM_CONFIG", 13);
            this.put("PHYSICAL_CPU_COUNT", 14);
            this.put("LOGICAL_CPU_COUNT", 15);
        }
    };

    private static String hostname(Server server, OperatingSystem operatingSystem) {
        String string = null;
        try {
            string = operatingSystem.getUserFriendlyName();
            return string;
        }
        catch (Exception exception) {
            try {
                string = server.getUserFriendlyName();
                return string;
            }
            catch (Exception exception2) {
                return string;
            }
        }
    }

    private static int power_supply_count(Server server) {
        int n = 0;
        try {
            PowerSupplyInfo[] powerSupplyInfoArray;
            PowerSupplyInfoSet powerSupplyInfoSet = server.getPowerSupplySet();
            if (powerSupplyInfoSet != null && (powerSupplyInfoArray = powerSupplyInfoSet.getValues()) != null) {
                for (int i = 0; i < powerSupplyInfoArray.length; ++i) {
                    if (powerSupplyInfoArray[i] == null) continue;
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private static int fan_count(Server server) {
        int n = 0;
        try {
            FanInfo[] fanInfoArray;
            FanInfoSet fanInfoSet = server.getFanSet();
            if (fanInfoSet != null && (fanInfoArray = fanInfoSet.getValues()) != null) {
                for (int i = 0; i < fanInfoArray.length; ++i) {
                    if (fanInfoArray[i] == null) continue;
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static long local_disk_capacity(OperatingSystem operatingSystem) {
        Object object;
        BigInteger bigInteger = BigInteger.ZERO;
        try {
            LocalDiskInfo[] localDiskInfoArray;
            object = operatingSystem.getLocalDiskInfos();
            if (object != null && (localDiskInfoArray = object.getValues()) != null && localDiskInfoArray.length > 0) {
                for (int i = 0; i < localDiskInfoArray.length; ++i) {
                    bigInteger = bigInteger.add(BigInteger.valueOf(localDiskInfoArray[i].getCapacity()));
                }
            }
        }
        catch (Exception exception) {
            return 0L;
        }
        object = BigInteger.valueOf(0x40000000L);
        return bigInteger.divide((BigInteger)object).longValue();
    }

    private static int cpu_count(Server server) {
        int n = 0;
        try {
            CpuInfo[] cpuInfoArray;
            CpuInfoSet cpuInfoSet = server.getCpuInfos();
            if (cpuInfoSet != null && (cpuInfoArray = cpuInfoSet.getValues()) != null) {
                for (int i = 0; i < cpuInfoArray.length; ++i) {
                    int n2;
                    Integer n3;
                    if (cpuInfoArray[i] == null || (n3 = cpuInfoArray[i].getCoreCount()) == null || (n2 = n3.intValue()) <= 0) continue;
                    n += n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private static int logical_cpu_count(Server server) {
        int n = 0;
        try {
            CpuInfo[] cpuInfoArray;
            CpuInfoSet cpuInfoSet = server.getCpuInfos();
            if (cpuInfoSet != null && (cpuInfoArray = cpuInfoSet.getValues()) != null) {
                for (int i = 0; i < cpuInfoArray.length; ++i) {
                    Integer n2;
                    if (cpuInfoArray[i] == null || (n2 = cpuInfoArray[i].getCoreCount()) == null) continue;
                    int n3 = n2;
                    int n4 = cpuInfoArray[i].getThreadCount();
                    if (n3 <= 0 || n4 <= 0) continue;
                    n += n3 * n4;
                }
                if (n == 0 && cpuInfoArray.length > 0) {
                    n = cpuInfoArray.length;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private static int physical_cpu_count(Server server) {
        int n = 0;
        try {
            CpuInfo[] cpuInfoArray;
            CpuInfoSet cpuInfoSet = server.getCpuInfos();
            if (cpuInfoSet != null && (cpuInfoArray = cpuInfoSet.getValues()) != null) {
                for (int i = 0; i < cpuInfoArray.length; ++i) {
                    Integer n2;
                    if (cpuInfoArray[i] == null || ((n2 = cpuInfoArray[i].getCoreCount()) == null || n2 < 0) && cpuInfoArray[i].getThreadCount() < 0) continue;
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static long memory_size(Server server) {
        long l = 0L;
        try {
            MemoryInfo[] memoryInfoArray;
            MemoryInfoSet memoryInfoSet = server.getMemoryInfos();
            if (memoryInfoSet != null && (memoryInfoArray = memoryInfoSet.getValues()) != null) {
                for (int i = 0; i < memoryInfoArray.length; ++i) {
                    l += memoryInfoArray[i].getSize();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l / 0x100000L;
    }

    static void populate(int n, ValueRow valueRow, int n2, Server server, OperatingSystem operatingSystem) {
        int n3 = 0;
        try {
            switch (n) {
                case 1: 
                case 2: {
                    String string = Metric_ECM_HW.hostname(server, operatingSystem);
                    if (string == null) break;
                    valueRow.setValue(n2, string);
                    break;
                }
                case 11: {
                    if (operatingSystem == null) break;
                    valueRow.setValue(n2, operatingSystem.getHostId());
                    break;
                }
                case 10: {
                    String string = server.getSerialNumber();
                    if (string == null) break;
                    valueRow.setValue(n2, string.trim());
                    break;
                }
                case 7: {
                    n3 = Metric_ECM_HW.cpu_count(server);
                    if (n3 > 0) {
                        valueRow.setValue(n2, (float)n3);
                        break;
                    }
                    valueRow.setValue(n2, 1.0f);
                    break;
                }
                case 15: {
                    n3 = Metric_ECM_HW.logical_cpu_count(server);
                    if (n3 > 0) {
                        valueRow.setValue(n2, (float)n3);
                        break;
                    }
                    valueRow.setValue(n2, 1.0f);
                    break;
                }
                case 14: {
                    n3 = Metric_ECM_HW.physical_cpu_count(server);
                    if (n3 > 0) {
                        valueRow.setValue(n2, (float)n3);
                        break;
                    }
                    valueRow.setValue(n2, 1.0f);
                    break;
                }
                case 3: {
                    if (operatingSystem != null) {
                        valueRow.setValue(n2, operatingSystem.getCpuArchitecture());
                        break;
                    }
                    valueRow.setValue(n2, server.getMachineHardwareClass());
                    break;
                }
                case 13: {
                    String string = server.getModel();
                    if (!OpsCenterHarvesterUtil.is_empty(string)) {
                        valueRow.setValue(n2, string);
                        break;
                    }
                    if (operatingSystem != null) {
                        valueRow.setValue(n2, operatingSystem.getCpuArchitecture());
                        break;
                    }
                    valueRow.setValue(n2, server.getMachineHardwareClass());
                    break;
                }
                case 5: {
                    valueRow.setValue(n2, (float)Metric_ECM_HW.memory_size(server));
                    break;
                }
                case 8: {
                    n3 = Metric_ECM_HW.fan_count(server);
                    if (n3 <= 0) break;
                    valueRow.setValue(n2, (float)n3);
                    break;
                }
                case 9: {
                    n3 = Metric_ECM_HW.power_supply_count(server);
                    if (n3 <= 0) break;
                    valueRow.setValue(n2, (float)n3);
                    break;
                }
                case 6: {
                    if (operatingSystem == null) break;
                    long l = Metric_ECM_HW.local_disk_capacity(operatingSystem);
                    if (l > 0L) {
                        valueRow.setValue(n2, (float)l);
                    }
                    break;
                }
                case 12: {
                    valueRow.setValue(n2, server.getManufacturer());
                    break;
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching HW info from Ops Center:  " + exception));
        }
    }

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        CollectionResult collectionResult = null;
        TableDescriptor tableDescriptor = metric.getTblDesc();
        Vector vector = tableDescriptor.getColDescs();
        MetricResult metricResult = new MetricResult();
        ValueRow valueRow = metricResult.addValueRow();
        for (int i = 0; i < vector.size(); ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(i);
            String string2 = columnDescriptor.getColumnName();
            Integer n = OCM_to_oc_map.get(string2.toUpperCase());
            if (n == null) continue;
            int n2 = n;
            Metric_ECM_HW.populate(n2, valueRow, i, server, operatingSystem);
        }
        collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
        return collectionResult;
    }
}

