/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.FRUFetcher;
import oracle.sysman.ccr.ocharvester.FRU_Board;
import oracle.sysman.ccr.ocharvester.FRU_CPU;
import oracle.sysman.ccr.ocharvester.FRU_DiskDrive;
import oracle.sysman.ccr.ocharvester.FRU_Fan;
import oracle.sysman.ccr.ocharvester.FRU_IOUnit;
import oracle.sysman.ccr.ocharvester.FRU_Memory;
import oracle.sysman.ccr.ocharvester.FRU_Power_Supply;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_HW_COMPONENT
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_HW_COMPONENT.class.getName());
    static final String METRIC_NAME = "ECM_HW_COMPONENT";
    public static final int OC_METRIC_FRU_NAME = 1;
    public static final int OC_METRIC_FRU_MANUFACTURER = 2;
    public static final int OC_METRIC_FRU_TYPE = 3;
    public static final int OC_METRIC_FRU_SIZE = 4;
    public static final int OC_METRIC_FRU_PARTNO = 5;
    public static final int OC_METRIC_FRU_SERIALNO = 6;
    public static final int OC_METRIC_FRU_PCI_ID = 7;
    public static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("NAME", 1);
            this.put("MANUFACTURER", 2);
            this.put("TYPE", 3);
            this.put("SIZE_IN_BYTES", 4);
            this.put("PART_NUMBER", 5);
            this.put("SERIAL_NUMBER", 6);
            this.put("PCI_ID", 7);
        }
    };
    private static final Map<String, FRUFetcher> FRU_map = new HashMap<String, FRUFetcher>(){
        {
            this.put("MEMORY", new FRU_Memory());
            this.put("DISK-DRIVE", new FRU_DiskDrive());
            this.put("BOARD", new FRU_Board());
            this.put("IO-UNIT", new FRU_IOUnit());
            this.put("POWER-SUPPLY", new FRU_Power_Supply());
            this.put("COOLING-FAN", new FRU_Fan());
            this.put("CPU", new FRU_CPU());
        }
    };

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        Vector vector;
        TableDescriptor tableDescriptor;
        CollectionResult collectionResult = null;
        MetricResult metricResult = null;
        int n = 0;
        if (metric != null && (tableDescriptor = metric.getTblDesc()) != null && (vector = tableDescriptor.getColDescs()) != null) {
            metricResult = new MetricResult();
            for (Map.Entry<String, FRUFetcher> entry : FRU_map.entrySet()) {
                String string2 = entry.getKey();
                FRUFetcher fRUFetcher = entry.getValue();
                n += fRUFetcher.fetch(server, metricResult, vector, string2);
            }
        }
        if (n > 0 && metricResult != null) {
            collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
        }
        return collectionResult;
    }
}

