/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.domain.types.CpuInfo;
import com.sun.hss.domain.types.CpuInfoSet;
import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_HW_CPU
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_HW_CPU.class.getName());
    private static final String METRIC_NAME = "ECM_HW_CPU";
    private static final int OC_METRIC_CPU_VENDOR = 1;
    private static final int OC_METRIC_CPU_FREQ = 2;
    private static final int OC_METRIC_CPU_MODEL = 3;
    private static final int OC_METRIC_CPU_SIBLINGS = 4;
    private static final int OC_METRIC_CPU_NCORES = 5;
    private static final int OC_METRIC_CPU_INSTANCE_COUNT = 6;
    private static final int OC_METRIC_CPU_HYPERTHREADED = 7;
    private static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("VENDOR_NAME", 1);
            this.put("FREQ_IN_MHZ", 2);
            this.put("IMPL", 3);
            this.put("SIBLINGS", 4);
            this.put("IS_HYPERTHREAD_ENABLED", 7);
            this.put("INSTANCE_COUNT", 6);
            this.put("NUM_CORES", 5);
        }
    };

    private static void populate(int n, ValueRow valueRow, int n2, CpuInfo cpuInfo) {
        try {
            switch (n) {
                case 1: {
                    String string = cpuInfo.getManufacturer();
                    if (!OpsCenterHarvesterUtil.is_empty(string)) {
                        valueRow.setValue(n2, string);
                        break;
                    }
                    String string2 = cpuInfo.getArchitecture();
                    if (string2 != null && string2.toLowerCase().indexOf("sparc") != -1) {
                        valueRow.setValue(n2, "Oracle Corporation");
                        break;
                    }
                    valueRow.setValue(n2, "Unknown");
                    break;
                }
                case 2: {
                    int n3 = cpuInfo.getSpeed();
                    if (n3 <= 0) break;
                    valueRow.setValue(n2, (float)n3);
                    break;
                }
                case 4: {
                    int n4 = cpuInfo.getThreadCount();
                    if (n4 <= 0) break;
                    valueRow.setValue(n2, (float)n4);
                    break;
                }
                case 3: {
                    String string = cpuInfo.getModel();
                    if (string != null && string.length() > 0) {
                        valueRow.setValue(n2, string);
                        break;
                    }
                    String string3 = cpuInfo.getArchitecture();
                    if (string3 != null) {
                        valueRow.setValue(n2, string3);
                    }
                    break;
                }
                case 7: {
                    if (cpuInfo.getThreadCount() > 0 && cpuInfo.getCoreCount() != null && cpuInfo.getCoreCount() > 0 && cpuInfo.getThreadCount() > cpuInfo.getCoreCount()) {
                        valueRow.setValue(n2, 1.0f);
                        break;
                    }
                    valueRow.setValue(n2, 0.0f);
                    break;
                }
                case 5: {
                    int n5 = cpuInfo.getCoreCount();
                    if (n5 > 0) {
                        valueRow.setValue(n2, (float)n5);
                    } else {
                        valueRow.setValue(n2, 1.0f);
                    }
                }
                case 6: {
                    valueRow.setValue(n2, 1.0f);
                    break;
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching CPU info from Ops Center:  " + exception));
        }
    }

    private CpuInfo[] make_sane_cpuvalue(CpuInfoSet cpuInfoSet) {
        CpuInfo[] cpuInfoArray;
        String string;
        String string2 = "cpu0";
        String string3 = "unknown";
        String string4 = "unknown";
        CpuInfo[] cpuInfoArray2 = null;
        int n = 1000;
        int n2 = 1;
        CpuInfo[] cpuInfoArray3 = cpuInfoSet.getValues();
        if (cpuInfoArray3 != null && cpuInfoArray3.length >= 1) {
            int n3;
            String string5;
            String string6;
            string = cpuInfoArray3[0].getArchitecture();
            if (!OpsCenterHarvesterUtil.is_empty(string)) {
                string3 = string;
            }
            if (!OpsCenterHarvesterUtil.is_empty((String)(cpuInfoArray = cpuInfoArray3[0].getManufacturer()))) {
                cpuInfoArray2 = cpuInfoArray;
            }
            if (!OpsCenterHarvesterUtil.is_empty(string6 = cpuInfoArray3[0].getName())) {
                string2 = string6;
            }
            if (!OpsCenterHarvesterUtil.is_empty(string5 = cpuInfoArray3[0].getModel())) {
                string4 = string5;
            }
            if ((n3 = cpuInfoArray3[0].getSpeed()) > 0) {
                // empty if block
            }
            n = n3;
            n2 = cpuInfoArray3.length;
        }
        string = new CpuInfo("CPU0", null, null, cpuInfoArray2, string3, n, string4, new Integer(1), n2);
        cpuInfoArray = new CpuInfo[]{string};
        return cpuInfoArray;
    }

    private static boolean sanity_check_cpuset(CpuInfoSet cpuInfoSet) {
        CpuInfo[] cpuInfoArray = cpuInfoSet.getValues();
        if (cpuInfoArray != null && cpuInfoArray.length >= 1) {
            for (int i = 0; i < cpuInfoArray.length; ++i) {
                if (cpuInfoArray[i] == null || cpuInfoArray[i].getCoreCount() != null && cpuInfoArray[i].getCoreCount() >= 0 && cpuInfoArray[i].getThreadCount() >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        CollectionResult collectionResult = null;
        int n = 0;
        TableDescriptor tableDescriptor = metric.getTblDesc();
        Vector vector = tableDescriptor.getColDescs();
        MetricResult metricResult = new MetricResult();
        try {
            boolean bl;
            CpuInfo[] cpuInfoArray;
            CpuInfoSet cpuInfoSet = server.getCpuInfos();
            if (cpuInfoSet != null && (cpuInfoArray = !(bl = Metric_ECM_HW_CPU.sanity_check_cpuset(cpuInfoSet)) ? this.make_sane_cpuvalue(cpuInfoSet) : cpuInfoSet.getValues()) != null) {
                for (int i = 0; i < cpuInfoArray.length; ++i) {
                    if (cpuInfoArray[i] == null) continue;
                    ++n;
                    ValueRow valueRow = metricResult.addValueRow();
                    for (int j = 0; j < vector.size(); ++j) {
                        ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(j);
                        String string2 = columnDescriptor.getColumnName();
                        Integer n2 = OCM_to_oc_map.get(string2.toUpperCase());
                        if (n2 == null) continue;
                        int n3 = n2;
                        Metric_ECM_HW_CPU.populate(n3, valueRow, j, cpuInfoArray[i]);
                    }
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching CPU info from Ops Center:  " + exception));
        }
        if (n > 0) {
            collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
        }
        return collectionResult;
    }
}

