/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.domain.types.InterfaceInfo;
import com.sun.hss.domain.types.InterfaceInfoSet;
import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_HW_NIC
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_HW_NIC.class.getName());
    private static final String METRIC_NAME = "ECM_HW_NIC";
    private static final int OC_METRIC_NIC_NAME = 1;
    private static final int OC_METRIC_NIC_INETADDRESS = 4;
    private static final int OC_METRIC_NIC_MASK = 5;
    private static final int OC_METRIC_NIC_MACADDRESS = 6;
    private static final int OC_METRIC_NIC_DESCRIPTION = 7;
    private static final int OC_METRIC_NIC_MTU = 8;
    private static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("NAME", 1);
            this.put("INET_ADDRESS", 4);
            this.put("MASK", 5);
            this.put("MAC_ADDRESS", 6);
            this.put("DESCRIPTION", 7);
            this.put("MAX_TRANSFER_UNIT", 8);
        }
    };

    static void populate(int n, ValueRow valueRow, int n2, InterfaceInfo interfaceInfo) {
        try {
            switch (n) {
                case 1: 
                case 7: {
                    valueRow.setValue(n2, interfaceInfo.getName());
                    break;
                }
                case 4: {
                    valueRow.setValue(n2, interfaceInfo.getIpAddress());
                    break;
                }
                case 6: {
                    valueRow.setValue(n2, interfaceInfo.getMacAddress());
                    break;
                }
                case 5: {
                    valueRow.setValue(n2, interfaceInfo.getSubnetMask());
                    break;
                }
                case 8: {
                    int n3 = interfaceInfo.getMtu();
                    if (n3 <= 0) break;
                    valueRow.setValue(n2, (float)interfaceInfo.getMtu());
                    break;
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching NIC info from Ops Center:  " + exception));
        }
    }

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        CollectionResult collectionResult = null;
        int n = 0;
        if (operatingSystem == null) {
            return collectionResult;
        }
        TableDescriptor tableDescriptor = metric.getTblDesc();
        Vector vector = tableDescriptor.getColDescs();
        MetricResult metricResult = new MetricResult();
        try {
            InterfaceInfo[] interfaceInfoArray;
            InterfaceInfoSet interfaceInfoSet = operatingSystem.getInterfaceInfos();
            if (interfaceInfoSet != null && (interfaceInfoArray = interfaceInfoSet.getValues()) != null) {
                for (int i = 0; i < interfaceInfoArray.length; ++i) {
                    if (interfaceInfoArray[i] == null) continue;
                    ++n;
                    ValueRow valueRow = metricResult.addValueRow();
                    for (int j = 0; j < vector.size(); ++j) {
                        ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(j);
                        String string2 = columnDescriptor.getColumnName();
                        Integer n2 = OCM_to_oc_map.get(string2.toUpperCase());
                        if (n2 == null) continue;
                        int n3 = n2;
                        Metric_ECM_HW_NIC.populate(n3, valueRow, j, interfaceInfoArray[i]);
                    }
                }
            }
            if (n > 0) {
                collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching NIC info from Ops Center:  " + exception));
        }
        return collectionResult;
    }
}

