/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.domain.types.FirmwareInfo;
import com.sun.hss.domain.types.FirmwareInfoSet;
import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_INSTALLED_FIRMWARE
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_INSTALLED_FIRMWARE.class.getName());
    private static final String METRIC_NAME = "ECM_INSTALLED_FIRMWARE";
    private static final int OC_METRIC_FW_DESCR = 1;
    private static final int OC_METRIC_FW_TYPE = 2;
    private static final int OC_METRIC_FW_VERSION = 3;
    private static final int OC_METRIC_FW_INSTDATE = 4;
    private static final int OC_METRIC_FW_PROVIDER = 5;
    private static final int OC_METRIC_FW_RELDATE = 6;
    private static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("DESCRIPTION", 1);
            this.put("TYPE", 2);
            this.put("VERSION", 3);
            this.put("INSTALLATION_DATE", 4);
            this.put("PROVIDER", 5);
            this.put("RELEASE_DATE", 6);
        }
    };

    static void populate(int n, ValueRow valueRow, int n2, FirmwareInfo firmwareInfo) {
        try {
            switch (n) {
                case 1: {
                    String string = firmwareInfo.getDescription();
                    if (OpsCenterHarvesterUtil.is_empty(string)) break;
                    valueRow.setValue(n2, string);
                    break;
                }
                case 2: {
                    String string = firmwareInfo.getType();
                    if (OpsCenterHarvesterUtil.is_empty(string)) break;
                    valueRow.setValue(n2, string);
                    break;
                }
                case 3: {
                    String string = firmwareInfo.getVersion();
                    if (OpsCenterHarvesterUtil.is_empty(string)) break;
                    valueRow.setValue(n2, string);
                    break;
                }
                case 4: {
                    Date date = firmwareInfo.getInstallDate();
                    if (date == null) break;
                    valueRow.setValue(n2, date.toString());
                    break;
                }
                case 5: {
                    String string = firmwareInfo.getProvider();
                    if (OpsCenterHarvesterUtil.is_empty(string)) break;
                    valueRow.setValue(n2, string);
                    break;
                }
                case 6: {
                    Date date = firmwareInfo.getReleaseDate();
                    if (date == null) break;
                    valueRow.setValue(n2, date.toString());
                    break;
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching firmware info from Ops Center:  " + exception));
        }
    }

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        Vector vector;
        CollectionResult collectionResult = null;
        int n = 0;
        if (metric == null) {
            return null;
        }
        TableDescriptor tableDescriptor = metric.getTblDesc();
        if (tableDescriptor != null && (vector = tableDescriptor.getColDescs()) != null) {
            MetricResult metricResult = new MetricResult();
            try {
                FirmwareInfo[] firmwareInfoArray;
                FirmwareInfoSet firmwareInfoSet = server.getFirmwareInfos();
                if (firmwareInfoSet != null && (firmwareInfoArray = firmwareInfoSet.getValues()) != null) {
                    for (int i = 0; i < firmwareInfoArray.length; ++i) {
                        if (firmwareInfoArray[i] == null || firmwareInfoArray[i].getDescription() == null) continue;
                        ++n;
                        ValueRow valueRow = metricResult.addValueRow();
                        for (int j = 0; j < vector.size(); ++j) {
                            ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(j);
                            String string2 = columnDescriptor.getColumnName();
                            Integer n2 = OCM_to_oc_map.get(string2.toUpperCase());
                            if (n2 == null) continue;
                            int n3 = n2;
                            Metric_ECM_INSTALLED_FIRMWARE.populate(n3, valueRow, j, firmwareInfoArray[i]);
                        }
                    }
                }
                if (n > 0) {
                    collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
                }
            }
            catch (Exception exception) {
                slog.error((Object)("Error fetching Firmware info from Ops Center:  " + exception));
            }
        }
        return collectionResult;
    }
}

