/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.OSInventory;
import oracle.sysman.ccr.ocharvester.OSPatch;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_INSTALLED_OS_PATCHES
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_INSTALLED_OS_PATCHES.class.getName());
    private static final String METRIC_NAME = "ECM_INSTALLED_OS_PATCHES";
    private static final int OC_METRIC_PATCH_ID = 1;
    private static final int OC_METRIC_PATCH_VENDOR = 2;
    private static final String DASH = "-";
    private static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("ID", 1);
            this.put("VENDOR", 2);
        }
    };

    static void populate(int n, ValueRow valueRow, int n2, String string) {
        switch (n) {
            case 1: {
                valueRow.setValue(n2, string);
                break;
            }
            case 2: {
                valueRow.setValue(n2, "Oracle");
                break;
            }
        }
    }

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        OSInventory oSInventory;
        CollectionResult collectionResult = null;
        int n = 0;
        if (softwareInventory == null || metric == null) {
            return null;
        }
        String string2 = OpsCenterHarvesterUtil.os_hostname(operatingSystem);
        if (string2 != null && (oSInventory = softwareInventory.findhost(string2)) != null && oSInventory.getPatchCount() > 0) {
            TableDescriptor tableDescriptor = metric.getTblDesc();
            if (tableDescriptor == null) {
                return null;
            }
            Vector vector = tableDescriptor.getColDescs();
            if (vector == null) {
                return null;
            }
            MetricResult metricResult = new MetricResult();
            Map<String, OSPatch> map = oSInventory.getPatches();
            Set<String> set = map.keySet();
            for (String string3 : set) {
                String string4 = string3;
                if (OpsCenterHarvesterUtil.is_empty(string4)) continue;
                OSPatch oSPatch = map.get(string4);
                String string5 = string4 + DASH + oSPatch.getRevision();
                ++n;
                ValueRow valueRow = metricResult.addValueRow();
                for (int i = 0; i < vector.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(i);
                    String string6 = columnDescriptor.getColumnName();
                    Integer n2 = OCM_to_oc_map.get(string6.toUpperCase());
                    if (n2 == null) continue;
                    int n3 = n2;
                    Metric_ECM_INSTALLED_OS_PATCHES.populate(n3, valueRow, i, string5);
                }
            }
            if (n > 0) {
                collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
            }
        }
        return collectionResult;
    }
}

