/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.domain.types.SwapUsage;
import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_OS
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_OS.class.getName());
    private static final String METRIC_NAME = "ECM_OS";
    private static final int OC_METRIC_OS_NAME = 1;
    private static final int OC_METRIC_OS_VENDOR_NAME = 2;
    private static final int OC_METRIC_OS_BASE_VERSION = 3;
    private static final int OC_METRIC_OS_UPDATE_LEVEL = 4;
    private static final int OC_METRIC_OS_DISTRIBUTOR_VERSION = 5;
    private static final int OC_METRIC_OS_ADDRESS_LENGTH = 6;
    private static final int OC_METRIC_OS_MAX_SWAP_SPACE = 7;
    private static final int OC_METRIC_OS_TIMEZONE = 8;
    private static final int OC_METRIC_OS_PLATFORM_ID = 9;
    private static final int OC_METRIC_OS_PLATFORM_VERSION_ID = 10;
    private static final int PLATFORM_ID_SOLARIS_SPARC = 23;
    private static final int PLATFORM_ID_SOLARIS_X86 = 267;
    private static final int PLATFORM_ID_WINDOWS = 208;
    private static final int PLATFORM_ID_LINUX = 226;
    private static final int PLATFORM_ID_UNKNOWN = -999;
    private static final int PLATFORM_VERSION_ID_SOLARIS_10_SPARC = 6136;
    private static final int PLATFORM_VERSION_ID_SOLARIS_11_SPARC = 24003;
    private static final int PLATFORM_VERSION_ID_SOLARIS_11_X64 = 24004;
    private static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("NAME", 1);
            this.put("VENDOR_NAME", 2);
            this.put("BASE_VERSION", 3);
            this.put("UPDATE_LEVEL", 4);
            this.put("DISTRIBUTOR_VERSION", 5);
            this.put("PLATFORM_ID", 9);
            this.put("MAX_SWAP_SPACE_IN_MB", 7);
            this.put("PLATFORM_VERSION_ID", 10);
        }
    };

    private static int platform_id(String string, String string2) {
        if (string2.toLowerCase().startsWith("sparc")) {
            return 23;
        }
        if ("solaris".equalsIgnoreCase(string) && "x86".equalsIgnoreCase(string2)) {
            return 267;
        }
        if ("windows".equalsIgnoreCase(string)) {
            return 208;
        }
        if ("linux".equalsIgnoreCase(string)) {
            return 226;
        }
        return -999;
    }

    private static int platform_version_id(String string, String string2, String string3) {
        if (string2.toLowerCase().startsWith("sparc") && "solaris".equalsIgnoreCase(string)) {
            if ("10".equals(string3)) {
                return 6136;
            }
            if ("11".equals(string3)) {
                return 24003;
            }
        }
        if (string2.toLowerCase().equals("x86") && "solaris".equalsIgnoreCase(string) && "11".equals(string3)) {
            return 24004;
        }
        return -1;
    }

    private static void populate(int n, ValueRow valueRow, int n2, OperatingSystem operatingSystem, String[] stringArray) {
        try {
            switch (n) {
                case 1: {
                    valueRow.setValue(n2, operatingSystem.getType());
                    break;
                }
                case 5: {
                    valueRow.setValue(n2, "N/A");
                    break;
                }
                case 3: {
                    if (stringArray[0] != null) {
                        valueRow.setValue(n2, stringArray[0]);
                        break;
                    }
                    valueRow.setValue(n2, operatingSystem.getDescription());
                    break;
                }
                case 4: {
                    if (stringArray[1] == null) break;
                    valueRow.setValue(n2, stringArray[1]);
                    break;
                }
                case 9: {
                    String string = operatingSystem.getType();
                    String string2 = operatingSystem.getCpuArchitecture();
                    if (string == null || string2 == null) break;
                    int n3 = Metric_ECM_OS.platform_id(string, string2);
                    valueRow.setValue(n2, Integer.toString(n3));
                    break;
                }
                case 2: {
                    if ("solaris".equalsIgnoreCase(operatingSystem.getType())) {
                        valueRow.setValue(n2, "Oracle Corporation");
                        break;
                    }
                    String string = operatingSystem.getDescription();
                    if (string != null) {
                        if (string.indexOf("Red Hat") != -1) {
                            valueRow.setValue(n2, "Red Hat, Inc.");
                            break;
                        }
                        if (string.indexOf("SUSE") != -1) {
                            valueRow.setValue(n2, "Attachmate");
                        }
                    }
                    break;
                }
                case 7: {
                    SwapUsage swapUsage = operatingSystem.getSwapUsage();
                    if (swapUsage == null) break;
                    long l = swapUsage.getFreeSpace();
                    double d = (double)l / 1024.0;
                    long l2 = (long)d;
                    if (l2 > 0L) {
                        String string = Long.toString(l2);
                        valueRow.setValue(n2, string);
                    }
                    break;
                }
                case 10: {
                    String string = operatingSystem.getType();
                    String string3 = operatingSystem.getCpuArchitecture();
                    if (string == null || string3 == null || stringArray[0] == null) break;
                    int n4 = Metric_ECM_OS.platform_version_id(string, string3, stringArray[0]);
                    if (n4 >= 0) {
                        valueRow.setValue(n2, Integer.toString(n4));
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching OS info from Ops Center:  " + exception));
        }
    }

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        CollectionResult collectionResult = null;
        if (operatingSystem == null) {
            return collectionResult;
        }
        TableDescriptor tableDescriptor = metric.getTblDesc();
        Vector vector = tableDescriptor.getColDescs();
        MetricResult metricResult = new MetricResult();
        ValueRow valueRow = metricResult.addValueRow();
        String[] stringArray = OpsCenterHarvesterUtil.os_base_and_update(operatingSystem);
        for (int i = 0; i < vector.size(); ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(i);
            String string2 = columnDescriptor.getColumnName();
            Integer n = OCM_to_oc_map.get(string2.toUpperCase());
            if (n == null) continue;
            Metric_ECM_OS.populate(n, valueRow, i, operatingSystem, stringArray);
        }
        collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
        return collectionResult;
    }
}

