/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.domain.types.FileSystemUsage;
import com.sun.hss.domain.types.FileSystemUsageSet;
import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_OS_FILESYSTEM
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_OS_FILESYSTEM.class.getName());
    private static final String METRIC_NAME = "ECM_OS_FILESYSTEM";
    private static final int OC_METRIC_FS_RESOURCE_NAME = 1;
    private static final int OC_METRIC_FS_TYPE = 2;
    private static final int OC_METRIC_FS_DISKSPACE_GB = 3;
    private static final int OC_METRIC_FS_AVAILSPACE = 4;
    private static final int OC_METRIC_FS_MOUNTPOINT = 5;
    private static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("RESOURCE_NAME", 1);
            this.put("TYPE", 2);
            this.put("DISK_SPACE_IN_GB", 3);
            this.put("AVAIL_DISK_SPACE_IN_GB", 4);
            this.put("MOUNT_LOCATION", 5);
        }
    };

    private static float to_gb(long l) {
        return (float)((double)l / 1000000.0);
    }

    private static void populate(int n, ValueRow valueRow, int n2, FileSystemUsage fileSystemUsage) {
        try {
            switch (n) {
                case 5: {
                    valueRow.setValue(n2, fileSystemUsage.getName());
                    break;
                }
                case 2: {
                    valueRow.setValue(n2, fileSystemUsage.getType());
                    break;
                }
                case 3: {
                    valueRow.setValue(n2, Metric_ECM_OS_FILESYSTEM.to_gb(fileSystemUsage.getTotalSpace()));
                    break;
                }
                case 4: {
                    valueRow.setValue(n2, Metric_ECM_OS_FILESYSTEM.to_gb(fileSystemUsage.getTotalSpace() - fileSystemUsage.getUsedSpace()));
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching filesystem info from Ops Center: " + exception));
        }
    }

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        CollectionResult collectionResult = null;
        int n = 0;
        if (operatingSystem == null) {
            return collectionResult;
        }
        TableDescriptor tableDescriptor = metric.getTblDesc();
        Vector vector = tableDescriptor.getColDescs();
        MetricResult metricResult = new MetricResult();
        try {
            FileSystemUsage[] fileSystemUsageArray;
            FileSystemUsageSet fileSystemUsageSet = operatingSystem.getFileSystemUsages();
            if (fileSystemUsageSet != null && (fileSystemUsageArray = fileSystemUsageSet.getValues()) != null) {
                for (int i = 0; i < fileSystemUsageArray.length; ++i) {
                    if (fileSystemUsageArray[i] == null) continue;
                    ++n;
                    ValueRow valueRow = metricResult.addValueRow();
                    for (int j = 0; j < vector.size(); ++j) {
                        ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(j);
                        String string2 = columnDescriptor.getColumnName();
                        Integer n2 = OCM_to_oc_map.get(string2.toUpperCase());
                        if (n2 == null) continue;
                        int n3 = n2;
                        Metric_ECM_OS_FILESYSTEM.populate(n3, valueRow, j, fileSystemUsageArray[i]);
                    }
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching filesystem info from Ops Center:  " + exception));
        }
        if (n > 0) {
            collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
        }
        return collectionResult;
    }
}

